# frozen_string_literal: true
# rubocop:todo all

# Copyright (C) 2018-2020 MongoDB Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

module Mongo
  module Operation
    # @api private
    class OpMsgBase
      include Specifiable
      include Executable
      include SessionsSupported
      include Timed

      private

      def message(connection)
        cmd = apply_relevant_timeouts_to(command(connection), connection)
        Protocol::Msg.new(flags, options(connection), cmd)
      end
    end
  end
end
