FUNCTION fitfunc, p, x=x, y=y, err=err
  gauss = p[0]+p[1]*exp(-(x-p[2])^2/(2*p[3]^2))
  return, (y - gauss)/err
END
PRO test_mpfit
  x = findgen(101)
  err = [2.45583,-3.25605, 5.87131,-1.73504, 2.27937,-0.48254,-1.51753,-0.93256, 1.12209, 1.65635, 1.28370,-3.57939, 4.03734,-0.17061, 1.32193,-0.30438,-0.21467,-2.46095,-2.34313,-0.88627, 1.51226,-2.06973,-3.97503,-0.07323,-5.06270,-3.67407, 3.76492,-0.55431, 2.76809, 2.23146,-2.30901,-1.99149,-4.16457, 2.09245,-0.71644,-3.27360, 0.84205,-4.13405, 5.02517, 3.07811,-2.83230, 3.39967, 0.24383, 0.85002, 6.02679, 0.94512, 0.88598,-6.16427,-1.20659,-0.38692,-0.12944,-2.47544,-2.79558, 0.39396, 1.71503,-0.87366,-3.12669,-1.27370, 3.74370,-2.54965,-1.25783, 0.62415,-0.27057,-0.97599,-3.04811,-0.21875,-2.03241, 1.32219,-0.41634, 4.63014, 1.16504,-0.75943, 3.12185,-2.25148, 3.99848, 1.31917, 1.54279, 1.44990, 1.52935, 0.00041,-2.96998,-0.87376, 4.16183, 1.99984, 1.48010,-3.42435, 1.37966,-0.21252,-0.74505,-1.38282,-0.92772, 5.10892, 2.45020,-0.64636, 2.03258,-0.77305, 0.05296,-7.53868, 5.39158,-0.78637,-1.50639] ; on shot error estimate
  y = 25.*exp(-(x-32.)^2/(2*5.^2))+12.0+err
  start_params = [12.,10.,45.,10.]
  functargs = {x:x, y:y, err:err}
  params = mpfit("fitfunc",start_params,functargs=functargs,/quiet)
  ref = [12.0004, 24.4652, 32.1227, 5.07643]
  print, params, ref, abs(ref-params)
  w=where(abs(params-ref) gt 0.01, count)
  if (count gt 0)  then exit, status=1
  exit, status=0
END
