#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("get next quick menu value")

    def run(self):
        if self.env["runtime"]["QuickMenuManager"].next_value():
            value = self.env["runtime"]["QuickMenuManager"].get_current_value()
            self.env["runtime"]["OutputManager"].present_text(
                value, interrupt=True
            )

    def set_callback(self, callback):
        pass
