#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("clears the currently selected clipboard")

    def run(self):
        self.env["runtime"]["MemoryManager"].clear_current_index_list(
            "clipboardHistory"
        )
        self.env["runtime"]["OutputManager"].present_text(
            _("clipboard cleared"), interrupt=True
        )
        return

    def set_callback(self, callback):
        pass
