/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ODFRootPackageValidator;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.xml.sax.ErrorHandler;

public class ODFStreamValidator
extends ODFRootPackageValidator {
    private InputStream m_aInputStream = null;
    private String m_aBaseURI = null;
    private byte[] m_Buffer = null;

    ODFStreamValidator(InputStream aInputStream, String aBaseURI, Logger.LogLevel nLogLevel, OdfValidatorMode eMode, OdfVersion aVersion, SAXParseExceptionFilter aFilter, ODFValidatorProvider aValidatorProvider) throws ODFValidatorException {
        super(nLogLevel, eMode, aVersion, aFilter, aValidatorProvider);
        this.m_aInputStream = aInputStream;
        this.m_aBaseURI = aBaseURI;
    }

    @Override
    protected OdfPackage getPackage(ErrorHandler handler) throws Exception {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((n = this.m_aInputStream.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        this.m_Buffer = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.m_Buffer);
        OdfPackage ret = OdfPackage.loadPackage(bais, this.m_aBaseURI, handler);
        this.m_Buffer = null;
        return ret;
    }

    @Override
    protected String getLoggerName() {
        return this.m_aBaseURI;
    }

    @Override
    protected String getDocumentPath() {
        return "";
    }

    @Override
    protected byte[] getBytes() throws IOException {
        return this.m_Buffer;
    }
}

