/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import com.sun.appserv.management.util.jmx.AttributeNameManglerImpl;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.misc.Output;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeNameMapperImpl
implements AttributeNameMapper {
    final Map<String, String> mDerivedToOriginal = new HashMap<String, String>();
    final Map<String, String> mOriginalToDerived = new HashMap<String, String>();
    final Set<String> mAllNames = new HashSet<String>();
    final AttributeNameMangler mMangler;
    private Output mDebug = null;

    public AttributeNameMapperImpl() {
        this(null, null);
    }

    public void setDebugOutput(Output debugOutput) {
        this.mDebug = debugOutput;
    }

    protected final void debug(Object o) {
        if (this.mDebug != null) {
            this.mDebug.println(o);
        }
    }

    @Override
    public String matchName(String derivedName, String[] candidates) {
        throw new UnsupportedOperationException("matchName");
    }

    public AttributeNameMapperImpl(String[] originalNames) {
        this(originalNames, new AttributeNameManglerImpl(true, null));
    }

    public AttributeNameMapperImpl(AttributeNameMangler mangler) {
        this(null, mangler);
    }

    public AttributeNameMapperImpl(String[] originalNames, AttributeNameMangler mangler) {
        AttributeNameMangler attributeNameMangler = this.mMangler = mangler == null ? new AttributeNameManglerImpl(true, null) : mangler;
        if (originalNames != null) {
            this.deriveAll(originalNames);
        }
    }

    @Override
    public void deriveAll(String[] originalNames) {
        HashSet<String> notRequired = new HashSet<String>();
        HashSet<String> required = new HashSet<String>();
        for (String originalName : originalNames) {
            if (this.mOriginalToDerived.containsKey(originalName)) continue;
            if (!this.requiresMapping(originalName)) {
                notRequired.add(originalName);
                continue;
            }
            required.add(originalName);
        }
        for (String name : notRequired) {
            this.addMapping(name, name);
        }
        for (String originalName : required) {
            String preferredDerivation;
            String derivedName = preferredDerivation = this.originalToDerived(originalName);
            int id = 0;
            while (this.mAllNames.contains(derivedName) || required.contains(derivedName)) {
                derivedName = preferredDerivation + "_" + id;
                ++id;
            }
            this.addMapping(originalName, derivedName);
        }
    }

    public boolean derivedSameAsOriginal(String derivedName) {
        String original = this.derivedToOriginal(derivedName);
        boolean theSame = original != null && derivedName.equals(original);
        return theSame;
    }

    @Override
    public void addMapping(String originalName, String derivedName) {
        this.mDerivedToOriginal.put(derivedName, originalName);
        this.mOriginalToDerived.put(originalName, derivedName);
        this.mAllNames.add(derivedName);
    }

    @Override
    public void dontMap(String originalName) {
        this.debug("dontMap: " + originalName);
        this.addMapping(originalName, originalName);
    }

    public boolean requiresMapping(String originalName) {
        boolean requiresMapping = true;
        char firstChar = originalName.charAt(0);
        if (Character.isUpperCase(firstChar) && Character.isJavaIdentifierStart(firstChar)) {
            int length = originalName.length();
            requiresMapping = false;
            for (int i = 1; i < length; ++i) {
                if (Character.isJavaIdentifierPart(originalName.charAt(i))) continue;
                requiresMapping = true;
                break;
            }
        }
        return requiresMapping;
    }

    @Override
    public String originalToDerived(String originalName) {
        String derivedName = this.mOriginalToDerived.get(originalName);
        if (derivedName == null) {
            derivedName = this.mMangler.mangleAttributeName(originalName);
        }
        return derivedName;
    }

    @Override
    public String derivedToOriginal(String derivedName) {
        String original = this.mDerivedToOriginal.get(derivedName);
        if (original == null) {
            original = derivedName;
        }
        return original;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.mAllNames;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AttributeNameMapperImpl mappings:\n");
        for (String name : this.getAttributeNames()) {
            buf.append(name);
            buf.append(" => ");
            buf.append(this.derivedToOriginal(name) + "\n");
        }
        return buf.toString();
    }
}

