"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warn = warn;
exports.warnFileDeprecation = warnFileDeprecation;
exports.warnOptionDeprecation = warnOptionDeprecation;

/* global global, console */
function warn(warning, type) {
  if (global && global._YAML_SILENCE_WARNINGS) return;
  const {
    emitWarning
  } = global && global.process; // This will throw in Jest if `warning` is an Error instance due to
  // https://github.com/facebook/jest/issues/2549

  if (emitWarning) emitWarning(warning, type);else {
    // eslint-disable-next-line no-console
    console.warn(type ? `${type}: ${warning}` : warning);
  }
}

function warnFileDeprecation(filename) {
  if (global && global._YAML_SILENCE_DEPRECATION_WARNINGS) return;
  const path = filename.replace(/.*yaml[/\\]/i, '').replace(/\.js$/, '').replace(/\\/g, '/');
  warn(`The endpoint 'yaml/${path}' will be removed in a future release.`, 'DeprecationWarning');
}

const warned = {};

function warnOptionDeprecation(name, alternative) {
  if (global && global._YAML_SILENCE_DEPRECATION_WARNINGS) return;
  if (warned[name]) return;
  warned[name] = true;
  let msg = `The option '${name}' will be removed in a future release`;
  msg += alternative ? `, use '${alternative}' instead.` : '.';
  warn(msg, 'DeprecationWarning');
}