; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7a < %s | FileCheck %s --check-prefix=ARM
; RUN: llc -mtriple=armv6m < %s | FileCheck %s --check-prefix=THUMB
; RUN: llc -mtriple=armv7m < %s | FileCheck %s --check-prefix=THUMB2
; RUN: llc -mtriple=thumbv8.1m.main < %s | FileCheck %s --check-prefix=THUMBV8

declare i8 @llvm.smax.i8(i8 %a, i8 %b) readnone

define i8 @smaxi8_zero(i8 %a) {
; ARM-LABEL: smaxi8_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    sxtb r0, r0
; ARM-NEXT:    bic r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smaxi8_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    sxtb r0, r0
; THUMB-NEXT:    asrs r1, r0, #31
; THUMB-NEXT:    bics r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smaxi8_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    sxtb r0, r0
; THUMB2-NEXT:    bic.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smaxi8_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    sxtb r0, r0
; THUMBV8-NEXT:    bic.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i8 @llvm.smax.i8(i8 %a, i8 0)
  ret i8 %c
}

declare i16 @llvm.smax.i16(i16 %a, i16 %b) readnone

define i16 @smaxi16_zero(i16 %a) {
; ARM-LABEL: smaxi16_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    sxth r0, r0
; ARM-NEXT:    bic r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smaxi16_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    sxth r0, r0
; THUMB-NEXT:    asrs r1, r0, #31
; THUMB-NEXT:    bics r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smaxi16_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    sxth r0, r0
; THUMB2-NEXT:    bic.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smaxi16_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    sxth r0, r0
; THUMBV8-NEXT:    bic.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i16 @llvm.smax.i16(i16 %a, i16 0)
  ret i16 %c
}

declare i32 @llvm.smax.i32(i32 %a, i32 %b) readnone

define i32 @smaxi32_zero(i32 %a) {
; ARM-LABEL: smaxi32_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    bic r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smaxi32_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    asrs r1, r0, #31
; THUMB-NEXT:    bics r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smaxi32_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    bic.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smaxi32_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    bic.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i32 @llvm.smax.i32(i32 %a, i32 0)
  ret i32 %c
}

; SMIN

declare i8 @llvm.smin.i8(i8 %a, i8 %b) readnone

define i8 @smini8_zero(i8 %a) {
; ARM-LABEL: smini8_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    sxtb r0, r0
; ARM-NEXT:    and r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smini8_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    sxtb r1, r0
; THUMB-NEXT:    asrs r0, r1, #31
; THUMB-NEXT:    ands r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smini8_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    sxtb r0, r0
; THUMB2-NEXT:    and.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smini8_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    sxtb r0, r0
; THUMBV8-NEXT:    and.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i8 @llvm.smin.i8(i8 %a, i8 0)
  ret i8 %c
}

declare i16 @llvm.smin.i16(i16 %a, i16 %b) readnone

define i16 @smini16_zero(i16 %a) {
; ARM-LABEL: smini16_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    sxth r0, r0
; ARM-NEXT:    and r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smini16_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    sxth r1, r0
; THUMB-NEXT:    asrs r0, r1, #31
; THUMB-NEXT:    ands r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smini16_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    sxth r0, r0
; THUMB2-NEXT:    and.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smini16_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    sxth r0, r0
; THUMBV8-NEXT:    and.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i16 @llvm.smin.i16(i16 %a, i16 0)
  ret i16 %c
}

declare i32 @llvm.smin.i32(i32 %a, i32 %b) readnone

define i32 @smini32_zero(i32 %a) {
; ARM-LABEL: smini32_zero:
; ARM:       @ %bb.0:
; ARM-NEXT:    and r0, r0, r0, asr #31
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: smini32_zero:
; THUMB:       @ %bb.0:
; THUMB-NEXT:    asrs r1, r0, #31
; THUMB-NEXT:    ands r0, r1
; THUMB-NEXT:    bx lr
;
; THUMB2-LABEL: smini32_zero:
; THUMB2:       @ %bb.0:
; THUMB2-NEXT:    and.w r0, r0, r0, asr #31
; THUMB2-NEXT:    bx lr
;
; THUMBV8-LABEL: smini32_zero:
; THUMBV8:       @ %bb.0:
; THUMBV8-NEXT:    and.w r0, r0, r0, asr #31
; THUMBV8-NEXT:    bx lr
  %c = call i32 @llvm.smin.i32(i32 %a, i32 0)
  ret i32 %c
}
