# CHANGELOG


## v0.16.2 (2025-05-21)

### Bug Fixes

- Update poetry to v2 ([#112](https://github.com/Bluetooth-Devices/inkbird-ble/pull/112),
  [`aed3011`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/aed301162cbccc3af277b2487458134f24be13c4))

### Chores

- Add test for 12 updates in a row from an IBS-P02B
  ([#109](https://github.com/Bluetooth-Devices/inkbird-ble/pull/109),
  [`e3f9829`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e3f98298b781d58ad1782ca04daf002769d08481))

- Add tests for real world data from IBS-P02B
  ([#108](https://github.com/Bluetooth-Devices/inkbird-ble/pull/108),
  [`c529358`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/c529358b29f4dd98f93be0558af858dffa7fc15f))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#106](https://github.com/Bluetooth-Devices/inkbird-ble/pull/106),
  [`61a4076`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/61a40763626e4ca058b7be792e86d8970b697ecd))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>


## v0.16.1 (2025-05-01)

### Bug Fixes

- Detection of 18 byte models ([#105](https://github.com/Bluetooth-Devices/inkbird-ble/pull/105),
  [`2f8e6c5`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/2f8e6c5f9a280742c550bf0e2b91ea146aff4b04))


## v0.16.0 (2025-05-01)

### Features

- Add support for IBS-P02B ([#104](https://github.com/Bluetooth-Devices/inkbird-ble/pull/104),
  [`4b853ef`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/4b853efdfb68c6e4446987ce66da598bba7a47cb))


## v0.15.0 (2025-04-30)

### Chores

- **deps**: Bump bluetooth-data-tools from 1.28.0 to 1.28.1
  ([#100](https://github.com/Bluetooth-Devices/inkbird-ble/pull/100),
  [`714849a`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/714849a7f4d4f35341f73fec29e69752fd94c5bf))

- **deps**: Bump habluetooth from 3.42.0 to 3.44.0
  ([#101](https://github.com/Bluetooth-Devices/inkbird-ble/pull/101),
  [`f379f70`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/f379f70f7e4910c2ad2e4b29decde42a9e702c15))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#99](https://github.com/Bluetooth-Devices/inkbird-ble/pull/99),
  [`f4830e8`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/f4830e80702c249b4215461b9f69a03e479e811f))

### Features

- Use changed_manufacturer_data from newer bluetooth-sensor-state-data
  ([#103](https://github.com/Bluetooth-Devices/inkbird-ble/pull/103),
  [`61d4414`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/61d4414c34535ebded6bf63c6499ffac33ac1265))


## v0.14.1 (2025-04-28)

### Bug Fixes

- Ensure habluetooth is installed with Python 3.13
  ([#98](https://github.com/Bluetooth-Devices/inkbird-ble/pull/98),
  [`e104dc1`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e104dc162ee0f1885d5cace1ba6af1405fb35837))


## v0.14.0 (2025-04-27)

### Chores

- **deps**: Bump habluetooth from 3.38.0 to 3.38.1
  ([#91](https://github.com/Bluetooth-Devices/inkbird-ble/pull/91),
  [`23949ee`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/23949ee90043929488f7f88fe2ca5e35bdf02be6))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump habluetooth from 3.38.1 to 3.39.0
  ([#94](https://github.com/Bluetooth-Devices/inkbird-ble/pull/94),
  [`a11c38a`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/a11c38a3f6d437e68761c253e171cc37de646e67))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#90](https://github.com/Bluetooth-Devices/inkbird-ble/pull/90),
  [`e9d8e02`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e9d8e0206284f0f7ec4b9e17746120d4fe21c8a7))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#93](https://github.com/Bluetooth-Devices/inkbird-ble/pull/93),
  [`2c9ff35`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/2c9ff35f1f70eaa36be10db447007dcffc3a5922))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add support for raw data parsing ([#97](https://github.com/Bluetooth-Devices/inkbird-ble/pull/97),
  [`af80d38`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/af80d38203d94bbfa434bf6d9a3f98ef4e3c0146))


## v0.13.0 (2025-04-14)

### Features

- Avoid a time call on each parse since its already in the service info
  ([#89](https://github.com/Bluetooth-Devices/inkbird-ble/pull/89),
  [`844bcd6`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/844bcd691cc437e55dd545f5b286d85e35bd13f8))


## v0.12.0 (2025-04-13)

### Features

- Add passive detection for the IAM-T1
  ([#88](https://github.com/Bluetooth-Devices/inkbird-ble/pull/88),
  [`7ff42be`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7ff42be727f0617311046beaddd4670a983744b2))


## v0.11.0 (2025-04-13)

### Chores

- **deps-dev**: Bump pytest-cov from 6.1.0 to 6.1.1
  ([#87](https://github.com/Bluetooth-Devices/inkbird-ble/pull/87),
  [`4362c7d`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/4362c7d04013932b50b99aceda70311bf707fb09))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#86](https://github.com/Bluetooth-Devices/inkbird-ble/pull/86),
  [`9df0340`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/9df0340058cee1c47b08057fdd3d32b12fb128c3))

updates: - [github.com/commitizen-tools/commitizen: v4.4.1 →
  v4.5.0](https://github.com/commitizen-tools/commitizen/compare/v4.4.1...v4.5.0) -
  [github.com/astral-sh/ruff-pre-commit: v0.11.2 →
  v0.11.4](https://github.com/astral-sh/ruff-pre-commit/compare/v0.11.2...v0.11.4)

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add support for IAM-T1 ([#85](https://github.com/Bluetooth-Devices/inkbird-ble/pull/85),
  [`1ad0db0`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1ad0db09c7546b50eb7614dd4cc7326b684a2b1c))


## v0.10.1 (2025-04-05)

### Bug Fixes

- Pytest-asyncio should have been a dev dep
  ([#84](https://github.com/Bluetooth-Devices/inkbird-ble/pull/84),
  [`d767490`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d767490f5dfb00f25c9ec5967228374096704bb2))


## v0.10.0 (2025-04-05)

### Chores

- Update deps ([#83](https://github.com/Bluetooth-Devices/inkbird-ble/pull/83),
  [`265bfb2`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/265bfb2a7840451600a633749f19c2f85476778f))

- Updating coverage (7.7.1 -> 7.8.0) - Updating cryptography (44.0.1 -> 44.0.2) - Downgrading
  home-assistant-bluetooth (1.13.1 -> 1.10.4) - Updating pytest-cov (6.0.0 -> 6.1.0)

- **deps**: Bump bluetooth-data-tools from 1.26.0 to 1.26.1
  ([#78](https://github.com/Bluetooth-Devices/inkbird-ble/pull/78),
  [`c101274`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/c101274f83fae510b0b295b6256b5e5dff3c284a))

- **deps**: Bump bluetooth-data-tools from 1.26.1 to 1.27.0
  ([#80](https://github.com/Bluetooth-Devices/inkbird-ble/pull/80),
  [`839c14b`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/839c14bed2e71d5a818caa0080b33cc541a82c22))

chore(deps): bump bluetooth-data-tools from 1.26.1 to 1.26.2

Bumps [bluetooth-data-tools](https://github.com/bdraco/bluetooth-data-tools) from 1.26.1 to 1.26.2.
  - [Release notes](https://github.com/bdraco/bluetooth-data-tools/releases) -
  [Changelog](https://github.com/Bluetooth-Devices/bluetooth-data-tools/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/bdraco/bluetooth-data-tools/compare/v1.26.1...v1.26.2)

--- updated-dependencies: - dependency-name: bluetooth-data-tools dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump sphinx from 7.4.7 to 8.2.3
  ([#79](https://github.com/Bluetooth-Devices/inkbird-ble/pull/79),
  [`bbd4903`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/bbd490301d7d16c35956f3979eda687486f03499))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#77](https://github.com/Bluetooth-Devices/inkbird-ble/pull/77),
  [`1afa92e`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1afa92eade4e13a6c5913a4e761b35b433400c06))

* chore(pre-commit.ci): pre-commit autoupdate

updates: - [github.com/astral-sh/ruff-pre-commit: v0.9.10 →
  v0.11.2](https://github.com/astral-sh/ruff-pre-commit/compare/v0.9.10...v0.11.2)

* chore(pre-commit.ci): auto fixes

* chore: fixes

---------

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

Co-authored-by: J. Nick Koston <nick@koston.org>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#81](https://github.com/Bluetooth-Devices/inkbird-ble/pull/81),
  [`c271c48`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/c271c480640b181225dcfb6491107424312b72e1))

updates: - [github.com/PyCQA/flake8: 7.1.2 →
  7.2.0](https://github.com/PyCQA/flake8/compare/7.1.2...7.2.0)

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add polling support for sensors ([#82](https://github.com/Bluetooth-Devices/inkbird-ble/pull/82),
  [`0327676`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/032767655d4580c0f2775a19517776e6fba711fb))


## v0.9.0 (2025-03-11)

### Chores

- **deps**: Bump bluetooth-data-tools from 1.23.4 to 1.26.0
  ([#71](https://github.com/Bluetooth-Devices/inkbird-ble/pull/71),
  [`1e6ba76`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1e6ba7694661aaef29f0cdb729df380d166ef88b))

- **deps**: Bump myst-parser from 3.0.1 to 4.0.1
  ([#72](https://github.com/Bluetooth-Devices/inkbird-ble/pull/72),
  [`2d4851e`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/2d4851e7b8d02a87633938958415358b24f5ff8f))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#70](https://github.com/Bluetooth-Devices/inkbird-ble/pull/70),
  [`66dc43f`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/66dc43f865dbf08bd76d787f125e0dc62b33d19f))

### Features

- Add support for ITH-11-B ([#75](https://github.com/Bluetooth-Devices/inkbird-ble/pull/75),
  [`e6e48f3`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e6e48f36ea570a0ae717dd7297837c83b50b206f))


## v0.8.0 (2025-03-10)

### Chores

- **deps**: Bump sphinx from 6.2.1 to 7.4.7
  ([#67](https://github.com/Bluetooth-Devices/inkbird-ble/pull/67),
  [`9ae0e2c`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/9ae0e2c101553da2da8161666a203b60594ec4b5))

Bumps [sphinx](https://github.com/sphinx-doc/sphinx) from 6.2.1 to 7.4.7. - [Release
  notes](https://github.com/sphinx-doc/sphinx/releases) -
  [Changelog](https://github.com/sphinx-doc/sphinx/blob/v7.4.7/CHANGES.rst) -
  [Commits](https://github.com/sphinx-doc/sphinx/compare/v6.2.1...v7.4.7)

--- updated-dependencies: - dependency-name: sphinx dependency-type: direct:production

update-type: version-update:semver-major ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest from 8.3.4 to 8.3.5
  ([#66](https://github.com/Bluetooth-Devices/inkbird-ble/pull/66),
  [`1938624`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/19386243bcad5a4b8a0b18e66206af160091f7ca))

Bumps [pytest](https://github.com/pytest-dev/pytest) from 8.3.4 to 8.3.5. - [Release
  notes](https://github.com/pytest-dev/pytest/releases) -
  [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst) -
  [Commits](https://github.com/pytest-dev/pytest/compare/8.3.4...8.3.5)

--- updated-dependencies: - dependency-name: pytest dependency-type: direct:development

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#65](https://github.com/Bluetooth-Devices/inkbird-ble/pull/65),
  [`6dd8d09`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/6dd8d0901e182caa55473cbed41a03dc840fa8ab))

updates: - [github.com/commitizen-tools/commitizen: v4.2.2 →
  v4.4.1](https://github.com/commitizen-tools/commitizen/compare/v4.2.2...v4.4.1) -
  [github.com/astral-sh/ruff-pre-commit: v0.9.7 →
  v0.9.9](https://github.com/astral-sh/ruff-pre-commit/compare/v0.9.7...v0.9.9)

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add support for ITH-13-B and ITH-21-B
  ([#69](https://github.com/Bluetooth-Devices/inkbird-ble/pull/69),
  [`631a28b`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/631a28b8e92e8d0c334b96692a5f8c2001e68859))


## v0.7.1 (2025-03-01)

### Bug Fixes

- Add missing humid sensor on newer TH2 models that have it
  ([#64](https://github.com/Bluetooth-Devices/inkbird-ble/pull/64),
  [`e6283ad`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e6283ada62bfe3794c37889b1a82f5e72eef1d18))

### Chores

- **ci**: Bump the github-actions group with 2 updates
  ([#63](https://github.com/Bluetooth-Devices/inkbird-ble/pull/63),
  [`0929e03`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/0929e031bc3088570cc0698dd3e2a9ad492301a2))

Bumps the github-actions group with 2 updates:
  [python-semantic-release/python-semantic-release](https://github.com/python-semantic-release/python-semantic-release)
  and
  [python-semantic-release/publish-action](https://github.com/python-semantic-release/publish-action).

Updates `python-semantic-release/python-semantic-release` from 9.20.0 to 9.21.0 - [Release
  notes](https://github.com/python-semantic-release/python-semantic-release/releases) -
  [Changelog](https://github.com/python-semantic-release/python-semantic-release/blob/master/CHANGELOG.rst)
  -
  [Commits](https://github.com/python-semantic-release/python-semantic-release/compare/v9.20.0...v9.21.0)

Updates `python-semantic-release/publish-action` from 9.20.0 to 9.21.0 - [Release
  notes](https://github.com/python-semantic-release/publish-action/releases) -
  [Changelog](https://github.com/python-semantic-release/publish-action/blob/main/releaserc.toml) -
  [Commits](https://github.com/python-semantic-release/publish-action/compare/v9.20.0...v9.21.0)

--- updated-dependencies: - dependency-name: python-semantic-release/python-semantic-release
  dependency-type: direct:production

update-type: version-update:semver-minor

dependency-group: github-actions

- dependency-name: python-semantic-release/publish-action dependency-type: direct:production

dependency-group: github-actions ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump myst-parser from 1.0.0 to 3.0.1
  ([#61](https://github.com/Bluetooth-Devices/inkbird-ble/pull/61),
  [`7708961`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/77089618c5503e6041deca0e467506e5c100bd32))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump sphinx-rtd-theme from 2.0.0 to 3.0.2
  ([#62](https://github.com/Bluetooth-Devices/inkbird-ble/pull/62),
  [`564fb88`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/564fb882bdab262af23d2d1344d445caf2a007d8))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#60](https://github.com/Bluetooth-Devices/inkbird-ble/pull/60),
  [`65febcf`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/65febcfd2cd9835d339ec2526c44b5114bc7f80d))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>


## v0.7.0 (2025-02-20)

### Chores

- Switch to ruff ([#58](https://github.com/Bluetooth-Devices/inkbird-ble/pull/58),
  [`d483e9d`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d483e9d7a194129a84f6751fa456fbe31d858dee))

- Update dependabot.yml
  ([`63b15b6`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/63b15b6271e55cfa12f0709790fb18e2084f3b9f))

- **ci**: Bump the github-actions group with 6 updates
  ([#56](https://github.com/Bluetooth-Devices/inkbird-ble/pull/56),
  [`ffb5b0c`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/ffb5b0ce29f7035138aaca8779bf7e09cc6c01c5))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: J. Nick Koston <nick@koston.org>

- **deps**: Bump sphinx from 5.3.0 to 6.2.1
  ([#57](https://github.com/Bluetooth-Devices/inkbird-ble/pull/57),
  [`897212c`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/897212c1f3484bf54eb8ab434e67cef8002fdd52))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

### Features

- Switch to GH trusted publishing for PyPI
  ([#59](https://github.com/Bluetooth-Devices/inkbird-ble/pull/59),
  [`a017e3a`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/a017e3af6d31a16a9cccdde98e27855e9e219ca0))


## v0.6.0 (2025-02-20)

### Chores

- Add poetry cache to CI ([#54](https://github.com/Bluetooth-Devices/inkbird-ble/pull/54),
  [`47101db`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/47101db85fb7815072014f88abcfb9b85debffcd))

- Add some adv data from an ith-21-b
  ([#43](https://github.com/Bluetooth-Devices/inkbird-ble/pull/43),
  [`b86af8a`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/b86af8a813175d7437b788da0600f7bc822e1730))

- Create dependabot.yml
  ([`d719e63`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d719e63d29e064b713adf55b3f87d4b8bda06a50))

- Fix codecov ([#55](https://github.com/Bluetooth-Devices/inkbird-ble/pull/55),
  [`6ef0734`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/6ef07340e93605d94d35310ff496b66007c59f84))

- Update Python versions ([#52](https://github.com/Bluetooth-Devices/inkbird-ble/pull/52),
  [`0eed983`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/0eed98378ac0bf5cf0068124d6e1bcbc5bc3f22b))

- **deps**: Bump myst-parser from 0.18.1 to 1.0.0
  ([#49](https://github.com/Bluetooth-Devices/inkbird-ble/pull/49),
  [`613b2ce`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/613b2cedc8cbf3292a3575428320caefd61c75a0))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump sphinx-rtd-theme from 1.3.0 to 2.0.0
  ([#48](https://github.com/Bluetooth-Devices/inkbird-ble/pull/48),
  [`e1a94a1`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e1a94a1ad46750b69cf246dd160dae18dff4f2fd))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest from 7.4.4 to 8.3.4
  ([#53](https://github.com/Bluetooth-Devices/inkbird-ble/pull/53),
  [`263753d`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/263753d365a3e6262f259041771e71b0d2b86a27))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest-cov from 3.0.0 to 6.0.0
  ([#51](https://github.com/Bluetooth-Devices/inkbird-ble/pull/51),
  [`aed72d9`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/aed72d9bd8c31251984ab8420b7145743f0e8261))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#28](https://github.com/Bluetooth-Devices/inkbird-ble/pull/28),
  [`9c565a4`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/9c565a4be62d6a54d79bc7af43a2e5f62ed96cdd))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#29](https://github.com/Bluetooth-Devices/inkbird-ble/pull/29),
  [`5a3360f`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/5a3360fbcb6c5f99968b8c3ba9fdd85c254c3b2c))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#30](https://github.com/Bluetooth-Devices/inkbird-ble/pull/30),
  [`e2996c0`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e2996c0abde2e3b3722da10882f69d065304cc65))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#31](https://github.com/Bluetooth-Devices/inkbird-ble/pull/31),
  [`a0907bc`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/a0907bceb8120c4a0293c3ffa6bff9939b4bbc86))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#32](https://github.com/Bluetooth-Devices/inkbird-ble/pull/32),
  [`e64a9e0`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e64a9e0dc08927d930f773e121b2d87ff1fcbead))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#33](https://github.com/Bluetooth-Devices/inkbird-ble/pull/33),
  [`f175c26`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/f175c26955f7d35e50a9b20603a92cfbc6f4c880))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#36](https://github.com/Bluetooth-Devices/inkbird-ble/pull/36),
  [`85f9934`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/85f9934619e9faea543b58031ca78b41e4306e98))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#38](https://github.com/Bluetooth-Devices/inkbird-ble/pull/38),
  [`7a413de`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7a413de6f574f01f6904ea69e0e54da12a11f64c))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#39](https://github.com/Bluetooth-Devices/inkbird-ble/pull/39),
  [`cb5ceea`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/cb5ceeac9d7a2dd6d923c8ca5b7ddd220ef798a3))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#40](https://github.com/Bluetooth-Devices/inkbird-ble/pull/40),
  [`d6244d6`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d6244d68172e607e2783db3b511211bc441d3ae1))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#42](https://github.com/Bluetooth-Devices/inkbird-ble/pull/42),
  [`cf478cc`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/cf478ccd0a97362e5a74b4e16a24342c89a5951f))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#44](https://github.com/Bluetooth-Devices/inkbird-ble/pull/44),
  [`fbb7572`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/fbb7572828d6f6881fa8194d821b99a43ce412b7))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#46](https://github.com/Bluetooth-Devices/inkbird-ble/pull/46),
  [`7ac44d2`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7ac44d239b2b912c2c93406b033af9a627f39c2c))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add support for passing in the model
  ([#47](https://github.com/Bluetooth-Devices/inkbird-ble/pull/47),
  [`886b180`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/886b1805eb38f4800785b31e3a55460d9bd7b045))


## v0.5.8 (2024-07-03)

### Bug Fixes

- Handle sps broadcasting N0BYD ([#27](https://github.com/Bluetooth-Devices/inkbird-ble/pull/27),
  [`4686f57`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/4686f57b1864fbe7163e3f82bb6f788a137baf6a))


## v0.5.7 (2024-07-03)

### Bug Fixes

- Switch data change detection algorithm to use newer method
  ([#25](https://github.com/Bluetooth-Devices/inkbird-ble/pull/25),
  [`b41b1d6`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/b41b1d64c34c9b46ea6085c1911d2b2fc9336768))

### Chores

- Fix ci ([#26](https://github.com/Bluetooth-Devices/inkbird-ble/pull/26),
  [`eadb3fd`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/eadb3fdb2be292c74fd2a82a9cf019414ff452a3))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#24](https://github.com/Bluetooth-Devices/inkbird-ble/pull/24),
  [`0eddeb7`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/0eddeb7f3fb184a555b1d3f1a2f40d7f72731725))

* chore(pre-commit.ci): pre-commit autoupdate

updates: - [github.com/commitizen-tools/commitizen: v2.28.0 →
  v3.27.0](https://github.com/commitizen-tools/commitizen/compare/v2.28.0...v3.27.0) -
  [github.com/pre-commit/pre-commit-hooks: v4.3.0 →
  v4.6.0](https://github.com/pre-commit/pre-commit-hooks/compare/v4.3.0...v4.6.0) -
  [github.com/pre-commit/mirrors-prettier: v2.7.1 →
  v4.0.0-alpha.8](https://github.com/pre-commit/mirrors-prettier/compare/v2.7.1...v4.0.0-alpha.8) -
  [github.com/asottile/pyupgrade: v2.37.1 →
  v3.16.0](https://github.com/asottile/pyupgrade/compare/v2.37.1...v3.16.0) -
  [github.com/PyCQA/isort: 5.12.0 → 5.13.2](https://github.com/PyCQA/isort/compare/5.12.0...5.13.2)
  - [github.com/psf/black: 22.6.0 → 24.4.2](https://github.com/psf/black/compare/22.6.0...24.4.2) -
  [github.com/codespell-project/codespell: v2.1.0 →
  v2.3.0](https://github.com/codespell-project/codespell/compare/v2.1.0...v2.3.0) -
  [github.com/PyCQA/flake8: 4.0.1 → 7.1.0](https://github.com/PyCQA/flake8/compare/4.0.1...7.1.0) -
  [github.com/pre-commit/mirrors-mypy: v0.931 →
  v1.10.1](https://github.com/pre-commit/mirrors-mypy/compare/v0.931...v1.10.1) -
  [github.com/PyCQA/bandit: 1.7.4 → 1.7.9](https://github.com/PyCQA/bandit/compare/1.7.4...1.7.9)

* chore(pre-commit.ci): auto fixes

---------

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>


## v0.5.6 (2023-02-06)

### Bug Fixes

- Account for switching adapter when finding changed_manufacturer_data
  ([#20](https://github.com/Bluetooth-Devices/inkbird-ble/pull/20),
  [`37400d0`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/37400d0a65fe3ff347ffb554fd0da4f8b78a187f))

- Bump python-semantic-release ([#21](https://github.com/Bluetooth-Devices/inkbird-ble/pull/21),
  [`64d17d7`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/64d17d7d90a49f882143cc3fb079cfa6ef488bcb))

- Update isort to fix CI ([#19](https://github.com/Bluetooth-Devices/inkbird-ble/pull/19),
  [`174b482`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/174b4825397add3b5f878d63e44aa108b3556b7e))


## v0.5.5 (2022-08-14)

### Bug Fixes

- Use new changed_manufacturer_data helper to remove bad data
  ([#18](https://github.com/Bluetooth-Devices/inkbird-ble/pull/18),
  [`cc4fcb2`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/cc4fcb2f14f3ba468bc634621883a2cb688f9feb))


## v0.5.4 (2022-08-14)

### Bug Fixes

- Parser when there are multiple manufacturer_data fields present
  ([#17](https://github.com/Bluetooth-Devices/inkbird-ble/pull/17),
  [`a4a9047`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/a4a9047816f22f2703b1109d62cf5c22e2ee09cb))


## v0.5.3 (2022-08-14)

### Bug Fixes

- Xbbq2 bad data ([#16](https://github.com/Bluetooth-Devices/inkbird-ble/pull/16),
  [`76b44d5`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/76b44d5bffd36750e8316a70dc27e4148c415687))


## v0.5.2 (2022-08-08)

### Bug Fixes

- Some IBBQ2 identify with xBBQ ([#15](https://github.com/Bluetooth-Devices/inkbird-ble/pull/15),
  [`0ebc14c`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/0ebc14c962ab95f6e76a69194f8bcd0d784345a0))

### Chores

- Add more tests ([#14](https://github.com/Bluetooth-Devices/inkbird-ble/pull/14),
  [`7e8369f`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7e8369f728de6d745925913ce2348469605377a3))


## v0.5.1 (2022-07-21)

### Bug Fixes

- Bump sensor-state-data to fix typing
  ([#13](https://github.com/Bluetooth-Devices/inkbird-ble/pull/13),
  [`e7b1610`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/e7b161063899d34ae665e39ea425beb1db468f84))


## v0.5.0 (2022-07-21)

### Features

- Refactor for sensor-state-data 2 ([#12](https://github.com/Bluetooth-Devices/inkbird-ble/pull/12),
  [`02d7ca1`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/02d7ca1435e3aa98b7c46f7cf6bbbf9285330973))


## v0.4.0 (2022-07-20)

### Features

- Export SensorDescription and SensorValue
  ([#11](https://github.com/Bluetooth-Devices/inkbird-ble/pull/11),
  [`d362302`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d362302b9f707abde4a4280422788010c01ff437))


## v0.3.2 (2022-07-20)

### Bug Fixes

- Bump deps ([#9](https://github.com/Bluetooth-Devices/inkbird-ble/pull/9),
  [`714cb68`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/714cb686f25ee4cd647ec1aafff774a8b47522f3))

- Test names ([#10](https://github.com/Bluetooth-Devices/inkbird-ble/pull/10),
  [`1379ea8`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1379ea837ad5d80f885170d1545a64a057d2663c))


## v0.3.1 (2022-07-20)

### Bug Fixes

- Ibbq parser ([#8](https://github.com/Bluetooth-Devices/inkbird-ble/pull/8),
  [`1844d9f`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1844d9fa659349685265e77ba079a87d68c4c6a0))


## v0.3.0 (2022-07-19)

### Features

- Set manufacturer ([#7](https://github.com/Bluetooth-Devices/inkbird-ble/pull/7),
  [`d0ba693`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/d0ba693652a083f208423aca6fd7a2e6742cff2a))


## v0.2.4 (2022-07-19)

### Bug Fixes

- Add guards to avoid matching unexpected devices
  ([#6](https://github.com/Bluetooth-Devices/inkbird-ble/pull/6),
  [`3a47dd7`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/3a47dd7ba3b9da547b5f7c1f32fcafae0bb9cee9))


## v0.2.3 (2022-07-19)

### Bug Fixes

- Parsing bbq data ([#5](https://github.com/Bluetooth-Devices/inkbird-ble/pull/5),
  [`7b2fe02`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7b2fe02005021c2f5c15372f795c4777fbbb3d9c))


## v0.2.2 (2022-07-19)

### Bug Fixes

- Fix processing empty mfr data ([#4](https://github.com/Bluetooth-Devices/inkbird-ble/pull/4),
  [`1730e18`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/1730e18e75c7f345cce39db0f5234717602c2ae8))


## v0.2.1 (2022-07-19)

### Bug Fixes

- Bump libs ([#3](https://github.com/Bluetooth-Devices/inkbird-ble/pull/3),
  [`7d6d00b`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/7d6d00ba3b02404cf128df26b2093a1ff9a3f36b))


## v0.2.0 (2022-07-19)

### Features

- First publish ([#2](https://github.com/Bluetooth-Devices/inkbird-ble/pull/2),
  [`9b0b9ba`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/9b0b9ba5114c94a046a78a018f67423cc57df61a))


## v0.1.0 (2022-07-19)

### Chores

- Initial commit
  ([`176cb19`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/176cb19ab5431902e705feb48d31fa660019f027))

### Features

- Init repo ([#1](https://github.com/Bluetooth-Devices/inkbird-ble/pull/1),
  [`2920480`](https://github.com/Bluetooth-Devices/inkbird-ble/commit/29204806c2a5a9ab1b53ea268fbb4e7e5123b624))
