# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.devtestlabs import DevTestLabsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDevTestLabsFormulasOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DevTestLabsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.formulas.list(
            resource_group_name=resource_group.name,
            lab_name="str",
            api_version="2018-09-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.formulas.get(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.formulas.begin_create_or_update(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            formula={
                "author": "str",
                "creationDate": "2020-02-20 00:00:00",
                "description": "str",
                "formulaContent": {
                    "allowClaim": False,
                    "artifacts": [
                        {
                            "artifactId": "str",
                            "artifactTitle": "str",
                            "deploymentStatusMessage": "str",
                            "installTime": "2020-02-20 00:00:00",
                            "parameters": [{"name": "str", "value": "str"}],
                            "status": "str",
                            "vmExtensionStatusMessage": "str",
                        }
                    ],
                    "bulkCreationParameters": {"instanceCount": 0},
                    "createdDate": "2020-02-20 00:00:00",
                    "customImageId": "str",
                    "dataDiskParameters": [
                        {
                            "attachNewDataDiskOptions": {"diskName": "str", "diskSizeGiB": 0, "diskType": "str"},
                            "existingLabDiskId": "str",
                            "hostCaching": "str",
                        }
                    ],
                    "disallowPublicIpAddress": False,
                    "environmentId": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "galleryImageReference": {
                        "offer": "str",
                        "osType": "str",
                        "publisher": "str",
                        "sku": "str",
                        "version": "str",
                    },
                    "isAuthenticationWithSshKey": bool,
                    "labSubnetName": "str",
                    "labVirtualNetworkId": "str",
                    "location": "str",
                    "name": "str",
                    "networkInterface": {
                        "dnsName": "str",
                        "privateIpAddress": "str",
                        "publicIpAddress": "str",
                        "publicIpAddressId": "str",
                        "rdpAuthority": "str",
                        "sharedPublicIpAddressConfiguration": {
                            "inboundNatRules": [{"backendPort": 0, "frontendPort": 0, "transportProtocol": "str"}]
                        },
                        "sshAuthority": "str",
                        "subnetId": "str",
                        "virtualNetworkId": "str",
                    },
                    "notes": "str",
                    "ownerObjectId": "dynamicValue",
                    "ownerUserPrincipalName": "str",
                    "password": "str",
                    "planId": "str",
                    "scheduleParameters": [
                        {
                            "dailyRecurrence": {"time": "str"},
                            "hourlyRecurrence": {"minute": 0},
                            "location": "str",
                            "name": "str",
                            "notificationSettings": {
                                "emailRecipient": "str",
                                "notificationLocale": "str",
                                "status": "str",
                                "timeInMinutes": 0,
                                "webhookUrl": "str",
                            },
                            "status": "str",
                            "tags": {"str": "str"},
                            "targetResourceId": "str",
                            "taskType": "str",
                            "timeZoneId": "str",
                            "weeklyRecurrence": {"time": "str", "weekdays": ["str"]},
                        }
                    ],
                    "size": "str",
                    "sshKey": "str",
                    "storageType": "labStorageType",
                    "tags": {"str": "str"},
                    "userName": "str",
                },
                "id": "str",
                "location": "str",
                "name": "str",
                "osType": "str",
                "provisioningState": "str",
                "tags": {"str": "str"},
                "type": "str",
                "uniqueIdentifier": "str",
                "vm": {"labVmId": "str"},
            },
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.formulas.delete(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.formulas.update(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...
