##########################################################################
##                                                                      ##
## Copyright (C) 2011-2026 Lukas Spies                                  ##
## Contact: https://photoqt.org                                         ##
##                                                                      ##
## This file is part of PhotoQt.                                        ##
##                                                                      ##
## PhotoQt is free software: you can redistribute it and/or modify      ##
## it under the terms of the GNU General Public License as published by ##
## the Free Software Foundation, either version 2 of the License, or    ##
## (at your option) any later version.                                  ##
##                                                                      ##
## PhotoQt is distributed in the hope that it will be useful,           ##
## but WITHOUT ANY WARRANTY; without even the implied warranty of       ##
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ##
## GNU General Public License for more details.                         ##
##                                                                      ##
## You should have received a copy of the GNU General Public License    ##
## along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      ##
##                                                                      ##
##########################################################################

import numpy as np
import sys
import sqlite3

def get():

    conn = sqlite3.connect('../defaultsettings.db')

    dbtables = ['filedialog',
            'filetypes',
            'general',
            'imageview',
            'interface',
            'mainmenu',
            'mapview',
            'metadata',
            'slideshow',
            'thumbnails']

    cont_HEADER = """/**************************************************************************
**                                                                      **
** Copyright (C) 2011-2026 Lukas Spies                                  **
** Contact: https://photoqt.org                                         **
**                                                                      **
** This file is part of PhotoQt.                                        **
**                                                                      **
** PhotoQt is free software: you can redistribute it and/or modify      **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation, either version 2 of the License, or    **
** (at your option) any later version.                                  **
**                                                                      **
** PhotoQt is distributed in the hope that it will be useful,           **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
**                                                                      **
**************************************************************************/

/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/
//
// WARNING
// THIS FILE IS AUTO GENERATED BY `misc/pqc_settings.py`.
// ANY CHANGES HERE WILL BE OVERWRITTEN AT SOME POINT!
//
/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/

#pragma once

#include <QObject>
#include <QSqlDatabase>
#include <QQmlEngine>
#include <QQmlPropertyMap>
#include <QPoint>
#include <QSize>
#include <QTimer>

class PQCSettings : public QObject {

    Q_OBJECT
    QML_ELEMENT
    QML_SINGLETON

public:
    explicit PQCSettings(bool validateonly);
    explicit PQCSettings();
    ~PQCSettings();"""

    cont_HEADER += "\n"

    for tab in dbtables:

        c = conn.cursor()
        c.execute(f"SELECT `name`,`defaultvalue`,`datatype` FROM {tab} ORDER BY `name`")
        data = c.fetchall()

        cont_HEADER += f"""
    /**************************************/
    // table: {tab}"""
        for row in data:

            name = row[0]
            defaultvalue = row[1]
            datatype = row[2]

            qtdatatpe = "QString"
            if datatype == "bool":
                qtdatatpe = "bool"
            elif datatype == "int":
                qtdatatpe = "int"
            elif datatype == "double":
                qtdatatpe = "double"
            elif datatype == "list":
                qtdatatpe = "QStringList"
            elif datatype == "point":
                qtdatatpe = "QPoint"
            elif datatype == "size":
                qtdatatpe = "QSize"

            cont_HEADER += f"""

    Q_PROPERTY({qtdatatpe} {tab}{name} READ get{tab.capitalize()}{name} WRITE set{tab.capitalize()}{name} NOTIFY {tab}{name}Changed)
    {qtdatatpe} get{tab.capitalize()}{name}();
    void set{tab.capitalize()}{name}({qtdatatpe} val);
    Q_INVOKABLE const {qtdatatpe} getDefaultFor{tab.capitalize()}{name}();
    Q_INVOKABLE void setDefaultFor{tab.capitalize()}{name}();"""
        cont_HEADER += "\n"

    cont_HEADER += """
    void setDefault();
    void setDefaultFor(QString key);

    void readDB();

    bool backupDatabase();

    Q_INVOKABLE void closeDatabase();
    Q_INVOKABLE void reopenDatabase();
    Q_INVOKABLE QStringList updateFromCommandLine();

    QString verifyNameAndGetType(QString name);

    bool validateSettingsDatabase(bool skipDBHandling = false);
    bool validateSettingsValues(bool skipDBHandling = false);
    void setupFresh();

public Q_SLOTS:
    Q_INVOKABLE void resetToDefault();

private:"""

    for tab in dbtables:

        c = conn.cursor()
        c.execute(f"SELECT `name`,`datatype` FROM {tab} ORDER BY `name`")
        data = c.fetchall()

        cont_HEADER += f"""

    // table: {tab}"""
        for row in data:

            name = row[0]
            datatype = row[1]

            qtdatatpe = "QString"
            if datatype == "bool":
                qtdatatpe = "bool"
            elif datatype == "int":
                qtdatatpe = "int"
            elif datatype == "double":
                qtdatatpe = "double"
            elif datatype == "list":
                qtdatatpe = "QStringList"
            elif datatype == "point":
                qtdatatpe = "QPoint"
            elif datatype == "size":
                qtdatatpe = "QSize"

            cont_HEADER += f"""
    {qtdatatpe} m_{tab}{name};"""


    cont_HEADER += """

    QStringList dbtables;
    bool dbIsTransaction;
    QTimer *dbCommitTimer;

    bool readonly;
    void saveChangedValue(const QString &key, const QVariant &value);

Q_SIGNALS:"""

    for tab in dbtables:

        c = conn.cursor()
        c.execute(f"SELECT `name`,`datatype` FROM {tab} ORDER BY `name`")
        data = c.fetchall()

        cont_HEADER += f"""

    // table: {tab}"""
        for row in data:

            name = row[0]
            datatype = row[1]

            qtdatatpe = "QString"
            if datatype == "bool":
                qtdatatpe = "bool"
            elif datatype == "int":
                qtdatatpe = "int"
            elif datatype == "double":
                qtdatatpe = "double"
            elif datatype == "list":
                qtdatatpe = "QStringList"
            elif datatype == "point":
                qtdatatpe = "QPoint"
            elif datatype == "size":
                qtdatatpe = "QSize"

            cont_HEADER += f"""
    void {tab}{name}Changed();"""

    cont_HEADER += """

};

"""

    return cont_HEADER
