/*******************************************************************************
* Copyright 2023-2025 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {

// clang-format off
const char** get_conv_lookup_table_entries() {
    static const char *entries[] = {
        "xehpc dpas fwd x16:x16:any mb1 ic896iw64oc128ow64kw1pw0 simd=16 l=ic7 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb24 ic2048iw49oc2048ow49kw1pw0 simd=16 l=ow49 T=ic4oc4 i=ic32mb16oc64 bufs=3",
        "xehpg dpas bwd_w x16:any:x16 mb1 ic3ih224oc128oh56kh4sh4ph0 simd=8 l=oh8 T=oc2 i=ic4kw4oc8ow16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb128b ic64iw3136oc256ow3136kw1pw0 simd=8 l=ic2 T=ow8 i=ic32mb32oc32 bufs=2",
        "xehpg dpas fwd x16:x16:any mb2 ic320iw2304oc640ow2304kw1pw0 simd=8 l=ic20 T=oc4ow8 i=ic16oc32ow24",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih24oc1280oh24kh3ph1 simd=8 l=ic80kh3kw3 T=oc4 i=ic16oc32ow24",
        "xehpg dpas fwd x16:x16:any mb2 ic960iw9216oc320ow9216kw1pw0 simd=8 l=ic60 T=oc4ow8 i=ic16oc32ow32",
        "xehpg dpas fwd x8:x8:any mb128b ic128ih56oc128oh28kh3sh2ph1 simd=8 l=ic4kh3kw3 T=oc4ow8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic64ih56oc64oh56kh3ph1 simd=8 l=ic2kh3kw3 T=oc2ow8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic1024iw196oc256ow196kw1pw0 simd=8 l=ic32 T=oc8ow4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic256ih5oc12oh5kh3ph1 simd=16 l=ic2kh3kw3 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpc mad bwd_w f32:any:f32 mb32 ic8id25oc8od23kd5pd1 simd=16 l=ow23 T=x i=ic8mb16oc16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic1920iw2304oc640ow2304kw1pw0 simd=8 l=ic120 T=oc4ow8 i=ic16oc32ow24",
        "xehpg dpas fwd x16:x16:any mb1 ic320ih66oc320oh64kh3ph0 simd=8 l=ic20kh3kw3 T=oc8ow2 i=ic16oc16ow32 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic320ih48oc640oh48kh3ph1 simd=8 l=ic20kh3kw3 T=ow4 i=ic16mb2oc32ow12 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic960iw4096oc320ow4096kw1pw0 simd=16 l=ic30 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic960iw4096oc320ow4096kw1pw0 simd=16 l=ic30 T=oc2ow8 i=ic32oc64ow32 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb64b ic128iw252oc256ow237kw16pw0 simd=16 l=mb2ow79 T=ic4oc2 i=ic32mb8oc64 bufs=2",
        "xehpg dpas fwd x16:x16:any mb2 ic640ih48oc640oh48kh3ph1 simd=8 l=ic40kh3kw3 T=ow4 i=ic16mb2oc32ow12 bufs=0",
        "xehpc mad fwd f32:f32:any mb2048 ic8ih10oc8oh8kh3ph0 simd=16 l=kh3 T=x i=ic8kw3oc16ow8 bufs=0",
        "xehpc mad fwd f64:f64:any mb2048 ic8ih10oc8oh8kh3ph0 simd=8 l=kh3 T=x i=ic8kw3oc8ow8 bufs=0",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih7oc32oh7kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic128ih7oc32oh7kh3ph1 simd=16 l=kh3kw3 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic320ih96oc320oh96kh3ph1 simd=8 l=ic20kh3kw3 T=ow2 i=ic16mb2oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic960ih48oc640oh48kh3ph1 simd=8 l=ic60kh3kw3 T=ow4 i=ic16mb2oc32ow12",
        "xehpg dpas fwd x8:x8:any mb1 ic16ih16oc16oh14kh3ph0 simd=8 l=kh3kw2 T=ow2 i=ic16kw2oc8ow8 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic32ih232oc3oh224kh9ph0 simd=8 l=kh9kw9 T=ow2 i=ic32oc8ow28 bufs=1",
        "xehpg dpas fwd x8:x8:any mb32 ic32ih232oc3oh224kh9ph0 simd=8 l=kh9kw9 T=ow4 i=ic32mb32oc8 bufs=1",
        "xehpg mad bwd_w f32:any:f32 mb2048 ic2ih10oc8oh8kh3ph0 simd=8 l=oh8 T=x i=ic8mb16oc8 bufs=0",
        "xehpg mad fwd x16:x16:any mb128 g144ic1ih151oc1oh75kh3sh2ph0 simd=8 l=kh3 T=x i=g64kw3mb8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic320ih96oc320oh48kh3sh2ph1 simd=8 l=ic20kh3kw3 T=ow4 i=ic16mb2oc32ow12 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic640ih16oc1280oh16kh3ph1 simd=16 l=ic5kh3kw3 T=ic4 i=ic32oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic640ih16oc1280oh16kh3ph1 simd=16 l=ic20kh3kw3 T=oc2ow2 i=ic32oc16ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic4ih96oc320oh96kh3ph1 simd=8 l=kh3 T=ow2 i=ic4kw4mb2oc32ow16",
        "xehpg dpas fwd x16:x16:any mb2 ic960ih96oc320oh96kh3ph1 simd=8 l=ic60kh3kw3 T=oc4ow4 i=ic16oc32ow24",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic1024ih38oc324oh38kh3ph1 simd=16 l=oh2ow38 T=oc4 i=ic32mb16oc32 bufs=3",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic64iw1022oc128ow1007kw16pw0 simd=16 l=mb4ow7 T=ic2oc2 i=ic32oc64ow16",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih128oc8oh64kh3sh2ph0 simd=8 l=kh3 T=ow2 i=ic4kw8oc8ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic640ih32oc640oh16kh3sh2ph1 simd=16 l=ic20kh3kw3 T=oc8ow2 i=ic32oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640ih32oc640oh16kh3sh2ph1 simd=16 l=ic20kh3kw3 T=ow2 i=ic32mb2oc64ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic960iw4096oc320ow4096kw1pw0 simd=8 l=ic60 T=oc4ow4 i=ic16oc32ow32",
        "xehpg dpas fwd x8:x8:any mb128b ic3ih224oc64oh112kh7sh2ph3 simd=8 l=kh7 T=oc2ow8 i=ic4kw8mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih32oc10oh30kh3ph0 simd=8 l=kh3kw3 T=ow4 i=ic32oc8ow8 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic1024ih38oc16oh38kh3ph1 simd=16 l=kh3kw3 T=ic2iw2 i=ic64mb16oc16 bufs=3",
        "xehpc mad bwd_w f32:any:f32 mb32 ic6id26ih28iw27oc6od26oh26ow26kd3kh3kw8pd1ph0pw3 simd=16 l=oh2ow26 T=ic2 i=kw8mb16oc16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic640iw256oc1280ow256kw1pw0 simd=8 l=ic40 T=oc8ow4 i=ic16oc16ow32",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic128iw15000oc1024ow15000kw1pw0 simd=16 l=ow250 T=ic4oc8 i=ic32mb16oc32 bufs=3",
        "xehpg dpas bwd_d any:x16:x16 mb1 ic4ih1080iw1920oc36oh360ow640kh3kw3sh3sw3ph0pw0 simd=8 l=kh3kw3oc3 T=iw2 i=ic8iw30oc16",
        "xehpc mad fwd f32:f32:any mb100 ic1iw29532oc10ow5905kw10sw5pw0 simd=16 l=x T=x i=kw10mb10oc16 bufs=0",
        "xehpg mad bwd_w f32:any:f32 mb1 ic3ih224oc128oh56kh4sh4ph0 simd=16 l=oh28 T=x i=ic3oc32ow8 bufs=0",
        "xehpg mad fwd x8:x8:any mb1 g32ic2ih28oc2oh28kh3ph1 simd=8 l=kh3 T=ow2 i=ic2kw3oc8ow14 bufs=0",
        "xehpg mad fwd x16:x16:any mb128 g144ic1ih191oc1oh95kh3sh2ph0 simd=8 l=kh3 T=x i=g64kw3mb8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb32 ic512ih19oc486oh19kh3ph1 simd=16 l=ow19 T=x i=ic32mb16oc64 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic256iw5625oc128ow5625kw1pw0 simd=16 l=oc4 T=ic4 i=ic64mb16oc32 bufs=3",
        "xehpc dpas fwd x8:x8:any mb128 ic64iw3136oc256ow3136kw1pw0 simd=16 l=x T=oc4 i=ic64oc64ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1280iw64oc1280ow64kw1pw0 simd=16 l=ic40 T=oc2ow2 i=ic32oc16ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280iw64oc1280ow64kw1pw0 simd=16 l=ic40 T=oc2ow8 i=ic32oc32ow8 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic512ih14oc512oh7kh3sh2ph1 simd=8 l=ic16kh3kw3 T=mb4oc8 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x8:x8:any mb32b ic3ih416oc16oh416kh3ph1 simd=16 l=kh3 T=x i=ic4kw8mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32b ic3ih416oc16oh416kh3ph1 simd=16 l=kh3 T=ow8 i=ic4kw4mb32oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic1920ih48oc640oh48kh3ph1 simd=8 l=ic120kh3kw3 T=ow4 i=ic16mb2oc32ow12",
        "xehpg mad fwd x8:x8:any mb32b g224ic1iw3136oc1ow3136kw1pw0 simd=8 l=x T=x i=g32mb16 bufs=0",
        "xehpc mad fwd x8:x8:any mb1 g288ic1ih128iw256oc1oh128ow256kh5kw5dh3dw3ph8pw8 simd=16 l=kh5 T=x i=g16kw5ow16 bufs=0",
        "xehpc dpas fwd x8:x8:any mb128 ic128ih28oc128oh28kh3ph1 simd=16 l=ic2kh3kw3 T=oc2ow4 i=ic64mb32oc64 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic128ih28oc128oh28kh3ph1 simd=8 l=ic4kh3kw3 T=oc4ow4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb8 ic3ih224oc768oh14kh16sh16ph0 simd=16 l=kh16kw4 T=oc8 i=ic4kw4oc64ow14 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic320ih32oc640oh32kh3ph1 simd=8 l=ic20kh3kw3 T=oc2 i=ic16oc32ow16",
        "xehpg dpas fwd x16:x16:any mb2 ic640iw9216oc320ow9216kw1pw0 simd=8 l=ic40 T=oc2ow8 i=ic16oc32ow32",
        "xehpg dpas fwd x8:x8:any mb128b ic256iw3136oc128ow3136kw1pw0 simd=8 l=ic8 T=oc8ow4 i=ic32mb16oc16 bufs=3",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic512ih10oc486oh10kh3ph1 simd=16 l=oh10ow10 T=x i=ic32mb16oc64 bufs=3",
        "xehpg dpas fwd x16:x16:any mb5 ic512ih14oc512oh14kh3ph1 simd=8 l=ic4kh3kw3 T=ic4 i=ic32oc16ow14 bufs=0",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih14oc32oh14kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih32oc64oh32kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic1920ih24oc1280oh24kh3ph1 simd=8 l=ic120kh3kw3 T=oc4 i=ic16oc32ow24",
        "xehpg dpas fwd x8:x8:any mb32 g32ic8ih28oc8oh28kh3ph1 simd=8 l=kh3 T=ow8 i=ic8kw4mb32oc8 bufs=2",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih16oc1280oh16kh3ph1 simd=8 l=ic20kh3kw3 T=ic2 i=ic16oc32ow16 bufs=0",
        "xehpc dpas fwd x8:x8:any mb32b ic4ih1080iw1920oc1oh1080ow1920kh3kw3ph1pw1 simd=16 l=kh3 T=x i=ic4kw8mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32b ic4ih1080iw1920oc1oh1080ow1920kh3kw3ph1pw1 simd=16 l=kh3 T=ow8 i=ic4kw4mb32oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb32b ic512ih13oc1024oh13kh3ph1 simd=8 l=ic32kh3kw3 T=oc8 i=ic16mb32oc32 bufs=2",
        "xehpg dpas fwd x8:x8:any mb32b ic512ih13oc1024oh13kh3ph1 simd=8 l=ic16kh3kw3 T=oc8ow2 i=ic32mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1280ih32oc1280oh32kh3ph1 simd=16 l=ic5kh3kw3 T=ic8 i=ic32oc32ow32 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic1280ih32oc1280oh32kh3ph1 simd=16 l=ic40kh3kw3 T=ow4 i=ic32mb2oc32ow8 bufs=3",
        "xehpg dpas bwd_d any:x16:x16 mb16 ic1088iw15000oc512ow15000kw1pw0 simd=8 l=oc16 T=ic4iw8 i=ic32mb16oc32 bufs=3",
        "xehpg mad fwd x16:x16:any mb1 g512ic1iw32oc1ow32kw3dw1pw2 simd=8 l=x T=ow4 i=g8kw3ow8",
        "xehpg dpas fwd x8:x8:any mb1 ic128iw32oc256ow32kw1pw0 simd=8 l=ic2 T=oc8ow2 i=ic64oc8ow8",
        "xehpg dpas fwd x16:x16:any mb1 ic128iw32oc256ow32kw1pw0 simd=8 l=ic4 T=oc4ow4 i=ic32oc8ow8",
        "xehpc dpas fwd x16:x16:any mb16b ic32id17ih33iw33oc32od17oh33ow33kd3kh3kw3pd1ph1pw1 simd=16 l=ic2kd3kh3kw3 T=ow2 i=ic16mb16oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic640ih32oc640oh32kh3ph1 simd=16 l=ic20kh3kw3 T=oc8 i=ic32oc16ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640ih32oc640oh32kh3ph1 simd=16 l=ic20kh3kw3 T=oc8 i=ic32oc32ow32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic256ih14oc256oh14kh3ph1 simd=8 l=kh3kw3 T=ic8 i=ic32oc32ow8 bufs=0",
        "xehpc dpas fwd x8:x8:any mb32 g32ic8ih28oc8oh28kh3ph1 simd=16 l=kh3kw3 T=ow4 i=ic32mb32oc16 bufs=3",
        "xehpc mad bwd_d any:f32:f32 mb2048 ic8ih10oc8oh8kh3ph0 simd=16 l=kh3kw3 T=iw2 i=ic16mb16oc8 bufs=0",
        "xehpc mad bwd_d any:f64:f64 mb2048 ic8ih10oc8oh8kh3ph0 simd=8 l=kh3kw3 T=iw2 i=ic8mb16oc8 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic1024ih100iw171oc512oh100ow171kh3kw3dh1dw1ph2pw2 simd=8 l=ic32kh3kw3 T=oc8 i=ic32oc64ow16 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic512ih19oc486oh19kh3ph1 simd=16 l=kh3kw3oc16 T=ic2iw8 i=ic64mb16oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic64id224ih224iw160oc32od224oh224ow160kd3kh3kw3pd1ph1pw1 simd=16 l=ic4kd3kh3kw3 T=x i=ic16oc32ow32 bufs=3",
        "xehpc dpas fwd x8:x8:any mb1 ic64id224ih224iw160oc32od224oh224ow160kd3kh3kw3pd1ph1pw1 simd=16 l=kd3kh3kw3 T=ic2 i=ic32oc32ow32 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic256ih512oc256oh512kh3ph1 simd=16 l=ic8kh3kw3 T=oc4ow4 i=ic32oc64ow32 bufs=3",
        "xehpc mad bwd_w f32:any:f32 mb32 ic8id25oc8od25kd5pd2 simd=16 l=ow25 T=x i=ic8mb16oc16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb128b ic2048iw49oc512ow49kw1pw0 simd=8 l=ic64 T=oc4ow4 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic960ih32oc640oh32kh3ph1 simd=8 l=ic60kh3kw3 T=oc8 i=ic16oc32ow16",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic256ih5oc486oh5kh3ph1 simd=16 l=oh5ow5 T=oc4 i=ic32mb16oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic2560iw64oc1280ow64kw1pw0 simd=8 l=ic20 T=ic8ow2 i=ic16oc16ow32 bufs=0",
        "xehpg dpas fwd x16:x16:any mb32b ic1280ih10oc546oh10kh3ph1 simd=8 l=ic80kh3kw3 T=oc8ow2 i=ic16mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic640iw1024oc640ow1024kw1pw0 simd=16 l=ic20 T=oc4ow8 i=ic32oc64ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640iw1024oc640ow1024kw1pw0 simd=16 l=ic20 T=oc4ow8 i=ic32oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb16 ic128ih75oc128oh38kh3sh2ph1 simd=16 l=ic4kh3kw3 T=oc2ow4 i=ic32mb16oc64 bufs=3",
        "xehpc dpas fwd x16:x16:any mb16 ic1024ih38oc324oh38kh3ph1 simd=16 l=ic32kh3kw3 T=oc2ow8 i=ic32mb16oc64 bufs=3",
        "xehpc dpas fwd x8:x8:any mb32b ic144ih2oc144oh2kh3ph1 simd=16 l=ic5kh3kw3 T=mb2oc2 i=ic32mb16oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic512ih10oc6oh10kh3ph1 simd=8 l=ic4kh3kw3 T=ic8 i=ic16oc8ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic640iw256oc1280ow256kw1pw0 simd=16 l=ic20 T=oc2ow8 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640iw256oc1280ow256kw1pw0 simd=16 l=ic20 T=oc8ow4 i=ic32oc32ow16 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic256ih38oc256oh38kh3ph1 simd=16 l=kh3kw3oc8 T=ic2iw8 i=ic64mb16oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb16 ic256ih75oc512oh38kh1sh2ph0 simd=16 l=ic8 T=oc4ow2 i=ic32mb16oc64 bufs=3",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic256ih38oc256oh38kh3ph1 simd=16 l=oh38ow2 T=ic8oc2 i=ic32mb16oc64 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32 g32ic4ih56oc4oh56kh3ph1 simd=16 l=kh3kw3 T=ow8 i=ic16mb32oc16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb128b ic256ih14oc256oh14kh3ph1 simd=8 l=ic8kh3kw3 T=mb4oc4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb32b ic6id26ih28iw27oc6od26oh26ow26kd3kh3kw8pd1ph0pw3 simd=16 l=oh13ow26 T=x i=kw8mb16oc16 bufs=2",
        "xehpg dpas fwd x16:x16:any mb2 ic960iw2304oc640ow2304kw1pw0 simd=8 l=ic60 T=oc4ow8 i=ic16oc32ow24",
        "xehpg dpas fwd x16:x16:any mb1 ic256ih5oc6oh5kh3ph1 simd=8 l=ic2kh3kw3 T=ic8 i=ic16oc8ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic64ih32oc1oh32kh3ph1 simd=16 l=ic2kh3kw3 T=ow4 i=ic32oc16ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic512ih5oc24oh5kh3ph1 simd=8 l=ic4kh3kw3 T=ic8 i=ic16oc8ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih16oc1280oh16kh3ph1 simd=8 l=ic40kh3kw3 T=ic2 i=ic16oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih16oc1280oh16kh3ph1 simd=8 l=ic80kh3kw3 T=oc2 i=ic16oc32ow16 bufs=2",
        "xehpc dpas fwd x16:x16:any mb1 ic960ih32oc640oh32kh3ph1 simd=16 l=ic30kh3kw3 T=oc2ow4 i=ic32oc32ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic960ih32oc640oh32kh3ph1 simd=16 l=ic30kh3kw3 T=ow2 i=ic32mb2oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic640iw576oc1280ow576kw1pw0 simd=8 l=ic40 T=oc8ow8 i=ic16oc32ow24 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic128ih32oc128oh32kh3ph1 simd=8 l=kh3kw3 T=ic8 i=ic16oc32ow16 bufs=0",
        "xehpg dpas bwd_w x16:any:x16 mb8 ic512iw73oc512ow35kw4sw2pw0 simd=8 l=mb8 T=ic8oc8 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1152oc48 simd=16 l=ic9 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpg mad fwd x16:x16:any mb1 g512ic1iw32oc1ow32kw3pw1 simd=8 l=x T=x i=g8kw3ow8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb24 g32ic8ih56oc8oh56kh3ph1 simd=16 l=oh2ow14 T=x i=ic8mb32oc16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic320iw4096oc320ow4096kw1pw0 simd=8 l=ic20 T=oc4ow4 i=ic16oc32ow32",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic128ih75oc128oh38kh3sh2ph1 simd=16 l=oh19 T=ic4oc2 i=ic32mb16oc64 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic2560ih16oc1280oh16kh3ph1 simd=16 l=ic10kh3kw3 T=ic8 i=ic32oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic2560ih16oc1280oh16kh3ph1 simd=16 l=ic10kh3kw3 T=ic8 i=ic32mb2oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic640ih64oc320oh64kh3ph1 simd=16 l=ic20kh3kw3 T=oc2ow4 i=ic32oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640ih64oc320oh64kh3ph1 simd=16 l=ic20kh3kw3 T=ow8 i=ic32mb2oc32ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb6 ic512ih28iw21oc512oh28ow21kh3kw3ph1pw1 simd=8 l=ic8kh3kw3 T=ic2 i=ic32oc16ow21 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1920ih32oc640oh32kh3ph1 simd=8 l=ic120kh3kw3 T=oc8ow2 i=ic16oc32ow16",
        "xehpg mad fwd x16:x16:any mb128 g40ic1ih150oc1oh150kh3ph1 simd=8 l=kh3 T=ow8 i=g16kw3mb8 bufs=1",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic1024ih38oc324oh38kh3ph1 simd=16 l=kh3kw3oc11 T=ic4iw8 i=ic64mb16oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih232oc32oh224kh9ph0 simd=8 l=kh9kw2 T=oc2ow4 i=ic4kw8oc16ow28 bufs=1",
        "xehpg dpas fwd x16:x16:any mb1 ic1280iw1024oc640ow1024kw1pw0 simd=8 l=ic80 T=oc4ow8 i=ic16oc32ow32",
        "xehpc dpas fwd x16:x16:any mb64 ic128iw18oc128ow15kw4pw0 simd=16 l=ic4kw4 T=ow8 i=ic32mb8oc32",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih1024oc24oh256kh7sh4ph3 simd=8 l=kh7 T=oc2ow8 i=ic4kw8oc16ow32 bufs=1",
        "xehpg dpas fwd x16:x16:any mb1 ic320ih64oc320oh64kh3ph1 simd=8 l=ic20kh3kw3 T=oc8ow4 i=ic16oc16ow16",
        "xehpg dpas fwd x16:x16:any mb1 ic128ih512oc128oh512kh3ph1 simd=8 l=ic4kh3kw3 T=oc4ow8 i=ic32oc32ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb24 g32ic8ih56oc8oh56kh3ph1 simd=8 l=kh3 T=ow8 i=ic8kw4mb12oc8 bufs=2",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic128iw18oc128ow15kw4pw0 simd=16 l=mb64 T=ic2oc2 i=ic16oc16ow16",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih48oc1280oh48kh3ph1 simd=8 l=ic80kh3kw3 T=oc8ow2 i=ic16oc32ow24",
        "xehpg dpas fwd x16:x16:any mb1 ic32ih9oc32oh7kh3ph0 simd=8 l=kh3kw3 T=ic2 i=ic16oc16ow7 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic320iw1024oc640ow1024kw1pw0 simd=8 l=ic20 T=oc8ow8 i=ic16oc16ow32 bufs=0",
        "xehpc dpas bwd_w tf32:any:tf32 mb64b ic64iw1022oc128ow1007kw16pw0 simd=16 l=mb2ow19 T=ic2oc2 i=ic32mb8oc64 bufs=2",
        "xehpc dpas fwd x16:x16:any mb1 ic2560iw256oc1280ow256kw1pw0 simd=16 l=ic80 T=oc2ow8 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic2560iw256oc1280ow256kw1pw0 simd=16 l=ic80 T=oc2ow8 i=ic32oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic1152oc48 simd=8 l=ic9 T=ic8 i=ic16oc8ow8 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic256iw32oc128ow32kw1pw0 simd=8 l=x T=ic4 i=ic64oc8ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic256iw32oc128ow32kw1pw0 simd=8 l=x T=ic8 i=ic32oc8ow8 bufs=0",
        "xehpg mad fwd x8:x8:any mb32b g256ic1iw4096oc1ow4096kw1pw0 simd=8 l=x T=x i=g32mb16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic128iw32oc512ow32kw1pw0 simd=8 l=x T=ic2 i=ic64oc8ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic128iw32oc512ow32kw1pw0 simd=8 l=x T=ic8 i=ic16oc16ow16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb128b ic512iw49oc2048ow49kw1pw0 simd=8 l=ic16 T=mb4oc8 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1280iw1024oc640ow1024kw1pw0 simd=16 l=ic40 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280iw1024oc640ow1024kw1pw0 simd=16 l=ic40 T=oc4ow8 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic2560ih8oc1280oh8kh3ph1 simd=16 l=ic80kh3kw3 T=oc2 i=ic32oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic2560ih8oc1280oh8kh3ph1 simd=16 l=ic80kh3kw3 T=oc2ow8 i=ic32mb2oc64 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic256iw262144oc128ow262144kw1pw0 simd=16 l=ic8 T=oc2ow2 i=ic32oc64ow32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic3ih224oc128oh56kh4sh4ph0 simd=8 l=kh4 T=oc2 i=ic4kw4oc32ow8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic256iw5625oc128ow5625kw1pw0 simd=16 l=ow125 T=ic8oc2 i=ic16mb16oc64 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic128ih75oc128oh38kh3sh2ph1 simd=16 l=kh3kw3oc4 T=x i=ic64mb16oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic4ih64oc320oh64kh3ph1 simd=16 l=kh3 T=x i=ic4kw4oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic4ih64oc320oh64kh3ph1 simd=16 l=kh3 T=ow4 i=ic4kw4mb2oc64ow8 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb32b ic8id25oc8od25kd5pd2 simd=16 l=oh25ow5 T=x i=ic8mb16oc16 bufs=2",
        "xehpc dpas fwd x16:x16:any mb1 ic1920ih16oc1280oh16kh3ph1 simd=16 l=ic8kh3kw3 T=ic8 i=ic32oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic1920ih16oc1280oh16kh3ph1 simd=16 l=ic60kh3kw3 T=ow2 i=ic32mb2oc64ow8 bufs=3",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih13oc32oh13kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpc mad bwd_d any:f32:f32 mb2048 ic8ih10oc10oh8kh3ph0 simd=16 l=kh3kw3 T=x i=ic16mb16oc16 bufs=0",
        "xehpc mad bwd_d any:f64:f64 mb2048 ic8ih10oc10oh8kh3ph0 simd=8 l=kh3kw3 T=oc2 i=ic8mb16oc8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb16 ic256ih38oc256oh38kh3ph1 simd=16 l=ic8kh3kw3 T=oc2ow8 i=ic32mb16oc64 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic2560iw144oc1280ow144kw1pw0 simd=8 l=ic80 T=ic2 i=ic16mb2oc16ow16 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic3ih300oc64oh150kh7sh2ph3 simd=16 l=oh2ow10 T=x i=ic4kw8mb16oc64 bufs=3",
        "xehpg dpas bwd_w x16:any:x16 mb4 ic256id8oc512od8kd3pd1 simd=8 l=oh8 T=ic2oc8 i=ic32oc8ow16 bufs=3",
        "xehpc dpas fwd x8:x8:any mb32 ic32ih232oc3oh224kh9ph0 simd=16 l=kh9kw9 T=ow8 i=ic32mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32 ic32ih232oc3oh224kh9ph0 simd=16 l=kh9kw9 T=ow8 i=ic32mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic640ih64oc640oh64kh3ph1 simd=16 l=ic20kh3kw3 T=oc2ow4 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640ih64oc640oh64kh3ph1 simd=16 l=ic20kh3kw3 T=ow8 i=ic32mb2oc64ow8 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic512ih28oc1024oh14kh1sh2ph0 simd=8 l=ic16 T=mb4oc8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic256iw196oc1024ow196kw1pw0 simd=8 l=ic8 T=oc8ow4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic640iw4096oc320ow4096kw1pw0 simd=16 l=ic20 T=oc2 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic640iw4096oc320ow4096kw1pw0 simd=16 l=ic20 T=oc2ow8 i=ic32oc64ow32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb5 ic128ih56oc128oh56kh3ph1 simd=8 l=ic2kh3kw3 T=ic2 i=ic32oc32ow14 bufs=0",
        "xehpc mad bwd_w f32:any:f32 mb2048 ic8ih10oc10oh8kh3ph0 simd=16 l=oh4ow8 T=x i=ic8mb16oc16 bufs=0",
        "xehpc mad bwd_w f64:any:f64 mb2048 ic8ih10oc10oh8kh3ph0 simd=8 l=oh2ow8 T=x i=ic8mb8oc16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic4ih64oc512oh64kh3ph1 simd=16 l=kh3 T=ow4 i=ic4kw4oc64ow16 bufs=3",
        "xehpc dpas fwd x8:x8:any mb128 ic512iw49oc2048ow49kw1pw0 simd=16 l=ic8 T=mb8oc4 i=ic64mb16oc64 bufs=3",
        "xehpg dpas fwd x16:x16:any mb32 ic32ih512oc3oh512kh3ph1 simd=8 l=kh3kw3 T=ow8 i=ic32mb16oc8 bufs=2",
        "xehpg dpas fwd x8:x8:any mb32 ic32ih512oc3oh512kh3ph1 simd=8 l=kh3kw3 T=ow8 i=ic32mb16oc8 bufs=2",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih12oc1280oh12kh3ph1 simd=8 l=ic40kh3kw3 T=ic2ow2 i=ic16mb2oc32ow6",
        "xehpg mad bwd_w f32:any:f32 mb100 ic1iw29532oc10ow5905kw10sw5pw0 simd=16 l=ow5 T=x i=mb16oc16 bufs=0",
        "xehpc mad fwd f32:f32:any mb1024b g32ic4ih56oc4oh56kh3ph1 simd=16 l=kh3 T=ow8 i=ic4kw3mb16oc16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih64oc640oh64kh3ph1 simd=8 l=ic40kh3kw3 T=oc8ow2 i=ic16oc16ow32",
        "xehpg mad fwd x8:x8:any mb1 g32ic2ih112oc2oh56kh3sh2ph1 simd=8 l=kh3 T=ow2 i=ic2kw3oc8ow14 bufs=0",
        "xehpc dpas fwd x8:x8:any mb128 ic512ih14oc512oh7kh3sh2ph1 simd=16 l=ic8kh3kw3 T=oc4ow8 i=ic64mb32oc64 bufs=3",
        "xehpg dpas bwd_d any:x16:x16 mb2 ic256ih100oc256oh100kh3ph1 simd=8 l=kh3kw3oc8 T=ic8iw4 i=ic16iw25oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic320ih64oc320oh32kh3sh2ph1 simd=8 l=ic20kh3kw3 T=oc8ow2 i=ic16oc16ow16",
        "xehpc dpas fwd x16:x16:any mb1 ic320iw1024oc640ow1024kw1pw0 simd=16 l=ic10 T=oc4ow8 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320iw1024oc640ow1024kw1pw0 simd=16 l=ic10 T=oc2ow4 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb16 ic256ih38oc512oh19kh3sh2ph1 simd=16 l=ic8kh3kw3 T=oc4ow4 i=ic32mb16oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic4ih1080iw1920oc36oh360ow640kh3kw3sh3sw3ph0pw0 simd=8 l=kh3 T=oc2ow4 i=ic4kw4oc32ow16",
        "xehpg mad fwd x16:x16:any mb1 ic2ih56oc2oh56kh3ph1 simd=8 l=kh3 T=x i=ic2kw3oc8ow7 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1280iw64oc1280ow64kw1pw0 simd=8 l=ic10 T=ic8ow2 i=ic16oc16ow32 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic2560iw64oc1280ow64kw1pw0 simd=16 l=ic20 T=ic4 i=ic32oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic2560iw64oc1280ow64kw1pw0 simd=16 l=ic80 T=oc2ow8 i=ic32oc32ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic2560iw256oc1280ow256kw1pw0 simd=8 l=ic160 T=oc8ow4 i=ic16oc16ow32",
        "xehpc dpas bwd_w x16:any:x16 mb4 ic8ih640iw1024oc8oh640ow1024kh3kw3ph1pw1 simd=16 l=oh32 T=x i=ic8kw3oc16ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32 ic32ih512oc3oh512kh3ph1 simd=16 l=kh3kw3 T=ow8 i=ic32mb16oc16 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic32id224ih224iw160oc32od224oh224ow160kd3kh3kw3pd1ph1pw1 simd=8 l=kd3kh3kw3 T=oc2ow2 i=ic32oc16ow20 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb64b ic256iw90oc256ow59kw32pw0 simd=16 l=mb2ow59 T=ic8 i=ic32mb8oc64 bufs=2",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih32oc1280oh32kh3ph1 simd=8 l=ic80kh3kw3 T=oc4ow2 i=ic16oc16ow16",
        "xehpc mad bwd_d any:f32:f32 mb2048 ic2ih10oc8oh8kh3ph0 simd=16 l=kh3kw3 T=x i=ic16mb16oc8 bufs=0",
        "xehpc mad bwd_d any:f64:f64 mb2048 ic2ih10oc8oh8kh3ph0 simd=8 l=kh3kw3 T=iw2 i=ic8mb16oc8 bufs=0",
        "xehpg dpas fwd x8:x8:any mb32b ic384ih26oc256oh26kh3ph1 simd=8 l=ic12kh3kw3 T=oc4ow4 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic1920iw576oc1280ow576kw1pw0 simd=8 l=ic120 T=oc8ow8 i=ic16oc32ow24 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic16ih208oc32oh208kh3ph1 simd=8 l=kh3kw3 T=oc2 i=ic32oc16ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic320ih32oc640oh32kh3ph1 simd=16 l=ic10kh3kw3 T=oc2ow4 i=ic32oc32ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320ih32oc640oh32kh3ph1 simd=16 l=ic10kh3kw3 T=ow4 i=ic32mb2oc32ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic320ih66oc4oh64kh3ph0 simd=8 l=ic3kh3kw3 T=ic4ow8 i=ic32oc8ow8",
        "xehpg dpas fwd x16:x16:any mb1 ic1920ih16oc1280oh16kh3ph1 simd=8 l=ic60kh3kw3 T=ic2 i=ic16oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic32ih17oc32oh17kh3ph1 simd=16 l=ic2kh3kw3 T=oc2ow4 i=ic16oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic512ih64oc512oh64kh3ph1 simd=16 l=ic16kh3kw3 T=oc4ow4 i=ic32oc32ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb32 g32ic4ih56oc4oh56kh3ph1 simd=8 l=kh3 T=ow8 i=ic4kw4mb32oc8 bufs=2",
        "xehpg dpas fwd x8:x8:any mb32 g32ic4ih56oc4oh56kh3ph1 simd=8 l=kh3 T=ow8 i=ic8kw4mb32oc8 bufs=2",
        "xehpg mad fwd x16:x16:any mb1 g512ic1iw32oc1ow32kw3dw3pw4 simd=8 l=x T=ow4 i=g8kw3ow8",
        "xehpg dpas fwd x8:x8:any mb128b ic256ih56oc512oh28kh1sh2ph0 simd=8 l=ic8 T=oc8 i=ic32mb32oc32 bufs=2",
        "xehpc dpas bwd_w tf32:any:tf32 mb1 ic3ih224oc128oh56kh4sh4ph0 simd=16 l=oh7 T=oc8 i=ic4kw4oc16ow8 bufs=2",
        "xehpc dpas bwd_w x16:any:x16 mb1 ic3ih224oc128oh56kh4sh4ph0 simd=16 l=x T=oc2 i=ic8kw4oc16ow16 bufs=3",
        "xehpg dpas bwd_w x16:any:x16 mb16b ic1088iw1500oc512ow1500kw1pw0 simd=8 l=ow500 T=ic8oc8 i=ic32mb16oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1920ih32oc640oh32kh3ph1 simd=16 l=ic60kh3kw3 T=oc4ow2 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1920ih32oc640oh32kh3ph1 simd=16 l=ic60kh3kw3 T=ow2 i=ic32mb2oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic4iw4096oc4ow4096kw1pw0 simd=16 l=x T=ow2 i=ic4kw4oc16ow16 bufs=3",
        "xehpc dpas fwd x8:x8:any mb32 g32ic16ih14oc16oh14kh3ph1 simd=16 l=kh3kw3 T=ow4 i=ic32mb32oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic3ih224oc64oh112kh7sh2ph3 simd=8 l=kh7kw2 T=oc2ow4 i=ic4kw4oc16ow32 bufs=1",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih224oc64oh112kh7sh2ph3 simd=8 l=kh7 T=oc2ow4 i=ic4kw8oc16ow32 bufs=1",
        "xehpg dpas fwd x16:x16:any mb1 ic4ih64oc320oh64kh3ph1 simd=8 l=kh3 T=oc2 i=ic4kw4oc64ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic320ih64oc4oh64kh3ph1 simd=16 l=ic10kh3kw3 T=ow2 i=ic32oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320ih64oc4oh64kh3ph1 simd=16 l=ic10kh3kw3 T=x i=ic32oc16ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih34oc640oh32kh3ph0 simd=8 l=ic40kh3kw3 T=oc2 i=ic16oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic3ih300oc64oh150kh7sh2ph3 simd=8 l=kh7kw2 T=oc2 i=ic4kw4oc32ow15 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic1280ih16oc1280oh16kh3ph1 simd=16 l=ic5kh3kw3 T=ic8 i=ic32oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb2 ic1280ih16oc1280oh16kh3ph1 simd=16 l=ic5kh3kw3 T=ic8 i=ic32mb2oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1280iw256oc1280ow256kw1pw0 simd=8 l=ic80 T=oc8ow4 i=ic16oc16ow32",
        "xehpc mad bwd_w f32:any:f32 mb2048 ic2ih10oc8oh8kh3ph0 simd=16 l=oh4ow8 T=x i=ic2kw3mb16oc16 bufs=0",
        "xehpc mad bwd_w f64:any:f64 mb2048 ic2ih10oc8oh8kh3ph0 simd=8 l=oh4ow8 T=x i=ic2kw3mb8oc8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic1024ih38oc16oh38kh3ph1 simd=16 l=ow38 T=x i=ic32mb16oc16 bufs=3",
        "xehpg dpas bwd_w x16:any:x16 mb8 ic512iw299oc512ow73kw8sw4pw0 simd=8 l=mb8 T=ic8oc4 i=ic16oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih32oc640oh32kh3ph1 simd=8 l=ic40kh3kw3 T=oc8 i=ic16oc32ow16",
        "xehpc dpas bwd_w x16:any:x16 mb16 ic64ih75oc64oh75kh3ph1 simd=16 l=oh5ow5 T=ic4 i=ic16mb16oc64 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb32 ic6id26oc1od25kd2pd0 simd=16 l=mb2ow25 T=x i=ic8kw2mb8oc16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih64oc320oh64kh3ph1 simd=8 l=ic40kh3kw3 T=oc8ow4 i=ic16oc16ow16",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih18oc1280oh16kh3ph0 simd=8 l=ic40kh3kw3 T=ic2 i=ic16oc32ow16 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih608oc32oh608kh3ph1 simd=8 l=kh3 T=ow2 i=ic4kw8oc16ow32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic256ih150oc256oh150kh3ph1 simd=8 l=ic16kh3kw3 T=oc4 i=ic16oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb3200b ic448iw64oc2080ow64kw1pw0 simd=8 l=ic28 T=oc2ow8 i=ic16mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb3200b ic448iw64oc2080ow64kw1pw0 simd=8 l=ic14 T=oc4ow8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih32oc640oh32kh3ph1 simd=8 l=ic80kh3kw3 T=oc8ow2 i=ic16oc32ow16",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic64iw1022oc128ow1007kw16pw0 simd=16 l=kw16oc4 T=iw8 i=ic64iw32oc32",
        "xehpg dpas fwd x16:x16:any mb1 ic640iw1024oc640ow1024kw1pw0 simd=8 l=ic40 T=oc8ow8 i=ic16oc16ow32 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic320ih64oc320oh64kh3ph1 simd=16 l=ic10kh3kw3 T=oc2ow4 i=ic32oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320ih64oc320oh64kh3ph1 simd=16 l=ic10kh3kw3 T=ow8 i=ic32mb2oc32ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic32ih512oc32oh512kh3ph1 simd=8 l=ic2kh3kw3 T=oc2ow4 i=ic16oc16ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic896iw49oc32ow49kw1pw0 simd=16 l=ic7 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1920iw1024oc640ow1024kw1pw0 simd=8 l=ic120 T=oc8ow4 i=ic16oc32ow32",
        "xehpc dpas fwd x8:x8:any mb32b ic3id8ih224iw224oc16od8oh112ow112kd1kh3kw3sh2sw2pd0ph1pw1 simd=16 l=kh3 T=x i=ic4kw8mb32oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic640ih32oc640oh16kh3sh2ph1 simd=8 l=ic10kh3kw3 T=ic4 i=ic16oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih8oc1280oh8kh3ph1 simd=8 l=ic20kh3kw3 T=ic2 i=ic32oc16ow8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic256iw90oc256ow59kw32pw0 simd=16 l=mb64ow4 T=ic8oc4 i=ic16oc64ow16",
        "xehpg dpas bwd_w x16:any:x16 mb3 ic256ih10iw16oc256oh10ow16kh5kw5ph2pw2 simd=8 l=oh10 T=ic8oc4 i=ic16oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic1920iw256oc1280ow256kw1pw0 simd=8 l=ic120 T=oc8ow4 i=ic16oc16ow32",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic32id17ih33iw33oc32od17oh33ow33kd3kh3kw3pd1ph1pw1 simd=16 l=kd3kh3kw3 T=x i=ic32mb16oc32 bufs=3",
        "xehpc mad bwd_w f32:any:f32 mb100 ic1iw29532oc10ow5905kw10sw5pw0 simd=16 l=ow64 T=x i=kw8mb10oc16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic32id224ih224iw160oc32od224oh224ow160kd3kh3kw3pd1ph1pw1 simd=16 l=kd3kh3kw3 T=ic2 i=ic16oc32ow32 bufs=0",
        "xehpg dpas fwd x8:x8:any mb128b ic512iw784oc128ow784kw1pw0 simd=8 l=ic16 T=oc8 i=ic32mb32oc16 bufs=2",
        "xehpc dpas fwd x16:x16:any mb1 ic1280iw256oc1280ow256kw1pw0 simd=16 l=ic40 T=oc2ow8 i=ic32oc64ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280iw256oc1280ow256kw1pw0 simd=16 l=ic40 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc dpas bwd_w tf32:any:tf32 mb32b ic8id25oc8od23kd5pd1 simd=16 l=oh23 T=x i=ic8mb16oc16 bufs=2",
        "xehpg dpas fwd x8:x8:any mb128b ic256ih28oc256oh14kh3sh2ph1 simd=8 l=ic8kh3kw3 T=mb4oc8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic512iw784oc256ow784kw1pw0 simd=8 l=ic16 T=oc8 i=ic32mb32oc32 bufs=2",
        "xehpg dpas fwd x8:x8:any mb128b ic1024iw196oc512ow196kw1pw0 simd=8 l=ic32 T=oc8ow4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic512iw1444oc1024ow1444kw1pw0 simd=16 l=oc32 T=ic2iw8 i=ic64mb16oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic20ih6oc50oh4kh3ph0 simd=8 l=kh3kw3 T=x i=ic32oc8ow4 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic128ih512oc128oh512kh3ph1 simd=16 l=ic4kh3kw3 T=oc2ow2 i=ic32oc64ow32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic960ih64oc320oh64kh3ph1 simd=8 l=ic60kh3kw3 T=oc8ow4 i=ic16oc16ow16",
        "xehpg dpas fwd x8:x8:any mb32b ic4ih1080iw1920oc1oh1080ow1920kh3kw3ph1pw1 simd=8 l=kh3 T=ow2 i=ic4kw8mb32oc8 bufs=2",
        "xehpg dpas fwd x16:x16:any mb2 ic640ih96oc320oh96kh3ph1 simd=8 l=ic40kh3kw3 T=ow2 i=ic16mb2oc32ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic512ih256oc512oh256kh3ph1 simd=16 l=ic16kh3kw3 T=oc4ow8 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic2048oc128 simd=16 l=ic16 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih16oc1280oh8kh3sh2ph1 simd=8 l=ic20kh3kw3 T=ic2 i=ic32oc16ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic256ih512oc128oh512kh3ph1 simd=16 l=ic8kh3kw3 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc mad fwd f32:f32:any mb2048 ic2ih10oc8oh8kh3ph0 simd=16 l=kh3 T=x i=ic2kw3oc16ow8 bufs=0",
        "xehpc mad fwd f64:f64:any mb2048 ic2ih10oc8oh8kh3ph0 simd=8 l=kh3 T=x i=ic2kw3oc8ow8 bufs=0",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic128iw16oc64ow15kw2pw0 simd=16 l=x T=ic8 i=ic8kw2oc16ow16",
        "xehpg dpas fwd x8:x8:any mb32b ic10ih15oc20oh13kh3ph0 simd=8 l=kh3kw2 T=oc4ow4 i=ic16kw2mb32oc8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic1280ih10oc1280oh8kh3ph0 simd=8 l=ic20kh3kw3 T=ic2 i=ic32oc16ow8 bufs=0",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic256iw90oc256ow59kw32pw0 simd=16 l=kw32oc8 T=ic8iw4 i=ic32iw30oc32",
        "xehpg dpas fwd x16:x16:any mb2 ic640ih24oc1280oh24kh3ph1 simd=8 l=ic40kh3kw3 T=oc4 i=ic16oc32ow24",
        "xehpc dpas fwd x16:x16:any mb32 ic64ih256oc3oh256kh9ph4 simd=16 l=ic2kh9kw9 T=ow8 i=ic32mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic512ih256oc256oh256kh3ph1 simd=16 l=ic16kh3kw3 T=oc4ow8 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1920iw1024oc640ow1024kw1pw0 simd=16 l=ic60 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1920iw1024oc640ow1024kw1pw0 simd=16 l=ic60 T=oc8ow4 i=ic32oc32ow32 bufs=3",
        "xehpc mad fwd x16:x16:any mb1 ic2ih56oc2oh56kh3ph1 simd=16 l=kh3 T=ow8 i=ic2kw3oc16ow7 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic1280ih8oc1280oh8kh3ph1 simd=16 l=ic40kh3kw3 T=oc2 i=ic32oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280ih8oc1280oh8kh3ph1 simd=16 l=ic40kh3kw3 T=x i=ic32mb2oc32ow8 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic2560ih24oc1280oh24kh3ph1 simd=8 l=ic160kh3kw3 T=oc4 i=ic16oc32ow24",
        "xehpc dpas fwd x16:x16:any mb64 ic128iw252oc256ow237kw16pw0 simd=16 l=ic4kw16 T=oc4ow8 i=ic32oc64ow32",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih48oc640oh48kh3ph1 simd=8 l=ic80kh3kw3 T=ow4 i=ic16mb2oc32ow12",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic128iw252oc256ow237kw16pw0 simd=16 l=kw16oc8 T=ic4iw8 i=ic32iw32oc32",
        "xehpg dpas fwd x8:x8:any mb128b ic1024ih14oc2048oh7kh1sh2ph0 simd=8 l=ic32 T=mb4oc8 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic256iw3136oc64ow3136kw1pw0 simd=8 l=ic8 T=oc8ow2 i=ic32mb16oc8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb64 ic256iw90oc256ow59kw32pw0 simd=16 l=ic8kw32 T=ow4 i=ic32oc32ow16",
        "xehpg dpas fwd x16:x16:any mb2 ic320ih96oc4oh96kh3ph1 simd=8 l=ic10kh3kw3 T=ow8 i=ic32oc8ow16 bufs=0",
        "xehpc dpas fwd x16:x16:any mb32b ic3ih1024oc3oh512kh7sh2ph3 simd=16 l=kh7kw2 T=ow4 i=ic4kw4mb32oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic128ih512oc3oh512kh3ph1 simd=16 l=ic4kh3kw3 T=ow4 i=ic32oc16ow32 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic128iw16oc64ow15kw2pw0 simd=16 l=kw2oc2 T=ic2 i=ic16iw16oc32",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic256ih75oc512oh38kh1sh2ph0 simd=16 l=oc16 T=x i=ic64mb16oc32 bufs=3",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic128iw18oc128ow15kw4pw0 simd=16 l=kw4oc4 T=iw4 i=ic32iw8oc32",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic256iw18oc128ow15kw4pw0 simd=16 l=mb8 T=ic2oc8 i=ic32oc16ow16",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih6oc32oh6kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih58oc128oh56kh3ph0 simd=16 l=ic4kh3kw3 T=oc2ow8 i=ic32oc32ow7 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic128ih58oc128oh56kh3ph0 simd=16 l=ic8kh3kw3 T=oc4ow4 i=ic16oc16ow14 bufs=3",
        "xehpc mad fwd f32:f32:any mb2048 ic8ih10oc10oh8kh3ph0 simd=16 l=kh3 T=x i=ic8kw3oc16ow8 bufs=0",
        "xehpc mad fwd f64:f64:any mb2048 ic8ih10oc10oh8kh3ph0 simd=16 l=kh3 T=x i=ic8kw3oc16ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb64 ic64iw1022oc128ow1007kw16pw0 simd=16 l=ic2kw16 T=oc2ow2 i=ic32oc64ow32",
        "xehpg dpas fwd x8:x8:any mb1 ic512iw32oc128ow32kw1pw0 simd=8 l=x T=ic8 i=ic64oc8ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic512iw32oc128ow32kw1pw0 simd=8 l=ic2 T=ic8 i=ic32oc8ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb32b ic1iw8192oc64ow8177kw16pw0 simd=16 l=kw2 T=x i=ic2kw8oc64ow13",
        "xehpg dpas fwd x8:x8:any mb1 ic3ih300oc32oh150kh3sh2ph1 simd=8 l=kh3 T=oc2ow2 i=ic4kw8oc16ow25 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1024oc64 simd=16 l=ic8 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpc mad fwd x16:x16:any mb1 g64ic1ih8oc1oh8kh3ph1 simd=16 l=kh3 T=x i=g16kw3ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic320ih64oc320oh32kh3sh2ph1 simd=16 l=ic10kh3kw3 T=oc4ow2 i=ic32oc16ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320ih64oc320oh32kh3sh2ph1 simd=16 l=ic10kh3kw3 T=oc4ow2 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic320iw4096oc320ow4096kw1pw0 simd=16 l=ic10 T=oc2ow8 i=ic32oc64ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic320iw4096oc320ow4096kw1pw0 simd=16 l=ic10 T=oc2ow8 i=ic32oc32ow32 bufs=3",
        "xehpc dpas bwd_w x16:any:x16 mb32 ic1iw8192oc64ow8177kw16pw0 simd=16 l=mb2ow17 T=oc2 i=ic2kw16mb16oc16",
        "xehpg dpas fwd x8:x8:any mb1 ic4ih360iw640oc36oh360ow640kh3kw3ph1pw1 simd=8 l=kh3 T=ow2 i=ic4kw8oc16ow32",
        "xehpc dpas fwd x8:x8:any mb128 ic128iw784oc512ow784kw1pw0 simd=16 l=ic2 T=oc4 i=ic64oc64ow28 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic512iw65536oc256ow65536kw1pw0 simd=16 l=ic16 T=oc4ow2 i=ic32oc64ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1024iw196oc2048ow196kw1pw0 simd=16 l=ic64 T=oc4ow4 i=ic16oc32ow7 bufs=3",
        "xehpc dpas fwd x16:x16:any mb64 ic256iw18oc128ow15kw4pw0 simd=16 l=ic8kw4 T=ow8 i=ic32mb8oc32",
        "xehpg dpas fwd x16:x16:any mb1 ic960iw1024oc640ow1024kw1pw0 simd=8 l=ic60 T=oc8ow8 i=ic16oc16ow32 bufs=0",
        "xehpg mad fwd x16:x16:any mb1 g512ic1iw32oc1ow48kw3dw7pw16 simd=8 l=x T=ow8 i=g8kw3ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic256iw289oc32ow289kw1pw0 simd=16 l=ic2 T=ic8 i=ic16oc16ow8 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic464ih64oc160oh64kh3ph1 simd=8 l=ic15kh3kw3 T=oc4ow2 i=ic32oc16ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb32b ic512ih13oc1024oh13kh3ph1 simd=16 l=ic32kh3kw3 T=oc2ow8 i=ic16mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic960ih64oc320oh64kh3ph1 simd=16 l=ic30kh3kw3 T=oc2ow4 i=ic32oc64ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic960ih64oc320oh64kh3ph1 simd=16 l=ic30kh3kw3 T=ow8 i=ic32mb2oc32ow8 bufs=3",
        "xehpc mad bwd_w f32:any:f32 mb2048 ic8ih10oc8oh8kh3ph0 simd=16 l=oh8ow4 T=x i=ic8mb16oc16 bufs=0",
        "xehpc mad bwd_w f64:any:f64 mb2048 ic8ih10oc8oh8kh3ph0 simd=8 l=oh8ow2 T=x i=ic8mb8oc8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic256ih256oc256oh256kh3ph1 simd=16 l=ic8kh3kw3 T=oc2ow4 i=ic32oc64ow32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb128b ic128iw784oc512ow784kw1pw0 simd=8 l=ic4 T=oc8ow4 i=ic32mb32oc32 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic1280ih24oc1280oh12kh3sh2ph1 simd=8 l=ic40kh3kw3 T=ic2ow2 i=ic16mb2oc32ow6",
        "xehpc dpas fwd x16:x16:any mb64 ic128iw16oc64ow15kw2pw0 simd=16 l=ic4kw2 T=mb4 i=ic32mb16oc32",
        "xehpc dpas bwd_d any:x16:x16 mb16b ic32id17ih33iw33oc32od17oh33ow33kd3kh3kw3pd1ph1pw1 simd=16 l=kd3kh3kw3oc2 T=iw2 i=ic32mb16oc16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic2560ih16oc1280oh16kh3ph1 simd=8 l=ic80kh3kw3 T=ic2 i=ic16oc32ow16 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic2560ih16oc1280oh16kh3ph1 simd=8 l=ic160kh3kw3 T=oc4 i=ic16oc32ow16 bufs=2",
        "xehpc dpas bwd_d any:x16:x16 mb8 ic512iw299oc512ow73kw8sw4pw0 simd=16 l=kw8oc32 T=ic8iw4 i=ic64iw16oc16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic960iw1024oc640ow1024kw1pw0 simd=16 l=ic30 T=oc4ow4 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic960iw1024oc640ow1024kw1pw0 simd=16 l=ic30 T=oc4ow8 i=ic32oc32ow32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic16id128oc16od128kd3pd1 simd=16 l=kd3kh3kw3 T=ow4 i=ic16oc16ow32 bufs=3",
        "xehpg dpas fwd x8:x8:any mb1 ic4ih1080iw1920oc1oh1080ow1920kh3kw3ph1pw1 simd=8 l=kh3 T=ow4 i=ic4kw8oc8ow32",
        "xehpc dpas fwd x8:x8:any mb1 ic128ih16oc128oh16kh3ph1 simd=16 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic2560iw576oc1280ow576kw1pw0 simd=8 l=ic160 T=oc8ow8 i=ic16oc32ow24 bufs=0",
        "xehpg mad fwd x16:x16:any mb1 g512ic1iw32oc1ow64kw3dw15pw32 simd=8 l=x T=ow8 i=g8kw3ow8 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic1920iw256oc1280ow256kw1pw0 simd=16 l=ic60 T=oc4ow4 i=ic32oc32ow16 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1920iw256oc1280ow256kw1pw0 simd=16 l=ic60 T=oc4ow8 i=ic32oc32ow16 bufs=3",
        "xehpc dpas bwd_d any:tf32:tf32 mb32 ic1id25oc32od25kd5pd2 simd=16 l=kd5kh5kw5oc2 T=iw8 i=ic16mb32oc16 bufs=2",
        "xehpg dpas fwd x8:x8:any mb128b ic64iw3136oc64ow3136kw1pw0 simd=8 l=ic2 T=x i=ic32mb16oc64 bufs=0",
        "xehpg dpas fwd x8:x8:any mb1 ic1ih360iw640oc4oh360ow640kh3kw3ph1pw1 simd=8 l=kh3 T=ow4 i=ic4kw8oc8ow32",
        "xehpc dpas bwd_d any:x16:x16 mb16 ic256iw1444oc1024ow1444kw1pw0 simd=16 l=oc32 T=ic2iw4 i=ic64mb16oc32 bufs=3",
        "xehpc dpas bwd_w x16:any:x16 mb64 ic128iw252oc256ow237kw16pw0 simd=16 l=mb4ow15 T=ic4oc4 i=ic32oc64ow16",
        "xehpg dpas fwd x16:x16:any mb2 ic2560ih12oc1280oh12kh3ph1 simd=8 l=ic160kh3kw3 T=ow2 i=ic16mb2oc16ow6",
        "xehpg dpas fwd x8:x8:any mb1 ic128ih32oc64oh32kh3ph1 simd=8 l=kh3kw3 T=ic4 i=ic32oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb1 ic640iw4096oc320ow4096kw1pw0 simd=8 l=ic40 T=oc4ow4 i=ic16oc32ow32",
        "xehpc mad fwd x16:x16:any mb1 g64ic1ih16oc1oh16kh3ph1 simd=16 l=kh3 T=ow2 i=g16kw3ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic640ih96oc640oh96kh3ph1 simd=8 l=ic40kh3kw3 T=oc4ow4 i=ic16oc32ow24",
        "xehpc dpas bwd_d any:x16:x16 mb64 ic256iw18oc128ow15kw4pw0 simd=16 l=kw4oc4 T=ic2iw8 i=ic32mb16oc32",
        "xehpg dpas fwd x8:x8:any mb1 ic10ih15oc20oh13kh3ph0 simd=8 l=kh3kw2 T=ow2 i=ic16kw2oc8ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic1280ih16oc1280oh8kh3sh2ph1 simd=16 l=ic40kh3kw3 T=oc8 i=ic32oc16ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280ih16oc1280oh8kh3sh2ph1 simd=16 l=ic40kh3kw3 T=oc2ow8 i=ic32mb2oc64 bufs=3",
        "xehpg dpas fwd x16:x16:any mb1 ic2560ih8oc1280oh8kh3ph1 simd=8 l=ic40kh3kw3 T=ic2 i=ic32oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb2 ic640ih48oc640oh24kh3sh2ph1 simd=8 l=ic40kh3kw3 T=oc8 i=ic16oc16ow24",
        "xehpg dpas fwd x8:x8:any mb128b ic512ih7oc512oh7kh3ph1 simd=8 l=ic16kh3kw3 T=mb4oc4 i=ic32mb32oc32 bufs=3",
        "xehpc dpas fwd x16:x16:any mb1 ic3ih224oc1024oh16kh14sh14ph0 simd=16 l=kh14kw2 T=oc8ow2 i=ic4kw8oc16ow8 bufs=0",
        "xehpg dpas fwd x16:x16:any mb8 ic3ih224oc768oh14kh16sh16ph0 simd=8 l=kh16kw4 T=oc2 i=ic4kw4oc64ow14 bufs=0",
        "xehpc dpas fwd x16:x16:any mb1 ic512ih128oc512oh128kh3ph1 simd=16 l=ic16kh3kw3 T=oc4ow8 i=ic32oc64ow16 bufs=3",
        "xehpg dpas fwd x16:x16:any mb2 ic1280iw2304oc640ow2304kw1pw0 simd=8 l=ic80 T=oc4ow8 i=ic16oc32ow24",
        "xehpc dpas fwd x16:x16:any mb1 ic1280ih32oc640oh32kh3ph1 simd=16 l=ic40kh3kw3 T=oc2ow4 i=ic32oc64ow8 bufs=3",
        "xehpc dpas fwd x16:x16:any mb2 ic1280ih32oc640oh32kh3ph1 simd=16 l=ic40kh3kw3 T=ow2 i=ic32mb2oc64ow16 bufs=3",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512ih7oc512oh7kh3ph1 simd=8 l=ic2kh3kw3 T=ic8 i=ic32oc64ow8 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512ih14oc512oh7kh3sh2ph1 simd=8 l=ic2kh3kw3 T=ic8 i=ic32oc64ow7 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512iw784oc128ow784kw1pw0 simd=8 l=ic16 T=oc4 i=ic32oc16ow16 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256iw3136oc128ow3136kw1pw0 simd=8 l=ic8 T=oc4 i=ic32oc32ow16 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256iw3136oc64ow3136kw1pw0 simd=8 l=ic8 T=oc4ow2 i=ic32oc16ow28 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic64iw3136oc64ow3136kw1pw0 simd=8 l=ic2 T=oc2 i=ic32oc32ow16 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512iw49oc2048ow49kw1pw0 simd=8 l=ic16 T=oc8 i=ic32oc16ow16",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic1024ih14oc2048oh7kh1sh2ph0 simd=8 l=ic16 T=ic2 i=ic32oc64ow8 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256ih14oc256oh14kh3ph1 simd=8 l=ic2kh3kw3 T=ic4 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512ih28oc1024oh14kh1sh2ph0 simd=8 l=ic16 T=oc8 i=ic32oc32ow16",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic128iw784oc512ow784kw1pw0 simd=8 l=ic4 T=oc2 i=ic32oc32ow16 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic1024iw196oc512ow196kw1pw0 simd=8 l=ic32 T=oc2ow2 i=ic32oc16ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic2048iw49oc512ow49kw1pw0 simd=8 l=ic8 T=ic8 i=ic32oc32ow16 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic128ih28oc512oh28kh1ph0 simd=8 l=ic4 T=oc2 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512ih7oc2048oh7kh1ph0 simd=8 l=ic8 T=ic2 i=ic32oc64ow7 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic1024iw196oc256ow196kw1pw0 simd=8 l=ic8 T=ic4 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic64ih56oc256oh56kh1ph0 simd=8 l=ic2 T=oc2 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256ih28oc256oh14kh3sh2ph1 simd=8 l=ic4kh3kw3 T=oc8 i=ic64oc16ow8",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic64iw3136oc256ow3136kw1pw0 simd=8 l=ic2 T=oc8ow2 i=ic32oc32ow28 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256ih14oc1024oh14kh1ph0 simd=8 l=ic8 T=oc2 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic3ih224oc64oh112kh7sh2ph3 simd=8 l=kh7 T=oc2 i=ic4kw8oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic512iw784oc256ow784kw1pw0 simd=8 l=ic16 T=oc8ow2 i=ic32oc16ow28 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256ih56oc512oh28kh1sh2ph0 simd=8 l=ic8 T=oc8 i=ic32oc64ow14",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic64ih56oc64oh56kh3ph1 simd=8 l=ic2kh3kw3 T=oc2 i=ic32oc32ow16",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic128ih28oc128oh28kh3ph1 simd=8 l=ic2kh3kw3 T=ic2 i=ic32oc32ow14 bufs=0",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic128ih56oc128oh28kh3sh2ph1 simd=8 l=ic4kh3kw3 T=oc8 i=ic32oc16ow16",
        "xehpg:arl dpas fwd x8:x8:any mb1 ic256iw196oc1024ow196kw1pw0 simd=8 l=ic8 T=oc4ow2 i=ic32oc32ow14 bufs=0",
        nullptr,
    };
    return entries;
};
// clang-format on

} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
