open Ctypes

module Def (F : Cstubs.FOREIGN) = struct
  open F
  module Types = Posix_math_types.Def (Posix_math_generated_types)
  include Types

  let fpclassify = foreign "fpclassify" (float @-> returning int)
  let isfinite = foreign "isfinite" (double @-> returning bool)
  let isgreater = foreign "isgreater" (double @-> double @-> returning bool)

  let isgreaterequal =
    foreign "isgreaterequal" (double @-> double @-> returning bool)

  let isinf = foreign "isinf" (double @-> returning bool)
  let isless = foreign "isless" (double @-> double @-> returning bool)
  let islessequal = foreign "islessequal" (double @-> double @-> returning bool)

  let islessgreater =
    foreign "islessgreater" (double @-> double @-> returning bool)

  let isnan = foreign "isnan" (double @-> returning bool)
  let isnormal = foreign "isnormal" (double @-> returning bool)
  let isunordered = foreign "isunordered" (double @-> double @-> returning bool)
  let signbit = foreign "signbit" (double @-> returning bool)
  let m_e = foreign "ocaml_posix_math_m_e" (void @-> returning float)
  let m_log2e = foreign "ocaml_posix_math_m_log2e" (void @-> returning float)
  let m_log10e = foreign "ocaml_posix_math_m_log10e" (void @-> returning float)
  let m_ln2 = foreign "ocaml_posix_math_m_ln2" (void @-> returning float)
  let m_ln10 = foreign "ocaml_posix_math_m_ln10" (void @-> returning float)
  let m_pi = foreign "ocaml_posix_math_m_pi" (void @-> returning float)
  let m_pi_2 = foreign "ocaml_posix_math_m_pi_2" (void @-> returning float)
  let m_pi_4 = foreign "ocaml_posix_math_m_pi_4" (void @-> returning float)
  let m_1_pi = foreign "ocaml_posix_math_m_1_pi" (void @-> returning float)
  let m_2_pi = foreign "ocaml_posix_math_m_2_pi" (void @-> returning float)

  let m_2_sqrtpi =
    foreign "ocaml_posix_math_m_2_sqrtpi" (void @-> returning float)

  let m_sqrt2 = foreign "ocaml_posix_math_m_sqrt2" (void @-> returning float)
  let m_sqrt1_2 = foreign "ocaml_posix_math_m_sqrt1_2" (void @-> returning float)
  let signgam = foreign "ocaml_posix_math_signgam" (void @-> returning (ptr int))
  let huge_val = foreign "ocaml_posix_math_huge_val" (void @-> returning double)
  let huge_valf = foreign "ocaml_posix_math_huge_valf" (void @-> returning float)

  let huge_vall =
    foreign "ocaml_posix_math_huge_vall" (void @-> returning ldouble)

  let infinity = foreign "ocaml_posix_math_infinity" (void @-> returning float)
  let nan_constant = foreign "ocaml_posix_math_nan" (void @-> returning float)
  let acos = foreign "acos" (double @-> returning double)
  let acosf = foreign "acosf" (float @-> returning float)
  let acosh = foreign "acosh" (double @-> returning double)
  let acoshf = foreign "acoshf" (float @-> returning float)
  let acoshl = foreign "acoshl" (ldouble @-> returning ldouble)
  let acosl = foreign "acosl" (ldouble @-> returning ldouble)
  let asin = foreign "asin" (double @-> returning double)
  let asinf = foreign "asinf" (float @-> returning float)
  let asinh = foreign "asinh" (double @-> returning double)
  let asinhf = foreign "asinhf" (float @-> returning float)
  let asinhl = foreign "asinhl" (ldouble @-> returning ldouble)
  let asinl = foreign "asinl" (ldouble @-> returning ldouble)
  let atan = foreign "atan" (double @-> returning double)
  let atan2 = foreign "atan2" (double @-> double @-> returning double)
  let atan2f = foreign "atan2f" (float @-> float @-> returning float)
  let atan2l = foreign "atan2l" (ldouble @-> ldouble @-> returning ldouble)
  let atanf = foreign "atanf" (float @-> returning float)
  let atanh = foreign "atanh" (double @-> returning double)
  let atanhf = foreign "atanhf" (float @-> returning float)
  let atanhl = foreign "atanhl" (ldouble @-> returning ldouble)
  let atanl = foreign "atanl" (ldouble @-> returning ldouble)
  let cbrt = foreign "cbrt" (double @-> returning double)
  let cbrtf = foreign "cbrtf" (float @-> returning float)
  let cbrtl = foreign "cbrtl" (ldouble @-> returning ldouble)
  let ceil = foreign "ceil" (double @-> returning double)
  let ceilf = foreign "ceilf" (float @-> returning float)
  let ceill = foreign "ceill" (ldouble @-> returning ldouble)
  let copysign = foreign "copysign" (double @-> double @-> returning double)
  let copysignf = foreign "copysignf" (float @-> float @-> returning float)
  let copysignl = foreign "copysignl" (ldouble @-> ldouble @-> returning ldouble)
  let cos = foreign "cos" (double @-> returning double)
  let cosf = foreign "cosf" (float @-> returning float)
  let cosh = foreign "cosh" (double @-> returning double)
  let coshf = foreign "coshf" (float @-> returning float)
  let coshl = foreign "coshl" (ldouble @-> returning ldouble)
  let cosl = foreign "cosl" (ldouble @-> returning ldouble)
  let erf = foreign "erf" (double @-> returning double)
  let erfc = foreign "erfc" (double @-> returning double)
  let erfcf = foreign "erfcf" (float @-> returning float)
  let erfcl = foreign "erfcl" (ldouble @-> returning ldouble)
  let erff = foreign "erff" (float @-> returning float)
  let erfl = foreign "erfl" (ldouble @-> returning ldouble)
  let exp = foreign "exp" (double @-> returning double)
  let exp2 = foreign "exp2" (double @-> returning double)
  let exp2f = foreign "exp2f" (float @-> returning float)
  let exp2l = foreign "exp2l" (ldouble @-> returning ldouble)
  let expf = foreign "expf" (float @-> returning float)
  let expl = foreign "expl" (ldouble @-> returning ldouble)
  let expm1 = foreign "expm1" (double @-> returning double)
  let expm1f = foreign "expm1f" (float @-> returning float)
  let expm1l = foreign "expm1l" (ldouble @-> returning ldouble)
  let fabs = foreign "fabs" (double @-> returning double)
  let fabsf = foreign "fabsf" (float @-> returning float)
  let fabsl = foreign "fabsl" (ldouble @-> returning ldouble)
  let fdim = foreign "fdim" (double @-> double @-> returning double)
  let fdimf = foreign "fdimf" (float @-> float @-> returning float)
  let fdiml = foreign "fdiml" (ldouble @-> ldouble @-> returning ldouble)
  let floor = foreign "floor" (double @-> returning double)
  let floorf = foreign "floorf" (float @-> returning float)
  let floorl = foreign "floorl" (ldouble @-> returning ldouble)
  let fma = foreign "fma" (double @-> double @-> double @-> returning double)
  let fmaf = foreign "fmaf" (float @-> float @-> float @-> returning float)

  let fmal =
    foreign "fmal" (ldouble @-> ldouble @-> ldouble @-> returning ldouble)

  let fmax = foreign "fmax" (double @-> double @-> returning double)
  let fmaxf = foreign "fmaxf" (float @-> float @-> returning float)
  let fmaxl = foreign "fmaxl" (ldouble @-> ldouble @-> returning ldouble)
  let fmin = foreign "fmin" (double @-> double @-> returning double)
  let fminf = foreign "fminf" (float @-> float @-> returning float)
  let fminl = foreign "fminl" (ldouble @-> ldouble @-> returning ldouble)
  let fmod = foreign "fmod" (double @-> double @-> returning double)
  let fmodf = foreign "fmodf" (float @-> float @-> returning float)
  let fmodl = foreign "fmodl" (ldouble @-> ldouble @-> returning ldouble)
  let frexp = foreign "frexp" (double @-> ptr int @-> returning double)
  let frexpf = foreign "frexpf" (float @-> ptr int @-> returning float)
  let frexpl = foreign "frexpl" (ldouble @-> ptr int @-> returning ldouble)
  let hypot = foreign "hypot" (double @-> double @-> returning double)
  let hypotf = foreign "hypotf" (float @-> float @-> returning float)
  let hypotl = foreign "hypotl" (ldouble @-> ldouble @-> returning ldouble)
  let ilogb = foreign "ilogb" (double @-> returning int)
  let ilogbf = foreign "ilogbf" (float @-> returning int)
  let ilogbl = foreign "ilogbl" (ldouble @-> returning int)
  let j0 = foreign "j0" (double @-> returning double)
  let j1 = foreign "j1" (double @-> returning double)
  let jn = foreign "jn" (int @-> double @-> returning double)
  let ldexp = foreign "ldexp" (double @-> int @-> returning double)
  let ldexpf = foreign "ldexpf" (float @-> int @-> returning float)
  let ldexpl = foreign "ldexpl" (ldouble @-> int @-> returning ldouble)
  let lgamma = foreign "lgamma" (double @-> returning double)
  let lgammaf = foreign "lgammaf" (float @-> returning float)
  let lgammal = foreign "lgammal" (ldouble @-> returning ldouble)
  let llrint = foreign "llrint" (double @-> returning llong)
  let llrintf = foreign "llrintf" (float @-> returning llong)
  let llrintl = foreign "llrintl" (ldouble @-> returning llong)
  let llround = foreign "llround" (double @-> returning llong)
  let llroundf = foreign "llroundf" (float @-> returning llong)
  let llroundl = foreign "llroundl" (ldouble @-> returning llong)
  let log = foreign "log" (double @-> returning double)
  let log10 = foreign "log10" (double @-> returning double)
  let log10f = foreign "log10f" (float @-> returning float)
  let log10l = foreign "log10l" (ldouble @-> returning ldouble)
  let log1p = foreign "log1p" (double @-> returning double)
  let log1pf = foreign "log1pf" (float @-> returning float)
  let log1pl = foreign "log1pl" (ldouble @-> returning ldouble)
  let log2 = foreign "log2" (double @-> returning double)
  let log2f = foreign "log2f" (float @-> returning float)
  let log2l = foreign "log2l" (ldouble @-> returning ldouble)
  let logb = foreign "logb" (double @-> returning double)
  let logbf = foreign "logbf" (float @-> returning float)
  let logbl = foreign "logbl" (ldouble @-> returning ldouble)
  let logf = foreign "logf" (float @-> returning float)
  let logl = foreign "logl" (ldouble @-> returning ldouble)
  let lrint = foreign "lrint" (double @-> returning long)
  let lrintf = foreign "lrintf" (float @-> returning long)
  let lrintl = foreign "lrintl" (ldouble @-> returning long)
  let lround = foreign "lround" (double @-> returning long)
  let lroundf = foreign "lroundf" (float @-> returning long)
  let lroundl = foreign "lroundl" (ldouble @-> returning long)
  let modf = foreign "modf" (double @-> ptr double @-> returning double)
  let modff = foreign "modff" (float @-> ptr float @-> returning float)
  let modfl = foreign "modfl" (ldouble @-> ptr ldouble @-> returning ldouble)
  let nan = foreign "nan" (string @-> returning double)
  let nanf = foreign "nanf" (string @-> returning float)
  let nanl = foreign "nanl" (string @-> returning ldouble)
  let nearbyint = foreign "nearbyint" (double @-> returning double)
  let nearbyintf = foreign "nearbyintf" (float @-> returning float)
  let nearbyintl = foreign "nearbyintl" (ldouble @-> returning ldouble)
  let nextafter = foreign "nextafter" (double @-> double @-> returning double)
  let nextafterf = foreign "nextafterf" (float @-> float @-> returning float)

  let nextafterl =
    foreign "nextafterl" (ldouble @-> ldouble @-> returning ldouble)

  let nexttoward = foreign "nexttoward" (double @-> ldouble @-> returning double)
  let nexttowardf = foreign "nexttowardf" (float @-> ldouble @-> returning float)

  let nexttowardl =
    foreign "nexttowardl" (ldouble @-> ldouble @-> returning ldouble)

  let pow = foreign "pow" (double @-> double @-> returning double)
  let powf = foreign "powf" (float @-> float @-> returning float)
  let powl = foreign "powl" (ldouble @-> ldouble @-> returning ldouble)
  let remainder = foreign "remainder" (double @-> double @-> returning double)
  let remainderf = foreign "remainderf" (float @-> float @-> returning float)

  let remainderl =
    foreign "remainderl" (ldouble @-> ldouble @-> returning ldouble)

  let remquo =
    foreign "remquo" (double @-> double @-> ptr int @-> returning double)

  let remquof =
    foreign "remquof" (float @-> float @-> ptr int @-> returning float)

  let remquol =
    foreign "remquol" (ldouble @-> ldouble @-> ptr int @-> returning ldouble)

  let rint = foreign "rint" (double @-> returning double)
  let rintf = foreign "rintf" (float @-> returning float)
  let rintl = foreign "rintl" (ldouble @-> returning ldouble)
  let round = foreign "round" (double @-> returning double)
  let roundf = foreign "roundf" (float @-> returning float)
  let roundl = foreign "roundl" (ldouble @-> returning ldouble)
  let scalbln = foreign "scalbln" (double @-> long @-> returning double)
  let scalblnf = foreign "scalblnf" (float @-> long @-> returning float)
  let scalblnl = foreign "scalblnl" (ldouble @-> long @-> returning ldouble)
  let scalbn = foreign "scalbn" (double @-> int @-> returning double)
  let scalbnf = foreign "scalbnf" (float @-> int @-> returning float)
  let scalbnl = foreign "scalbnl" (ldouble @-> int @-> returning ldouble)
  let sin = foreign "sin" (double @-> returning double)
  let sinf = foreign "sinf" (float @-> returning float)
  let sinh = foreign "sinh" (double @-> returning double)
  let sinhf = foreign "sinhf" (float @-> returning float)
  let sinhl = foreign "sinhl" (ldouble @-> returning ldouble)
  let sinl = foreign "sinl" (ldouble @-> returning ldouble)
  let sqrt = foreign "sqrt" (double @-> returning double)
  let sqrtf = foreign "sqrtf" (float @-> returning float)
  let sqrtl = foreign "sqrtl" (ldouble @-> returning ldouble)
  let tan = foreign "tan" (double @-> returning double)
  let tanf = foreign "tanf" (float @-> returning float)
  let tanh = foreign "tanh" (double @-> returning double)
  let tanhf = foreign "tanhf" (float @-> returning float)
  let tanhl = foreign "tanhl" (ldouble @-> returning ldouble)
  let tanl = foreign "tanl" (ldouble @-> returning ldouble)
  let tgamma = foreign "tgamma" (double @-> returning double)
  let tgammaf = foreign "tgammaf" (float @-> returning float)
  let tgammal = foreign "tgammal" (ldouble @-> returning ldouble)
  let trunc = foreign "trunc" (double @-> returning double)
  let truncf = foreign "truncf" (float @-> returning float)
  let truncl = foreign "truncl" (ldouble @-> returning ldouble)
  let y0 = foreign "y0" (double @-> returning double)
  let y1 = foreign "y1" (double @-> returning double)
  let yn = foreign "yn" (int @-> double @-> returning double)
end
