// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Xml
{
    /// <summary>
    /// This class defines a set of common XML namespaces for sharing across multiple source files.
    /// </summary>
    internal static class XmlReservedNs
    {
        internal const string NsXml = "http://www.w3.org/XML/1998/namespace";
        internal const string NsXmlNs = "http://www.w3.org/2000/xmlns/";
        internal const string NsDataType = "urn:schemas-microsoft-com:datatypes";
        internal const string NsDataTypeAlias = "uuid:C2F41010-65B3-11D1-A29F-00AA00C14882";
        internal const string NsDataTypeOld = "urn:uuid:C2F41010-65B3-11D1-A29F-00AA00C14882/";
        internal const string NsMsxsl = "urn:schemas-microsoft-com:xslt";
        internal const string NsXdr = "urn:schemas-microsoft-com:xml-data";
        internal const string NsXslDebug = "urn:schemas-microsoft-com:xslt-debug";
        internal const string NsXdrAlias = "uuid:BDC6E3F0-6DA3-11D1-A2A3-00AA00C14882";
        internal const string NsWdXsl = "http://www.w3.org/TR/WD-xsl";
        internal const string NsXs = "http://www.w3.org/2001/XMLSchema";
        internal const string NsXsi = "http://www.w3.org/2001/XMLSchema-instance";
        internal const string NsXslt = "http://www.w3.org/1999/XSL/Transform";
        internal const string NsExsltCommon = "http://exslt.org/common";
        internal const string NsXQueryDataType = "http://www.w3.org/2003/11/xpath-datatypes";
        internal const string NsCollationBase = "http://collations.microsoft.com";
        internal const string NsCollCodePoint = "http://www.w3.org/2004/10/xpath-functions/collation/codepoint";
    };
}
