/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 639 language definitions, lookup functions

   Written by Moritz Bunkus <mo@bunkus.online>.
*/

// -----------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso639_list" rake target.
// -----------------------------------------------------------------------

#include "common/iso639_types.h"

using namespace std::string_literals;

namespace mtx::iso639 {

std::vector<language_t> g_languages;

struct language_init_t {
  char const *english_name, *alpha_3_code, *alpha_2_code, *terminology_abbrev;
  bool is_part_of_iso639_2, is_deprecated;
};

static language_init_t const s_languages_init[] = {
  { "'Are'are",                                                   "alu",     "",   "",    false, false },
  { "'Auhelawa",                                                  "kud",     "",   "",    false, false },
  { "A'ou",                                                       "aou",     "",   "",    false, false },
  { "A-Pucikwar",                                                 "apq",     "",   "",    false, false },
  { "Aari",                                                       "aiw",     "",   "",    false, false },
  { "Aasáx",                                                      "aas",     "",   "",    false, false },
  { "Abadi",                                                      "kbt",     "",   "",    false, false },
  { "Abaga",                                                      "abg",     "",   "",    false, false },
  { "Abai Sungai",                                                "abf",     "",   "",    false, false },
  { "Abanyom",                                                    "abm",     "",   "",    false, false },
  { "Abar",                                                       "mij",     "",   "",    false, false },
  { "Abau",                                                       "aau",     "",   "",    false, false },
  { "Abaza",                                                      "abq",     "",   "",    false, false },
  { "Abellen Ayta",                                               "abp",     "",   "",    false, false },
  { "Abidji",                                                     "abi",     "",   "",    false, false },
  { "Abinomn",                                                    "bsa",     "",   "",    false, false },
  { "Abipon",                                                     "axb",     "",   "",    false, false },
  { "Abishira",                                                   "ash",     "",   "",    false, false },
  { "Abkhazian",                                                  "abk",     "ab", "",    true,  false },
  { "Abom",                                                       "aob",     "",   "",    false, false },
  { "Abon",                                                       "abo",     "",   "",    false, false },
  { "Abron",                                                      "abr",     "",   "",    false, false },
  { "Abu",                                                        "ado",     "",   "",    false, false },
  { "Abu' Arapesh",                                               "aah",     "",   "",    false, false },
  { "Abua",                                                       "abn",     "",   "",    false, false },
  { "Abui",                                                       "abz",     "",   "",    false, false },
  { "Abun",                                                       "kgr",     "",   "",    false, false },
  { "Abure",                                                      "abu",     "",   "",    false, false },
  { "Abureni",                                                    "mgj",     "",   "",    false, false },
  { "Abé",                                                        "aba",     "",   "",    false, false },
  { "Acatepec Me'phaa",                                           "tpx",     "",   "",    false, false },
  { "Achagua",                                                    "aca",     "",   "",    false, false },
  { "Achang",                                                     "acn",     "",   "",    false, false },
  { "Ache",                                                       "yif",     "",   "",    false, false },
  { "Acheron",                                                    "acz",     "",   "",    false, false },
  { "Achi",                                                       "acr",     "",   "",    false, false },
  { "Achinese",                                                   "ace",     "",   "",    true,  false },
  { "Achterhoeks",                                                "act",     "",   "",    false, false },
  { "Achuar-Shiwiar",                                             "acu",     "",   "",    false, false },
  { "Achumawi",                                                   "acv",     "",   "",    false, false },
  { "Aché",                                                       "guq",     "",   "",    false, false },
  { "Acoli",                                                      "ach",     "",   "",    true,  false },
  { "Acroá",                                                      "acs",     "",   "",    false, false },
  { "Adai",                                                       "xad",     "",   "",    false, false },
  { "Adamawa Fulfulde",                                           "fub",     "",   "",    false, false },
  { "Adamorobe Sign Language",                                    "ads",     "",   "",    false, false },
  { "Adang",                                                      "adn",     "",   "",    false, false },
  { "Adangbe",                                                    "adq",     "",   "",    false, false },
  { "Adangme",                                                    "ada",     "",   "",    true,  false },
  { "Adap",                                                       "adp",     "",   "",    false, true  },
  { "Adara",                                                      "kad",     "",   "",    false, false },
  { "Adasen",                                                     "tiu",     "",   "",    false, false },
  { "Adele",                                                      "ade",     "",   "",    false, false },
  { "Adhola",                                                     "adh",     "",   "",    false, false },
  { "Adi",                                                        "adi",     "",   "",    false, false },
  { "Adilabad Gondi",                                             "wsg",     "",   "",    false, false },
  { "Adioukrou",                                                  "adj",     "",   "",    false, false },
  { "Adithinngithigh",                                            "dth",     "",   "",    false, false },
  { "Adivasi Oriya",                                              "ort",     "",   "",    false, false },
  { "Adiwasi Garasia",                                            "gas",     "",   "",    false, false },
  { "Adnyamathanha",                                              "adt",     "",   "",    false, false },
  { "Adonara",                                                    "adr",     "",   "",    false, false },
  { "Aduge",                                                      "adu",     "",   "",    false, false },
  { "Adyghe",                                                     "ady",     "",   "",    true,  false },
  { "Adzera",                                                     "adz",     "",   "",    false, false },
  { "Aeka",                                                       "aez",     "",   "",    false, false },
  { "Aekyom",                                                     "awi",     "",   "",    false, false },
  { "Aequian",                                                    "xae",     "",   "",    false, false },
  { "Aer",                                                        "aeq",     "",   "",    false, false },
  { "Afade",                                                      "aal",     "",   "",    false, false },
  { "Afar",                                                       "aar",     "aa", "",    true,  false },
  { "Afghan Sign Language",                                       "afg",     "",   "",    false, false },
  { "Afitti",                                                     "aft",     "",   "",    false, false },
  { "Afrihili",                                                   "afh",     "",   "",    true,  false },
  { "Afrikaans",                                                  "afr",     "af", "",    true,  false },
  { "Afro-Asiatic languages",                                     "afa",     "",   "",    true,  false },
  { "Afro-Seminole Creole",                                       "afs",     "",   "",    false, false },
  { "Agarabi",                                                    "agd",     "",   "",    false, false },
  { "Agariya",                                                    "agi",     "",   "",    false, false },
  { "Agatu",                                                      "agc",     "",   "",    false, false },
  { "Agavotaguerra",                                              "avo",     "",   "",    false, false },
  { "Aghem",                                                      "agq",     "",   "",    false, false },
  { "Aghu Tharnggalu",                                            "ggr",     "",   "",    false, true  },
  { "Aghu",                                                       "ahh",     "",   "",    false, false },
  { "Aghu-Tharnggala",                                            "gtu",     "",   "",    false, false },
  { "Aghul",                                                      "agx",     "",   "",    false, false },
  { "Aghwan",                                                     "xag",     "",   "",    false, false },
  { "Agi",                                                        "aif",     "",   "",    false, false },
  { "Agob",                                                       "kit",     "",   "",    false, false },
  { "Agoi",                                                       "ibm",     "",   "",    false, false },
  { "Aguacateco",                                                 "agu",     "",   "",    false, false },
  { "Aguano",                                                     "aga",     "",   "",    false, false },
  { "Aguaruna",                                                   "agr",     "",   "",    false, false },
  { "Aguna",                                                      "aug",     "",   "",    false, false },
  { "Agusan Manobo",                                              "msm",     "",   "",    false, false },
  { "Agutaynen",                                                  "agn",     "",   "",    false, false },
  { "Agwagwune",                                                  "yay",     "",   "",    false, false },
  { "Ahanta",                                                     "aha",     "",   "",    false, false },
  { "Aheri Gondi",                                                "esg",     "",   "",    false, false },
  { "Aheu",                                                       "thm",     "",   "",    false, false },
  { "Ahirani",                                                    "ahr",     "",   "",    false, false },
  { "Ahom",                                                       "aho",     "",   "",    false, false },
  { "Ahtena",                                                     "aht",     "",   "",    false, false },
  { "Ahwai",                                                      "nfd",     "",   "",    false, false },
  { "Ai-Cham",                                                    "aih",     "",   "",    false, false },
  { "Aighon",                                                     "aix",     "",   "",    false, false },
  { "Aikanã",                                                     "tba",     "",   "",    false, false },
  { "Aiklep",                                                     "mwg",     "",   "",    false, false },
  { "Aimaq",                                                      "aiq",     "",   "",    false, false },
  { "Aimele",                                                     "ail",     "",   "",    false, false },
  { "Aimol",                                                      "aim",     "",   "",    false, false },
  { "Ainbai",                                                     "aic",     "",   "",    false, false },
  { "Ainu (China)",                                               "aib",     "",   "",    false, false },
  { "Ainu (Japan)",                                               "ain",     "",   "",    true,  false },
  { "Aiome",                                                      "aki",     "",   "",    false, false },
  { "Airoran",                                                    "air",     "",   "",    false, false },
  { "Aiton",                                                      "aio",     "",   "",    false, false },
  { "Aja (Benin)",                                                "ajg",     "",   "",    false, false },
  { "Aja (South Sudan)",                                          "aja",     "",   "",    false, false },
  { "Ajawa",                                                      "ajw",     "",   "",    false, false },
  { "Ajië",                                                       "aji",     "",   "",    false, false },
  { "Ajumbu",                                                     "muc",     "",   "",    false, false },
  { "Ajyíninka Apurucayali",                                      "cpc",     "",   "",    false, false },
  { "Ak",                                                         "akq",     "",   "",    false, false },
  { "Aka",                                                        "soh",     "",   "",    false, false },
  { "Aka-Bea",                                                    "abj",     "",   "",    false, false },
  { "Aka-Bo",                                                     "akm",     "",   "",    false, false },
  { "Aka-Cari",                                                   "aci",     "",   "",    false, false },
  { "Aka-Jeru",                                                   "akj",     "",   "",    false, false },
  { "Aka-Kede",                                                   "akx",     "",   "",    false, false },
  { "Aka-Kol",                                                    "aky",     "",   "",    false, false },
  { "Aka-Kora",                                                   "ack",     "",   "",    false, false },
  { "Akan",                                                       "aka",     "ak", "",    true,  false },
  { "Akar-Bale",                                                  "acl",     "",   "",    false, false },
  { "Akaselem",                                                   "aks",     "",   "",    false, false },
  { "Akawaio",                                                    "ake",     "",   "",    false, false },
  { "Ake",                                                        "aik",     "",   "",    false, false },
  { "Akebu",                                                      "keu",     "",   "",    false, false },
  { "Akei",                                                       "tsr",     "",   "",    false, false },
  { "Akeu",                                                       "aeu",     "",   "",    false, false },
  { "Akha",                                                       "ahk",     "",   "",    false, false },
  { "Akhvakh",                                                    "akv",     "",   "",    false, false },
  { "Akkadian",                                                   "akk",     "",   "",    true,  false },
  { "Akkala Sami",                                                "sia",     "",   "",    false, false },
  { "Aklanon",                                                    "akl",     "",   "",    false, false },
  { "Akolet",                                                     "akt",     "",   "",    false, false },
  { "Akoose",                                                     "bss",     "",   "",    false, false },
  { "Akoye",                                                      "miw",     "",   "",    false, false },
  { "Akpa",                                                       "akf",     "",   "",    false, false },
  { "Akpes",                                                      "ibe",     "",   "",    false, false },
  { "Akrukay",                                                    "afi",     "",   "",    false, false },
  { "Akukem",                                                     "spm",     "",   "",    false, false },
  { "Akuku",                                                      "ayk",     "",   "",    false, false },
  { "Akum",                                                       "aku",     "",   "",    false, false },
  { "Akuntsu",                                                    "aqz",     "",   "",    false, false },
  { "Akurio",                                                     "ako",     "",   "",    false, false },
  { "Akwa",                                                       "akw",     "",   "",    false, false },
  { "Akyaung Ari Naga",                                           "nqy",     "",   "",    false, false },
  { "Al-Sayyid Bedouin Sign Language",                            "syy",     "",   "",    false, false },
  { "Alaba-K’abeena",                                             "alw",     "",   "",    false, false },
  { "Alabama",                                                    "akz",     "",   "",    false, false },
  { "Alabat Island Agta",                                         "dul",     "",   "",    false, false },
  { "Alacalufan languages",                                       "aqa",     "",   "",    false, false },
  { "Alacatlatzala Mixtec",                                       "mim",     "",   "",    false, false },
  { "Alago",                                                      "ala",     "",   "",    false, false },
  { "Alagwa",                                                     "wbj",     "",   "",    false, false },
  { "Alak",                                                       "alk",     "",   "",    false, false },
  { "Alamblak",                                                   "amp",     "",   "",    false, false },
  { "Alangan",                                                    "alj",     "",   "",    false, false },
  { "Alanic",                                                     "xln",     "",   "",    false, false },
  { "Alapmunte",                                                  "apv",     "",   "",    false, false },
  { "Alawa",                                                      "alh",     "",   "",    false, false },
  { "Albanian Sign Language",                                     "sqk",     "",   "",    false, false },
  { "Albanian languages",                                         "sqj",     "",   "",    false, false },
  { "Albanian",                                                   "alb",     "sq", "sqi", true,  false },
  { "Albarradas Sign Language",                                   "lsc",     "",   "",    false, false },
  { "Albay Bicolano",                                             "bhk",     "",   "",    false, true  },
  { "Alcozauca Mixtec",                                           "xta",     "",   "",    false, false },
  { "Alege",                                                      "alf",     "",   "",    false, false },
  { "Alekano",                                                    "gah",     "",   "",    false, false },
  { "Aleut",                                                      "ale",     "",   "",    true,  false },
  { "Algerian Arabic",                                            "arq",     "",   "",    false, false },
  { "Algerian Jewish Sign Language",                              "ajs",     "",   "",    false, false },
  { "Algerian Saharan Arabic",                                    "aao",     "",   "",    false, false },
  { "Algerian Sign Language",                                     "asp",     "",   "",    false, false },
  { "Algic languages",                                            "aql",     "",   "",    false, false },
  { "Algonquian languages",                                       "alg",     "",   "",    true,  false },
  { "Algonquin",                                                  "alq",     "",   "",    false, false },
  { "Ali",                                                        "aiy",     "",   "",    false, false },
  { "Alladian",                                                   "ald",     "",   "",    false, false },
  { "Allar",                                                      "all",     "",   "",    false, false },
  { "Alngith",                                                    "aid",     "",   "",    false, false },
  { "Alo Phola",                                                  "ypo",     "",   "",    false, false },
  { "Alor",                                                       "aol",     "",   "",    false, false },
  { "Aloápam Zapotec",                                            "zaq",     "",   "",    false, false },
  { "Alsea",                                                      "aes",     "",   "",    false, false },
  { "Altaic languages",                                           "tut",     "",   "",    true,  false },
  { "Alu Kurumba",                                                "xua",     "",   "",    false, false },
  { "Alugu",                                                      "aub",     "",   "",    false, false },
  { "Alumu-Tesu",                                                 "aab",     "",   "",    false, false },
  { "Alune",                                                      "alp",     "",   "",    false, false },
  { "Aluo",                                                       "yna",     "",   "",    false, false },
  { "Alur",                                                       "alz",     "",   "",    false, false },
  { "Alutor",                                                     "alr",     "",   "",    false, false },
  { "Alviri-Vidari",                                              "avd",     "",   "",    false, false },
  { "Alyawarr",                                                   "aly",     "",   "",    false, false },
  { "Ama (Papua New Guinea)",                                     "amm",     "",   "",    false, false },
  { "Ama (Sudan)",                                                "nyi",     "",   "",    false, false },
  { "Amahai",                                                     "amq",     "",   "",    false, false },
  { "Amahuaca",                                                   "amc",     "",   "",    false, false },
  { "Amaimon",                                                    "ali",     "",   "",    false, false },
  { "Amal",                                                       "aad",     "",   "",    false, false },
  { "Amami Koniya Sign Language",                                 "jks",     "",   "",    false, false },
  { "Amanab",                                                     "amn",     "",   "",    false, false },
  { "Amanayé",                                                    "ama",     "",   "",    false, false },
  { "Amara",                                                      "aie",     "",   "",    false, false },
  { "Amarakaeri",                                                 "amr",     "",   "",    false, false },
  { "Amarasi",                                                    "aaz",     "",   "",    false, false },
  { "Amatlán Zapotec",                                            "zpo",     "",   "",    false, false },
  { "Amba (Solomon Islands)",                                     "utp",     "",   "",    false, false },
  { "Amba (Uganda)",                                              "rwm",     "",   "",    false, false },
  { "Ambai",                                                      "amk",     "",   "",    false, false },
  { "Ambakich",                                                   "aew",     "",   "",    false, false },
  { "Ambala Ayta",                                                "abc",     "",   "",    false, false },
  { "Ambelau",                                                    "amv",     "",   "",    false, false },
  { "Ambele",                                                     "ael",     "",   "",    false, false },
  { "Amblong",                                                    "alm",     "",   "",    false, false },
  { "Ambo",                                                       "amb",     "",   "",    false, false },
  { "Ambo-Pasco Quechua",                                         "qva",     "",   "",    false, false },
  { "Ambonese Malay",                                             "abs",     "",   "",    false, false },
  { "Ambrak",                                                     "aag",     "",   "",    false, false },
  { "Ambul",                                                      "apo",     "",   "",    false, false },
  { "Ambulas",                                                    "abt",     "",   "",    false, false },
  { "Amdang",                                                     "amj",     "",   "",    false, false },
  { "Amdo Tibetan",                                               "adx",     "",   "",    false, false },
  { "Amele",                                                      "aey",     "",   "",    false, false },
  { "American Sign Language",                                     "ase",     "",   "",    false, false },
  { "Amganad Ifugao",                                             "ifa",     "",   "",    false, false },
  { "Amharic",                                                    "amh",     "am", "",    true,  false },
  { "Ami",                                                        "amy",     "",   "",    false, false },
  { "Amis",                                                       "ami",     "",   "",    false, false },
  { "Amo",                                                        "amo",     "",   "",    false, false },
  { "Amol",                                                       "alx",     "",   "",    false, false },
  { "Amoltepec Mixtec",                                           "mbz",     "",   "",    false, false },
  { "Ampanang",                                                   "apg",     "",   "",    false, false },
  { "Ampari Dogon",                                               "aqd",     "",   "",    false, false },
  { "Amri Karbi",                                                 "ajz",     "",   "",    false, false },
  { "Amto",                                                       "amt",     "",   "",    false, false },
  { "Amundava",                                                   "adw",     "",   "",    false, false },
  { "Amurdak",                                                    "amg",     "",   "",    false, false },
  { "Ana Tinga Dogon",                                            "dti",     "",   "",    false, false },
  { "Anaang",                                                     "anw",     "",   "",    false, false },
  { "Anakalangu",                                                 "akg",     "",   "",    false, false },
  { "Anal",                                                       "anm",     "",   "",    false, false },
  { "Anam",                                                       "pda",     "",   "",    false, false },
  { "Anambé",                                                     "aan",     "",   "",    false, false },
  { "Anamgura",                                                   "imi",     "",   "",    false, false },
  { "Anasi",                                                      "bpo",     "",   "",    false, false },
  { "Ancient Hebrew",                                             "hbo",     "",   "",    false, false },
  { "Ancient Macedonian",                                         "xmk",     "",   "",    false, false },
  { "Ancient North Arabian",                                      "xna",     "",   "",    false, false },
  { "Ancient Zapotec",                                            "xzp",     "",   "",    false, false },
  { "Andaandi",                                                   "dgl",     "",   "",    false, false },
  { "Andai",                                                      "afd",     "",   "",    false, false },
  { "Andajin",                                                    "ajn",     "",   "",    false, false },
  { "Andalusian Arabic",                                          "xaa",     "",   "",    false, false },
  { "Andaman Creole Hindi",                                       "hca",     "",   "",    false, false },
  { "Andaqui",                                                    "ana",     "",   "",    false, false },
  { "Andarum",                                                    "aod",     "",   "",    false, false },
  { "Andegerebinha",                                              "adg",     "",   "",    false, false },
  { "Andh",                                                       "anr",     "",   "",    false, false },
  { "Andi",                                                       "ani",     "",   "",    false, false },
  { "Andio",                                                      "bzb",     "",   "",    false, false },
  { "Andoa",                                                      "anb",     "",   "",    false, false },
  { "Andoque",                                                    "ano",     "",   "",    false, false },
  { "Andra-Hus",                                                  "anx",     "",   "",    false, false },
  { "Aneityum",                                                   "aty",     "",   "",    false, false },
  { "Anem",                                                       "anz",     "",   "",    false, false },
  { "Aneme Wake",                                                 "aby",     "",   "",    false, false },
  { "Anfillo",                                                    "myo",     "",   "",    false, false },
  { "Angaataha",                                                  "agm",     "",   "",    false, false },
  { "Angaité",                                                    "aqt",     "",   "",    false, false },
  { "Angal Enen",                                                 "aoe",     "",   "",    false, false },
  { "Angal Heneng",                                               "akh",     "",   "",    false, false },
  { "Angal",                                                      "age",     "",   "",    false, false },
  { "Angami Naga",                                                "njm",     "",   "",    false, false },
  { "Angguruk Yali",                                              "yli",     "",   "",    false, false },
  { "Angika",                                                     "anp",     "",   "",    true,  false },
  { "Angkamuthi",                                                 "avm",     "",   "",    false, false },
  { "Anglo-Norman",                                               "xno",     "",   "",    false, false },
  { "Angloromani",                                                "rme",     "",   "",    false, false },
  { "Angolar",                                                    "aoa",     "",   "",    false, false },
  { "Angor",                                                      "agg",     "",   "",    false, false },
  { "Angoram",                                                    "aog",     "",   "",    false, false },
  { "Angosturas Tunebo",                                          "tnd",     "",   "",    false, false },
  { "Anguthimri",                                                 "awg",     "",   "",    false, false },
  { "Ani Phowa",                                                  "ypn",     "",   "",    false, false },
  { "Anii",                                                       "blo",     "",   "",    false, false },
  { "Animere",                                                    "anf",     "",   "",    false, false },
  { "Anindilyakwa",                                               "aoi",     "",   "",    false, false },
  { "Aninka",                                                     "aqk",     "",   "",    false, false },
  { "Anjam",                                                      "boj",     "",   "",    false, false },
  { "Ankave",                                                     "aak",     "",   "",    false, false },
  { "Anmatyerre",                                                 "amx",     "",   "",    false, false },
  { "Anong",                                                      "nun",     "",   "",    false, false },
  { "Anor",                                                       "anj",     "",   "",    false, false },
  { "Anserma",                                                    "ans",     "",   "",    false, false },
  { "Ansus",                                                      "and",     "",   "",    false, false },
  { "Antakarinya",                                                "ant",     "",   "",    false, false },
  { "Antankarana Malagasy",                                       "xmv",     "",   "",    false, false },
  { "Antigua and Barbuda Creole English",                         "aig",     "",   "",    false, false },
  { "Anu-Hkongso Chin",                                           "anl",     "",   "",    false, false },
  { "Anuak",                                                      "anu",     "",   "",    false, false },
  { "Anufo",                                                      "cko",     "",   "",    false, false },
  { "Anuki",                                                      "aui",     "",   "",    false, false },
  { "Anus",                                                       "auq",     "",   "",    false, false },
  { "Anuta",                                                      "aud",     "",   "",    false, false },
  { "Anyin Morofo",                                               "mtb",     "",   "",    false, false },
  { "Anyin",                                                      "any",     "",   "",    false, false },
  { "Ao Naga",                                                    "njo",     "",   "",    false, false },
  { "Aoheng",                                                     "pni",     "",   "",    false, false },
  { "Aore",                                                       "aor",     "",   "",    false, false },
  { "Ap Ma",                                                      "kbx",     "",   "",    false, false },
  { "Apache languages",                                           "apa",     "",   "",    true,  false },
  { "Apalachee",                                                  "xap",     "",   "",    false, false },
  { "Apalaí",                                                     "apy",     "",   "",    false, false },
  { "Apali",                                                      "ena",     "",   "",    false, false },
  { "Apasco-Apoala Mixtec",                                       "mip",     "",   "",    false, false },
  { "Apatani",                                                    "apt",     "",   "",    false, false },
  { "Apiaká",                                                     "api",     "",   "",    false, false },
  { "Apinayé",                                                    "apn",     "",   "",    false, false },
  { "Apma",                                                       "app",     "",   "",    false, false },
  { "Aproumu Aizi",                                               "ahp",     "",   "",    false, false },
  { "Apurinã",                                                    "apu",     "",   "",    false, false },
  { "Aputai",                                                     "apx",     "",   "",    false, false },
  { "Aquitanian",                                                 "xaq",     "",   "",    false, false },
  { "Arabana",                                                    "ard",     "",   "",    false, false },
  { "Arabela",                                                    "arl",     "",   "",    false, false },
  { "Arabic",                                                     "ara",     "ar", "",    true,  false },
  { "Aragonese",                                                  "arg",     "an", "",    true,  false },
  { "Araki",                                                      "akr",     "",   "",    false, false },
  { "Arakwal",                                                    "rkw",     "",   "",    false, false },
  { "Aralle-Tabulahan",                                           "atq",     "",   "",    false, false },
  { "Aramanik",                                                   "aam",     "",   "",    false, true  },
  { "Arammba",                                                    "stk",     "",   "",    false, false },
  { "Aranadan",                                                   "aaf",     "",   "",    false, false },
  { "Aranama-Tamique",                                            "xrt",     "",   "",    false, false },
  { "Arandai",                                                    "jbj",     "",   "",    false, false },
  { "Araona",                                                     "aro",     "",   "",    false, false },
  { "Arapaho",                                                    "arp",     "",   "",    true,  false },
  { "Arapaso",                                                    "arj",     "",   "",    false, false },
  { "Ararandewára",                                               "xaj",     "",   "",    false, false },
  { "Arauan languages",                                           "auf",     "",   "",    false, false },
  { "Arawak",                                                     "arw",     "",   "",    true,  false },
  { "Arawakan languages",                                         "awd",     "",   "",    false, false },
  { "Araweté",                                                    "awt",     "",   "",    false, false },
  { "Arawum",                                                     "awm",     "",   "",    false, false },
  { "Arbore",                                                     "arv",     "",   "",    false, false },
  { "Arbëreshë Albanian",                                         "aae",     "",   "",    false, false },
  { "Archi",                                                      "aqc",     "",   "",    false, false },
  { "Ardhamāgadhī Prākrit",                                       "pka",     "",   "",    false, false },
  { "Are",                                                        "mwc",     "",   "",    false, false },
  { "Areba",                                                      "aea",     "",   "",    false, false },
  { "Arem",                                                       "aem",     "",   "",    false, false },
  { "Arequipa-La Unión Quechua",                                  "qxu",     "",   "",    false, false },
  { "Argentine Sign Language",                                    "aed",     "",   "",    false, false },
  { "Argobba",                                                    "agj",     "",   "",    false, false },
  { "Arguni",                                                     "agf",     "",   "",    false, false },
  { "Arhuaco",                                                    "arh",     "",   "",    false, false },
  { "Arhâ",                                                       "aqr",     "",   "",    false, false },
  { "Arhö",                                                       "aok",     "",   "",    false, false },
  { "Ari",                                                        "aac",     "",   "",    false, false },
  { "Aribwatsa",                                                  "laz",     "",   "",    false, false },
  { "Aribwaung",                                                  "ylu",     "",   "",    false, false },
  { "Arifama-Miniafia",                                           "aai",     "",   "",    false, false },
  { "Arigidi",                                                    "aqg",     "",   "",    false, false },
  { "Arikapú",                                                    "ark",     "",   "",    false, false },
  { "Arikara",                                                    "ari",     "",   "",    false, false },
  { "Arikem",                                                     "ait",     "",   "",    false, false },
  { "Arin",                                                       "xrn",     "",   "",    false, false },
  { "Aringa",                                                     "luc",     "",   "",    false, false },
  { "Arma",                                                       "aoh",     "",   "",    false, true  },
  { "Armazic",                                                    "xrm",     "",   "",    false, false },
  { "Armenian (family)",                                          "hyx",     "",   "",    false, false },
  { "Armenian Sign Language",                                     "aen",     "",   "",    false, false },
  { "Armenian",                                                   "arm",     "hy", "hye", true,  false },
  { "Arop-Lokep",                                                 "apr",     "",   "",    false, false },
  { "Arop-Sissano",                                               "aps",     "",   "",    false, false },
  { "Arosi",                                                      "aia",     "",   "",    false, false },
  { "Arpitan",                                                    "frp",     "",   "",    false, false },
  { "Arritinngithigh",                                            "rrt",     "",   "",    false, false },
  { "Arta",                                                       "atz",     "",   "",    false, false },
  { "Artificial languages",                                       "art",     "",   "",    true,  false },
  { "Aruamu",                                                     "msy",     "",   "",    false, false },
  { "Aruek",                                                      "aur",     "",   "",    false, false },
  { "Aruop",                                                      "lsr",     "",   "",    false, false },
  { "Arutani",                                                    "atx",     "",   "",    false, false },
  { "Aruá (Amazonas State)",                                      "aru",     "",   "",    false, false },
  { "Aruá (Rodonia State)",                                       "arx",     "",   "",    false, false },
  { "Arvanitika Albanian",                                        "aat",     "",   "",    false, false },
  { "As",                                                         "asz",     "",   "",    false, false },
  { "Asaro'o",                                                    "mtv",     "",   "",    false, false },
  { "Asas",                                                       "asd",     "",   "",    false, true  },
  { "Ashe",                                                       "ahs",     "",   "",    false, false },
  { "Ashkun",                                                     "ask",     "",   "",    false, false },
  { "Asho Chin",                                                  "csh",     "",   "",    false, false },
  { "Ashtiani",                                                   "atn",     "",   "",    false, false },
  { "Asháninka",                                                  "cni",     "",   "",    false, false },
  { "Ashéninka Pajonal",                                          "cjo",     "",   "",    false, false },
  { "Ashéninka Perené",                                           "prq",     "",   "",    false, false },
  { "Asilulu",                                                    "asl",     "",   "",    false, false },
  { "Askopan",                                                    "eiv",     "",   "",    false, false },
  { "Asoa",                                                       "asv",     "",   "",    false, false },
  { "Assamese",                                                   "asm",     "as", "",    true,  false },
  { "Assan",                                                      "xss",     "",   "",    false, true  },
  { "Assangori",                                                  "sjg",     "",   "",    false, false },
  { "Assiniboine",                                                "asb",     "",   "",    false, false },
  { "Assyrian Neo-Aramaic",                                       "aii",     "",   "",    false, false },
  { "Asturian",                                                   "ast",     "",   "",    true,  false },
  { "Asu (Nigeria)",                                              "aum",     "",   "",    false, false },
  { "Asu (Tanzania)",                                             "asa",     "",   "",    false, false },
  { "Asue Awyu",                                                  "psa",     "",   "",    false, false },
  { "Asumboa",                                                    "aua",     "",   "",    false, false },
  { "Asunción Mixtepec Zapotec",                                  "zoo",     "",   "",    false, false },
  { "Asuri",                                                      "asr",     "",   "",    false, false },
  { "Ata Manobo",                                                 "atd",     "",   "",    false, false },
  { "Ata",                                                        "atm",     "",   "",    false, false },
  { "Atakapa",                                                    "aqp",     "",   "",    false, false },
  { "Atampaya",                                                   "amz",     "",   "",    false, false },
  { "Atatláhuca Mixtec",                                          "mib",     "",   "",    false, false },
  { "Atauran",                                                    "adb",     "",   "",    false, false },
  { "Atayal",                                                     "tay",     "",   "",    false, false },
  { "Atemble",                                                    "ate",     "",   "",    false, false },
  { "Athapascan languages",                                       "ath",     "",   "",    true,  false },
  { "Athpariya",                                                  "aph",     "",   "",    false, false },
  { "Ati",                                                        "atk",     "",   "",    false, false },
  { "Atikamekw",                                                  "atj",     "",   "",    false, false },
  { "Atlantic-Congo languages",                                   "alv",     "",   "",    false, false },
  { "Atohwaim",                                                   "aqm",     "",   "",    false, false },
  { "Atong (Cameroon)",                                           "ato",     "",   "",    false, false },
  { "Atong (India)",                                              "aot",     "",   "",    false, false },
  { "Atorada",                                                    "aox",     "",   "",    false, false },
  { "Atsahuaca",                                                  "atc",     "",   "",    false, false },
  { "Atsam",                                                      "cch",     "",   "",    false, false },
  { "Atsugewi",                                                   "atw",     "",   "",    false, false },
  { "Attapady Kurumba",                                           "pkr",     "",   "",    false, false },
  { "Attié",                                                      "ati",     "",   "",    false, false },
  { "Atzingo Matlatzinca",                                        "ocu",     "",   "",    false, false },
  { "Au",                                                         "avt",     "",   "",    false, false },
  { "Aulua",                                                      "aul",     "",   "",    false, false },
  { "Aurá",                                                       "aux",     "",   "",    false, false },
  { "Aushi",                                                      "auh",     "",   "",    false, false },
  { "Aushiri",                                                    "avs",     "",   "",    false, false },
  { "Auslan",                                                     "asf",     "",   "",    false, false },
  { "Austral",                                                    "aut",     "",   "",    false, false },
  { "Australian Aborigines Sign Language",                        "asw",     "",   "",    false, false },
  { "Australian languages",                                       "aus",     "",   "",    true,  false },
  { "Austrian Sign Language",                                     "asq",     "",   "",    false, false },
  { "Austro-Asiatic languages",                                   "aav",     "",   "",    false, false },
  { "Austronesian languages",                                     "map",     "",   "",    true,  false },
  { "Auwe",                                                       "smf",     "",   "",    false, false },
  { "Auye",                                                       "auu",     "",   "",    false, false },
  { "Auyokawa",                                                   "auo",     "",   "",    false, false },
  { "Avaric",                                                     "ava",     "av", "",    true,  false },
  { "Avatime",                                                    "avn",     "",   "",    false, false },
  { "Avau",                                                       "avb",     "",   "",    false, false },
  { "Avestan",                                                    "ave",     "ae", "",    true,  false },
  { "Avikam",                                                     "avi",     "",   "",    false, false },
  { "Avokaya",                                                    "avu",     "",   "",    false, false },
  { "Avá-Canoeiro",                                               "avv",     "",   "",    false, false },
  { "Awa (China)",                                                "vwa",     "",   "",    false, false },
  { "Awa (Papua New Guinea)",                                     "awb",     "",   "",    false, false },
  { "Awa-Cuaiquer",                                               "kwi",     "",   "",    false, false },
  { "Awabakal",                                                   "awk",     "",   "",    false, false },
  { "Awad Bing",                                                  "bcu",     "",   "",    false, false },
  { "Awadhi",                                                     "awa",     "",   "",    true,  false },
  { "Awak",                                                       "awo",     "",   "",    false, false },
  { "Awar",                                                       "aya",     "",   "",    false, false },
  { "Awara",                                                      "awx",     "",   "",    false, false },
  { "Awbono",                                                     "awh",     "",   "",    false, false },
  { "Aweer",                                                      "bob",     "",   "",    false, false },
  { "Awera",                                                      "awr",     "",   "",    false, false },
  { "Awetí",                                                      "awe",     "",   "",    false, false },
  { "Awing",                                                      "azo",     "",   "",    false, false },
  { "Awiyaana",                                                   "auy",     "",   "",    false, false },
  { "Awjilah",                                                    "auj",     "",   "",    false, false },
  { "Awngi",                                                      "awn",     "",   "",    false, false },
  { "Awngthim",                                                   "gwm",     "",   "",    false, false },
  { "Awtuw",                                                      "kmn",     "",   "",    false, false },
  { "Awu",                                                        "yiu",     "",   "",    false, false },
  { "Awun",                                                       "aww",     "",   "",    false, false },
  { "Awutu",                                                      "afu",     "",   "",    false, false },
  { "Awyi",                                                       "auw",     "",   "",    false, false },
  { "Axamb",                                                      "ahb",     "",   "",    false, false },
  { "Axi Yi",                                                     "yix",     "",   "",    false, false },
  { "Ayabadhu",                                                   "ayd",     "",   "",    false, false },
  { "Ayacucho Quechua",                                           "quy",     "",   "",    false, false },
  { "Ayautla Mazatec",                                            "vmy",     "",   "",    false, false },
  { "Ayere",                                                      "aye",     "",   "",    false, false },
  { "Ayerrerenge",                                                "axe",     "",   "",    false, false },
  { "Ayi (China)",                                                "ayx",     "",   "",    false, true  },
  { "Ayi (Papua New Guinea)",                                     "ayq",     "",   "",    false, false },
  { "Ayiwo",                                                      "nfl",     "",   "",    false, false },
  { "Ayizi",                                                      "yyz",     "",   "",    false, false },
  { "Ayizo Gbe",                                                  "ayb",     "",   "",    false, false },
  { "Aymara",                                                     "aym",     "ay", "",    true,  false },
  { "Ayoquesco Zapotec",                                          "zaf",     "",   "",    false, false },
  { "Ayoreo",                                                     "ayo",     "",   "",    false, false },
  { "Ayu",                                                        "ayu",     "",   "",    false, false },
  { "Ayutla Mixtec",                                              "miy",     "",   "",    false, false },
  { "Azerbaijani",                                                "aze",     "az", "",    true,  false },
  { "Azha",                                                       "aza",     "",   "",    false, false },
  { "Azhe",                                                       "yiz",     "",   "",    false, false },
  { "Azoyú Me'phaa",                                              "tpc",     "",   "",    false, false },
  { "Baan",                                                       "bvj",     "",   "",    false, false },
  { "Baangi",                                                     "bqx",     "",   "",    false, false },
  { "Baatonum",                                                   "bba",     "",   "",    false, false },
  { "Baba Malay",                                                 "mbf",     "",   "",    false, false },
  { "Baba",                                                       "bbw",     "",   "",    false, false },
  { "Babalia Creole Arabic",                                      "bbz",     "",   "",    false, true  },
  { "Babango",                                                    "bbm",     "",   "",    false, false },
  { "Babanki",                                                    "bbk",     "",   "",    false, false },
  { "Babatana",                                                   "baa",     "",   "",    false, false },
  { "Babine",                                                     "bcr",     "",   "",    false, false },
  { "Babuza",                                                     "bzg",     "",   "",    false, false },
  { "Bacama",                                                     "bcy",     "",   "",    false, false },
  { "Bacanese Malay",                                             "btj",     "",   "",    false, false },
  { "Bactrian",                                                   "xbc",     "",   "",    false, false },
  { "Bada (Indonesia)",                                           "bhz",     "",   "",    false, false },
  { "Bada (Nigeria)",                                             "bau",     "",   "",    false, false },
  { "Badaga",                                                     "bfq",     "",   "",    false, false },
  { "Bade",                                                       "bde",     "",   "",    false, false },
  { "Badeshi",                                                    "bdz",     "",   "",    false, false },
  { "Badimaya",                                                   "bia",     "",   "",    false, false },
  { "Badjiri",                                                    "jbi",     "",   "",    false, false },
  { "Badui",                                                      "bac",     "",   "",    false, false },
  { "Badyara",                                                    "pbp",     "",   "",    false, false },
  { "Baeggu",                                                     "bvd",     "",   "",    false, false },
  { "Baelelea",                                                   "bvc",     "",   "",    false, false },
  { "Baetora",                                                    "btr",     "",   "",    false, false },
  { "Bafanji",                                                    "bfj",     "",   "",    false, false },
  { "Bafaw-Balong",                                               "bwt",     "",   "",    false, false },
  { "Bafia",                                                      "ksf",     "",   "",    false, false },
  { "Bafut",                                                      "bfd",     "",   "",    false, false },
  { "Baga Kaloum",                                                "bqf",     "",   "",    false, false },
  { "Baga Koga",                                                  "bgo",     "",   "",    false, false },
  { "Baga Manduri",                                               "bmd",     "",   "",    false, false },
  { "Baga Mboteni",                                               "bgm",     "",   "",    false, true  },
  { "Baga Pokur",                                                 "bcg",     "",   "",    false, false },
  { "Baga Sitemu",                                                "bsp",     "",   "",    false, false },
  { "Baga Sobané",                                                "bsv",     "",   "",    false, false },
  { "Bagheli",                                                    "bfy",     "",   "",    false, false },
  { "Bagirmi Fulfulde",                                           "fui",     "",   "",    false, false },
  { "Bagirmi",                                                    "bmi",     "",   "",    false, false },
  { "Bago-Kusuntu",                                               "bqg",     "",   "",    false, false },
  { "Bagri",                                                      "bgq",     "",   "",    false, false },
  { "Bagupi",                                                     "bpi",     "",   "",    false, false },
  { "Bagusa",                                                     "bqb",     "",   "",    false, false },
  { "Bagvalal",                                                   "kva",     "",   "",    false, false },
  { "Baha Buyang",                                                "yha",     "",   "",    false, false },
  { "Baham",                                                      "bdw",     "",   "",    false, false },
  { "Bahamas Creole English",                                     "bah",     "",   "",    false, false },
  { "Baharna Arabic",                                             "abv",     "",   "",    false, false },
  { "Bahau",                                                      "bhv",     "",   "",    false, false },
  { "Bahinemo",                                                   "bjh",     "",   "",    false, false },
  { "Bahing",                                                     "bhj",     "",   "",    false, false },
  { "Bahnar",                                                     "bdq",     "",   "",    false, false },
  { "Bahonsuai",                                                  "bsu",     "",   "",    false, false },
  { "Bai (South Sudan)",                                          "bdj",     "",   "",    false, false },
  { "Baibai",                                                     "bbf",     "",   "",    false, false },
  { "Baikeno",                                                    "bkx",     "",   "",    false, false },
  { "Baima",                                                      "bqh",     "",   "",    false, false },
  { "Baimak",                                                     "bmx",     "",   "",    false, false },
  { "Bainouk-Gunyaamolo",                                         "bcz",     "",   "",    false, false },
  { "Bainouk-Gunyuño",                                            "bab",     "",   "",    false, false },
  { "Bainouk-Samik",                                              "bcb",     "",   "",    false, false },
  { "Baiso",                                                      "bsw",     "",   "",    false, false },
  { "Baissa Fali",                                                "fah",     "",   "",    false, false },
  { "Bajan",                                                      "bjs",     "",   "",    false, false },
  { "Bajelani",                                                   "bjm",     "",   "",    false, false },
  { "Bajjika",                                                    "vjk",     "",   "",    false, false },
  { "Baka (Cameroon)",                                            "bkc",     "",   "",    false, false },
  { "Baka (South Sudan)",                                         "bdh",     "",   "",    false, false },
  { "Bakairí",                                                    "bkq",     "",   "",    false, false },
  { "Bakaka",                                                     "bqz",     "",   "",    false, false },
  { "Bakhtiari",                                                  "bqi",     "",   "",    false, false },
  { "Baki",                                                       "bki",     "",   "",    false, false },
  { "Bakoko",                                                     "bkh",     "",   "",    false, false },
  { "Bakole",                                                     "kme",     "",   "",    false, false },
  { "Bakpinka",                                                   "bbs",     "",   "",    false, false },
  { "Bakumpai",                                                   "bkr",     "",   "",    false, false },
  { "Bakwé",                                                      "bjw",     "",   "",    false, false },
  { "Balaesang",                                                  "bls",     "",   "",    false, false },
  { "Balaibalan",                                                 "zba",     "",   "",    false, false },
  { "Balangao",                                                   "blw",     "",   "",    false, false },
  { "Balangingi",                                                 "sse",     "",   "",    false, false },
  { "Balanta-Ganja",                                              "bjt",     "",   "",    false, false },
  { "Balanta-Kentohe",                                            "ble",     "",   "",    false, false },
  { "Balantak",                                                   "blz",     "",   "",    false, false },
  { "Balau",                                                      "blg",     "",   "",    false, true  },
  { "Baldemu",                                                    "bdn",     "",   "",    false, false },
  { "Bali (Democratic Republic of Congo)",                        "bcp",     "",   "",    false, false },
  { "Bali (Nigeria)",                                             "bcn",     "",   "",    false, false },
  { "Balinese Malay",                                             "mhp",     "",   "",    false, false },
  { "Balinese",                                                   "ban",     "",   "",    true,  false },
  { "Balkan Gagauz Turkish",                                      "bgx",     "",   "",    false, false },
  { "Balkan Romani",                                              "rmn",     "",   "",    false, false },
  { "Balo",                                                       "bqo",     "",   "",    false, false },
  { "Baloi",                                                      "biz",     "",   "",    false, false },
  { "Balti",                                                      "bft",     "",   "",    false, false },
  { "Baltic Romani",                                              "rml",     "",   "",    false, false },
  { "Baltic languages",                                           "bat",     "",   "",    true,  false },
  { "Baluan-Pam",                                                 "blq",     "",   "",    false, false },
  { "Baluchi",                                                    "bal",     "",   "",    true,  false },
  { "Bamako Sign Language",                                       "bog",     "",   "",    false, false },
  { "Bamali",                                                     "bbq",     "",   "",    false, false },
  { "Bambalang",                                                  "bmo",     "",   "",    false, false },
  { "Bambam",                                                     "ptu",     "",   "",    false, false },
  { "Bambara",                                                    "bam",     "bm", "",    true,  false },
  { "Bambassi",                                                   "myf",     "",   "",    false, false },
  { "Bambili-Bambui",                                             "baw",     "",   "",    false, false },
  { "Bamenyam",                                                   "bce",     "",   "",    false, false },
  { "Bamileke languages",                                         "bai",     "",   "",    true,  false },
  { "Bamu",                                                       "bcf",     "",   "",    false, false },
  { "Bamukumbit",                                                 "bqt",     "",   "",    false, false },
  { "Bamun",                                                      "bax",     "",   "",    false, false },
  { "Bamunka",                                                    "bvm",     "",   "",    false, false },
  { "Bamwe",                                                      "bmg",     "",   "",    false, false },
  { "Ban Khor Sign Language",                                     "bfk",     "",   "",    false, false },
  { "Bana",                                                       "bcw",     "",   "",    false, false },
  { "Banao Itneg",                                                "bjx",     "",   "",    false, false },
  { "Banaro",                                                     "byz",     "",   "",    false, false },
  { "Banda (Indonesia)",                                          "bnd",     "",   "",    false, false },
  { "Banda Malay",                                                "bpq",     "",   "",    false, false },
  { "Banda languages",                                            "bad",     "",   "",    true,  false },
  { "Banda-Bambari",                                              "liy",     "",   "",    false, false },
  { "Banda-Banda",                                                "bpd",     "",   "",    false, false },
  { "Banda-Mbrès",                                                "bqk",     "",   "",    false, false },
  { "Banda-Ndélé",                                                "bfl",     "",   "",    false, false },
  { "Banda-Yangere",                                              "yaj",     "",   "",    false, false },
  { "Bandi",                                                      "bza",     "",   "",    false, false },
  { "Bandial",                                                    "bqj",     "",   "",    false, false },
  { "Bandjalang",                                                 "bdy",     "",   "",    false, false },
  { "Bandjigali",                                                 "bjd",     "",   "",    false, true  },
  { "Bangala",                                                    "bxg",     "",   "",    false, false },
  { "Bangandu",                                                   "bgf",     "",   "",    false, false },
  { "Bangba",                                                     "bbe",     "",   "",    false, false },
  { "Banggai",                                                    "bgz",     "",   "",    false, false },
  { "Banggarla",                                                  "bjb",     "",   "",    false, false },
  { "Bangi",                                                      "bni",     "",   "",    false, false },
  { "Bangime",                                                    "dba",     "",   "",    false, false },
  { "Bangka",                                                     "mfb",     "",   "",    false, false },
  { "Bangolan",                                                   "bgj",     "",   "",    false, false },
  { "Bangubangu",                                                 "bnx",     "",   "",    false, false },
  { "Bangwinji",                                                  "bsj",     "",   "",    false, false },
  { "Baniva",                                                     "bvv",     "",   "",    false, false },
  { "Baniwa",                                                     "bwi",     "",   "",    false, false },
  { "Banjar",                                                     "bjn",     "",   "",    false, false },
  { "Bankagooma",                                                 "bxw",     "",   "",    false, false },
  { "Bankal",                                                     "jjr",     "",   "",    false, false },
  { "Bankan Tey Dogon",                                           "dbw",     "",   "",    false, false },
  { "Bankon",                                                     "abb",     "",   "",    false, false },
  { "Bannoni",                                                    "bcm",     "",   "",    false, false },
  { "Bantawa",                                                    "bap",     "",   "",    false, false },
  { "Bantayanon",                                                 "bfx",     "",   "",    false, false },
  { "Bantik",                                                     "bnq",     "",   "",    false, false },
  { "Bantoanon",                                                  "bno",     "",   "",    false, false },
  { "Bantu languages",                                            "bnt",     "",   "",    true,  false },
  { "Banyjima",                                                   "pnw",     "",   "",    false, false },
  { "Baoulé",                                                     "bci",     "",   "",    false, false },
  { "Bara Malagasy",                                              "bhr",     "",   "",    false, false },
  { "Baraamu",                                                    "brd",     "",   "",    false, false },
  { "Barababaraba",                                               "rbp",     "",   "",    false, false },
  { "Barai",                                                      "bbb",     "",   "",    false, false },
  { "Barakai",                                                    "baj",     "",   "",    false, false },
  { "Baram Kayan",                                                "kys",     "",   "",    false, false },
  { "Barama",                                                     "bbg",     "",   "",    false, false },
  { "Barambu",                                                    "brm",     "",   "",    false, false },
  { "Baramu",                                                     "bmz",     "",   "",    false, false },
  { "Barapasi",                                                   "brp",     "",   "",    false, false },
  { "Baras",                                                      "brs",     "",   "",    false, false },
  { "Barasana-Eduria",                                            "bsn",     "",   "",    false, false },
  { "Barbacoas",                                                  "bpb",     "",   "",    false, true  },
  { "Barbaram",                                                   "vmb",     "",   "",    false, false },
  { "Barbareño",                                                  "boi",     "",   "",    false, false },
  { "Barclayville Grebo",                                         "gry",     "",   "",    false, false },
  { "Bardi",                                                      "bcj",     "",   "",    false, false },
  { "Barein",                                                     "bva",     "",   "",    false, false },
  { "Bargam",                                                     "mlp",     "",   "",    false, false },
  { "Bari",                                                       "bfa",     "",   "",    false, false },
  { "Bariai",                                                     "bch",     "",   "",    false, false },
  { "Bariji",                                                     "bjc",     "",   "",    false, false },
  { "Barikanchi",                                                 "bxo",     "",   "",    false, false },
  { "Barikewa",                                                   "jbk",     "",   "",    false, false },
  { "Barok",                                                      "bjk",     "",   "",    false, false },
  { "Barombi",                                                    "bbi",     "",   "",    false, false },
  { "Barro Negro Tunebo",                                         "tbn",     "",   "",    false, false },
  { "Barrow Point",                                               "bpt",     "",   "",    false, false },
  { "Baruga",                                                     "bjz",     "",   "",    false, false },
  { "Baruya",                                                     "byr",     "",   "",    false, false },
  { "Barwe",                                                      "bwg",     "",   "",    false, false },
  { "Barzani Jewish Neo-Aramaic",                                 "bjf",     "",   "",    false, false },
  { "Baré",                                                       "bae",     "",   "",    false, false },
  { "Barí",                                                       "mot",     "",   "",    false, false },
  { "Basa (Cameroon)",                                            "bas",     "",   "",    true,  false },
  { "Basa (Nigeria)",                                             "bzw",     "",   "",    false, false },
  { "Basa-Gumna",                                                 "bsl",     "",   "",    false, false },
  { "Basa-Gurmana",                                               "buj",     "",   "",    false, false },
  { "Basap",                                                      "bdb",     "",   "",    false, false },
  { "Basay",                                                      "byq",     "",   "",    false, false },
  { "Bashkardi",                                                  "bsg",     "",   "",    false, false },
  { "Bashkir",                                                    "bak",     "ba", "",    true,  false },
  { "Basketo",                                                    "bst",     "",   "",    false, false },
  { "Basque (family)",                                            "euq",     "",   "",    false, false },
  { "Basque",                                                     "baq",     "eu", "eus", true,  false },
  { "Bassa",                                                      "bsq",     "",   "",    false, false },
  { "Bassa-Kontagora",                                            "bsr",     "",   "",    false, false },
  { "Bassari",                                                    "bsc",     "",   "",    false, false },
  { "Bassossi",                                                   "bsi",     "",   "",    false, false },
  { "Bata",                                                       "bta",     "",   "",    false, false },
  { "Batad Ifugao",                                               "ifb",     "",   "",    false, false },
  { "Batak Alas-Kluet",                                           "btz",     "",   "",    false, false },
  { "Batak Angkola",                                              "akb",     "",   "",    false, false },
  { "Batak Dairi",                                                "btd",     "",   "",    false, false },
  { "Batak Karo",                                                 "btx",     "",   "",    false, false },
  { "Batak Mandailing",                                           "btm",     "",   "",    false, false },
  { "Batak Simalungun",                                           "bts",     "",   "",    false, false },
  { "Batak Toba",                                                 "bbc",     "",   "",    false, false },
  { "Batak languages",                                            "btk",     "",   "",    true,  false },
  { "Batak",                                                      "bya",     "",   "",    false, false },
  { "Batanga",                                                    "bnm",     "",   "",    false, false },
  { "Batek",                                                      "btq",     "",   "",    false, false },
  { "Bateri",                                                     "btv",     "",   "",    false, false },
  { "Bathari",                                                    "bhm",     "",   "",    false, false },
  { "Bati (Cameroon)",                                            "btc",     "",   "",    false, false },
  { "Bati (Indonesia)",                                           "bvt",     "",   "",    false, false },
  { "Batjala",                                                    "xby",     "",   "",    false, false },
  { "Bats",                                                       "bbl",     "",   "",    false, false },
  { "Batu",                                                       "btu",     "",   "",    false, false },
  { "Batui",                                                      "zbt",     "",   "",    false, false },
  { "Batuley",                                                    "bay",     "",   "",    false, false },
  { "Bau Bidayuh",                                                "sne",     "",   "",    false, false },
  { "Bau",                                                        "bbd",     "",   "",    false, false },
  { "Bauchi",                                                     "bsf",     "",   "",    false, false },
  { "Bauni",                                                      "bpe",     "",   "",    false, false },
  { "Baure",                                                      "brg",     "",   "",    false, false },
  { "Bauria",                                                     "bge",     "",   "",    false, false },
  { "Bauwaki",                                                    "bwk",     "",   "",    false, false },
  { "Bauzi",                                                      "bvz",     "",   "",    false, false },
  { "Bavarian",                                                   "bar",     "",   "",    false, false },
  { "Bawm Chin",                                                  "bgr",     "",   "",    false, false },
  { "Bay Miwok",                                                  "mkq",     "",   "",    false, false },
  { "Bayali",                                                     "bjy",     "",   "",    false, false },
  { "Baybayanon",                                                 "bvy",     "",   "",    false, false },
  { "Baygo",                                                      "byg",     "",   "",    false, false },
  { "Bayono",                                                     "byl",     "",   "",    false, false },
  { "Bayot",                                                      "bda",     "",   "",    false, false },
  { "Bayungu",                                                    "bxj",     "",   "",    false, false },
  { "Bazigar",                                                    "bfr",     "",   "",    false, false },
  { "Beami",                                                      "beo",     "",   "",    false, false },
  { "Beaver",                                                     "bea",     "",   "",    false, false },
  { "Beba",                                                       "bfp",     "",   "",    false, false },
  { "Bebele",                                                     "beb",     "",   "",    false, false },
  { "Bebeli",                                                     "bek",     "",   "",    false, false },
  { "Bebil",                                                      "bxp",     "",   "",    false, false },
  { "Bedjond",                                                    "bjv",     "",   "",    false, false },
  { "Bedoanas",                                                   "bed",     "",   "",    false, false },
  { "Beeke",                                                      "bkf",     "",   "",    false, false },
  { "Beele",                                                      "bxq",     "",   "",    false, false },
  { "Beembe",                                                     "beq",     "",   "",    false, false },
  { "Beezen",                                                     "bnz",     "",   "",    false, false },
  { "Befang",                                                     "bby",     "",   "",    false, false },
  { "Beginci",                                                    "ebc",     "",   "",    false, false },
  { "Beja",                                                       "bej",     "",   "",    true,  false },
  { "Bekati'",                                                    "bei",     "",   "",    false, false },
  { "Bekwarra",                                                   "bkv",     "",   "",    false, false },
  { "Bekwel",                                                     "bkw",     "",   "",    false, false },
  { "Belait",                                                     "beg",     "",   "",    false, false },
  { "Belanda Bor",                                                "bxb",     "",   "",    false, false },
  { "Belanda Viri",                                               "bvi",     "",   "",    false, false },
  { "Belarusian",                                                 "bel",     "be", "",    true,  false },
  { "Belhariya",                                                  "byw",     "",   "",    false, false },
  { "Beli (Papua New Guinea)",                                    "bey",     "",   "",    false, false },
  { "Beli (South Sudan)",                                         "blm",     "",   "",    false, false },
  { "Belize Kriol English",                                       "bzj",     "",   "",    false, false },
  { "Bella Coola",                                                "blc",     "",   "",    false, false },
  { "Bellari",                                                    "brw",     "",   "",    false, false },
  { "Belning",                                                    "glb",     "",   "",    false, false },
  { "Bemba (Democratic Republic of Congo)",                       "bmy",     "",   "",    false, true  },
  { "Bemba (Zambia)",                                             "bem",     "",   "",    true,  false },
  { "Bembe",                                                      "bmb",     "",   "",    false, false },
  { "Ben Tey Dogon",                                              "dbt",     "",   "",    false, false },
  { "Bena (Nigeria)",                                             "yun",     "",   "",    false, false },
  { "Bena (Tanzania)",                                            "bez",     "",   "",    false, false },
  { "Benabena",                                                   "bef",     "",   "",    false, false },
  { "Benamanga",                                                  "egm",     "",   "",    false, false },
  { "Bench",                                                      "bcq",     "",   "",    false, false },
  { "Bende",                                                      "bdp",     "",   "",    false, false },
  { "Bendi",                                                      "bct",     "",   "",    false, false },
  { "Beng",                                                       "nhb",     "",   "",    false, false },
  { "Benga",                                                      "bng",     "",   "",    false, false },
  { "Bengali",                                                    "ben",     "bn", "",    true,  false },
  { "Benggoi",                                                    "bgy",     "",   "",    false, false },
  { "Bengkala Sign Language",                                     "bqy",     "",   "",    false, false },
  { "Bentong",                                                    "bnu",     "",   "",    false, false },
  { "Benyadu'",                                                   "byd",     "",   "",    false, false },
  { "Beothuk",                                                    "bue",     "",   "",    false, false },
  { "Bepour",                                                     "bie",     "",   "",    false, false },
  { "Berakou",                                                    "bxv",     "",   "",    false, false },
  { "Berau Malay",                                                "bve",     "",   "",    false, false },
  { "Berber languages",                                           "ber",     "",   "",    true,  false },
  { "Berbice Creole Dutch",                                       "brc",     "",   "",    false, false },
  { "Berik",                                                      "bkl",     "",   "",    false, false },
  { "Berinomo",                                                   "bit",     "",   "",    false, false },
  { "Berom",                                                      "bom",     "",   "",    false, false },
  { "Berta",                                                      "wti",     "",   "",    false, false },
  { "Berti",                                                      "byt",     "",   "",    false, false },
  { "Besisi",                                                     "mhe",     "",   "",    false, false },
  { "Besme",                                                      "bes",     "",   "",    false, false },
  { "Besoa",                                                      "bep",     "",   "",    false, false },
  { "Betaf",                                                      "bfe",     "",   "",    false, false },
  { "Betawi",                                                     "bew",     "",   "",    false, false },
  { "Bete",                                                       "byf",     "",   "",    false, false },
  { "Bete-Bendi",                                                 "btt",     "",   "",    false, false },
  { "Beti (Cameroon)",                                            "btb",     "",   "",    false, true  },
  { "Beti (Côte d'Ivoire)",                                       "eot",     "",   "",    false, false },
  { "Betta Kurumba",                                              "xub",     "",   "",    false, false },
  { "Bezhta",                                                     "kap",     "",   "",    false, false },
  { "Bhadrawahi",                                                 "bhd",     "",   "",    false, false },
  { "Bhalay",                                                     "bhx",     "",   "",    false, false },
  { "Bharia",                                                     "bha",     "",   "",    false, false },
  { "Bhatola",                                                    "btl",     "",   "",    false, true  },
  { "Bhatri",                                                     "bgw",     "",   "",    false, false },
  { "Bhattiyali",                                                 "bht",     "",   "",    false, false },
  { "Bhaya",                                                      "bhe",     "",   "",    false, false },
  { "Bhele",                                                      "bhy",     "",   "",    false, false },
  { "Bhilali",                                                    "bhi",     "",   "",    false, false },
  { "Bhili",                                                      "bhb",     "",   "",    false, false },
  { "Bhojpuri",                                                   "bho",     "",   "",    true,  false },
  { "Bhoti Kinnauri",                                             "nes",     "",   "",    false, false },
  { "Bhujel",                                                     "byh",     "",   "",    false, false },
  { "Bhunjia",                                                    "bhu",     "",   "",    false, false },
  { "Biafada",                                                    "bif",     "",   "",    false, false },
  { "Biage",                                                      "bdf",     "",   "",    false, false },
  { "Biak",                                                       "bhw",     "",   "",    false, false },
  { "Biali",                                                      "beh",     "",   "",    false, false },
  { "Bian Marind",                                                "bpv",     "",   "",    false, false },
  { "Biangai",                                                    "big",     "",   "",    false, false },
  { "Biao Mon",                                                   "bmt",     "",   "",    false, false },
  { "Biao",                                                       "byk",     "",   "",    false, false },
  { "Biao-Jiao Mien",                                             "bje",     "",   "",    false, false },
  { "Biatah Bidayuh",                                             "bth",     "",   "",    false, false },
  { "Bibbulman",                                                  "xbp",     "",   "",    false, false },
  { "Bidhawal",                                                   "ihw",     "",   "",    false, false },
  { "Bidiyo",                                                     "bid",     "",   "",    false, false },
  { "Bidjara",                                                    "bym",     "",   "",    false, false },
  { "Bidyogo",                                                    "bjg",     "",   "",    false, false },
  { "Biem",                                                       "bmc",     "",   "",    false, false },
  { "Bierebo",                                                    "bnk",     "",   "",    false, false },
  { "Bieria",                                                     "brj",     "",   "",    false, false },
  { "Biete",                                                      "biu",     "",   "",    false, false },
  { "Big Nambas",                                                 "nmb",     "",   "",    false, false },
  { "Biga",                                                       "bhc",     "",   "",    false, false },
  { "Bigambal",                                                   "xbe",     "",   "",    false, false },
  { "Bih",                                                        "ibh",     "",   "",    false, false },
  { "Bihari languages",                                           "bih",     "",   "",    true,  false },
  { "Bijim",                                                      "jbm",     "",   "",    false, false },
  { "Bijori",                                                     "bix",     "",   "",    false, false },
  { "Bikaru",                                                     "bic",     "",   "",    false, true  },
  { "Bikol",                                                      "bik",     "",   "",    true,  false },
  { "Bikya",                                                      "byb",     "",   "",    false, false },
  { "Bila",                                                       "bip",     "",   "",    false, false },
  { "Bilaspuri",                                                  "kfs",     "",   "",    false, false },
  { "Bilba",                                                      "bpz",     "",   "",    false, false },
  { "Bilbil",                                                     "brz",     "",   "",    false, false },
  { "Bile",                                                       "bil",     "",   "",    false, false },
  { "Bilin",                                                      "byn",     "",   "",    true,  false },
  { "Bilma Kanuri",                                               "bms",     "",   "",    false, false },
  { "Biloxi",                                                     "bll",     "",   "",    false, false },
  { "Bilua",                                                      "blb",     "",   "",    false, false },
  { "Bilur",                                                      "bxf",     "",   "",    false, false },
  { "Bima",                                                       "bhp",     "",   "",    false, false },
  { "Bimin",                                                      "bhl",     "",   "",    false, false },
  { "Bimoba",                                                     "bim",     "",   "",    false, false },
  { "Bina (Nigeria)",                                             "byj",     "",   "",    false, false },
  { "Bina (Papua New Guinea)",                                    "bmn",     "",   "",    false, false },
  { "Binahari",                                                   "bxz",     "",   "",    false, false },
  { "Binandere",                                                  "bhg",     "",   "",    false, false },
  { "Bindal",                                                     "xbd",     "",   "",    false, false },
  { "Bine",                                                       "bon",     "",   "",    false, false },
  { "Bini",                                                       "bin",     "",   "",    true,  false },
  { "Binji",                                                      "bpj",     "",   "",    false, false },
  { "Binongan Itneg",                                             "itb",     "",   "",    false, false },
  { "Bintauna",                                                   "bne",     "",   "",    false, false },
  { "Bintulu",                                                    "bny",     "",   "",    false, false },
  { "Binukid",                                                    "bkd",     "",   "",    false, false },
  { "Binumarien",                                                 "bjr",     "",   "",    false, false },
  { "Bipi",                                                       "biq",     "",   "",    false, false },
  { "Bira",                                                       "brf",     "",   "",    false, false },
  { "Birale",                                                     "bxe",     "",   "",    false, false },
  { "Birao",                                                      "brr",     "",   "",    false, false },
  { "Birgit",                                                     "btf",     "",   "",    false, false },
  { "Birhor",                                                     "biy",     "",   "",    false, false },
  { "Biri",                                                       "bzr",     "",   "",    false, false },
  { "Biritai",                                                    "bqq",     "",   "",    false, false },
  { "Birked",                                                     "brk",     "",   "",    false, false },
  { "Birri",                                                      "bvq",     "",   "",    false, false },
  { "Birrpayi",                                                   "xbj",     "",   "",    false, false },
  { "Birwa",                                                      "brl",     "",   "",    false, false },
  { "Biseni",                                                     "ije",     "",   "",    false, false },
  { "Bishnupriya",                                                "bpy",     "",   "",    false, false },
  { "Bishuo",                                                     "bwh",     "",   "",    false, false },
  { "Bisis",                                                      "bnw",     "",   "",    false, false },
  { "Bislama",                                                    "bis",     "bi", "",    true,  false },
  { "Bisorio",                                                    "bir",     "",   "",    false, false },
  { "Bissa",                                                      "bib",     "",   "",    false, false },
  { "Bisu",                                                       "bzi",     "",   "",    false, false },
  { "Bit",                                                        "bgk",     "",   "",    false, false },
  { "Bitare",                                                     "brt",     "",   "",    false, false },
  { "Bitur",                                                      "mcc",     "",   "",    false, false },
  { "Biwat",                                                      "bwm",     "",   "",    false, false },
  { "Biyo",                                                       "byo",     "",   "",    false, false },
  { "Biyom",                                                      "bpm",     "",   "",    false, false },
  { "Blablanga",                                                  "blp",     "",   "",    false, false },
  { "Blafe",                                                      "bfh",     "",   "",    false, false },
  { "Blagar",                                                     "beu",     "",   "",    false, false },
  { "Blang",                                                      "blr",     "",   "",    false, false },
  { "Blissymbols",                                                "zbl",     "",   "",    true,  false },
  { "Bo (Laos)",                                                  "bgl",     "",   "",    false, false },
  { "Bo (Papua New Guinea)",                                      "bpw",     "",   "",    false, false },
  { "Bo-Rukul",                                                   "mae",     "",   "",    false, false },
  { "Bo-Ung",                                                     "mux",     "",   "",    false, false },
  { "Boano (Maluku)",                                             "bzn",     "",   "",    false, false },
  { "Boano (Sulawesi)",                                           "bzl",     "",   "",    false, false },
  { "Bobongko",                                                   "bgb",     "",   "",    false, false },
  { "Bobot",                                                      "bty",     "",   "",    false, false },
  { "Bodo (Central African Republic)",                            "boy",     "",   "",    false, false },
  { "Bodo (India)",                                               "brx",     "",   "",    false, false },
  { "Bodo Gadaba",                                                "gbj",     "",   "",    false, false },
  { "Bodo Parja",                                                 "bdv",     "",   "",    false, false },
  { "Bofi",                                                       "bff",     "",   "",    false, false },
  { "Boga",                                                       "bvw",     "",   "",    false, false },
  { "Bogaya",                                                     "boq",     "",   "",    false, false },
  { "Boghom",                                                     "bux",     "",   "",    false, false },
  { "Boguru",                                                     "bqu",     "",   "",    false, false },
  { "Bohtan Neo-Aramaic",                                         "bhn",     "",   "",    false, false },
  { "Boikin",                                                     "bzf",     "",   "",    false, false },
  { "Bokha",                                                      "ybk",     "",   "",    false, false },
  { "Boko (Benin)",                                               "bqc",     "",   "",    false, false },
  { "Boko (Democratic Republic of Congo)",                        "bkp",     "",   "",    false, false },
  { "Bokobaru",                                                   "bus",     "",   "",    false, false },
  { "Bokoto",                                                     "bdt",     "",   "",    false, false },
  { "Bokyi",                                                      "bky",     "",   "",    false, false },
  { "Bola",                                                       "bnp",     "",   "",    false, false },
  { "Bolango",                                                    "bld",     "",   "",    false, false },
  { "Bole",                                                       "bol",     "",   "",    false, false },
  { "Bolgarian",                                                  "xbo",     "",   "",    false, false },
  { "Bolgo",                                                      "bvo",     "",   "",    false, false },
  { "Bolia",                                                      "bli",     "",   "",    false, false },
  { "Bolinao",                                                    "smk",     "",   "",    false, false },
  { "Bolivian Sign Language",                                     "bvl",     "",   "",    false, false },
  { "Boloki",                                                     "bkt",     "",   "",    false, false },
  { "Bolon",                                                      "bof",     "",   "",    false, false },
  { "Bolondo",                                                    "bzm",     "",   "",    false, false },
  { "Bolongan",                                                   "blj",     "",   "",    false, false },
  { "Bolyu",                                                      "ply",     "",   "",    false, false },
  { "Bom-Kim",                                                    "bmf",     "",   "",    false, false },
  { "Boma",                                                       "boh",     "",   "",    false, false },
  { "Bomboli",                                                    "bml",     "",   "",    false, false },
  { "Bomboma",                                                    "bws",     "",   "",    false, false },
  { "Bomitaba",                                                   "zmx",     "",   "",    false, false },
  { "Bomu",                                                       "bmq",     "",   "",    false, false },
  { "Bomwali",                                                    "bmw",     "",   "",    false, false },
  { "Bon Gula",                                                   "glc",     "",   "",    false, false },
  { "Bonan",                                                      "peh",     "",   "",    false, false },
  { "Bondei",                                                     "bou",     "",   "",    false, false },
  { "Bondo",                                                      "bfw",     "",   "",    false, false },
  { "Bondoukou Kulango",                                          "kzc",     "",   "",    false, false },
  { "Bondum Dom Dogon",                                           "dbu",     "",   "",    false, false },
  { "Bonerate",                                                   "bna",     "",   "",    false, false },
  { "Bonerif",                                                    "bnv",     "",   "",    false, false },
  { "Bonggi",                                                     "bdg",     "",   "",    false, false },
  { "Bonggo",                                                     "bpg",     "",   "",    false, false },
  { "Bongili",                                                    "bui",     "",   "",    false, false },
  { "Bongo",                                                      "bot",     "",   "",    false, false },
  { "Bongu",                                                      "bpu",     "",   "",    false, false },
  { "Bonjo",                                                      "bok",     "",   "",    false, false },
  { "Bonkeng",                                                    "bvg",     "",   "",    false, false },
  { "Bonkiman",                                                   "bop",     "",   "",    false, false },
  { "Bontok",                                                     "bnc",     "",   "",    false, false },
  { "Bookan",                                                     "bnb",     "",   "",    false, false },
  { "Boon",                                                       "bnl",     "",   "",    false, false },
  { "Boor",                                                       "bvf",     "",   "",    false, false },
  { "Bora",                                                       "boa",     "",   "",    false, false },
  { "Borana-Arsi-Guji Oromo",                                     "gax",     "",   "",    false, false },
  { "Border Kuna",                                                "kvn",     "",   "",    false, false },
  { "Borei",                                                      "gai",     "",   "",    false, false },
  { "Borgu Fulfulde",                                             "fue",     "",   "",    false, false },
  { "Borna (Democratic Republic of Congo)",                       "bxx",     "",   "",    false, true  },
  { "Boro (Ethiopia)",                                            "bwo",     "",   "",    false, false },
  { "Boro (Ghana)",                                               "xxb",     "",   "",    false, false },
  { "Borong",                                                     "ksr",     "",   "",    false, false },
  { "Boruca",                                                     "brn",     "",   "",    false, false },
  { "Borôro",                                                     "bor",     "",   "",    false, false },
  { "Boselewa",                                                   "bwf",     "",   "",    false, false },
  { "Bosngun",                                                    "bqs",     "",   "",    false, false },
  { "Bosnian",                                                    "bos",     "bs", "",    true,  false },
  { "Bote-Majhi",                                                 "bmj",     "",   "",    false, false },
  { "Botlikh",                                                    "bph",     "",   "",    false, false },
  { "Botolan Sambal",                                             "sbl",     "",   "",    false, false },
  { "Bouna Kulango",                                              "nku",     "",   "",    false, false },
  { "Bouni",                                                      "suo",     "",   "",    false, false },
  { "Bouyei",                                                     "pcc",     "",   "",    false, false },
  { "Bozaba",                                                     "bzo",     "",   "",    false, false },
  { "Bragat",                                                     "aof",     "",   "",    false, false },
  { "Brahui",                                                     "brh",     "",   "",    false, false },
  { "Braj",                                                       "bra",     "",   "",    true,  false },
  { "Brao",                                                       "brb",     "",   "",    false, false },
  { "Brazilian Sign Language",                                    "bzs",     "",   "",    false, false },
  { "Brem",                                                       "buq",     "",   "",    false, false },
  { "Breri",                                                      "brq",     "",   "",    false, false },
  { "Breton",                                                     "bre",     "br", "",    true,  false },
  { "Bribri Sign Language",                                       "rib",     "",   "",    false, false },
  { "Bribri",                                                     "bzd",     "",   "",    false, false },
  { "Brithenig",                                                  "bzt",     "",   "",    false, false },
  { "British Sign Language",                                      "bfi",     "",   "",    false, false },
  { "Brokkat",                                                    "bro",     "",   "",    false, false },
  { "Brokpake",                                                   "sgt",     "",   "",    false, false },
  { "Brokskat",                                                   "bkk",     "",   "",    false, false },
  { "Brooke's Point Palawano",                                    "plw",     "",   "",    false, false },
  { "Broome Pearling Lugger Pidgin",                              "bpl",     "",   "",    false, false },
  { "Brunca Sign Language",                                       "rnb",     "",   "",    false, false },
  { "Brunei Bisaya",                                              "bsb",     "",   "",    false, false },
  { "Brunei",                                                     "kxd",     "",   "",    false, false },
  { "Bruny Island Tasmanian",                                     "xpz",     "",   "",    false, false },
  { "Bu (Bauchi State)",                                          "zbu",     "",   "",    false, false },
  { "Bu (Kaduna State)",                                          "jid",     "",   "",    false, false },
  { "Bu-Nao Bunu",                                                "bwx",     "",   "",    false, false },
  { "Bua",                                                        "bub",     "",   "",    false, false },
  { "Bualkhaw Chin",                                              "cbl",     "",   "",    false, false },
  { "Buamu",                                                      "box",     "",   "",    false, false },
  { "Bube",                                                       "bvb",     "",   "",    false, false },
  { "Bubi",                                                       "buw",     "",   "",    false, false },
  { "Bubia",                                                      "bbx",     "",   "",    false, false },
  { "Budeh Stieng",                                               "stt",     "",   "",    false, false },
  { "Budibud",                                                    "btp",     "",   "",    false, false },
  { "Budong-Budong",                                              "bdx",     "",   "",    false, false },
  { "Budu",                                                       "buu",     "",   "",    false, false },
  { "Budukh",                                                     "bdk",     "",   "",    false, false },
  { "Buduma",                                                     "bdm",     "",   "",    false, false },
  { "Budza",                                                      "bja",     "",   "",    false, false },
  { "Bugan",                                                      "bbh",     "",   "",    false, false },
  { "Bugawac",                                                    "buk",     "",   "",    false, false },
  { "Bughotu",                                                    "bgt",     "",   "",    false, false },
  { "Buginese",                                                   "bug",     "",   "",    true,  false },
  { "Buglere",                                                    "sab",     "",   "",    false, false },
  { "Bugun",                                                      "bgg",     "",   "",    false, false },
  { "Buhi'non Bikol",                                             "ubl",     "",   "",    false, false },
  { "Buhid",                                                      "bku",     "",   "",    false, false },
  { "Buhutu",                                                     "bxh",     "",   "",    false, false },
  { "Bukar-Sadung Bidayuh",                                       "sdo",     "",   "",    false, false },
  { "Bukat",                                                      "bvk",     "",   "",    false, false },
  { "Bukharic",                                                   "bhh",     "",   "",    false, false },
  { "Bukit Malay",                                                "bvu",     "",   "",    false, false },
  { "Bukitan",                                                    "bkn",     "",   "",    false, false },
  { "Bukiyip",                                                    "ape",     "",   "",    false, false },
  { "Buksa",                                                      "tkb",     "",   "",    false, false },
  { "Bukusu",                                                     "bxk",     "",   "",    false, false },
  { "Bukwen",                                                     "buz",     "",   "",    false, false },
  { "Bulgarian Sign Language",                                    "bqn",     "",   "",    false, false },
  { "Bulgarian",                                                  "bul",     "bg", "",    true,  false },
  { "Bulgebi",                                                    "bmp",     "",   "",    false, false },
  { "Buli (Ghana)",                                               "bwu",     "",   "",    false, false },
  { "Buli (Indonesia)",                                           "bzq",     "",   "",    false, false },
  { "Buli",                                                       "uly",     "",   "",    false, false },
  { "Bullom So",                                                  "buy",     "",   "",    false, false },
  { "Bulo Stieng",                                                "sti",     "",   "",    false, false },
  { "Bulu (Cameroon)",                                            "bum",     "",   "",    false, false },
  { "Bulu (Papua New Guinea)",                                    "bjl",     "",   "",    false, false },
  { "Bum",                                                        "bmv",     "",   "",    false, false },
  { "Bumaji",                                                     "byp",     "",   "",    false, false },
  { "Bumang",                                                     "bvp",     "",   "",    false, false },
  { "Bumbita Arapesh",                                            "aon",     "",   "",    false, false },
  { "Bumthangkha",                                                "kjz",     "",   "",    false, false },
  { "Bun",                                                        "buv",     "",   "",    false, false },
  { "Buna",                                                       "bvn",     "",   "",    false, false },
  { "Bunak",                                                      "bfn",     "",   "",    false, false },
  { "Bunama",                                                     "bdd",     "",   "",    false, false },
  { "Bundeli",                                                    "bns",     "",   "",    false, false },
  { "Bung",                                                       "bqd",     "",   "",    false, false },
  { "Bungain",                                                    "but",     "",   "",    false, false },
  { "Bunganditj",                                                 "xbg",     "",   "",    false, false },
  { "Bungku",                                                     "bkz",     "",   "",    false, false },
  { "Bungu",                                                      "wun",     "",   "",    false, false },
  { "Bunoge Dogon",                                               "dgb",     "",   "",    false, false },
  { "Bunuba",                                                     "bck",     "",   "",    false, false },
  { "Bunun",                                                      "bnn",     "",   "",    false, false },
  { "Buol",                                                       "blf",     "",   "",    false, false },
  { "Bura-Pabir",                                                 "bwr",     "",   "",    false, false },
  { "Burak",                                                      "bys",     "",   "",    false, false },
  { "Buraka",                                                     "bkg",     "",   "",    false, false },
  { "Burarra",                                                    "bvr",     "",   "",    false, false },
  { "Burate",                                                     "bti",     "",   "",    false, false },
  { "Burduna",                                                    "bxn",     "",   "",    false, false },
  { "Bure",                                                       "bvh",     "",   "",    false, false },
  { "Buriat",                                                     "bua",     "",   "",    true,  false },
  { "Burji",                                                      "bji",     "",   "",    false, false },
  { "Burmbar",                                                    "vrt",     "",   "",    false, false },
  { "Burmese",                                                    "bur",     "my", "mya", true,  false },
  { "Burmeso",                                                    "bzu",     "",   "",    false, false },
  { "Buru (Indonesia)",                                           "mhs",     "",   "",    false, false },
  { "Buru (Nigeria)",                                             "bqw",     "",   "",    false, false },
  { "Burui",                                                      "bry",     "",   "",    false, false },
  { "Burumakok",                                                  "aip",     "",   "",    false, false },
  { "Burun",                                                      "bdi",     "",   "",    false, false },
  { "Burundian Sign Language",                                    "lsb",     "",   "",    false, false },
  { "Burunge",                                                    "bds",     "",   "",    false, false },
  { "Burushaski",                                                 "bsk",     "",   "",    false, false },
  { "Burusu",                                                     "bqr",     "",   "",    false, false },
  { "Buruwai",                                                    "asi",     "",   "",    false, false },
  { "Busa",                                                       "bqp",     "",   "",    false, false },
  { "Busam",                                                      "bxs",     "",   "",    false, false },
  { "Busami",                                                     "bsm",     "",   "",    false, false },
  { "Busang Kayan",                                               "bfg",     "",   "",    false, false },
  { "Bushi",                                                      "buc",     "",   "",    false, false },
  { "Bushoong",                                                   "buf",     "",   "",    false, false },
  { "Buso",                                                       "bso",     "",   "",    false, false },
  { "Busoa",                                                      "bup",     "",   "",    false, false },
  { "Bussa",                                                      "dox",     "",   "",    false, false },
  { "Busuu",                                                      "bju",     "",   "",    false, false },
  { "Butbut Kalinga",                                             "kyb",     "",   "",    false, false },
  { "Butmas-Tur",                                                 "bnr",     "",   "",    false, false },
  { "Butuanon",                                                   "btw",     "",   "",    false, false },
  { "Buwal",                                                      "bhs",     "",   "",    false, false },
  { "Buya",                                                       "byy",     "",   "",    false, true  },
  { "Buyu",                                                       "byi",     "",   "",    false, false },
  { "Buyuan Jinuo",                                               "jiy",     "",   "",    false, false },
  { "Bwa",                                                        "bww",     "",   "",    false, false },
  { "Bwaidoka",                                                   "bwd",     "",   "",    false, false },
  { "Bwanabwana",                                                 "tte",     "",   "",    false, false },
  { "Bwatoo",                                                     "bwa",     "",   "",    false, false },
  { "Bwe Karen",                                                  "bwe",     "",   "",    false, false },
  { "Bwela",                                                      "bwl",     "",   "",    false, false },
  { "Bwile",                                                      "bwc",     "",   "",    false, false },
  { "Bwisi",                                                      "bwz",     "",   "",    false, false },
  { "Byangsi",                                                    "bee",     "",   "",    false, false },
  { "Byep",                                                       "mkk",     "",   "",    false, false },
  { "Bädi Kanum",                                                 "khd",     "",   "",    false, false },
  { "C'Lela",                                                     "dri",     "",   "",    false, false },
  { "Caac",                                                       "msq",     "",   "",    false, false },
  { "Cabiyarí",                                                   "cbb",     "",   "",    false, false },
  { "Cabécar",                                                    "cjp",     "",   "",    false, false },
  { "Cacaloxtepec Mixtec",                                        "miu",     "",   "",    false, false },
  { "Cacaopera",                                                  "ccr",     "",   "",    false, false },
  { "Cacgia Roglai",                                              "roc",     "",   "",    false, false },
  { "Cacua",                                                      "cbv",     "",   "",    false, false },
  { "Caddo",                                                      "cad",     "",   "",    true,  false },
  { "Caddoan languages",                                          "cdd",     "",   "",    false, false },
  { "Cafundo Creole",                                             "ccd",     "",   "",    false, false },
  { "Cagua",                                                      "cbh",     "",   "",    false, true  },
  { "Cahuarano",                                                  "cah",     "",   "",    false, false },
  { "Cahuilla",                                                   "chl",     "",   "",    false, false },
  { "Cajamarca Quechua",                                          "qvc",     "",   "",    false, false },
  { "Cajatambo North Lima Quechua",                               "qvl",     "",   "",    false, false },
  { "Cajonos Zapotec",                                            "zad",     "",   "",    false, false },
  { "Cajun French",                                               "frc",     "",   "",    false, false },
  { "Caka",                                                       "ckx",     "",   "",    false, false },
  { "Cakchiquel-Quiché Mixed Language",                           "ckz",     "",   "",    false, false },
  { "Cakfem-Mushere",                                             "cky",     "",   "",    false, false },
  { "Calamian Tagbanwa",                                          "tbk",     "",   "",    false, false },
  { "Calderón Highland Quichua",                                  "qud",     "",   "",    false, false },
  { "Callawalla",                                                 "caw",     "",   "",    false, false },
  { "Caluyanun",                                                  "clu",     "",   "",    false, false },
  { "Caló",                                                       "rmq",     "",   "",    false, false },
  { "Caló",                                                       "rmr",     "",   "",    false, true  },
  { "Cambodian Sign Language",                                    "csx",     "",   "",    false, false },
  { "Cameroon Mambila",                                           "mcu",     "",   "",    false, false },
  { "Cameroon Pidgin",                                            "wes",     "",   "",    false, false },
  { "Camling",                                                    "rab",     "",   "",    false, false },
  { "Campalagian",                                                "cml",     "",   "",    false, false },
  { "Campidanese Sardinian",                                      "sro",     "",   "",    false, false },
  { "Camsá",                                                      "kbh",     "",   "",    false, false },
  { "Camtho",                                                     "cmt",     "",   "",    false, false },
  { "Camunic",                                                    "xcc",     "",   "",    false, false },
  { "Candoshi-Shapra",                                            "cbu",     "",   "",    false, false },
  { "Canela",                                                     "ram",     "",   "",    false, false },
  { "Canichana",                                                  "caz",     "",   "",    false, false },
  { "Cao Lan",                                                    "mlc",     "",   "",    false, false },
  { "Cao Miao",                                                   "cov",     "",   "",    false, false },
  { "Capanahua",                                                  "kaq",     "",   "",    false, false },
  { "Capiznon",                                                   "cps",     "",   "",    false, false },
  { "Cappadocian Greek",                                          "cpg",     "",   "",    false, false },
  { "Caquinte",                                                   "cot",     "",   "",    false, false },
  { "Car Nicobarese",                                             "caq",     "",   "",    false, false },
  { "Cara",                                                       "cfd",     "",   "",    false, false },
  { "Carabayo",                                                   "cby",     "",   "",    false, false },
  { "Caramanta",                                                  "crf",     "",   "",    false, false },
  { "Carapana",                                                   "cbc",     "",   "",    false, false },
  { "Carian",                                                     "xcr",     "",   "",    false, false },
  { "Caribbean Hindustani",                                       "hns",     "",   "",    false, false },
  { "Caribbean Javanese",                                         "jvn",     "",   "",    false, false },
  { "Carijona",                                                   "cbd",     "",   "",    false, false },
  { "Carolina Algonquian",                                        "crr",     "",   "",    false, false },
  { "Carolinian",                                                 "cal",     "",   "",    false, false },
  { "Carpathian Romani",                                          "rmc",     "",   "",    false, false },
  { "Carrier",                                                    "crx",     "",   "",    false, false },
  { "Cashibo-Cacataibo",                                          "cbr",     "",   "",    false, false },
  { "Cashinahua",                                                 "cbs",     "",   "",    false, false },
  { "Casiguran Dumagat Agta",                                     "dgc",     "",   "",    false, false },
  { "Casuarina Coast Asmat",                                      "asc",     "",   "",    false, false },
  { "Cataelano Mandaya",                                          "mst",     "",   "",    false, true  },
  { "Catalan Sign Language",                                      "csc",     "",   "",    false, false },
  { "Catalan",                                                    "cat",     "ca", "",    true,  false },
  { "Catawba",                                                    "chc",     "",   "",    false, false },
  { "Cauca",                                                      "cca",     "",   "",    false, true  },
  { "Caucasian languages",                                        "cau",     "",   "",    true,  false },
  { "Cavineña",                                                   "cav",     "",   "",    false, false },
  { "Cayubaba",                                                   "cyb",     "",   "",    false, false },
  { "Cayuga",                                                     "cay",     "",   "",    false, false },
  { "Cayuse",                                                     "xcy",     "",   "",    false, false },
  { "Cañar Highland Quichua",                                     "qxr",     "",   "",    false, false },
  { "Ca̱hungwa̱rya̱",                                             "nat",     "",   "",    false, false },
  { "Cebaara Senoufo",                                            "sef",     "",   "",    false, false },
  { "Cebuano",                                                    "ceb",     "",   "",    true,  false },
  { "Celtiberian",                                                "xce",     "",   "",    false, false },
  { "Celtic languages",                                           "cel",     "",   "",    true,  false },
  { "Cemuhî",                                                     "cam",     "",   "",    false, false },
  { "Cen",                                                        "cen",     "",   "",    false, false },
  { "Central American Indian languages",                          "cai",     "",   "",    true,  false },
  { "Central Asmat",                                              "cns",     "",   "",    false, false },
  { "Central Atlas Tamazight",                                    "tzm",     "",   "",    false, false },
  { "Central Awyu",                                               "awu",     "",   "",    false, false },
  { "Central Aymara",                                             "ayr",     "",   "",    false, false },
  { "Central Bai",                                                "bca",     "",   "",    false, false },
  { "Central Berawan",                                            "zbc",     "",   "",    false, false },
  { "Central Bikol",                                              "bcl",     "",   "",    false, false },
  { "Central Bontok",                                             "lbk",     "",   "",    false, false },
  { "Central Cagayan Agta",                                       "agt",     "",   "",    false, false },
  { "Central Grebo",                                              "grv",     "",   "",    false, false },
  { "Central Hongshuihe Zhuang",                                  "zch",     "",   "",    false, false },
  { "Central Huasteca Nahuatl",                                   "nch",     "",   "",    false, false },
  { "Central Huishui Hmong",                                      "hmc",     "",   "",    false, false },
  { "Central Kanuri",                                             "knc",     "",   "",    false, false },
  { "Central Kurdish",                                            "ckb",     "",   "",    false, false },
  { "Central Maewo",                                              "mwo",     "",   "",    false, false },
  { "Central Malay",                                              "pse",     "",   "",    false, false },
  { "Central Malayo-Polynesian languages",                        "plf",     "",   "",    false, false },
  { "Central Masela",                                             "mxz",     "",   "",    false, false },
  { "Central Mashan Hmong",                                       "hmm",     "",   "",    false, false },
  { "Central Mazahua",                                            "maz",     "",   "",    false, false },
  { "Central Melanau",                                            "mel",     "",   "",    false, false },
  { "Central Mnong",                                              "cmo",     "",   "",    false, false },
  { "Central Nahuatl",                                            "nhn",     "",   "",    false, false },
  { "Central Nicobarese",                                         "ncb",     "",   "",    false, false },
  { "Central Ojibwa",                                             "ojc",     "",   "",    false, false },
  { "Central Okinawan",                                           "ryu",     "",   "",    false, false },
  { "Central Palawano",                                           "plc",     "",   "",    false, false },
  { "Central Pame",                                               "pbs",     "",   "",    false, false },
  { "Central Pashto",                                             "pst",     "",   "",    false, false },
  { "Central Pomo",                                               "poo",     "",   "",    false, false },
  { "Central Puebla Nahuatl",                                     "ncx",     "",   "",    false, false },
  { "Central Sama",                                               "sml",     "",   "",    false, false },
  { "Central Siberian Yupik",                                     "ess",     "",   "",    false, false },
  { "Central Sierra Miwok",                                       "csm",     "",   "",    false, false },
  { "Central Subanen",                                            "syb",     "",   "",    false, false },
  { "Central Sudanic languages",                                  "csu",     "",   "",    false, false },
  { "Central Tagbanwa",                                           "tgt",     "",   "",    false, false },
  { "Central Tarahumara",                                         "tar",     "",   "",    false, false },
  { "Central Tunebo",                                             "tuf",     "",   "",    false, false },
  { "Central Yupik",                                              "esu",     "",   "",    false, false },
  { "Central-Eastern Niger Fulfulde",                             "fuq",     "",   "",    false, false },
  { "Centúúm",                                                    "cet",     "",   "",    false, false },
  { "Cerma",                                                      "cme",     "",   "",    false, false },
  { "Cha'ari",                                                    "cxh",     "",   "",    false, false },
  { "Chabu",                                                      "sbf",     "",   "",    false, false },
  { "Chachapoyas Quechua",                                        "quk",     "",   "",    false, false },
  { "Chachi",                                                     "cbi",     "",   "",    false, false },
  { "Chadian Arabic",                                             "shu",     "",   "",    false, false },
  { "Chadian Sign Language",                                      "cds",     "",   "",    false, false },
  { "Chadic languages",                                           "cdc",     "",   "",    false, false },
  { "Chadong",                                                    "cdy",     "",   "",    false, false },
  { "Chagatai",                                                   "chg",     "",   "",    true,  false },
  { "Chaima",                                                     "ciy",     "",   "",    false, false },
  { "Chak",                                                       "ckh",     "",   "",    false, false },
  { "Chakali",                                                    "cli",     "",   "",    false, false },
  { "Chakavian",                                                  "ckm",     "",   "",    false, false },
  { "Chakma",                                                     "ccp",     "",   "",    false, false },
  { "Chala",                                                      "cll",     "",   "",    false, false },
  { "Chaldean Neo-Aramaic",                                       "cld",     "",   "",    false, false },
  { "Chalikha",                                                   "tgf",     "",   "",    false, false },
  { "Chamacoco",                                                  "ceg",     "",   "",    false, false },
  { "Chamalal",                                                   "cji",     "",   "",    false, false },
  { "Chamari",                                                    "cdg",     "",   "",    false, true  },
  { "Chambeali",                                                  "cdh",     "",   "",    false, false },
  { "Chambri",                                                    "can",     "",   "",    false, false },
  { "Chamic languages",                                           "cmc",     "",   "",    true,  false },
  { "Chamicuro",                                                  "ccc",     "",   "",    false, false },
  { "Chamorro",                                                   "cha",     "ch", "",    true,  false },
  { "Chang Naga",                                                 "nbc",     "",   "",    false, false },
  { "Changriwa",                                                  "cga",     "",   "",    false, false },
  { "Changthang",                                                 "cna",     "",   "",    false, false },
  { "Chantyal",                                                   "chx",     "",   "",    false, false },
  { "Chané",                                                      "caj",     "",   "",    false, false },
  { "Chara",                                                      "cra",     "",   "",    false, false },
  { "Chaudangsi",                                                 "cdn",     "",   "",    false, false },
  { "Chaungtha",                                                  "ccq",     "",   "",    false, true  },
  { "Chaura",                                                     "crv",     "",   "",    false, false },
  { "Chavacano",                                                  "cbk",     "",   "",    false, false },
  { "Chayahuita",                                                 "cbt",     "",   "",    false, false },
  { "Chayuco Mixtec",                                             "mih",     "",   "",    false, false },
  { "Chazumba Mixtec",                                            "xtb",     "",   "",    false, false },
  { "Che",                                                        "ruk",     "",   "",    false, false },
  { "Chechen",                                                    "che",     "ce", "",    true,  false },
  { "Cheke Holo",                                                 "mrn",     "",   "",    false, false },
  { "Chemakum",                                                   "xch",     "",   "",    false, false },
  { "Chenapian",                                                  "cjn",     "",   "",    false, false },
  { "Chenchu",                                                    "cde",     "",   "",    false, false },
  { "Chenoua",                                                    "cnu",     "",   "",    false, false },
  { "Chepang",                                                    "cdm",     "",   "",    false, false },
  { "Chepya",                                                     "ycp",     "",   "",    false, false },
  { "Cherepon",                                                   "cpn",     "",   "",    false, false },
  { "Cherokee",                                                   "chr",     "",   "",    true,  false },
  { "Chesu",                                                      "ych",     "",   "",    false, false },
  { "Chetco",                                                     "ctc",     "",   "",    false, false },
  { "Chewong",                                                    "cwg",     "",   "",    false, false },
  { "Cheyenne",                                                   "chy",     "",   "",    true,  false },
  { "Chhattisgarhi",                                              "hne",     "",   "",    false, false },
  { "Chhintange",                                                 "ctn",     "",   "",    false, false },
  { "Chhulung",                                                   "cur",     "",   "",    false, false },
  { "Chiangmai Sign Language",                                    "csd",     "",   "",    false, false },
  { "Chiapanec",                                                  "cip",     "",   "",    false, false },
  { "Chibcha",                                                    "chb",     "",   "",    true,  false },
  { "Chibchan languages",                                         "cba",     "",   "",    false, false },
  { "Chicahuaxtla Triqui",                                        "trs",     "",   "",    false, false },
  { "Chichicapan Zapotec",                                        "zpv",     "",   "",    false, false },
  { "Chichimeca-Jonaz",                                           "pei",     "",   "",    false, false },
  { "Chickasaw",                                                  "cic",     "",   "",    false, false },
  { "Chicomuceltec",                                              "cob",     "",   "",    false, false },
  { "Chiga",                                                      "cgg",     "",   "",    false, false },
  { "Chigmecatitlán Mixtec",                                      "mii",     "",   "",    false, false },
  { "Chilcotin",                                                  "clc",     "",   "",    false, false },
  { "Chilean Quechua",                                            "cqu",     "",   "",    false, true  },
  { "Chilean Sign Language",                                      "csg",     "",   "",    false, false },
  { "Chilisso",                                                   "clh",     "",   "",    false, false },
  { "Chiltepec Chinantec",                                        "csa",     "",   "",    false, false },
  { "Chimakum",                                                   "cmk",     "",   "",    false, true  },
  { "Chimalapa Zoque",                                            "zoh",     "",   "",    false, false },
  { "Chimariko",                                                  "cid",     "",   "",    false, false },
  { "Chimborazo Highland Quichua",                                "qug",     "",   "",    false, false },
  { "Chimila",                                                    "cbg",     "",   "",    false, false },
  { "China Buriat",                                               "bxu",     "",   "",    false, false },
  { "Chinali",                                                    "cih",     "",   "",    false, false },
  { "Chinbon Chin",                                               "cnb",     "",   "",    false, false },
  { "Chincha Quechua",                                            "qxc",     "",   "",    false, false },
  { "Chinese (family)",                                           "zhx",     "",   "",    false, false },
  { "Chinese Pidgin English",                                     "cpi",     "",   "",    false, false },
  { "Chinese Sign Language",                                      "csl",     "",   "",    false, false },
  { "Chinese",                                                    "chi",     "zh", "zho", true,  false },
  { "Chinook jargon",                                             "chn",     "",   "",    true,  false },
  { "Chinook",                                                    "chh",     "",   "",    false, false },
  { "Chipaya",                                                    "cap",     "",   "",    false, false },
  { "Chipewyan",                                                  "chp",     "",   "",    true,  false },
  { "Chipiajes",                                                  "cbe",     "",   "",    false, true  },
  { "Chippewa",                                                   "ciw",     "",   "",    false, false },
  { "Chiquihuitlán Mazatec",                                      "maq",     "",   "",    false, false },
  { "Chiquitano",                                                 "cax",     "",   "",    false, false },
  { "Chiquián Ancash Quechua",                                    "qxa",     "",   "",    false, false },
  { "Chiripá",                                                    "nhd",     "",   "",    false, false },
  { "Chiru",                                                      "cdf",     "",   "",    false, false },
  { "Chitimacha",                                                 "ctm",     "",   "",    false, false },
  { "Chitkuli Kinnauri",                                          "cik",     "",   "",    false, false },
  { "Chittagonian",                                               "ctg",     "",   "",    false, false },
  { "Chitwania Tharu",                                            "the",     "",   "",    false, false },
  { "Choapan Zapotec",                                            "zpc",     "",   "",    false, false },
  { "Chocangacakha",                                              "cgk",     "",   "",    false, false },
  { "Chochotec",                                                  "coz",     "",   "",    false, false },
  { "Choctaw",                                                    "cho",     "",   "",    true,  false },
  { "Chodri",                                                     "cdi",     "",   "",    false, false },
  { "Chokri Naga",                                                "nri",     "",   "",    false, false },
  { "Chokwe",                                                     "cjk",     "",   "",    false, false },
  { "Chol",                                                       "ctu",     "",   "",    false, false },
  { "Cholón",                                                     "cht",     "",   "",    false, false },
  { "Chong",                                                      "cog",     "",   "",    false, false },
  { "Choni",                                                      "cda",     "",   "",    false, false },
  { "Chonyi-Dzihana-Kauma",                                       "coh",     "",   "",    false, false },
  { "Chopi",                                                      "cce",     "",   "",    false, false },
  { "Chorasmian",                                                 "xco",     "",   "",    false, false },
  { "Chorotega",                                                  "cjr",     "",   "",    false, true  },
  { "Chortí",                                                     "caa",     "",   "",    false, false },
  { "Chothe Naga",                                                "nct",     "",   "",    false, false },
  { "Chrau",                                                      "crw",     "",   "",    false, false },
  { "Chru",                                                       "cje",     "",   "",    false, false },
  { "Chuanqiandian Cluster Miao",                                 "cqd",     "",   "",    false, false },
  { "Chuave",                                                     "cjv",     "",   "",    false, false },
  { "Chug",                                                       "cvg",     "",   "",    false, false },
  { "Chuj",                                                       "cac",     "",   "",    false, false },
  { "Chuka",                                                      "cuh",     "",   "",    false, false },
  { "Chukot",                                                     "ckt",     "",   "",    false, false },
  { "Chukwa",                                                     "cuw",     "",   "",    false, false },
  { "Chulym",                                                     "clw",     "",   "",    false, false },
  { "Chumburung",                                                 "ncu",     "",   "",    false, false },
  { "Chung",                                                      "cnq",     "",   "",    false, false },
  { "Churahi",                                                    "cdj",     "",   "",    false, false },
  { "Church Slavic",                                              "chu",     "cu", "",    true,  false },
  { "Chut",                                                       "scb",     "",   "",    false, false },
  { "Chuukese",                                                   "chk",     "",   "",    true,  false },
  { "Chuvantsy",                                                  "xcv",     "",   "",    false, false },
  { "Chuvash",                                                    "chv",     "cv", "",    true,  false },
  { "Chuwabu",                                                    "chw",     "",   "",    false, false },
  { "Chácobo",                                                    "cao",     "",   "",    false, false },
  { "Ci Gbe",                                                     "cib",     "",   "",    false, false },
  { "Cia-Cia",                                                    "cia",     "",   "",    false, false },
  { "Cibak",                                                      "ckl",     "",   "",    false, false },
  { "Cicipu",                                                     "awc",     "",   "",    false, false },
  { "Cimbrian",                                                   "cim",     "",   "",    false, false },
  { "Cinda-Regi-Tiyal",                                           "cdr",     "",   "",    false, false },
  { "Cineni",                                                     "cie",     "",   "",    false, false },
  { "Cinta Larga",                                                "cin",     "",   "",    false, false },
  { "Cisalpine Gaulish",                                          "xcg",     "",   "",    false, false },
  { "Cishingini",                                                 "asg",     "",   "",    false, false },
  { "Citak",                                                      "txt",     "",   "",    false, false },
  { "Ciwogai",                                                    "tgd",     "",   "",    false, false },
  { "Clallam",                                                    "clm",     "",   "",    false, false },
  { "Classical Armenian",                                         "xcl",     "",   "",    false, false },
  { "Classical Mandaic",                                          "myz",     "",   "",    false, false },
  { "Classical Mongolian",                                        "cmg",     "",   "",    false, false },
  { "Classical Nahuatl",                                          "nci",     "",   "",    false, false },
  { "Classical Newari",                                           "nwc",     "",   "",    true,  false },
  { "Classical Quechua",                                          "qwc",     "",   "",    false, false },
  { "Classical Sanskrit",                                         "cls",     "",   "",    false, false },
  { "Classical Syriac",                                           "syc",     "",   "",    true,  false },
  { "Classical Tibetan",                                          "xct",     "",   "",    false, false },
  { "Coahuilteco",                                                "xcw",     "",   "",    false, false },
  { "Coast Miwok",                                                "csi",     "",   "",    false, false },
  { "Coastal Kadazan",                                            "kzj",     "",   "",    false, true  },
  { "Coastal Konjo",                                              "kjc",     "",   "",    false, false },
  { "Coatecas Altas Zapotec",                                     "zca",     "",   "",    false, false },
  { "Coatepec Nahuatl",                                           "naz",     "",   "",    false, false },
  { "Coatlán Mixe",                                               "mco",     "",   "",    false, false },
  { "Coatlán Zapotec",                                            "zps",     "",   "",    false, false },
  { "Coatzospan Mixtec",                                          "miz",     "",   "",    false, false },
  { "Cocama-Cocamilla",                                           "cod",     "",   "",    false, false },
  { "Cochimi",                                                    "coj",     "",   "",    false, false },
  { "Cocopa",                                                     "coc",     "",   "",    false, false },
  { "Cocos Islands Malay",                                        "coa",     "",   "",    false, false },
  { "Coeur d'Alene",                                              "crd",     "",   "",    false, false },
  { "Cofán",                                                      "con",     "",   "",    false, false },
  { "Cogui",                                                      "kog",     "",   "",    false, false },
  { "Col",                                                        "liw",     "",   "",    false, false },
  { "Colombian Sign Language",                                    "csn",     "",   "",    false, false },
  { "Colonia Tovar German",                                       "gct",     "",   "",    false, false },
  { "Colorado",                                                   "cof",     "",   "",    false, false },
  { "Columbia-Wenatchi",                                          "col",     "",   "",    false, false },
  { "Comaltepec Chinantec",                                       "cco",     "",   "",    false, false },
  { "Comanche",                                                   "com",     "",   "",    false, false },
  { "Comecrudo",                                                  "xcm",     "",   "",    false, false },
  { "Como Karim",                                                 "cfg",     "",   "",    false, false },
  { "Comox",                                                      "coo",     "",   "",    false, false },
  { "Con",                                                        "cno",     "",   "",    false, false },
  { "Congo Swahili",                                              "swc",     "",   "",    false, false },
  { "Coos",                                                       "csz",     "",   "",    false, false },
  { "Copainalá Zoque",                                            "zoc",     "",   "",    false, false },
  { "Copala Triqui",                                              "trc",     "",   "",    false, false },
  { "Coptic",                                                     "cop",     "",   "",    true,  false },
  { "Coquille",                                                   "coq",     "",   "",    false, false },
  { "Cori",                                                       "cry",     "",   "",    false, false },
  { "Cornish",                                                    "cor",     "kw", "",    true,  false },
  { "Corongo Ancash Quechua",                                     "qwa",     "",   "",    false, false },
  { "Corsican",                                                   "cos",     "co", "",    true,  false },
  { "Costa Rican Sign Language",                                  "csr",     "",   "",    false, false },
  { "Cotabato Manobo",                                            "mta",     "",   "",    false, false },
  { "Cotoname",                                                   "xcn",     "",   "",    false, false },
  { "Cowlitz",                                                    "cow",     "",   "",    false, false },
  { "Coxima",                                                     "kox",     "",   "",    false, true  },
  { "Coyaima",                                                    "coy",     "",   "",    false, true  },
  { "Coyotepec Popoloca",                                         "pbf",     "",   "",    false, false },
  { "Coyutla Totonac",                                            "toc",     "",   "",    false, false },
  { "Cree",                                                       "cre",     "cr", "",    true,  false },
  { "Creek",                                                      "mus",     "",   "",    true,  false },
  { "Creoles and pidgins",                                        "crp",     "",   "",    true,  false },
  { "Creoles and pidgins, English based",                         "cpe",     "",   "",    true,  false },
  { "Creoles and pidgins, French-based",                          "cpf",     "",   "",    true,  false },
  { "Creoles and pidgins, Portuguese-based",                      "cpp",     "",   "",    true,  false },
  { "Crimean Tatar",                                              "crh",     "",   "",    true,  false },
  { "Croatia Sign Language",                                      "csq",     "",   "",    false, false },
  { "Croatian",                                                   "hrv",     "hr", "",    true,  false },
  { "Cross River Mbembe",                                         "mfn",     "",   "",    false, false },
  { "Crow",                                                       "cro",     "",   "",    false, false },
  { "Cruzeño",                                                    "crz",     "",   "",    false, false },
  { "Cua",                                                        "cua",     "",   "",    false, false },
  { "Cuba Sign Language",                                         "csf",     "",   "",    false, false },
  { "Cubeo",                                                      "cub",     "",   "",    false, false },
  { "Cuiba",                                                      "cui",     "",   "",    false, false },
  { "Cuitlatec",                                                  "cuy",     "",   "",    false, false },
  { "Culina",                                                     "cul",     "",   "",    false, false },
  { "Cumanagoto",                                                 "cuo",     "",   "",    false, false },
  { "Cumbric",                                                    "xcb",     "",   "",    false, false },
  { "Cumeral",                                                    "cum",     "",   "",    false, true  },
  { "Cun",                                                        "cuq",     "",   "",    false, false },
  { "Cuneiform Luwian",                                           "xlu",     "",   "",    false, false },
  { "Cung",                                                       "cug",     "",   "",    false, true  },
  { "Cupeño",                                                     "cup",     "",   "",    false, false },
  { "Curonian",                                                   "xcu",     "",   "",    false, false },
  { "Curripaco",                                                  "kpc",     "",   "",    false, false },
  { "Cusco Quechua",                                              "quz",     "",   "",    false, false },
  { "Cushitic languages",                                         "cus",     "",   "",    true,  false },
  { "Cutchi-Swahili",                                             "ccl",     "",   "",    false, false },
  { "Cuvok",                                                      "cuv",     "",   "",    false, false },
  { "Cuyamecalco Mixtec",                                         "xtu",     "",   "",    false, false },
  { "Cuyonon",                                                    "cyo",     "",   "",    false, false },
  { "Cwi Bwamu",                                                  "bwy",     "",   "",    false, false },
  { "Cypriot Arabic",                                             "acy",     "",   "",    false, false },
  { "Czech Sign Language",                                        "cse",     "",   "",    false, false },
  { "Czech",                                                      "cze",     "cs", "ces", true,  false },
  { "Côông",                                                      "cnc",     "",   "",    false, false },
  { "Da'a Kaili",                                                 "kzf",     "",   "",    false, false },
  { "Daai Chin",                                                  "dao",     "",   "",    false, false },
  { "Daakaka",                                                    "bpa",     "",   "",    false, false },
  { "Daantanai'",                                                 "lni",     "",   "",    false, false },
  { "Daasanach",                                                  "dsh",     "",   "",    false, false },
  { "Daatsʼíin",                                                 "dtn",     "",   "",    false, false },
  { "Daba",                                                       "dbq",     "",   "",    false, false },
  { "Dabarre",                                                    "dbr",     "",   "",    false, false },
  { "Dabe",                                                       "dbe",     "",   "",    false, false },
  { "Dacian",                                                     "xdc",     "",   "",    false, false },
  { "Dadi Dadi",                                                  "dda",     "",   "",    false, false },
  { "Dadibi",                                                     "mps",     "",   "",    false, false },
  { "Dadiya",                                                     "dbd",     "",   "",    false, false },
  { "Daga",                                                       "dgz",     "",   "",    false, false },
  { "Dagaari Dioula",                                             "dgd",     "",   "",    false, false },
  { "Dagba",                                                      "dgk",     "",   "",    false, false },
  { "Dagbani",                                                    "dag",     "",   "",    false, false },
  { "Dagik",                                                      "dec",     "",   "",    false, false },
  { "Dagoman",                                                    "dgn",     "",   "",    false, false },
  { "Dahalik",                                                    "dlk",     "",   "",    false, false },
  { "Dahalo",                                                     "dal",     "",   "",    false, false },
  { "Daho-Doo",                                                   "das",     "",   "",    false, false },
  { "Dai Zhuang",                                                 "zhd",     "",   "",    false, false },
  { "Dai",                                                        "dij",     "",   "",    false, false },
  { "Dair",                                                       "drb",     "",   "",    false, false },
  { "Dakka",                                                      "dkk",     "",   "",    false, false },
  { "Dakota",                                                     "dak",     "",   "",    true,  false },
  { "Dakpakha",                                                   "dka",     "",   "",    false, false },
  { "Dalabon",                                                    "ngk",     "",   "",    false, false },
  { "Dalmatian",                                                  "dlm",     "",   "",    false, false },
  { "Daloa Bété",                                                 "bev",     "",   "",    false, false },
  { "Dama",                                                       "dmm",     "",   "",    false, false },
  { "Damakawa",                                                   "dam",     "",   "",    false, false },
  { "Damal",                                                      "uhn",     "",   "",    false, false },
  { "Dambi",                                                      "dac",     "",   "",    false, false },
  { "Dameli",                                                     "dml",     "",   "",    false, false },
  { "Dampelas",                                                   "dms",     "",   "",    false, false },
  { "Dan",                                                        "daf",     "",   "",    false, true  },
  { "Dan",                                                        "dnj",     "",   "",    false, false },
  { "Danaru",                                                     "dnr",     "",   "",    false, false },
  { "Danau",                                                      "dnu",     "",   "",    false, false },
  { "Dandami Maria",                                              "daq",     "",   "",    false, false },
  { "Dangaléat",                                                  "daa",     "",   "",    false, false },
  { "Dangaura Tharu",                                             "thl",     "",   "",    false, false },
  { "Danish Sign Language",                                       "dsl",     "",   "",    false, false },
  { "Danish",                                                     "dan",     "da", "",    true,  false },
  { "Dano",                                                       "aso",     "",   "",    false, false },
  { "Danu",                                                       "dnv",     "",   "",    false, false },
  { "Daonda",                                                     "dnd",     "",   "",    false, false },
  { "Dar Daju Daju",                                              "djc",     "",   "",    false, false },
  { "Dar Fur Daju",                                               "daj",     "",   "",    false, false },
  { "Dar Sila Daju",                                              "dau",     "",   "",    false, false },
  { "Darai",                                                      "dry",     "",   "",    false, false },
  { "Dargwa",                                                     "dar",     "",   "",    true,  false },
  { "Dari",                                                       "prs",     "",   "",    false, false },
  { "Darkhat",                                                    "drh",     "",   "",    false, true  },
  { "Darkinyung",                                                 "xda",     "",   "",    false, false },
  { "Darlong",                                                    "dln",     "",   "",    false, false },
  { "Darmiya",                                                    "drd",     "",   "",    false, false },
  { "Daro-Matu Melanau",                                          "dro",     "",   "",    false, false },
  { "Darwazi",                                                    "drw",     "",   "",    false, true  },
  { "Dass",                                                       "dot",     "",   "",    false, false },
  { "Datooga",                                                    "tcc",     "",   "",    false, false },
  { "Daungwurrung",                                               "dgw",     "",   "",    false, false },
  { "Daur",                                                       "dta",     "",   "",    false, false },
  { "Davawenyo",                                                  "daw",     "",   "",    false, false },
  { "Dawawa",                                                     "dww",     "",   "",    false, false },
  { "Dawera-Daweloor",                                            "ddw",     "",   "",    false, false },
  { "Dawik Kui",                                                  "dwk",     "",   "",    false, false },
  { "Dawro",                                                      "dwr",     "",   "",    false, false },
  { "Day",                                                        "dai",     "",   "",    false, false },
  { "Dayi",                                                       "dax",     "",   "",    false, false },
  { "Daza",                                                       "dzd",     "",   "",    false, false },
  { "Dazaga",                                                     "dzg",     "",   "",    false, false },
  { "Deccan",                                                     "dcc",     "",   "",    false, false },
  { "Dedua",                                                      "ded",     "",   "",    false, false },
  { "Defaka",                                                     "afn",     "",   "",    false, false },
  { "Defi Gbe",                                                   "gbh",     "",   "",    false, false },
  { "Deg",                                                        "mzw",     "",   "",    false, false },
  { "Degaru",                                                     "dgu",     "",   "",    false, true  },
  { "Degema",                                                     "deg",     "",   "",    false, false },
  { "Degenan",                                                    "dge",     "",   "",    false, false },
  { "Degexit'an",                                                 "ing",     "",   "",    false, false },
  { "Dehu",                                                       "dhv",     "",   "",    false, false },
  { "Dehwari",                                                    "deh",     "",   "",    false, false },
  { "Dek",                                                        "dek",     "",   "",    false, true  },
  { "Dela-Oenale",                                                "row",     "",   "",    false, false },
  { "Delaware",                                                   "del",     "",   "",    true,  false },
  { "Delo",                                                       "ntr",     "",   "",    false, false },
  { "Dem",                                                        "dem",     "",   "",    false, false },
  { "Dema",                                                       "dmx",     "",   "",    false, false },
  { "Demisa",                                                     "dei",     "",   "",    false, false },
  { "Demta",                                                      "dmy",     "",   "",    false, false },
  { "Dendi (Benin)",                                              "ddn",     "",   "",    false, false },
  { "Dendi (Central African Republic)",                           "deq",     "",   "",    false, false },
  { "Dengese",                                                    "dez",     "",   "",    false, false },
  { "Dengka",                                                     "dnk",     "",   "",    false, false },
  { "Deno",                                                       "dbb",     "",   "",    false, false },
  { "Denya",                                                      "anv",     "",   "",    false, false },
  { "Dení",                                                       "dny",     "",   "",    false, false },
  { "Deori",                                                      "der",     "",   "",    false, false },
  { "Dera (Indonesia)",                                           "kbv",     "",   "",    false, false },
  { "Dera (Nigeria)",                                             "kna",     "",   "",    false, false },
  { "Desano",                                                     "des",     "",   "",    false, false },
  { "Desiya",                                                     "dso",     "",   "",    false, false },
  { "Dewas Rai",                                                  "dwz",     "",   "",    false, false },
  { "Dewoin",                                                     "dee",     "",   "",    false, false },
  { "Dezfuli",                                                    "def",     "",   "",    false, false },
  { "Dghwede",                                                    "dgh",     "",   "",    false, false },
  { "Dhaiso",                                                     "dhs",     "",   "",    false, false },
  { "Dhalandji",                                                  "dhl",     "",   "",    false, false },
  { "Dhangu-Djangu",                                              "dhg",     "",   "",    false, false },
  { "Dhanki",                                                     "dhn",     "",   "",    false, false },
  { "Dhanwar (India)",                                            "dha",     "",   "",    false, true  },
  { "Dhanwar (Nepal)",                                            "dhw",     "",   "",    false, false },
  { "Dhao",                                                       "nfa",     "",   "",    false, false },
  { "Dharawal",                                                   "tbh",     "",   "",    false, false },
  { "Dhargari",                                                   "dhr",     "",   "",    false, false },
  { "Dharuk",                                                     "xdk",     "",   "",    false, false },
  { "Dharumbal",                                                  "xgm",     "",   "",    false, false },
  { "Dhatki",                                                     "mki",     "",   "",    false, false },
  { "Dhimal",                                                     "dhi",     "",   "",    false, false },
  { "Dhivehi",                                                    "div",     "dv", "",    true,  false },
  { "Dhodia",                                                     "dho",     "",   "",    false, false },
  { "Dhofari Arabic",                                             "adf",     "",   "",    false, false },
  { "Dhudhuroa",                                                  "ddr",     "",   "",    false, false },
  { "Dhundari",                                                   "dhd",     "",   "",    false, false },
  { "Dhungaloo",                                                  "dhx",     "",   "",    false, false },
  { "Dhurga",                                                     "dhu",     "",   "",    false, false },
  { "Dhuwal",                                                     "duj",     "",   "",    false, true  },
  { "Dhuwal",                                                     "dwu",     "",   "",    false, false },
  { "Dhuwaya",                                                    "dwy",     "",   "",    false, false },
  { "Dia",                                                        "dia",     "",   "",    false, false },
  { "Dibabawon Manobo",                                           "mbd",     "",   "",    false, false },
  { "Dibiyaso",                                                   "dby",     "",   "",    false, false },
  { "Dibo",                                                       "dio",     "",   "",    false, false },
  { "Dibole",                                                     "bvx",     "",   "",    false, false },
  { "Dicamay Agta",                                               "duy",     "",   "",    false, false },
  { "Didinga",                                                    "did",     "",   "",    false, false },
  { "Dido",                                                       "ddo",     "",   "",    false, false },
  { "Dieri",                                                      "dif",     "",   "",    false, false },
  { "Digaro-Mishmi",                                              "mhu",     "",   "",    false, false },
  { "Digo",                                                       "dig",     "",   "",    false, false },
  { "Dii",                                                        "dur",     "",   "",    false, false },
  { "Dijim-Bwilim",                                               "cfa",     "",   "",    false, false },
  { "Dilling",                                                    "dil",     "",   "",    false, false },
  { "Dima",                                                       "jma",     "",   "",    false, false },
  { "Dimasa",                                                     "dis",     "",   "",    false, false },
  { "Dimbong",                                                    "dii",     "",   "",    false, false },
  { "Dime",                                                       "dim",     "",   "",    false, false },
  { "Dimli (individual language)",                                "diq",     "",   "",    false, false },
  { "Ding",                                                       "diz",     "",   "",    false, false },
  { "Dinka",                                                      "din",     "",   "",    true,  false },
  { "Dir-Nyamzak-Mbarimi",                                        "nzr",     "",   "",    false, false },
  { "Dirari",                                                     "dit",     "",   "",    false, true  },
  { "Dirasha",                                                    "gdl",     "",   "",    false, false },
  { "Diri",                                                       "dwa",     "",   "",    false, false },
  { "Diriku",                                                     "diu",     "",   "",    false, false },
  { "Dirim",                                                      "dir",     "",   "",    false, false },
  { "Disa",                                                       "dsi",     "",   "",    false, false },
  { "Ditammari",                                                  "tbz",     "",   "",    false, false },
  { "Ditidaht",                                                   "dtd",     "",   "",    false, false },
  { "Diuwe",                                                      "diy",     "",   "",    false, false },
  { "Diuxi-Tilantongo Mixtec",                                    "xtd",     "",   "",    false, false },
  { "Dixon Reef",                                                 "dix",     "",   "",    false, false },
  { "Dizin",                                                      "mdx",     "",   "",    false, false },
  { "Djabugay",                                                   "dyy",     "",   "",    false, false },
  { "Djabwurrung",                                                "tjw",     "",   "",    false, false },
  { "Djadjawurrung",                                              "dja",     "",   "",    false, false },
  { "Djambarrpuyngu",                                             "djr",     "",   "",    false, false },
  { "Djamindjung",                                                "djd",     "",   "",    false, false },
  { "Djangun",                                                    "djf",     "",   "",    false, false },
  { "Djawi",                                                      "djw",     "",   "",    false, false },
  { "Djeebbana",                                                  "djj",     "",   "",    false, false },
  { "Djimini Senoufo",                                            "dyi",     "",   "",    false, false },
  { "Djinang",                                                    "dji",     "",   "",    false, false },
  { "Djinba",                                                     "djb",     "",   "",    false, false },
  { "Djiwarli",                                                   "djl",     "",   "",    false, true  },
  { "Djiwarli",                                                   "dze",     "",   "",    false, false },
  { "Dobel",                                                      "kvo",     "",   "",    false, false },
  { "Dobu",                                                       "dob",     "",   "",    false, false },
  { "Doe",                                                        "doe",     "",   "",    false, false },
  { "Doga",                                                       "dgg",     "",   "",    false, false },
  { "Doghoro",                                                    "dgx",     "",   "",    false, false },
  { "Dogoso",                                                     "dgs",     "",   "",    false, false },
  { "Dogosé",                                                     "dos",     "",   "",    false, false },
  { "Dogri (individual language)",                                "dgo",     "",   "",    false, false },
  { "Dogri (macrolanguage)",                                      "doi",     "",   "",    true,  false },
  { "Dogul Dom Dogon",                                            "dbg",     "",   "",    false, false },
  { "Doka",                                                       "dbi",     "",   "",    false, false },
  { "Doko-Uyanga",                                                "uya",     "",   "",    false, false },
  { "Dokshi",                                                     "dsk",     "",   "",    false, false },
  { "Dolgan",                                                     "dlg",     "",   "",    false, false },
  { "Dolpo",                                                      "dre",     "",   "",    false, false },
  { "Dom",                                                        "doa",     "",   "",    false, false },
  { "Domaaki",                                                    "dmk",     "",   "",    false, false },
  { "Domari",                                                     "rmt",     "",   "",    false, false },
  { "Dombe",                                                      "dov",     "",   "",    false, false },
  { "Dominican Sign Language",                                    "doq",     "",   "",    false, false },
  { "Dompo",                                                      "doy",     "",   "",    false, false },
  { "Domu",                                                       "dof",     "",   "",    false, false },
  { "Domung",                                                     "dev",     "",   "",    false, false },
  { "Dondo",                                                      "dok",     "",   "",    false, false },
  { "Dong",                                                       "doh",     "",   "",    false, false },
  { "Dongo",                                                      "doo",     "",   "",    false, false },
  { "Dongotono",                                                  "ddd",     "",   "",    false, false },
  { "Dongshanba Lalo",                                            "yik",     "",   "",    false, false },
  { "Dongxiang",                                                  "sce",     "",   "",    false, false },
  { "Donno So Dogon",                                             "dds",     "",   "",    false, false },
  { "Doondo",                                                     "dde",     "",   "",    false, false },
  { "Dori'o",                                                     "dor",     "",   "",    false, false },
  { "Doromu-Koki",                                                "kqc",     "",   "",    false, false },
  { "Dororo",                                                     "drr",     "",   "",    false, true  },
  { "Dorze",                                                      "doz",     "",   "",    false, false },
  { "Doso",                                                       "dol",     "",   "",    false, false },
  { "Dotyali",                                                    "dty",     "",   "",    false, false },
  { "Doutai",                                                     "tds",     "",   "",    false, false },
  { "Doyayo",                                                     "dow",     "",   "",    false, false },
  { "Dravidian languages",                                        "dra",     "",   "",    true,  false },
  { "Drents",                                                     "drt",     "",   "",    false, false },
  { "Drung",                                                      "duu",     "",   "",    false, false },
  { "Duala",                                                      "dua",     "",   "",    true,  false },
  { "Duano",                                                      "dup",     "",   "",    false, false },
  { "Duau",                                                       "dva",     "",   "",    false, false },
  { "Dubli",                                                      "dub",     "",   "",    false, false },
  { "Dubu",                                                       "dmu",     "",   "",    false, false },
  { "Dugun",                                                      "ndu",     "",   "",    false, false },
  { "Duguri",                                                     "dbm",     "",   "",    false, false },
  { "Dugwor",                                                     "dme",     "",   "",    false, false },
  { "Duhwa",                                                      "kbz",     "",   "",    false, false },
  { "Duke",                                                       "nke",     "",   "",    false, false },
  { "Dulbu",                                                      "dbo",     "",   "",    false, false },
  { "Duli-Gey",                                                   "duz",     "",   "",    false, false },
  { "Duma",                                                       "dma",     "",   "",    false, false },
  { "Dumbea",                                                     "duf",     "",   "",    false, false },
  { "Dumi",                                                       "dus",     "",   "",    false, false },
  { "Dumpas",                                                     "dmv",     "",   "",    false, false },
  { "Dumun",                                                      "dui",     "",   "",    false, false },
  { "Duna",                                                       "duc",     "",   "",    false, false },
  { "Dungan",                                                     "dng",     "",   "",    false, false },
  { "Dungmali",                                                   "raa",     "",   "",    false, false },
  { "Dungra Bhil",                                                "duh",     "",   "",    false, false },
  { "Dungu",                                                      "dbv",     "",   "",    false, false },
  { "Dupaninan Agta",                                             "duo",     "",   "",    false, false },
  { "Dura",                                                       "drq",     "",   "",    false, false },
  { "Durango Nahuatl",                                            "nln",     "",   "",    false, true  },
  { "Duri",                                                       "mvp",     "",   "",    false, false },
  { "Duriankere",                                                 "dbn",     "",   "",    false, false },
  { "Durop",                                                      "krp",     "",   "",    false, false },
  { "Duruma",                                                     "dug",     "",   "",    false, false },
  { "Duruwa",                                                     "pci",     "",   "",    false, false },
  { "Dusner",                                                     "dsn",     "",   "",    false, false },
  { "Dusun Deyah",                                                "dun",     "",   "",    false, false },
  { "Dusun Malang",                                               "duq",     "",   "",    false, false },
  { "Dusun Witu",                                                 "duw",     "",   "",    false, false },
  { "Dutch Sign Language",                                        "dse",     "",   "",    false, false },
  { "Dutch",                                                      "dut",     "nl", "nld", true,  false },
  { "Dutton World Speedwords",                                    "dws",     "",   "",    false, false },
  { "Duungooma",                                                  "dux",     "",   "",    false, false },
  { "Duupa",                                                      "dae",     "",   "",    false, false },
  { "Duvle",                                                      "duv",     "",   "",    false, false },
  { "Duwai",                                                      "dbp",     "",   "",    false, false },
  { "Duwet",                                                      "gve",     "",   "",    false, false },
  { "Dũya",                                                      "ldb",     "",   "",    false, false },
  { "Dwang",                                                      "nnu",     "",   "",    false, false },
  { "Dyaberdyaber",                                               "dyb",     "",   "",    false, false },
  { "Dyan",                                                       "dya",     "",   "",    false, false },
  { "Dyangadi",                                                   "dyn",     "",   "",    false, false },
  { "Dyarim",                                                     "dyr",     "",   "",    false, false },
  { "Dyirbal",                                                    "dbl",     "",   "",    false, false },
  { "Dyugun",                                                     "dyd",     "",   "",    false, false },
  { "Dyula",                                                      "dyu",     "",   "",    true,  false },
  { "Dza",                                                        "jen",     "",   "",    false, false },
  { "Dzalakha",                                                   "dzl",     "",   "",    false, false },
  { "Dzando",                                                     "dzn",     "",   "",    false, false },
  { "Dzao Min",                                                   "bpn",     "",   "",    false, false },
  { "Dzongkha",                                                   "dzo",     "dz", "",    true,  false },
  { "Dzùùngoo",                                                   "dnn",     "",   "",    false, false },
  { "Dâw",                                                        "kwa",     "",   "",    false, false },
  { "E",                                                          "eee",     "",   "",    false, false },
  { "E'ma Buyang",                                                "yzg",     "",   "",    false, false },
  { "E'ñapa Woromaipu",                                           "pbh",     "",   "",    false, false },
  { "Early Tripuri",                                              "xtr",     "",   "",    false, false },
  { "East Ambae",                                                 "omb",     "",   "",    false, false },
  { "East Berawan",                                               "zbe",     "",   "",    false, false },
  { "East Damar",                                                 "dmr",     "",   "",    false, false },
  { "East Futuna",                                                "fud",     "",   "",    false, false },
  { "East Germanic languages",                                    "gme",     "",   "",    false, false },
  { "East Kewa",                                                  "kjs",     "",   "",    false, false },
  { "East Limba",                                                 "lma",     "",   "",    false, false },
  { "East Makian",                                                "mky",     "",   "",    false, false },
  { "East Masela",                                                "vme",     "",   "",    false, false },
  { "East Nyala",                                                 "nle",     "",   "",    false, false },
  { "East Slavic languages",                                      "zle",     "",   "",    false, false },
  { "East Tarangan",                                              "tre",     "",   "",    false, false },
  { "East Yugur",                                                 "yuy",     "",   "",    false, false },
  { "Eastern Abnaki",                                             "aaq",     "",   "",    false, false },
  { "Eastern Acipa",                                              "acp",     "",   "",    false, false },
  { "Eastern Apurímac Quechua",                                   "qve",     "",   "",    false, false },
  { "Eastern Arrernte",                                           "aer",     "",   "",    false, false },
  { "Eastern Balochi",                                            "bgp",     "",   "",    false, false },
  { "Eastern Bolivian Guaraní",                                   "gui",     "",   "",    false, false },
  { "Eastern Bontok",                                             "ebk",     "",   "",    false, false },
  { "Eastern Bru",                                                "bru",     "",   "",    false, false },
  { "Eastern Canadian Inuktitut",                                 "ike",     "",   "",    false, false },
  { "Eastern Cham",                                               "cjm",     "",   "",    false, false },
  { "Eastern Durango Nahuatl",                                    "azd",     "",   "",    false, false },
  { "Eastern Egyptian Bedawi Arabic",                             "avl",     "",   "",    false, false },
  { "Eastern Frisian",                                            "frs",     "",   "",    true,  false },
  { "Eastern Gorkha Tamang",                                      "tge",     "",   "",    false, false },
  { "Eastern Gurung",                                             "ggn",     "",   "",    false, true  },
  { "Eastern Highland Chatino",                                   "cly",     "",   "",    false, false },
  { "Eastern Highland Otomi",                                     "otm",     "",   "",    false, false },
  { "Eastern Hongshuihe Zhuang",                                  "zeh",     "",   "",    false, false },
  { "Eastern Huasteca Nahuatl",                                   "nhe",     "",   "",    false, false },
  { "Eastern Huishui Hmong",                                      "hme",     "",   "",    false, false },
  { "Eastern Karaboro",                                           "xrb",     "",   "",    false, false },
  { "Eastern Karnic",                                             "ekc",     "",   "",    false, true  },
  { "Eastern Katu",                                               "ktv",     "",   "",    false, false },
  { "Eastern Kayah",                                              "eky",     "",   "",    false, false },
  { "Eastern Keres",                                              "kee",     "",   "",    false, false },
  { "Eastern Khumi Chin",                                         "cek",     "",   "",    false, false },
  { "Eastern Krahn",                                              "kqo",     "",   "",    false, false },
  { "Eastern Lalu",                                               "yit",     "",   "",    false, false },
  { "Eastern Lawa",                                               "lwl",     "",   "",    false, false },
  { "Eastern Magar",                                              "mgp",     "",   "",    false, false },
  { "Eastern Malayo-Polynesian languages",                        "pqe",     "",   "",    false, false },
  { "Eastern Maninkakan",                                         "emk",     "",   "",    false, false },
  { "Eastern Mari",                                               "mhr",     "",   "",    false, false },
  { "Eastern Maroon Creole",                                      "djk",     "",   "",    false, false },
  { "Eastern Meohang",                                            "emg",     "",   "",    false, false },
  { "Eastern Minyag",                                             "emq",     "",   "",    false, false },
  { "Eastern Mnong",                                              "mng",     "",   "",    false, false },
  { "Eastern Muria",                                              "emu",     "",   "",    false, false },
  { "Eastern Ngad'a",                                             "nea",     "",   "",    false, false },
  { "Eastern Nisu",                                               "nos",     "",   "",    false, false },
  { "Eastern Ojibwa",                                             "ojg",     "",   "",    false, false },
  { "Eastern Oromo",                                              "hae",     "",   "",    false, false },
  { "Eastern Parbate Kham",                                       "kif",     "",   "",    false, false },
  { "Eastern Penan",                                              "pez",     "",   "",    false, false },
  { "Eastern Pomo",                                               "peb",     "",   "",    false, false },
  { "Eastern Qiandong Miao",                                      "hmq",     "",   "",    false, false },
  { "Eastern Subanen",                                            "sfe",     "",   "",    false, false },
  { "Eastern Sudanic languages",                                  "sdv",     "",   "",    false, false },
  { "Eastern Tamang",                                             "taj",     "",   "",    false, false },
  { "Eastern Tawbuid",                                            "bnj",     "",   "",    false, false },
  { "Eastern Xiangxi Miao",                                       "muq",     "",   "",    false, false },
  { "Eastern Xwla Gbe",                                           "gbx",     "",   "",    false, false },
  { "Eastern Yiddish",                                            "ydd",     "",   "",    false, false },
  { "Ebira",                                                      "igb",     "",   "",    false, false },
  { "Eblan",                                                      "xeb",     "",   "",    false, false },
  { "Ebrié",                                                      "ebr",     "",   "",    false, false },
  { "Ebughu",                                                     "ebg",     "",   "",    false, false },
  { "Ecuadorian Sign Language",                                   "ecs",     "",   "",    false, false },
  { "Ede Cabe",                                                   "cbj",     "",   "",    false, false },
  { "Ede Ica",                                                    "ica",     "",   "",    false, false },
  { "Ede Idaca",                                                  "idd",     "",   "",    false, false },
  { "Ede Ije",                                                    "ijj",     "",   "",    false, false },
  { "Edera Awyu",                                                 "awy",     "",   "",    false, false },
  { "Edolo",                                                      "etr",     "",   "",    false, false },
  { "Edomite",                                                    "xdm",     "",   "",    false, false },
  { "Edopi",                                                      "dbf",     "",   "",    false, false },
  { "Efai",                                                       "efa",     "",   "",    false, false },
  { "Efe",                                                        "efe",     "",   "",    false, false },
  { "Efik",                                                       "efi",     "",   "",    true,  false },
  { "Efutop",                                                     "ofu",     "",   "",    false, false },
  { "Ega",                                                        "ega",     "",   "",    false, false },
  { "Eggon",                                                      "ego",     "",   "",    false, false },
  { "Egypt Sign Language",                                        "esl",     "",   "",    false, false },
  { "Egyptian (Ancient)",                                         "egy",     "",   "",    true,  false },
  { "Egyptian Arabic",                                            "arz",     "",   "",    false, false },
  { "Egyptian languages",                                         "egx",     "",   "",    false, false },
  { "Ehueun",                                                     "ehu",     "",   "",    false, false },
  { "Eipomek",                                                    "eip",     "",   "",    false, false },
  { "Eitiep",                                                     "eit",     "",   "",    false, false },
  { "Ejagham",                                                    "etu",     "",   "",    false, false },
  { "Ejamat",                                                     "eja",     "",   "",    false, false },
  { "Ekai Chin",                                                  "cey",     "",   "",    false, false },
  { "Ekajuk",                                                     "eka",     "",   "",    true,  false },
  { "Ekari",                                                      "ekg",     "",   "",    false, false },
  { "Eki",                                                        "eki",     "",   "",    false, false },
  { "Ekit",                                                       "eke",     "",   "",    false, false },
  { "Ekpeye",                                                     "ekp",     "",   "",    false, false },
  { "El Alto Zapotec",                                            "zpp",     "",   "",    false, false },
  { "El Hugeirat",                                                "elh",     "",   "",    false, false },
  { "El Molo",                                                    "elo",     "",   "",    false, false },
  { "El Nayar Cora",                                              "crn",     "",   "",    false, false },
  { "Elamite",                                                    "elx",     "",   "",    true,  false },
  { "Eleme",                                                      "elm",     "",   "",    false, false },
  { "Elepi",                                                      "ele",     "",   "",    false, false },
  { "Elfdalian",                                                  "ovd",     "",   "",    false, false },
  { "Elip",                                                       "ekm",     "",   "",    false, false },
  { "Elkei",                                                      "elk",     "",   "",    false, false },
  { "Elotepec Zapotec",                                           "zte",     "",   "",    false, false },
  { "Eloyi",                                                      "afo",     "",   "",    false, false },
  { "Elpaputih",                                                  "elp",     "",   "",    false, true  },
  { "Elseng",                                                     "mrf",     "",   "",    false, false },
  { "Elu",                                                        "elu",     "",   "",    false, false },
  { "Elymian",                                                    "xly",     "",   "",    false, false },
  { "Emae",                                                       "mmw",     "",   "",    false, false },
  { "Emai-Iuleha-Ora",                                            "ema",     "",   "",    false, false },
  { "Eman",                                                       "emn",     "",   "",    false, false },
  { "Embaloh",                                                    "emb",     "",   "",    false, false },
  { "Emberá-Baudó",                                               "bdc",     "",   "",    false, false },
  { "Emberá-Catío",                                               "cto",     "",   "",    false, false },
  { "Emberá-Chamí",                                               "cmi",     "",   "",    false, false },
  { "Emberá-Tadó",                                                "tdc",     "",   "",    false, false },
  { "Embu",                                                       "ebu",     "",   "",    false, false },
  { "Emerillon",                                                  "eme",     "",   "",    false, false },
  { "Emilian",                                                    "egl",     "",   "",    false, false },
  { "Emok",                                                       "emo",     "",   "",    false, true  },
  { "Emplawas",                                                   "emw",     "",   "",    false, false },
  { "Emumu",                                                      "enr",     "",   "",    false, false },
  { "En",                                                         "enc",     "",   "",    false, false },
  { "Enawené-Nawé",                                               "unk",     "",   "",    false, false },
  { "Ende",                                                       "end",     "",   "",    false, false },
  { "Enga",                                                       "enq",     "",   "",    false, false },
  { "Engdewu",                                                    "ngr",     "",   "",    false, false },
  { "Engenni",                                                    "enn",     "",   "",    false, false },
  { "Enggano",                                                    "eno",     "",   "",    false, false },
  { "English",                                                    "eng",     "en", "",    true,  false },
  { "Enlhet",                                                     "enl",     "",   "",    false, false },
  { "Enrekang",                                                   "ptt",     "",   "",    false, false },
  { "Enu",                                                        "enu",     "",   "",    false, false },
  { "Enwan (Akwa Ibom State)",                                    "enw",     "",   "",    false, false },
  { "Enwan (Edo State)",                                          "env",     "",   "",    false, false },
  { "Enxet",                                                      "enx",     "",   "",    false, false },
  { "Enya",                                                       "gey",     "",   "",    false, false },
  { "Epena",                                                      "sja",     "",   "",    false, false },
  { "Epi-Olmec",                                                  "xep",     "",   "",    false, false },
  { "Epie",                                                       "epi",     "",   "",    false, false },
  { "Epigraphic Mayan",                                           "emy",     "",   "",    false, false },
  { "Eravallan",                                                  "era",     "",   "",    false, false },
  { "Erave",                                                      "kjy",     "",   "",    false, false },
  { "Ere",                                                        "twp",     "",   "",    false, false },
  { "Eritai",                                                     "ert",     "",   "",    false, false },
  { "Erokwanas",                                                  "erw",     "",   "",    false, false },
  { "Erre",                                                       "err",     "",   "",    false, false },
  { "Erromintxela",                                               "emx",     "",   "",    false, false },
  { "Ersu",                                                       "ers",     "",   "",    false, false },
  { "Eruwa",                                                      "erh",     "",   "",    false, false },
  { "Erzya",                                                      "myv",     "",   "",    true,  false },
  { "Esan",                                                       "ish",     "",   "",    false, false },
  { "Ese Ejja",                                                   "ese",     "",   "",    false, false },
  { "Ese",                                                        "mcq",     "",   "",    false, false },
  { "Eshtehardi",                                                 "esh",     "",   "",    false, false },
  { "Esimbi",                                                     "ags",     "",   "",    false, false },
  { "Eskayan",                                                    "esy",     "",   "",    false, false },
  { "Eskimo-Aleut languages",                                     "esx",     "",   "",    false, false },
  { "Esperanto",                                                  "epo",     "eo", "",    true,  false },
  { "Esselen",                                                    "esq",     "",   "",    false, false },
  { "Estado de México Otomi",                                     "ots",     "",   "",    false, false },
  { "Estonian Sign Language",                                     "eso",     "",   "",    false, false },
  { "Estonian",                                                   "est",     "et", "",    true,  false },
  { "Esuma",                                                      "esm",     "",   "",    false, false },
  { "Etchemin",                                                   "etc",     "",   "",    false, false },
  { "Etebi",                                                      "etb",     "",   "",    false, false },
  { "Eten",                                                       "etx",     "",   "",    false, false },
  { "Eteocretan",                                                 "ecr",     "",   "",    false, false },
  { "Eteocypriot",                                                "ecy",     "",   "",    false, false },
  { "Ethiopian Sign Language",                                    "eth",     "",   "",    false, false },
  { "Etkywan",                                                    "ich",     "",   "",    false, false },
  { "Eton (Cameroon)",                                            "eto",     "",   "",    false, false },
  { "Eton (Vanuatu)",                                             "etn",     "",   "",    false, false },
  { "Etruscan",                                                   "ett",     "",   "",    false, false },
  { "Etulo",                                                      "utr",     "",   "",    false, false },
  { "Eudeve",                                                     "eud",     "",   "",    false, false },
  { "Evant",                                                      "bzz",     "",   "",    false, false },
  { "Even",                                                       "eve",     "",   "",    false, false },
  { "Evenki",                                                     "evn",     "",   "",    false, false },
  { "Eviya",                                                      "gev",     "",   "",    false, false },
  { "Ewage-Notu",                                                 "nou",     "",   "",    false, false },
  { "Ewe",                                                        "ewe",     "ee", "",    true,  false },
  { "Ewondo",                                                     "ewo",     "",   "",    true,  false },
  { "Extremaduran",                                               "ext",     "",   "",    false, false },
  { "Eyak",                                                       "eya",     "",   "",    false, false },
  { "Ezaa",                                                       "eza",     "",   "",    false, false },
  { "Fa d'Ambu",                                                  "fab",     "",   "",    false, false },
  { "Fagani",                                                     "faf",     "",   "",    false, false },
  { "Faifi",                                                      "fif",     "",   "",    false, false },
  { "Faire Atta",                                                 "azt",     "",   "",    false, false },
  { "Faita",                                                      "faj",     "",   "",    false, false },
  { "Faiwol",                                                     "fai",     "",   "",    false, false },
  { "Fala",                                                       "fax",     "",   "",    false, false },
  { "Falam Chin",                                                 "cfm",     "",   "",    false, false },
  { "Fali",                                                       "fli",     "",   "",    false, false },
  { "Faliscan",                                                   "xfa",     "",   "",    false, false },
  { "Fam",                                                        "fam",     "",   "",    false, false },
  { "Fanagalo",                                                   "fng",     "",   "",    false, false },
  { "Fanamaket",                                                  "bjp",     "",   "",    false, false },
  { "Fanbak",                                                     "fnb",     "",   "",    false, false },
  { "Fang (Cameroon)",                                            "fak",     "",   "",    false, false },
  { "Fang (Equatorial Guinea)",                                   "fan",     "",   "",    true,  false },
  { "Fania",                                                      "fni",     "",   "",    false, false },
  { "Fanti",                                                      "fat",     "",   "",    true,  false },
  { "Far Western Muria",                                          "fmu",     "",   "",    false, false },
  { "Farefare",                                                   "gur",     "",   "",    false, false },
  { "Faroese",                                                    "fao",     "fo", "",    true,  false },
  { "Fas",                                                        "fqs",     "",   "",    false, false },
  { "Fasu",                                                       "faa",     "",   "",    false, false },
  { "Fataleka",                                                   "far",     "",   "",    false, false },
  { "Fataluku",                                                   "ddg",     "",   "",    false, false },
  { "Fayu",                                                       "fau",     "",   "",    false, false },
  { "Fe'fe'",                                                     "fmp",     "",   "",    false, false },
  { "Fembe",                                                      "agl",     "",   "",    false, false },
  { "Fernando Po Creole English",                                 "fpe",     "",   "",    false, false },
  { "Feroge",                                                     "fer",     "",   "",    false, false },
  { "Fiji Hindi",                                                 "hif",     "",   "",    false, false },
  { "Fijian",                                                     "fij",     "fj", "",    true,  false },
  { "Filipino",                                                   "fil",     "",   "",    true,  false },
  { "Filomena Mata-Coahuitlán Totonac",                           "tlp",     "",   "",    false, false },
  { "Finallig",                                                   "bkb",     "",   "",    false, true  },
  { "Finland-Swedish Sign Language",                              "fss",     "",   "",    false, false },
  { "Finnish Sign Language",                                      "fse",     "",   "",    false, false },
  { "Finnish",                                                    "fin",     "fi", "",    true,  false },
  { "Finno-Ugrian languages",                                     "fiu",     "",   "",    true,  false },
  { "Finongan",                                                   "fag",     "",   "",    false, false },
  { "Fipa",                                                       "fip",     "",   "",    false, false },
  { "Firan",                                                      "fir",     "",   "",    false, false },
  { "Fiwaga",                                                     "fiw",     "",   "",    false, false },
  { "Flaaitaal",                                                  "fly",     "",   "",    false, false },
  { "Flinders Island",                                            "fln",     "",   "",    false, false },
  { "Foau",                                                       "flh",     "",   "",    false, false },
  { "Foi",                                                        "foi",     "",   "",    false, false },
  { "Foia Foia",                                                  "ffi",     "",   "",    false, false },
  { "Folopa",                                                     "ppo",     "",   "",    false, false },
  { "Foma",                                                       "fom",     "",   "",    false, false },
  { "Fon",                                                        "fon",     "",   "",    true,  false },
  { "Fongoro",                                                    "fgr",     "",   "",    false, false },
  { "Foodo",                                                      "fod",     "",   "",    false, false },
  { "Forak",                                                      "frq",     "",   "",    false, false },
  { "Fordata",                                                    "frd",     "",   "",    false, false },
  { "Fore",                                                       "for",     "",   "",    false, false },
  { "Forest Enets",                                               "enf",     "",   "",    false, false },
  { "Forest Maninka",                                             "myq",     "",   "",    false, true  },
  { "Formosan languages",                                         "fox",     "",   "",    false, false },
  { "Fortsenal",                                                  "frt",     "",   "",    false, false },
  { "Francisco León Zoque",                                       "zos",     "",   "",    false, false },
  { "Frankish",                                                   "frk",     "",   "",    false, false },
  { "French Sign Language",                                       "fsl",     "",   "",    false, false },
  { "French",                                                     "fre",     "fr", "fra", true,  false },
  { "Friulian",                                                   "fur",     "",   "",    true,  false },
  { "Fulah",                                                      "ful",     "ff", "",    true,  false },
  { "Fuliiru",                                                    "flr",     "",   "",    false, false },
  { "Fulniô",                                                     "fun",     "",   "",    false, false },
  { "Fum",                                                        "fum",     "",   "",    false, false },
  { "Fungwa",                                                     "ula",     "",   "",    false, false },
  { "Fur",                                                        "fvr",     "",   "",    false, false },
  { "Furu",                                                       "fuu",     "",   "",    false, false },
  { "Futuna-Aniwa",                                               "fut",     "",   "",    false, false },
  { "Fuyug",                                                      "fuy",     "",   "",    false, false },
  { "Fwe",                                                        "fwe",     "",   "",    false, false },
  { "Fwâi",                                                       "fwa",     "",   "",    false, false },
  { "Fyam",                                                       "pym",     "",   "",    false, false },
  { "Fyer",                                                       "fie",     "",   "",    false, false },
  { "Ga",                                                         "gaa",     "",   "",    true,  false },
  { "Ga'anda",                                                    "gqa",     "",   "",    false, false },
  { "Ga'dang",                                                    "gdg",     "",   "",    false, false },
  { "Gaa",                                                        "ttb",     "",   "",    false, false },
  { "Gaam",                                                       "tbi",     "",   "",    false, false },
  { "Gabi-Gabi",                                                  "gbw",     "",   "",    false, false },
  { "Gabri",                                                      "gab",     "",   "",    false, false },
  { "Gabrielino-Fernandeño",                                      "xgf",     "",   "",    false, false },
  { "Gabutamon",                                                  "gav",     "",   "",    false, true  },
  { "Gadang",                                                     "gdk",     "",   "",    false, false },
  { "Gaddang",                                                    "gad",     "",   "",    false, false },
  { "Gaddi",                                                      "gbk",     "",   "",    false, false },
  { "Gade Lohar",                                                 "gda",     "",   "",    false, false },
  { "Gade",                                                       "ged",     "",   "",    false, false },
  { "Gadjerawang",                                                "gdh",     "",   "",    false, false },
  { "Gadsup",                                                     "gaj",     "",   "",    false, false },
  { "Gafat",                                                      "gft",     "",   "",    false, false },
  { "Gagadu",                                                     "gbu",     "",   "",    false, false },
  { "Gagauz",                                                     "gag",     "",   "",    false, false },
  { "Gagnoa Bété",                                                "btg",     "",   "",    false, false },
  { "Gagu",                                                       "ggu",     "",   "",    false, false },
  { "Gahri",                                                      "bfu",     "",   "",    false, false },
  { "Gaikundi",                                                   "gbf",     "",   "",    false, false },
  { "Gail",                                                       "gic",     "",   "",    false, false },
  { "Gaina",                                                      "gcn",     "",   "",    false, false },
  { "Gal",                                                        "gap",     "",   "",    false, false },
  { "Galambu",                                                    "glo",     "",   "",    false, false },
  { "Galatian",                                                   "xga",     "",   "",    false, false },
  { "Galela",                                                     "gbi",     "",   "",    false, false },
  { "Galeya",                                                     "gar",     "",   "",    false, false },
  { "Galibi Carib",                                               "car",     "",   "",    true,  false },
  { "Galice",                                                     "gce",     "",   "",    false, false },
  { "Galician",                                                   "glg",     "gl", "",    true,  false },
  { "Galindan",                                                   "xgl",     "",   "",    false, false },
  { "Gallurese Sardinian",                                        "sdn",     "",   "",    false, false },
  { "Galo",                                                       "adl",     "",   "",    false, false },
  { "Galolen",                                                    "gal",     "",   "",    false, false },
  { "Gamale Kham",                                                "kgj",     "",   "",    false, false },
  { "Gambera",                                                    "gma",     "",   "",    false, false },
  { "Gambian Wolof",                                              "wof",     "",   "",    false, false },
  { "Gamilaraay",                                                 "kld",     "",   "",    false, false },
  { "Gamit",                                                      "gbl",     "",   "",    false, false },
  { "Gamkonora",                                                  "gak",     "",   "",    false, false },
  { "Gamo",                                                       "gmv",     "",   "",    false, false },
  { "Gamo-Ningi",                                                 "bte",     "",   "",    false, false },
  { "Gan Chinese",                                                "gan",     "",   "",    false, false },
  { "Gana",                                                       "gnq",     "",   "",    false, false },
  { "Ganang",                                                     "gne",     "",   "",    false, false },
  { "Ganda",                                                      "lug",     "lg", "",    true,  false },
  { "Gane",                                                       "gzn",     "",   "",    false, false },
  { "Ganggalida",                                                 "gcd",     "",   "",    false, false },
  { "Ganglau",                                                    "ggl",     "",   "",    false, false },
  { "Gangte",                                                     "gnb",     "",   "",    false, false },
  { "Gangulu",                                                    "gnl",     "",   "",    false, false },
  { "Gants",                                                      "gao",     "",   "",    false, false },
  { "Ganza",                                                      "gza",     "",   "",    false, false },
  { "Ganzi",                                                      "gnz",     "",   "",    false, false },
  { "Gao",                                                        "gga",     "",   "",    false, false },
  { "Gapapaiwa",                                                  "pwg",     "",   "",    false, false },
  { "Garawa",                                                     "gbc",     "",   "",    false, true  },
  { "Garhwali",                                                   "gbm",     "",   "",    false, false },
  { "Garifuna",                                                   "cab",     "",   "",    false, false },
  { "Garig-Ilgar",                                                "ilg",     "",   "",    false, false },
  { "Garingbal",                                                  "xgi",     "",   "",    false, false },
  { "Garlali",                                                    "gll",     "",   "",    false, false },
  { "Garo",                                                       "grt",     "",   "",    false, false },
  { "Garre",                                                      "gex",     "",   "",    false, false },
  { "Garrwa",                                                     "wrk",     "",   "",    false, false },
  { "Garus",                                                      "gyb",     "",   "",    false, false },
  { "Garza",                                                      "xgr",     "",   "",    false, false },
  { "Gata'",                                                      "gaq",     "",   "",    false, false },
  { "Gavak",                                                      "dmc",     "",   "",    false, false },
  { "Gavar",                                                      "gou",     "",   "",    false, false },
  { "Gavião Do Jiparaná",                                         "gvo",     "",   "",    false, false },
  { "Gawar-Bati",                                                 "gwt",     "",   "",    false, false },
  { "Gawri",                                                      "gwc",     "",   "",    false, false },
  { "Gawwada",                                                    "gwd",     "",   "",    false, false },
  { "Gayil",                                                      "gyl",     "",   "",    false, false },
  { "Gayo",                                                       "gay",     "",   "",    true,  false },
  { "Gazi",                                                       "gzi",     "",   "",    false, false },
  { "Gaɓogbo",                                                    "gie",     "",   "",    false, false },
  { "Gbagyi",                                                     "gbr",     "",   "",    false, false },
  { "Gbanu",                                                      "gbv",     "",   "",    false, false },
  { "Gbanziri",                                                   "gbg",     "",   "",    false, false },
  { "Gbari",                                                      "gby",     "",   "",    false, false },
  { "Gbati-ri",                                                   "gti",     "",   "",    false, true  },
  { "Gbaya (Central African Republic)",                           "gba",     "",   "",    true,  false },
  { "Gbaya (Sudan)",                                              "krs",     "",   "",    false, false },
  { "Gbaya-Bossangoa",                                            "gbp",     "",   "",    false, false },
  { "Gbaya-Bozoum",                                               "gbq",     "",   "",    false, false },
  { "Gbaya-Mbodomo",                                              "gmm",     "",   "",    false, false },
  { "Gbayi",                                                      "gyg",     "",   "",    false, false },
  { "Gbesi Gbe",                                                  "gbs",     "",   "",    false, false },
  { "Gbii",                                                       "ggb",     "",   "",    false, false },
  { "Gbin",                                                       "xgb",     "",   "",    false, false },
  { "Gbiri-Niragu",                                               "grh",     "",   "",    false, false },
  { "Gboloo Grebo",                                               "gec",     "",   "",    false, false },
  { "Ge",                                                         "hmj",     "",   "",    false, false },
  { "Geba Karen",                                                 "kvq",     "",   "",    false, false },
  { "Gebe",                                                       "gei",     "",   "",    false, false },
  { "Gedaged",                                                    "gdd",     "",   "",    false, false },
  { "Gedeo",                                                      "drs",     "",   "",    false, false },
  { "Geez",                                                       "gez",     "",   "",    true,  false },
  { "Geji",                                                       "gji",     "",   "",    false, true  },
  { "Geji",                                                       "gyz",     "",   "",    false, false },
  { "Geko Karen",                                                 "ghk",     "",   "",    false, false },
  { "Gela",                                                       "nlg",     "",   "",    false, false },
  { "Gelao",                                                      "gio",     "",   "",    false, true  },
  { "Geme",                                                       "geq",     "",   "",    false, false },
  { "Gen",                                                        "gej",     "",   "",    false, false },
  { "Gende",                                                      "gaf",     "",   "",    false, false },
  { "Gengle",                                                     "geg",     "",   "",    false, false },
  { "Georgian",                                                   "geo",     "ka", "kat", true,  false },
  { "Gepo",                                                       "ygp",     "",   "",    false, false },
  { "Gera",                                                       "gew",     "",   "",    false, false },
  { "Gerai",                                                      "gef",     "",   "",    false, false },
  { "German Sign Language",                                       "gsg",     "",   "",    false, false },
  { "German",                                                     "ger",     "de", "deu", true,  false },
  { "Germanic languages",                                         "gem",     "",   "",    true,  false },
  { "Geruma",                                                     "gea",     "",   "",    false, false },
  { "Geser-Gorom",                                                "ges",     "",   "",    false, false },
  { "Gey",                                                        "guv",     "",   "",    false, true  },
  { "Ghadamès",                                                   "gha",     "",   "",    false, false },
  { "Ghanaian Pidgin English",                                    "gpe",     "",   "",    false, false },
  { "Ghanaian Sign Language",                                     "gse",     "",   "",    false, false },
  { "Ghandruk Sign Language",                                     "gds",     "",   "",    false, false },
  { "Ghanongga",                                                  "ghn",     "",   "",    false, false },
  { "Ghari",                                                      "gri",     "",   "",    false, false },
  { "Ghayavi",                                                    "bmk",     "",   "",    false, false },
  { "Gheg Albanian",                                              "aln",     "",   "",    false, false },
  { "Ghera",                                                      "ghr",     "",   "",    false, false },
  { "Ghodoberi",                                                  "gdo",     "",   "",    false, false },
  { "Ghomara",                                                    "gho",     "",   "",    false, false },
  { "Ghomálá'",                                                   "bbj",     "",   "",    false, false },
  { "Ghotuo",                                                     "aaa",     "",   "",    false, false },
  { "Ghulfan",                                                    "ghl",     "",   "",    false, false },
  { "Giangan",                                                    "bgi",     "",   "",    false, false },
  { "Gibanawa",                                                   "gib",     "",   "",    false, false },
  { "Gidar",                                                      "gid",     "",   "",    false, false },
  { "Giiwo",                                                      "kks",     "",   "",    false, false },
  { "Gikyode",                                                    "acd",     "",   "",    false, false },
  { "Gilaki",                                                     "glk",     "",   "",    false, false },
  { "Gilbertese",                                                 "gil",     "",   "",    true,  false },
  { "Gilima",                                                     "gix",     "",   "",    false, false },
  { "Gilyak",                                                     "niv",     "",   "",    false, false },
  { "Gimi (Eastern Highlands)",                                   "gim",     "",   "",    false, false },
  { "Gimi (West New Britain)",                                    "gip",     "",   "",    false, false },
  { "Gimme",                                                      "kmp",     "",   "",    false, false },
  { "Gimnime",                                                    "gmn",     "",   "",    false, false },
  { "Ginuman",                                                    "gnm",     "",   "",    false, false },
  { "Ginyanga",                                                   "ayg",     "",   "",    false, false },
  { "Girawa",                                                     "bbr",     "",   "",    false, false },
  { "Girirra",                                                    "gii",     "",   "",    false, false },
  { "Giryama",                                                    "nyf",     "",   "",    false, false },
  { "Githabul",                                                   "gih",     "",   "",    false, false },
  { "Gitonga",                                                    "toh",     "",   "",    false, false },
  { "Gitua",                                                      "ggt",     "",   "",    false, false },
  { "Gitxsan",                                                    "git",     "",   "",    false, false },
  { "Giyug",                                                      "giy",     "",   "",    false, false },
  { "Gizrra",                                                     "tof",     "",   "",    false, false },
  { "Glaro-Twabo",                                                "glr",     "",   "",    false, false },
  { "Glavda",                                                     "glw",     "",   "",    false, false },
  { "Glio-Oubi",                                                  "oub",     "",   "",    false, false },
  { "Gnau",                                                       "gnu",     "",   "",    false, false },
  { "Goan Konkani",                                               "gom",     "",   "",    false, false },
  { "Goaria",                                                     "gig",     "",   "",    false, false },
  { "Gobasi",                                                     "goi",     "",   "",    false, false },
  { "Gobu",                                                       "gox",     "",   "",    false, false },
  { "Godié",                                                      "god",     "",   "",    false, false },
  { "Godwari",                                                    "gdx",     "",   "",    false, false },
  { "Goemai",                                                     "ank",     "",   "",    false, false },
  { "Gofa",                                                       "gof",     "",   "",    false, false },
  { "Gogo",                                                       "gog",     "",   "",    false, false },
  { "Gogodala",                                                   "ggw",     "",   "",    false, false },
  { "Gokana",                                                     "gkn",     "",   "",    false, false },
  { "Gola",                                                       "gol",     "",   "",    false, false },
  { "Golin",                                                      "gvf",     "",   "",    false, false },
  { "Golpa",                                                      "lja",     "",   "",    false, false },
  { "Gondi",                                                      "gon",     "",   "",    true,  false },
  { "Gone Dau",                                                   "goo",     "",   "",    false, false },
  { "Gongduk",                                                    "goe",     "",   "",    false, false },
  { "Gonja",                                                      "gjn",     "",   "",    false, false },
  { "Goo",                                                        "gov",     "",   "",    false, false },
  { "Gooniyandi",                                                 "gni",     "",   "",    false, false },
  { "Gor",                                                        "gqr",     "",   "",    false, false },
  { "Gorakor",                                                    "goc",     "",   "",    false, false },
  { "Gorap",                                                      "goq",     "",   "",    false, false },
  { "Goreng",                                                     "xgg",     "",   "",    false, false },
  { "Gorontalo",                                                  "gor",     "",   "",    true,  false },
  { "Gorovu",                                                     "grq",     "",   "",    false, false },
  { "Gorowa",                                                     "gow",     "",   "",    false, false },
  { "Gothic",                                                     "got",     "",   "",    true,  false },
  { "Goundo",                                                     "goy",     "",   "",    false, false },
  { "Gourmanchéma",                                               "gux",     "",   "",    false, false },
  { "Gowlan",                                                     "goj",     "",   "",    false, false },
  { "Gowli",                                                      "gok",     "",   "",    false, false },
  { "Gowro",                                                      "gwf",     "",   "",    false, false },
  { "Gozarkhani",                                                 "goz",     "",   "",    false, false },
  { "Grangali",                                                   "nli",     "",   "",    false, false },
  { "Grass Koiari",                                               "kbk",     "",   "",    false, false },
  { "Grebo",                                                      "grb",     "",   "",    true,  false },
  { "Greek (ancient, -1453)",                                     "grc",     "",   "",    true,  false },
  { "Greek (modern, 1453-)",                                      "gre",     "el", "ell", true,  false },
  { "Greek Sign Language",                                        "gss",     "",   "",    false, false },
  { "Greek languages",                                            "grk",     "",   "",    false, false },
  { "Green Gelao",                                                "giq",     "",   "",    false, false },
  { "Grenadian Creole English",                                   "gcl",     "",   "",    false, false },
  { "Gresi",                                                      "grs",     "",   "",    false, false },
  { "Groma",                                                      "gro",     "",   "",    false, false },
  { "Gronings",                                                   "gos",     "",   "",    false, false },
  { "Gros Ventre",                                                "ats",     "",   "",    false, false },
  { "Gua",                                                        "gwx",     "",   "",    false, false },
  { "Guadeloupean Creole French",                                 "gcf",     "",   "",    false, false },
  { "Guahibo",                                                    "guh",     "",   "",    false, false },
  { "Guajajára",                                                  "gub",     "",   "",    false, false },
  { "Guajá",                                                      "gvj",     "",   "",    false, false },
  { "Guambiano",                                                  "gum",     "",   "",    false, false },
  { "Guana (Brazil)",                                             "gqn",     "",   "",    false, false },
  { "Guana (Paraguay)",                                           "gva",     "",   "",    false, false },
  { "Guanano",                                                    "gvc",     "",   "",    false, false },
  { "Guanche",                                                    "gnc",     "",   "",    false, false },
  { "Guanyinqiao",                                                "jiq",     "",   "",    false, false },
  { "Guarani",                                                    "grn",     "gn", "",    true,  false },
  { "Guarayu",                                                    "gyr",     "",   "",    false, false },
  { "Guarequena",                                                 "gae",     "",   "",    false, false },
  { "Guatemalan Sign Language",                                   "gsm",     "",   "",    false, false },
  { "Guató",                                                      "gta",     "",   "",    false, false },
  { "Guayabero",                                                  "guo",     "",   "",    false, false },
  { "Gudang",                                                     "xgd",     "",   "",    false, false },
  { "Gudanji",                                                    "nji",     "",   "",    false, false },
  { "Gude",                                                       "gde",     "",   "",    false, false },
  { "Gudu",                                                       "gdu",     "",   "",    false, false },
  { "Guduf-Gava",                                                 "gdf",     "",   "",    false, false },
  { "Guerrero Amuzgo",                                            "amu",     "",   "",    false, false },
  { "Guerrero Nahuatl",                                           "ngu",     "",   "",    false, false },
  { "Guevea De Humboldt Zapotec",                                 "zpg",     "",   "",    false, false },
  { "Gugadj",                                                     "ggd",     "",   "",    false, false },
  { "Gugu Badhun",                                                "gdc",     "",   "",    false, false },
  { "Gugu Warra",                                                 "wrw",     "",   "",    false, false },
  { "Gugubera",                                                   "kkp",     "",   "",    false, false },
  { "Guhu-Samane",                                                "ghs",     "",   "",    false, false },
  { "Guianese Creole French",                                     "gcr",     "",   "",    false, false },
  { "Guibei Zhuang",                                              "zgb",     "",   "",    false, false },
  { "Guiberoua Béte",                                             "bet",     "",   "",    false, false },
  { "Guibian Zhuang",                                             "zgn",     "",   "",    false, false },
  { "Guinea Kpelle",                                              "gkp",     "",   "",    false, false },
  { "Guinea-Bissau Sign Language",                                "lgs",     "",   "",    false, false },
  { "Guinean Sign Language",                                      "gus",     "",   "",    false, false },
  { "Guiqiong",                                                   "gqi",     "",   "",    false, false },
  { "Gujarati",                                                   "guj",     "gu", "",    true,  false },
  { "Gujari",                                                     "gju",     "",   "",    false, false },
  { "Gula (Central African Republic)",                            "kcm",     "",   "",    false, false },
  { "Gula (Chad)",                                                "glu",     "",   "",    false, false },
  { "Gula Iro",                                                   "glj",     "",   "",    false, false },
  { "Gula'alaa",                                                  "gmb",     "",   "",    false, false },
  { "Gulay",                                                      "gvl",     "",   "",    false, false },
  { "Gule",                                                       "gly",     "",   "",    false, false },
  { "Gulf Arabic",                                                "afb",     "",   "",    false, false },
  { "Guliguli",                                                   "gli",     "",   "",    false, true  },
  { "Gumalu",                                                     "gmu",     "",   "",    false, false },
  { "Gumatj",                                                     "gnn",     "",   "",    false, false },
  { "Gumawana",                                                   "gvs",     "",   "",    false, false },
  { "Gumuz",                                                      "guk",     "",   "",    false, false },
  { "Gun",                                                        "guw",     "",   "",    false, false },
  { "Gundi",                                                      "gdi",     "",   "",    false, false },
  { "Gunditjmara",                                                "gjm",     "",   "",    false, false },
  { "Gundungurra",                                                "xrd",     "",   "",    false, false },
  { "Gungabula",                                                  "gyf",     "",   "",    false, false },
  { "Gungu",                                                      "rub",     "",   "",    false, false },
  { "Guntai",                                                     "gnt",     "",   "",    false, false },
  { "Gunwinggu",                                                  "gup",     "",   "",    false, false },
  { "Gunya",                                                      "gyy",     "",   "",    false, false },
  { "Gupa-Abawa",                                                 "gpa",     "",   "",    false, false },
  { "Gupapuyngu",                                                 "guf",     "",   "",    false, false },
  { "Guramalum",                                                  "grz",     "",   "",    false, false },
  { "Gurani",                                                     "hac",     "",   "",    false, false },
  { "Gurdjar",                                                    "gdj",     "",   "",    false, false },
  { "Gureng Gureng",                                              "gnr",     "",   "",    false, false },
  { "Gurgula",                                                    "ggg",     "",   "",    false, false },
  { "Guriaso",                                                    "grx",     "",   "",    false, false },
  { "Gurindji Kriol",                                             "gjr",     "",   "",    false, false },
  { "Gurindji",                                                   "gue",     "",   "",    false, false },
  { "Gurmana",                                                    "gvm",     "",   "",    false, false },
  { "Guro",                                                       "goa",     "",   "",    false, false },
  { "Gurr-goni",                                                  "gge",     "",   "",    false, false },
  { "Gurung",                                                     "gvr",     "",   "",    false, false },
  { "Guruntum-Mbaaru",                                            "grd",     "",   "",    false, false },
  { "Gusii",                                                      "guz",     "",   "",    false, false },
  { "Gusilay",                                                    "gsl",     "",   "",    false, false },
  { "Guugu Yimidhirr",                                            "kky",     "",   "",    false, false },
  { "Guwa",                                                       "xgw",     "",   "",    false, false },
  { "Guwamu",                                                     "gwu",     "",   "",    false, false },
  { "Guya",                                                       "gka",     "",   "",    false, false },
  { "Guyanese Creole English",                                    "gyn",     "",   "",    false, false },
  { "Guyani",                                                     "gvy",     "",   "",    false, false },
  { "Gvoko",                                                      "ngs",     "",   "",    false, false },
  { "Gwa",                                                        "gwb",     "",   "",    false, false },
  { "Gwahatike",                                                  "dah",     "",   "",    false, false },
  { "Gwak",                                                       "jgk",     "",   "",    false, false },
  { "Gwamhi-Wuri",                                                "bga",     "",   "",    false, false },
  { "Gwandara",                                                   "gwn",     "",   "",    false, false },
  { "Gweda",                                                      "grw",     "",   "",    false, false },
  { "Gweno",                                                      "gwe",     "",   "",    false, false },
  { "Gwere",                                                      "gwr",     "",   "",    false, false },
  { "Gwichʼin",                                                   "gwi",     "",   "",    true,  false },
  { "Gyalsumdo",                                                  "gyo",     "",   "",    false, false },
  { "Gyele",                                                      "gyi",     "",   "",    false, false },
  { "Gyem",                                                       "gye",     "",   "",    false, false },
  { "Güilá Zapotec",                                              "ztu",     "",   "",    false, false },
  { "Gāndhārī",                                                   "pgd",     "",   "",    false, false },
  { "Ha",                                                         "haq",     "",   "",    false, false },
  { "Habu",                                                       "hbu",     "",   "",    false, false },
  { "Hadiyya",                                                    "hdy",     "",   "",    false, false },
  { "Hadothi",                                                    "hoj",     "",   "",    false, false },
  { "Hadrami Arabic",                                             "ayh",     "",   "",    false, false },
  { "Hadrami",                                                    "xhd",     "",   "",    false, false },
  { "Hadza",                                                      "hts",     "",   "",    false, false },
  { "Haeke",                                                      "aek",     "",   "",    false, false },
  { "Hahon",                                                      "hah",     "",   "",    false, false },
  { "Haida",                                                      "hai",     "",   "",    true,  false },
  { "Haigwai",                                                    "hgw",     "",   "",    false, false },
  { "Hainanese",                                                  "hnm",     "",   "",    false, false },
  { "Haiphong Sign Language",                                     "haf",     "",   "",    false, false },
  { "Haisla",                                                     "has",     "",   "",    false, false },
  { "Haitian Vodoun Culture Language",                            "hvc",     "",   "",    false, false },
  { "Haitian",                                                    "hat",     "ht", "",    true,  false },
  { "Haiǁom",                                                     "hgm",     "",   "",    false, false },
  { "Haji",                                                       "hji",     "",   "",    false, false },
  { "Hajong",                                                     "haj",     "",   "",    false, false },
  { "Hakha Chin",                                                 "cnh",     "",   "",    false, false },
  { "Hakka Chinese",                                              "hak",     "",   "",    false, false },
  { "Hakö",                                                       "hao",     "",   "",    false, false },
  { "Halang Doan",                                                "hld",     "",   "",    false, false },
  { "Halang",                                                     "hal",     "",   "",    false, false },
  { "Halbi",                                                      "hlb",     "",   "",    false, false },
  { "Halh Mongolian",                                             "khk",     "",   "",    false, false },
  { "Halia",                                                      "hla",     "",   "",    false, false },
  { "Halkomelem",                                                 "hur",     "",   "",    false, false },
  { "Hamap",                                                      "hmu",     "",   "",    false, false },
  { "Hamba",                                                      "hba",     "",   "",    false, false },
  { "Hamer-Banna",                                                "amf",     "",   "",    false, false },
  { "Hamtai",                                                     "hmt",     "",   "",    false, false },
  { "Han",                                                        "haa",     "",   "",    false, false },
  { "Hanga Hundi",                                                "wos",     "",   "",    false, false },
  { "Hanga",                                                      "hag",     "",   "",    false, false },
  { "Hangaza",                                                    "han",     "",   "",    false, false },
  { "Hani",                                                       "hni",     "",   "",    false, false },
  { "Hano",                                                       "lml",     "",   "",    false, false },
  { "Hanoi Sign Language",                                        "hab",     "",   "",    false, false },
  { "Hanunoo",                                                    "hnn",     "",   "",    false, false },
  { "Harami",                                                     "xha",     "",   "",    false, false },
  { "Harari",                                                     "har",     "",   "",    false, false },
  { "Harijan Kinnauri",                                           "kjo",     "",   "",    false, false },
  { "Haroi",                                                      "hro",     "",   "",    false, false },
  { "Harsusi",                                                    "hss",     "",   "",    false, false },
  { "Haruai",                                                     "tmd",     "",   "",    false, false },
  { "Haruku",                                                     "hrk",     "",   "",    false, false },
  { "Haryanvi",                                                   "bgc",     "",   "",    false, false },
  { "Harzani",                                                    "hrz",     "",   "",    false, false },
  { "Hasha",                                                      "ybj",     "",   "",    false, false },
  { "Hassaniyya",                                                 "mey",     "",   "",    false, false },
  { "Hatam",                                                      "had",     "",   "",    false, false },
  { "Hattic",                                                     "xht",     "",   "",    false, false },
  { "Hausa Sign Language",                                        "hsl",     "",   "",    false, false },
  { "Hausa",                                                      "hau",     "ha", "",    true,  false },
  { "Havasupai-Walapai-Yavapai",                                  "yuf",     "",   "",    false, false },
  { "Haveke",                                                     "hvk",     "",   "",    false, false },
  { "Havu",                                                       "hav",     "",   "",    false, false },
  { "Hawai'i Creole English",                                     "hwc",     "",   "",    false, false },
  { "Hawai'i Sign Language (HSL)",                                "hps",     "",   "",    false, false },
  { "Hawaiian",                                                   "haw",     "",   "",    true,  false },
  { "Haya",                                                       "hay",     "",   "",    false, false },
  { "Hazaragi",                                                   "haz",     "",   "",    false, false },
  { "Hdi",                                                        "xed",     "",   "",    false, false },
  { "Hebrew",                                                     "heb",     "he", "",    true,  false },
  { "Hehe",                                                       "heh",     "",   "",    false, false },
  { "Heiban",                                                     "hbn",     "",   "",    false, false },
  { "Heiltsuk",                                                   "hei",     "",   "",    false, false },
  { "Helong",                                                     "heg",     "",   "",    false, false },
  { "Hema",                                                       "nix",     "",   "",    false, false },
  { "Hemba",                                                      "hem",     "",   "",    false, false },
  { "Hember Avu",                                                 "mmi",     "",   "",    false, false },
  { "Herdé",                                                      "hed",     "",   "",    false, false },
  { "Herero",                                                     "her",     "hz", "",    true,  false },
  { "Hermit",                                                     "llf",     "",   "",    false, false },
  { "Hernican",                                                   "xhr",     "",   "",    false, false },
  { "Hewa",                                                       "ham",     "",   "",    false, false },
  { "Heyo",                                                       "auk",     "",   "",    false, false },
  { "Hiberno-Scottish Gaelic",                                    "ghc",     "",   "",    false, false },
  { "Hibito",                                                     "hib",     "",   "",    false, false },
  { "Hidatsa",                                                    "hid",     "",   "",    false, false },
  { "Hieroglyphic Luwian",                                        "hlu",     "",   "",    false, false },
  { "Higaonon",                                                   "mba",     "",   "",    false, false },
  { "Highland Konjo",                                             "kjk",     "",   "",    false, false },
  { "Highland Oaxaca Chontal",                                    "chd",     "",   "",    false, false },
  { "Highland Popoluca",                                          "poi",     "",   "",    false, false },
  { "Highland Puebla Nahuatl",                                    "azz",     "",   "",    false, false },
  { "Highland Totonac",                                           "tos",     "",   "",    false, false },
  { "Hijazi Arabic",                                              "acw",     "",   "",    false, false },
  { "Hijuk",                                                      "hij",     "",   "",    false, false },
  { "Hiligaynon",                                                 "hil",     "",   "",    true,  false },
  { "Himachali languages; Western Pahari languages",              "him",     "",   "",    true,  false },
  { "Himarimã",                                                   "hir",     "",   "",    false, false },
  { "Hindi",                                                      "hin",     "hi", "",    true,  false },
  { "Hinduri",                                                    "hii",     "",   "",    false, false },
  { "Hinukh",                                                     "gin",     "",   "",    false, false },
  { "Hiri Motu",                                                  "hmo",     "ho", "",    true,  false },
  { "Hittite",                                                    "hit",     "",   "",    true,  false },
  { "Hitu",                                                       "htu",     "",   "",    false, false },
  { "Hiw",                                                        "hiw",     "",   "",    false, false },
  { "Hixkaryána",                                                 "hix",     "",   "",    false, false },
  { "Hlai",                                                       "lic",     "",   "",    false, false },
  { "Hlepho Phowa",                                               "yhl",     "",   "",    false, false },
  { "Hlersu",                                                     "hle",     "",   "",    false, false },
  { "Hmar",                                                       "hmr",     "",   "",    false, false },
  { "Hmong Daw",                                                  "mww",     "",   "",    false, false },
  { "Hmong Don",                                                  "hmf",     "",   "",    false, false },
  { "Hmong Dô",                                                   "hmv",     "",   "",    false, false },
  { "Hmong Njua",                                                 "hnj",     "",   "",    false, false },
  { "Hmong Shua",                                                 "hmz",     "",   "",    false, false },
  { "Hmong",                                                      "hmn",     "",   "",    true,  false },
  { "Hmong-Mien languages",                                       "hmx",     "",   "",    false, false },
  { "Hmwaveke",                                                   "mrk",     "",   "",    false, false },
  { "Ho Chi Minh City Sign Language",                             "hos",     "",   "",    false, false },
  { "Ho",                                                         "hoc",     "",   "",    false, false },
  { "Ho-Chunk",                                                   "win",     "",   "",    false, false },
  { "Hoava",                                                      "hoa",     "",   "",    false, false },
  { "Hobyót",                                                     "hoh",     "",   "",    false, false },
  { "Hoia Hoia",                                                  "hhi",     "",   "",    false, false },
  { "Hokan languages",                                            "hok",     "",   "",    false, false },
  { "Holikachuk",                                                 "hoi",     "",   "",    false, false },
  { "Holiya",                                                     "hoy",     "",   "",    false, false },
  { "Holma",                                                      "hod",     "",   "",    false, false },
  { "Holoholo",                                                   "hoo",     "",   "",    false, false },
  { "Holu",                                                       "hol",     "",   "",    false, false },
  { "Homa",                                                       "hom",     "",   "",    false, false },
  { "Honduras Sign Language",                                     "hds",     "",   "",    false, false },
  { "Hong Kong Sign Language",                                    "hks",     "",   "",    false, false },
  { "Honi",                                                       "how",     "",   "",    false, false },
  { "Hopi",                                                       "hop",     "",   "",    false, false },
  { "Horned Miao",                                                "hrm",     "",   "",    false, false },
  { "Horo",                                                       "hor",     "",   "",    false, false },
  { "Horom",                                                      "hoe",     "",   "",    false, false },
  { "Horpa",                                                      "ero",     "",   "",    false, false },
  { "Horuru",                                                     "hrr",     "",   "",    false, true  },
  { "Hote",                                                       "hot",     "",   "",    false, false },
  { "Hoti",                                                       "hti",     "",   "",    false, false },
  { "Hovongan",                                                   "hov",     "",   "",    false, false },
  { "Hoyahoya",                                                   "hhy",     "",   "",    false, false },
  { "Hozo",                                                       "hoz",     "",   "",    false, false },
  { "Hpon",                                                       "hpo",     "",   "",    false, false },
  { "Hrangkhol",                                                  "hra",     "",   "",    false, false },
  { "Hre",                                                        "hre",     "",   "",    false, false },
  { "Hruso",                                                      "hru",     "",   "",    false, false },
  { "Hu",                                                         "huo",     "",   "",    false, false },
  { "Huachipaeri",                                                "hug",     "",   "",    false, false },
  { "Huallaga Huánuco Quechua",                                   "qub",     "",   "",    false, false },
  { "Huamalíes-Dos de Mayo Huánuco Quechua",                      "qvh",     "",   "",    false, false },
  { "Huambisa",                                                   "hub",     "",   "",    false, false },
  { "Huarijio",                                                   "var",     "",   "",    false, false },
  { "Huastec",                                                    "hus",     "",   "",    false, false },
  { "Huaulu",                                                     "hud",     "",   "",    false, false },
  { "Huautla Mazatec",                                            "mau",     "",   "",    false, false },
  { "Huaxcaleca Nahuatl",                                         "nhq",     "",   "",    false, false },
  { "Huaylas Ancash Quechua",                                     "qwh",     "",   "",    false, false },
  { "Huaylla Wanca Quechua",                                      "qvw",     "",   "",    false, false },
  { "Huba",                                                       "hbb",     "",   "",    false, false },
  { "Huehuetla Tepehua",                                          "tee",     "",   "",    false, false },
  { "Huichol",                                                    "hch",     "",   "",    false, false },
  { "Huilliche",                                                  "huh",     "",   "",    false, false },
  { "Huitepec Mixtec",                                            "mxs",     "",   "",    false, false },
  { "Huizhou Chinese",                                            "czh",     "",   "",    false, false },
  { "Hukumina",                                                   "huw",     "",   "",    false, false },
  { "Hula",                                                       "hul",     "",   "",    false, false },
  { "Hulaulá",                                                    "huy",     "",   "",    false, false },
  { "Huli",                                                       "hui",     "",   "",    false, false },
  { "Hulung",                                                     "huk",     "",   "",    false, false },
  { "Humburi Senni Songhay",                                      "hmb",     "",   "",    false, false },
  { "Humene",                                                     "huf",     "",   "",    false, false },
  { "Humla",                                                      "hut",     "",   "",    false, false },
  { "Hun-Saare",                                                  "dud",     "",   "",    false, true  },
  { "Hunde",                                                      "hke",     "",   "",    false, false },
  { "Hung",                                                       "hnu",     "",   "",    false, false },
  { "Hungana",                                                    "hum",     "",   "",    false, false },
  { "Hungarian Sign Language",                                    "hsh",     "",   "",    false, false },
  { "Hungarian",                                                  "hun",     "hu", "",    true,  false },
  { "Hungu",                                                      "hng",     "",   "",    false, false },
  { "Hunjara-Kaina Ke",                                           "hkk",     "",   "",    false, false },
  { "Hunnic",                                                     "xhc",     "",   "",    false, false },
  { "Hunsrik",                                                    "hrx",     "",   "",    false, false },
  { "Hunzib",                                                     "huz",     "",   "",    false, false },
  { "Hupa",                                                       "hup",     "",   "",    true,  false },
  { "Hupdë",                                                      "jup",     "",   "",    false, false },
  { "Hupla",                                                      "hap",     "",   "",    false, false },
  { "Hurrian",                                                    "xhu",     "",   "",    false, false },
  { "Hutterite German",                                           "geh",     "",   "",    false, false },
  { "Hwana",                                                      "hwo",     "",   "",    false, false },
  { "Hya",                                                        "hya",     "",   "",    false, false },
  { "Hyam",                                                       "jab",     "",   "",    false, false },
  { "Hyolmo",                                                     "scp",     "",   "",    false, false },
  { "Hértevin",                                                   "hrt",     "",   "",    false, false },
  { "Hõne",                                                       "juh",     "",   "",    false, false },
  { "I-Wak",                                                      "iwk",     "",   "",    false, false },
  { "Iaai",                                                       "iai",     "",   "",    false, false },
  { "Iamalele",                                                   "yml",     "",   "",    false, false },
  { "Iapama",                                                     "iap",     "",   "",    false, true  },
  { "Iatmul",                                                     "ian",     "",   "",    false, false },
  { "Iau",                                                        "tmu",     "",   "",    false, false },
  { "Ibali Teke",                                                 "tek",     "",   "",    false, false },
  { "Ibaloi",                                                     "ibl",     "",   "",    false, false },
  { "Iban",                                                       "iba",     "",   "",    true,  false },
  { "Ibanag",                                                     "ibg",     "",   "",    false, false },
  { "Ibani",                                                      "iby",     "",   "",    false, false },
  { "Ibatan",                                                     "ivb",     "",   "",    false, false },
  { "Iberian",                                                    "xib",     "",   "",    false, false },
  { "Ibibio",                                                     "ibb",     "",   "",    false, false },
  { "Ibilo",                                                      "ibi",     "",   "",    false, true  },
  { "Ibino",                                                      "ibn",     "",   "",    false, false },
  { "Ibu",                                                        "ibu",     "",   "",    false, false },
  { "Ibuoro",                                                     "ibr",     "",   "",    false, false },
  { "Icelandic Sign Language",                                    "icl",     "",   "",    false, false },
  { "Icelandic",                                                  "ice",     "is", "isl", true,  false },
  { "Iceve-Maci",                                                 "bec",     "",   "",    false, false },
  { "Ida'an",                                                     "dbj",     "",   "",    false, false },
  { "Idakho-Isukha-Tiriki",                                       "ida",     "",   "",    false, false },
  { "Idaté",                                                      "idt",     "",   "",    false, false },
  { "Idere",                                                      "ide",     "",   "",    false, false },
  { "Idesa",                                                      "ids",     "",   "",    false, false },
  { "Idi",                                                        "idi",     "",   "",    false, false },
  { "Ido",                                                        "ido",     "io", "",    true,  false },
  { "Idoma",                                                      "idu",     "",   "",    false, false },
  { "Idon",                                                       "idc",     "",   "",    false, false },
  { "Idu-Mishmi",                                                 "clk",     "",   "",    false, false },
  { "Iduna",                                                      "viv",     "",   "",    false, false },
  { "Ifo",                                                        "iff",     "",   "",    false, false },
  { "Ifè",                                                        "ife",     "",   "",    false, false },
  { "Igala",                                                      "igl",     "",   "",    false, false },
  { "Igana",                                                      "igg",     "",   "",    false, false },
  { "Igbo",                                                       "ibo",     "ig", "",    true,  false },
  { "Igede",                                                      "ige",     "",   "",    false, false },
  { "Ignaciano",                                                  "ign",     "",   "",    false, false },
  { "Igo",                                                        "ahl",     "",   "",    false, false },
  { "Iguta",                                                      "nar",     "",   "",    false, false },
  { "Igwe",                                                       "igw",     "",   "",    false, false },
  { "Iha Based Pidgin",                                           "ihb",     "",   "",    false, false },
  { "Iha",                                                        "ihp",     "",   "",    false, false },
  { "Ihievbe",                                                    "ihi",     "",   "",    false, false },
  { "Ija-Zuba",                                                   "vki",     "",   "",    false, true  },
  { "Ijo languages",                                              "ijo",     "",   "",    true,  false },
  { "Ik",                                                         "ikx",     "",   "",    false, false },
  { "Ika",                                                        "ikk",     "",   "",    false, false },
  { "Ikaranggal",                                                 "ikr",     "",   "",    false, false },
  { "Ikhin-Arokho",                                               "ikh",     "",   "",    false, false },
  { "Ikizu",                                                      "ikz",     "",   "",    false, false },
  { "Iko",                                                        "iki",     "",   "",    false, false },
  { "Ikobi",                                                      "meb",     "",   "",    false, false },
  { "Ikoma-Nata-Isenye",                                          "ntk",     "",   "",    false, false },
  { "Ikpeng",                                                     "txi",     "",   "",    false, false },
  { "Ikpeshi",                                                    "ikp",     "",   "",    false, false },
  { "Ikposo",                                                     "kpo",     "",   "",    false, false },
  { "Iku-Gora-Ankwa",                                             "ikv",     "",   "",    false, false },
  { "Ikulu",                                                      "ikl",     "",   "",    false, false },
  { "Ikwere",                                                     "ikw",     "",   "",    false, false },
  { "Ikwo",                                                       "iqw",     "",   "",    false, false },
  { "Ila",                                                        "ilb",     "",   "",    false, false },
  { "Ile Ape",                                                    "ila",     "",   "",    false, false },
  { "Ili Turki",                                                  "ili",     "",   "",    false, false },
  { "Ili'uun",                                                    "ilu",     "",   "",    false, false },
  { "Ilianen Manobo",                                             "mbi",     "",   "",    false, false },
  { "Illyrian",                                                   "xil",     "",   "",    false, false },
  { "Iloko",                                                      "ilo",     "",   "",    true,  false },
  { "Ilongot",                                                    "ilk",     "",   "",    false, false },
  { "Ilue",                                                       "ilv",     "",   "",    false, false },
  { "Ilwana",                                                     "mlk",     "",   "",    false, false },
  { "Imbabura Highland Quichua",                                  "qvi",     "",   "",    false, false },
  { "Imbongu",                                                    "imo",     "",   "",    false, false },
  { "Imeraguen",                                                  "ime",     "",   "",    false, true  },
  { "Imonda",                                                     "imn",     "",   "",    false, false },
  { "Imotong",                                                    "imt",     "",   "",    false, false },
  { "Imroing",                                                    "imr",     "",   "",    false, false },
  { "Inabaknon",                                                  "abx",     "",   "",    false, false },
  { "Inapang",                                                    "mzu",     "",   "",    false, false },
  { "Inari Sami",                                                 "smn",     "",   "",    true,  false },
  { "Indian Sign Language",                                       "ins",     "",   "",    false, false },
  { "Indic languages",                                            "inc",     "",   "",    true,  false },
  { "Indo-European languages",                                    "ine",     "",   "",    true,  false },
  { "Indo-Iranian languages",                                     "iir",     "",   "",    false, false },
  { "Indo-Portuguese",                                            "idb",     "",   "",    false, false },
  { "Indonesian Bajau",                                           "bdl",     "",   "",    false, false },
  { "Indonesian Sign Language",                                   "inl",     "",   "",    false, false },
  { "Indonesian",                                                 "ind",     "id", "",    true,  false },
  { "Indri",                                                      "idr",     "",   "",    false, false },
  { "Indus Kohistani",                                            "mvy",     "",   "",    false, false },
  { "Indus Valley Language",                                      "xiv",     "",   "",    false, false },
  { "Inebu One",                                                  "oin",     "",   "",    false, false },
  { "Ineseño",                                                    "inz",     "",   "",    false, false },
  { "Inga",                                                       "inb",     "",   "",    false, false },
  { "Ingrian",                                                    "izh",     "",   "",    false, false },
  { "Ingush",                                                     "inh",     "",   "",    true,  false },
  { "Inlaod Itneg",                                               "iti",     "",   "",    false, false },
  { "Innu",                                                       "moe",     "",   "",    false, false },
  { "Inoke-Yate",                                                 "ino",     "",   "",    false, false },
  { "Inonhan",                                                    "loc",     "",   "",    false, false },
  { "Inor",                                                       "ior",     "",   "",    false, false },
  { "Inpui Naga",                                                 "nkf",     "",   "",    false, false },
  { "Interglossa",                                                "igs",     "",   "",    false, false },
  { "Interlingua (International Auxiliary Language Association)", "ina",     "ia", "",    true,  false },
  { "Interlingue",                                                "ile",     "ie", "",    true,  false },
  { "International Sign",                                         "ils",     "",   "",    false, false },
  { "Interslavic",                                                "isv",     "",   "",    false, false },
  { "Intha",                                                      "int",     "",   "",    false, false },
  { "Inuinnaqtun",                                                "ikt",     "",   "",    false, false },
  { "Inuit Sign Language",                                        "iks",     "",   "",    false, false },
  { "Inuktitut",                                                  "iku",     "iu", "",    true,  false },
  { "Inupiaq",                                                    "ipk",     "ik", "",    true,  false },
  { "Iowa-Oto",                                                   "iow",     "",   "",    false, false },
  { "Ipalapa Amuzgo",                                             "azm",     "",   "",    false, false },
  { "Ipiko",                                                      "ipo",     "",   "",    false, false },
  { "Ipili",                                                      "ipi",     "",   "",    false, false },
  { "Ipulo",                                                      "ass",     "",   "",    false, false },
  { "Iquito",                                                     "iqu",     "",   "",    false, false },
  { "Ir",                                                         "irr",     "",   "",    false, false },
  { "Iranian Persian",                                            "pes",     "",   "",    false, false },
  { "Iranian Sign Language",                                      "psc",     "",   "",    false, false },
  { "Iranian languages",                                          "ira",     "",   "",    true,  false },
  { "Iranun (Malaysia)",                                          "ilm",     "",   "",    false, false },
  { "Iranun (Philippines)",                                       "ilp",     "",   "",    false, false },
  { "Iranun",                                                     "ill",     "",   "",    false, true  },
  { "Iraqw",                                                      "irk",     "",   "",    false, false },
  { "Irarutu",                                                    "irh",     "",   "",    false, false },
  { "Iraya",                                                      "iry",     "",   "",    false, false },
  { "Iresim",                                                     "ire",     "",   "",    false, false },
  { "Irish Sign Language",                                        "isg",     "",   "",    false, false },
  { "Irish",                                                      "gle",     "ga", "",    true,  false },
  { "Iroquoian languages",                                        "iro",     "",   "",    true,  false },
  { "Irula",                                                      "iru",     "",   "",    false, false },
  { "Irántxe",                                                    "irn",     "",   "",    false, false },
  { "Isabi",                                                      "isa",     "",   "",    false, false },
  { "Isanzu",                                                     "isn",     "",   "",    false, false },
  { "Isarog Agta",                                                "agk",     "",   "",    false, false },
  { "Isconahua",                                                  "isc",     "",   "",    false, false },
  { "Isebe",                                                      "igo",     "",   "",    false, false },
  { "Isekiri",                                                    "its",     "",   "",    false, false },
  { "Ishkashimi",                                                 "isk",     "",   "",    false, false },
  { "Isinai",                                                     "inn",     "",   "",    false, false },
  { "Isirawa",                                                    "srl",     "",   "",    false, false },
  { "Island Carib",                                               "crb",     "",   "",    false, false },
  { "Islander Creole English",                                    "icr",     "",   "",    false, false },
  { "Isnag",                                                      "isd",     "",   "",    false, false },
  { "Isoko",                                                      "iso",     "",   "",    false, false },
  { "Israeli Sign Language",                                      "isr",     "",   "",    false, false },
  { "Isthmus Mixe",                                               "mir",     "",   "",    false, false },
  { "Isthmus Zapotec",                                            "zai",     "",   "",    false, false },
  { "Isthmus-Cosoleacaque Nahuatl",                               "nhk",     "",   "",    false, false },
  { "Isthmus-Mecayapan Nahuatl",                                  "nhx",     "",   "",    false, false },
  { "Isthmus-Pajapan Nahuatl",                                    "nhp",     "",   "",    false, false },
  { "Istriot",                                                    "ist",     "",   "",    false, false },
  { "Istro Romanian",                                             "ruo",     "",   "",    false, false },
  { "Isu (Fako Division)",                                        "szv",     "",   "",    false, false },
  { "Isu (Menchum Division)",                                     "isu",     "",   "",    false, false },
  { "Italian Sign Language",                                      "ise",     "",   "",    false, false },
  { "Italian",                                                    "ita",     "it", "",    true,  false },
  { "Italic languages",                                           "itc",     "",   "",    false, false },
  { "Itawit",                                                     "itv",     "",   "",    false, false },
  { "Itelmen",                                                    "itl",     "",   "",    false, false },
  { "Itene",                                                      "ite",     "",   "",    false, false },
  { "Iteri",                                                      "itr",     "",   "",    false, false },
  { "Itik",                                                       "itx",     "",   "",    false, false },
  { "Ito",                                                        "itw",     "",   "",    false, false },
  { "Itonama",                                                    "ito",     "",   "",    false, false },
  { "Itu Mbon Uzo",                                               "itm",     "",   "",    false, false },
  { "Itundujia Mixtec",                                           "mce",     "",   "",    false, false },
  { "Itzá",                                                       "itz",     "",   "",    false, false },
  { "Iu Mien",                                                    "ium",     "",   "",    false, false },
  { "Ivatan",                                                     "ivv",     "",   "",    false, false },
  { "Ivbie North-Okpela-Arhe",                                    "atg",     "",   "",    false, false },
  { "Iwaidja",                                                    "ibd",     "",   "",    false, false },
  { "Iwal",                                                       "kbm",     "",   "",    false, false },
  { "Iwam",                                                       "iwm",     "",   "",    false, false },
  { "Iwur",                                                       "iwo",     "",   "",    false, false },
  { "Ixcatec",                                                    "ixc",     "",   "",    false, false },
  { "Ixcatlán Mazatec",                                           "mzi",     "",   "",    false, false },
  { "Ixil",                                                       "ixl",     "",   "",    false, false },
  { "Ixtayutla Mixtec",                                           "vmj",     "",   "",    false, false },
  { "Ixtenco Otomi",                                              "otz",     "",   "",    false, false },
  { "Iyayu",                                                      "iya",     "",   "",    false, false },
  { "Iyive",                                                      "uiv",     "",   "",    false, false },
  { "Iyo",                                                        "nca",     "",   "",    false, false },
  { "Iyo'wujwa Chorote",                                          "crq",     "",   "",    false, false },
  { "Iyojwa'ja Chorote",                                          "crt",     "",   "",    false, false },
  { "Izere",                                                      "izr",     "",   "",    false, false },
  { "Izi-Ezaa-Ikwo-Mgbo",                                         "izi",     "",   "",    false, true  },
  { "Izii",                                                       "izz",     "",   "",    false, false },
  { "Izon",                                                       "ijc",     "",   "",    false, false },
  { "Izora",                                                      "cbo",     "",   "",    false, false },
  { "Iñapari",                                                    "inp",     "",   "",    false, false },
  { "Jabutí",                                                     "jbt",     "",   "",    false, false },
  { "Jad",                                                        "jda",     "",   "",    false, false },
  { "Jadgali",                                                    "jdg",     "",   "",    false, false },
  { "Jah Hut",                                                    "jah",     "",   "",    false, false },
  { "Jahanka",                                                    "jad",     "",   "",    false, false },
  { "Jair Awyu",                                                  "awv",     "",   "",    false, false },
  { "Jaitmatang",                                                 "xjt",     "",   "",    false, false },
  { "Jakati",                                                     "jat",     "",   "",    false, false },
  { "Jakattoe",                                                   "jrt",     "",   "",    false, false },
  { "Jakun",                                                      "jak",     "",   "",    false, false },
  { "Jalapa De Díaz Mazatec",                                     "maj",     "",   "",    false, false },
  { "Jalkunan",                                                   "bxl",     "",   "",    false, false },
  { "Jamaican Country Sign Language",                             "jcs",     "",   "",    false, false },
  { "Jamaican Creole English",                                    "jam",     "",   "",    false, false },
  { "Jamaican Sign Language",                                     "jls",     "",   "",    false, false },
  { "Jamamadí",                                                   "jaa",     "",   "",    false, false },
  { "Jambi Malay",                                                "jax",     "",   "",    false, false },
  { "Jamiltepec Mixtec",                                          "mxt",     "",   "",    false, false },
  { "Jamsay Dogon",                                               "djm",     "",   "",    false, false },
  { "Jandai",                                                     "jan",     "",   "",    false, false },
  { "Jandavra",                                                   "jnd",     "",   "",    false, false },
  { "Jangkang",                                                   "djo",     "",   "",    false, false },
  { "Jangshung",                                                  "jna",     "",   "",    false, false },
  { "Janji",                                                      "jni",     "",   "",    false, false },
  { "Japanese (family)",                                          "jpx",     "",   "",    false, false },
  { "Japanese Sign Language",                                     "jsl",     "",   "",    false, false },
  { "Japanese",                                                   "jpn",     "ja", "",    true,  false },
  { "Japrería",                                                   "jru",     "",   "",    false, false },
  { "Jaqaru",                                                     "jqr",     "",   "",    false, false },
  { "Jara",                                                       "jaf",     "",   "",    false, false },
  { "Jarai",                                                      "jra",     "",   "",    false, false },
  { "Jarawa (India)",                                             "anq",     "",   "",    false, false },
  { "Jarawa (Nigeria)",                                           "jar",     "",   "",    false, true  },
  { "Jaru",                                                       "ddj",     "",   "",    false, false },
  { "Jauja Wanca Quechua",                                        "qxw",     "",   "",    false, false },
  { "Jaunsari",                                                   "jns",     "",   "",    false, false },
  { "Javanese",                                                   "jav",     "jv", "",    true,  false },
  { "Javindo",                                                    "jvd",     "",   "",    false, false },
  { "Jawe",                                                       "jaz",     "",   "",    false, false },
  { "Jawoyn",                                                     "djn",     "",   "",    false, false },
  { "Jaya",                                                       "jyy",     "",   "",    false, false },
  { "Jebero",                                                     "jeb",     "",   "",    false, false },
  { "Jeh",                                                        "jeh",     "",   "",    false, false },
  { "Jehai",                                                      "jhi",     "",   "",    false, false },
  { "Jejara Naga",                                                "pzn",     "",   "",    false, false },
  { "Jejueo",                                                     "jje",     "",   "",    false, false },
  { "Jemez",                                                      "tow",     "",   "",    false, false },
  { "Jenaama Bozo",                                               "bze",     "",   "",    false, false },
  { "Jeng",                                                       "jeg",     "",   "",    false, true  },
  { "Jennu Kurumba",                                              "xuj",     "",   "",    false, false },
  { "Jere",                                                       "jer",     "",   "",    false, false },
  { "Jeri Kuo",                                                   "jek",     "",   "",    false, false },
  { "Jerung",                                                     "jee",     "",   "",    false, false },
  { "Jewish Babylonian Aramaic (ca. 200-1200 CE)",                "tmr",     "",   "",    false, false },
  { "Jewish Palestinian Aramaic",                                 "jpa",     "",   "",    false, false },
  { "Jhankot Sign Language",                                      "jhs",     "",   "",    false, false },
  { "Jiamao",                                                     "jio",     "",   "",    false, false },
  { "Jiarong",                                                    "jya",     "",   "",    false, false },
  { "Jiba",                                                       "juo",     "",   "",    false, false },
  { "Jibu",                                                       "jib",     "",   "",    false, false },
  { "Jicarilla Apache",                                           "apj",     "",   "",    false, false },
  { "Jiiddu",                                                     "jii",     "",   "",    false, false },
  { "Jilbe",                                                      "jie",     "",   "",    false, false },
  { "Jilim",                                                      "jil",     "",   "",    false, false },
  { "Jimi (Cameroon)",                                            "jim",     "",   "",    false, false },
  { "Jimi (Nigeria)",                                             "jmi",     "",   "",    false, false },
  { "Jina",                                                       "jia",     "",   "",    false, false },
  { "Jingulu",                                                    "jig",     "",   "",    false, false },
  { "Jinyu Chinese",                                              "cjy",     "",   "",    false, false },
  { "Jiongnai Bunu",                                              "pnu",     "",   "",    false, false },
  { "Jirel",                                                      "jul",     "",   "",    false, false },
  { "Jiru",                                                       "jrr",     "",   "",    false, false },
  { "Jita",                                                       "jit",     "",   "",    false, false },
  { "Jju",                                                        "kaj",     "",   "",    false, false },
  { "Joba",                                                       "job",     "",   "",    false, false },
  { "Jofotek-Bromnya",                                            "jbr",     "",   "",    false, false },
  { "Jogi",                                                       "jog",     "",   "",    false, false },
  { "Jola-Fonyi",                                                 "dyo",     "",   "",    false, false },
  { "Jola-Kasa",                                                  "csk",     "",   "",    false, false },
  { "Jonkor Bourmataguil",                                        "jeu",     "",   "",    false, false },
  { "Jordanian Sign Language",                                    "jos",     "",   "",    false, false },
  { "Jorá",                                                       "jor",     "",   "",    false, false },
  { "Jowulu",                                                     "jow",     "",   "",    false, false },
  { "Ju",                                                         "juu",     "",   "",    false, false },
  { "Juang",                                                      "jun",     "",   "",    false, false },
  { "Judeo-Arabic",                                               "jrb",     "",   "",    true,  false },
  { "Judeo-Berber",                                               "jbe",     "",   "",    false, false },
  { "Judeo-Georgian",                                             "jge",     "",   "",    false, false },
  { "Judeo-Iraqi Arabic",                                         "yhd",     "",   "",    false, false },
  { "Judeo-Italian",                                              "itk",     "",   "",    false, false },
  { "Judeo-Moroccan Arabic",                                      "aju",     "",   "",    false, false },
  { "Judeo-Persian",                                              "jpr",     "",   "",    true,  false },
  { "Judeo-Tat",                                                  "jdt",     "",   "",    false, false },
  { "Judeo-Tripolitanian Arabic",                                 "yud",     "",   "",    false, false },
  { "Judeo-Tunisian Arabic",                                      "ajt",     "",   "",    false, true  },
  { "Judeo-Yemeni Arabic",                                        "jye",     "",   "",    false, false },
  { "Jukun Takum",                                                "jbu",     "",   "",    false, false },
  { "Jumjum",                                                     "jum",     "",   "",    false, false },
  { "Jumla Sign Language",                                        "jus",     "",   "",    false, false },
  { "Jumli",                                                      "jml",     "",   "",    false, false },
  { "Jungle Inga",                                                "inj",     "",   "",    false, false },
  { "Juquila Mixe",                                               "mxq",     "",   "",    false, false },
  { "Jur Modo",                                                   "bex",     "",   "",    false, false },
  { "Juray",                                                      "juy",     "",   "",    false, false },
  { "Jurchen",                                                    "juc",     "",   "",    false, false },
  { "Jurúna",                                                     "jur",     "",   "",    false, false },
  { "Jutish",                                                     "jut",     "",   "",    false, false },
  { "Juwal",                                                      "mwb",     "",   "",    false, false },
  { "Juxtlahuaca Mixtec",                                         "vmc",     "",   "",    false, false },
  { "Juǀʼhoan",                                                   "ktz",     "",   "",    false, false },
  { "Jwira-Pepesa",                                               "jwi",     "",   "",    false, false },
  { "Jèrriais",                                                   "nrf",     "",   "",    false, false },
  { "Júma",                                                       "jua",     "",   "",    false, false },
  { "K'iche'",                                                    "quc",     "",   "",    false, false },
  { "Kaamba",                                                     "xku",     "",   "",    false, false },
  { "Kaan",                                                       "ldl",     "",   "",    false, false },
  { "Kaang Chin",                                                 "ckn",     "",   "",    false, false },
  { "Kaansa",                                                     "gna",     "",   "",    false, false },
  { "Kaba",                                                       "ksp",     "",   "",    false, false },
  { "Kabalai",                                                    "kvf",     "",   "",    false, false },
  { "Kabardian",                                                  "kbd",     "",   "",    true,  false },
  { "Kabatei",                                                    "xkp",     "",   "",    false, false },
  { "Kabixí",                                                     "xbx",     "",   "",    false, true  },
  { "Kabiyè",                                                     "kbp",     "",   "",    false, false },
  { "Kabola",                                                     "klz",     "",   "",    false, false },
  { "Kabore One",                                                 "onk",     "",   "",    false, false },
  { "Kabras",                                                     "lkb",     "",   "",    false, false },
  { "Kaburi",                                                     "uka",     "",   "",    false, false },
  { "Kabutra",                                                    "kbu",     "",   "",    false, false },
  { "Kabuverdianu",                                               "kea",     "",   "",    false, false },
  { "Kabwa",                                                      "cwa",     "",   "",    false, false },
  { "Kabwari",                                                    "kcw",     "",   "",    false, false },
  { "Kabyle",                                                     "kab",     "",   "",    true,  false },
  { "Kachama-Ganjule",                                            "kcx",     "",   "",    false, false },
  { "Kachari",                                                    "xac",     "",   "",    false, false },
  { "Kachhi",                                                     "kfr",     "",   "",    false, false },
  { "Kachi Koli",                                                 "gjk",     "",   "",    false, false },
  { "Kachin",                                                     "kac",     "",   "",    true,  false },
  { "Kachok",                                                     "xkk",     "",   "",    false, false },
  { "Kacipo-Bale Suri",                                           "koe",     "",   "",    false, false },
  { "Kadai",                                                      "kzd",     "",   "",    false, false },
  { "Kadar",                                                      "kej",     "",   "",    false, false },
  { "Kadaru",                                                     "kdu",     "",   "",    false, false },
  { "Kadazan Dusun",                                              "dtp",     "",   "",    false, false },
  { "Kadiwéu",                                                    "kbc",     "",   "",    false, false },
  { "Kado",                                                       "kdv",     "",   "",    false, true  },
  { "Kadu",                                                       "zkd",     "",   "",    false, false },
  { "Kadung",                                                     "dkg",     "",   "",    false, false },
  { "Kaduo",                                                      "ktp",     "",   "",    false, false },
  { "Kaeku",                                                      "kkq",     "",   "",    false, false },
  { "Kaera",                                                      "jka",     "",   "",    false, false },
  { "Kafa",                                                       "kbr",     "",   "",    false, false },
  { "Kafoa",                                                      "kpu",     "",   "",    false, false },
  { "Kagan Kalagan",                                              "kll",     "",   "",    false, false },
  { "Kagate",                                                     "syw",     "",   "",    false, false },
  { "Kagayanen",                                                  "cgc",     "",   "",    false, false },
  { "Kagoma",                                                     "kdm",     "",   "",    false, false },
  { "Kagoro",                                                     "xkg",     "",   "",    false, false },
  { "Kagulu",                                                     "kki",     "",   "",    false, false },
  { "Kahe",                                                       "hka",     "",   "",    false, false },
  { "Kahua",                                                      "agw",     "",   "",    false, false },
  { "Kaian",                                                      "kct",     "",   "",    false, false },
  { "Kaibobo",                                                    "kzb",     "",   "",    false, false },
  { "Kaidipang",                                                  "kzp",     "",   "",    false, false },
  { "Kaiep",                                                      "kbw",     "",   "",    false, false },
  { "Kaikadi",                                                    "kep",     "",   "",    false, false },
  { "Kaikavian Literary Language",                                "kjv",     "",   "",    false, false },
  { "Kaike",                                                      "kzq",     "",   "",    false, false },
  { "Kaimbulawa",                                                 "zka",     "",   "",    false, false },
  { "Kaimbé",                                                     "xai",     "",   "",    false, false },
  { "Kaingang",                                                   "kgp",     "",   "",    false, false },
  { "Kairak",                                                     "ckr",     "",   "",    false, false },
  { "Kairiru",                                                    "kxa",     "",   "",    false, false },
  { "Kairui-Midiki",                                              "krd",     "",   "",    false, false },
  { "Kais",                                                       "kzm",     "",   "",    false, false },
  { "Kaitag",                                                     "xdq",     "",   "",    false, false },
  { "Kaivi",                                                      "kce",     "",   "",    false, false },
  { "Kaiwá",                                                      "kgk",     "",   "",    false, false },
  { "Kaiy",                                                       "tcq",     "",   "",    false, false },
  { "Kajakse",                                                    "ckq",     "",   "",    false, false },
  { "Kajali",                                                     "xkj",     "",   "",    false, false },
  { "Kajaman",                                                    "kag",     "",   "",    false, false },
  { "Kakabai",                                                    "kqf",     "",   "",    false, false },
  { "Kakabe",                                                     "kke",     "",   "",    false, false },
  { "Kakanda",                                                    "kka",     "",   "",    false, false },
  { "Kakauhua",                                                   "kbf",     "",   "",    false, true  },
  { "Kaki Ae",                                                    "tbd",     "",   "",    false, false },
  { "Kakihum",                                                    "kxe",     "",   "",    false, true  },
  { "Kako",                                                       "kkj",     "",   "",    false, false },
  { "Kakwa",                                                      "keo",     "",   "",    false, false },
  { "Kala Lagaw Ya",                                              "mwp",     "",   "",    false, false },
  { "Kalaallisut",                                                "kal",     "kl", "",    true,  false },
  { "Kalaamaya",                                                  "lkm",     "",   "",    false, false },
  { "Kalabakan",                                                  "kve",     "",   "",    false, false },
  { "Kalabari",                                                   "ijn",     "",   "",    false, false },
  { "Kalabra",                                                    "kzz",     "",   "",    false, false },
  { "Kalagan",                                                    "kqe",     "",   "",    false, false },
  { "Kalaktang Monpa",                                            "kkf",     "",   "",    false, false },
  { "Kalam",                                                      "kmh",     "",   "",    false, false },
  { "Kalamsé",                                                    "knz",     "",   "",    false, false },
  { "Kalanadi",                                                   "wkl",     "",   "",    false, false },
  { "Kalanga",                                                    "kck",     "",   "",    false, false },
  { "Kalanguya",                                                  "kak",     "",   "",    false, false },
  { "Kalao",                                                      "kly",     "",   "",    false, false },
  { "Kalapuya",                                                   "kyl",     "",   "",    false, false },
  { "Kalarko",                                                    "kba",     "",   "",    false, false },
  { "Kalasha",                                                    "kls",     "",   "",    false, false },
  { "Kalenjin",                                                   "kln",     "",   "",    false, false },
  { "Kalispel-Pend d'Oreille",                                    "fla",     "",   "",    false, false },
  { "Kalkoti",                                                    "xka",     "",   "",    false, false },
  { "Kalkutung",                                                  "ktg",     "",   "",    false, false },
  { "Kalmyk",                                                     "xal",     "",   "",    true,  false },
  { "Kalo Finnish Romani",                                        "rmf",     "",   "",    false, false },
  { "Kalou",                                                      "ywa",     "",   "",    false, false },
  { "Kaluli",                                                     "bco",     "",   "",    false, false },
  { "Kalumpang",                                                  "kli",     "",   "",    false, false },
  { "Kam",                                                        "kdx",     "",   "",    false, false },
  { "Kamakan",                                                    "vkm",     "",   "",    false, false },
  { "Kamang",                                                     "woi",     "",   "",    false, false },
  { "Kamano",                                                     "kbq",     "",   "",    false, false },
  { "Kamar",                                                      "keq",     "",   "",    false, false },
  { "Kamara",                                                     "jmr",     "",   "",    false, false },
  { "Kamarian",                                                   "kzx",     "",   "",    false, false },
  { "Kamaru",                                                     "kgx",     "",   "",    false, false },
  { "Kamas",                                                      "xas",     "",   "",    false, false },
  { "Kamasa",                                                     "klp",     "",   "",    false, false },
  { "Kamasau",                                                    "kms",     "",   "",    false, false },
  { "Kamayo",                                                     "kyk",     "",   "",    false, false },
  { "Kamayurá",                                                   "kay",     "",   "",    false, false },
  { "Kamba (Brazil)",                                             "xba",     "",   "",    false, true  },
  { "Kamba (Kenya)",                                              "kam",     "",   "",    true,  false },
  { "Kambaata",                                                   "ktb",     "",   "",    false, false },
  { "Kambaira",                                                   "kyy",     "",   "",    false, false },
  { "Kambera",                                                    "xbr",     "",   "",    false, false },
  { "Kamberau",                                                   "irx",     "",   "",    false, false },
  { "Kambiwá",                                                    "xbw",     "",   "",    false, false },
  { "Kami (Nigeria)",                                             "kmi",     "",   "",    false, false },
  { "Kami (Tanzania)",                                            "kcu",     "",   "",    false, false },
  { "Kamo",                                                       "kcq",     "",   "",    false, false },
  { "Kamoro",                                                     "kgq",     "",   "",    false, false },
  { "Kamu",                                                       "xmu",     "",   "",    false, false },
  { "Kamula",                                                     "xla",     "",   "",    false, false },
  { "Kamviri",                                                    "xvi",     "",   "",    false, false },
  { "Kamwe",                                                      "hig",     "",   "",    false, false },
  { "Kanakanabu",                                                 "xnb",     "",   "",    false, false },
  { "Kanamarí",                                                   "knm",     "",   "",    false, false },
  { "Kanan",                                                      "zkn",     "",   "",    false, false },
  { "Kanashi",                                                    "xns",     "",   "",    false, false },
  { "Kanasi",                                                     "soq",     "",   "",    false, false },
  { "Kanauji",                                                    "bjj",     "",   "",    false, false },
  { "Kandas",                                                     "kqw",     "",   "",    false, false },
  { "Kandawo",                                                    "gam",     "",   "",    false, false },
  { "Kande",                                                      "kbs",     "",   "",    false, false },
  { "Kanembu",                                                    "kbl",     "",   "",    false, false },
  { "Kang",                                                       "kyp",     "",   "",    false, false },
  { "Kanga",                                                      "kcp",     "",   "",    false, false },
  { "Kangean",                                                    "kkv",     "",   "",    false, false },
  { "Kanggape",                                                   "igm",     "",   "",    false, false },
  { "Kangjia",                                                    "kxs",     "",   "",    false, false },
  { "Kango (Bas-Uélé District)",                                  "kty",     "",   "",    false, false },
  { "Kango (Tshopo District)",                                    "kzy",     "",   "",    false, false },
  { "Kangri",                                                     "xnr",     "",   "",    false, false },
  { "Kaniet",                                                     "ktk",     "",   "",    false, false },
  { "Kanikkaran",                                                 "kev",     "",   "",    false, false },
  { "Kaningdon-Nindem",                                           "kdp",     "",   "",    false, false },
  { "Kaningi",                                                    "kzo",     "",   "",    false, false },
  { "Kaningra",                                                   "knr",     "",   "",    false, false },
  { "Kaninuwa",                                                   "wat",     "",   "",    false, false },
  { "Kanite",                                                     "kmu",     "",   "",    false, false },
  { "Kanjari",                                                    "kft",     "",   "",    false, false },
  { "Kanju",                                                      "kbe",     "",   "",    false, false },
  { "Kankanaey",                                                  "kne",     "",   "",    false, false },
  { "Kannada Kurumba",                                            "kfi",     "",   "",    false, false },
  { "Kannada",                                                    "kan",     "kn", "",    true,  false },
  { "Kanowit-Tanjong Melanau",                                    "kxn",     "",   "",    false, false },
  { "Kanoé",                                                      "kxo",     "",   "",    false, false },
  { "Kansa",                                                      "ksk",     "",   "",    false, false },
  { "Kantosi",                                                    "xkt",     "",   "",    false, false },
  { "Kanu",                                                       "khx",     "",   "",    false, false },
  { "Kanufi",                                                     "kni",     "",   "",    false, false },
  { "Kanuri",                                                     "kau",     "kr", "",    true,  false },
  { "Kanyok",                                                     "kny",     "",   "",    false, false },
  { "Kao",                                                        "kax",     "",   "",    false, false },
  { "Kaonde",                                                     "kqn",     "",   "",    false, false },
  { "Kap",                                                        "ykm",     "",   "",    false, false },
  { "Kapin",                                                      "tbx",     "",   "",    false, false },
  { "Kapinawá",                                                   "xpn",     "",   "",    false, false },
  { "Kapingamarangi",                                             "kpg",     "",   "",    false, false },
  { "Kapori",                                                     "khp",     "",   "",    false, false },
  { "Kapriman",                                                   "dju",     "",   "",    false, false },
  { "Kaptiau",                                                    "kbi",     "",   "",    false, false },
  { "Kapya",                                                      "klo",     "",   "",    false, false },
  { "Kaqchikel",                                                  "cak",     "",   "",    false, false },
  { "Kara (Central African Republic)",                            "kah",     "",   "",    false, false },
  { "Kara (Korea)",                                               "zra",     "",   "",    false, false },
  { "Kara (Papua New Guinea)",                                    "leu",     "",   "",    false, false },
  { "Kara (Tanzania)",                                            "reg",     "",   "",    false, false },
  { "Kara-Kalpak",                                                "kaa",     "",   "",    true,  false },
  { "Karachay-Balkar",                                            "krc",     "",   "",    true,  false },
  { "Karagas",                                                    "kim",     "",   "",    false, false },
  { "Karahawyana",                                                "xkh",     "",   "",    false, true  },
  { "Karaim",                                                     "kdr",     "",   "",    false, false },
  { "Karajarri",                                                  "gbd",     "",   "",    false, false },
  { "Karajá",                                                     "kpj",     "",   "",    false, false },
  { "Karakhanid",                                                 "xqa",     "",   "",    false, false },
  { "Karami",                                                     "xar",     "",   "",    false, false },
  { "Karamojong",                                                 "kdj",     "",   "",    false, false },
  { "Karang",                                                     "kzr",     "",   "",    false, false },
  { "Karanga",                                                    "kth",     "",   "",    false, false },
  { "Karankawa",                                                  "zkk",     "",   "",    false, false },
  { "Karao",                                                      "kyj",     "",   "",    false, false },
  { "Karas",                                                      "kgv",     "",   "",    false, false },
  { "Karata",                                                     "kpt",     "",   "",    false, false },
  { "Karawa",                                                     "xrw",     "",   "",    false, false },
  { "Karbi",                                                      "mjw",     "",   "",    false, false },
  { "Kare (Central African Republic)",                            "kbn",     "",   "",    false, false },
  { "Kare (Papua New Guinea)",                                    "kmf",     "",   "",    false, false },
  { "Karekare",                                                   "kai",     "",   "",    false, false },
  { "Karelian",                                                   "krl",     "",   "",    true,  false },
  { "Karen languages",                                            "kar",     "",   "",    true,  false },
  { "Karenggapa",                                                 "eaa",     "",   "",    false, false },
  { "Karey",                                                      "kyd",     "",   "",    false, false },
  { "Kari",                                                       "kbj",     "",   "",    false, false },
  { "Karian",                                                     "bql",     "",   "",    false, false },
  { "Karingani",                                                  "kgn",     "",   "",    false, false },
  { "Karipuna",                                                   "kuq",     "",   "",    false, false },
  { "Karipúna Creole French",                                     "kmv",     "",   "",    false, false },
  { "Karipúna",                                                   "kgm",     "",   "",    false, true  },
  { "Karirí-Xocó",                                                "kzw",     "",   "",    false, false },
  { "Karitiâna",                                                  "ktn",     "",   "",    false, false },
  { "Kariya",                                                     "kil",     "",   "",    false, false },
  { "Kariyarra",                                                  "vka",     "",   "",    false, false },
  { "Karkar-Yuri",                                                "yuj",     "",   "",    false, false },
  { "Karkin",                                                     "krb",     "",   "",    false, false },
  { "Karko",                                                      "kko",     "",   "",    false, false },
  { "Karnai",                                                     "bbv",     "",   "",    false, false },
  { "Karo (Brazil)",                                              "arr",     "",   "",    false, false },
  { "Karo (Ethiopia)",                                            "kxh",     "",   "",    false, false },
  { "Karok",                                                      "kyh",     "",   "",    false, false },
  { "Karon Dori",                                                 "kgw",     "",   "",    false, false },
  { "Karon",                                                      "krx",     "",   "",    false, false },
  { "Karore",                                                     "xkx",     "",   "",    false, false },
  { "Karranga",                                                   "xrq",     "",   "",    false, true  },
  { "Karuwali",                                                   "rxw",     "",   "",    false, false },
  { "Kasanga",                                                    "ccj",     "",   "",    false, false },
  { "Kasem",                                                      "xsm",     "",   "",    false, false },
  { "Kashaya",                                                    "kju",     "",   "",    false, false },
  { "Kashmiri",                                                   "kas",     "ks", "",    true,  false },
  { "Kashubian",                                                  "csb",     "",   "",    true,  false },
  { "Kasiguranin",                                                "ksn",     "",   "",    false, false },
  { "Kaska",                                                      "kkz",     "",   "",    false, false },
  { "Kaskean",                                                    "zsk",     "",   "",    false, false },
  { "Kasseng",                                                    "kgc",     "",   "",    false, true  },
  { "Kasua",                                                      "khs",     "",   "",    false, false },
  { "Kataang",                                                    "kgd",     "",   "",    false, true  },
  { "Katabaga",                                                   "ktq",     "",   "",    false, false },
  { "Katawixi",                                                   "xat",     "",   "",    false, false },
  { "Katbol",                                                     "tmb",     "",   "",    false, false },
  { "Katcha-Kadugli-Miri",                                        "xtc",     "",   "",    false, false },
  { "Kathoriya Tharu",                                            "tkt",     "",   "",    false, false },
  { "Kathu",                                                      "ykt",     "",   "",    false, false },
  { "Kati",                                                       "bsh",     "",   "",    false, false },
  { "Katkari",                                                    "kfu",     "",   "",    false, false },
  { "Katla",                                                      "kcr",     "",   "",    false, false },
  { "Kato",                                                       "ktw",     "",   "",    false, false },
  { "Katso",                                                      "kaf",     "",   "",    false, false },
  { "Katua",                                                      "kta",     "",   "",    false, false },
  { "Katukína",                                                   "kav",     "",   "",    false, false },
  { "Kaulong",                                                    "pss",     "",   "",    false, false },
  { "Kaur",                                                       "vkk",     "",   "",    false, false },
  { "Kaure",                                                      "bpp",     "",   "",    false, false },
  { "Kaurna",                                                     "zku",     "",   "",    false, false },
  { "Kauwera",                                                    "xau",     "",   "",    false, false },
  { "Kavalan",                                                    "ckv",     "",   "",    false, false },
  { "Kavet",                                                      "krv",     "",   "",    false, false },
  { "Kawacha",                                                    "kcb",     "",   "",    false, false },
  { "Kawaiisu",                                                   "xaw",     "",   "",    false, false },
  { "Kawe",                                                       "kgb",     "",   "",    false, false },
  { "Kawi",                                                       "kaw",     "",   "",    true,  false },
  { "Kaxararí",                                                   "ktx",     "",   "",    false, false },
  { "Kaxuiâna",                                                   "kbb",     "",   "",    false, false },
  { "Kayabí",                                                     "kyz",     "",   "",    false, false },
  { "Kayagar",                                                    "kyt",     "",   "",    false, false },
  { "Kayan Mahakam",                                              "xay",     "",   "",    false, false },
  { "Kayan River Kayan",                                          "xkn",     "",   "",    false, false },
  { "Kayan",                                                      "pdu",     "",   "",    false, false },
  { "Kayapó",                                                     "txu",     "",   "",    false, false },
  { "Kayardild",                                                  "gyd",     "",   "",    false, false },
  { "Kayaw",                                                      "kvl",     "",   "",    false, false },
  { "Kayeli",                                                     "kzl",     "",   "",    false, false },
  { "Kayong",                                                     "kxy",     "",   "",    false, false },
  { "Kayort",                                                     "kyv",     "",   "",    false, false },
  { "Kaytetye",                                                   "gbb",     "",   "",    false, false },
  { "Kayupulau",                                                  "kzu",     "",   "",    false, false },
  { "Kazakh",                                                     "kaz",     "kk", "",    true,  false },
  { "Kazukuru",                                                   "kzk",     "",   "",    false, false },
  { "Ke'o",                                                       "xxk",     "",   "",    false, false },
  { "Keak",                                                       "keh",     "",   "",    false, false },
  { "Keapara",                                                    "khz",     "",   "",    false, false },
  { "Kedah Malay",                                                "meo",     "",   "",    false, false },
  { "Kedang",                                                     "ksx",     "",   "",    false, false },
  { "Keder",                                                      "kdy",     "",   "",    false, false },
  { "Keerray-Woorroong",                                          "wkr",     "",   "",    false, false },
  { "Kehu",                                                       "khh",     "",   "",    false, false },
  { "Kei",                                                        "kei",     "",   "",    false, false },
  { "Keiga",                                                      "kec",     "",   "",    false, false },
  { "Kein",                                                       "bmh",     "",   "",    false, false },
  { "Keiyo",                                                      "eyo",     "",   "",    false, false },
  { "Kekchí",                                                     "kek",     "",   "",    false, false },
  { "Kela (Democratic Republic of Congo)",                        "kel",     "",   "",    false, false },
  { "Kela (Papua New Guinea)",                                    "kcl",     "",   "",    false, false },
  { "Kelabit",                                                    "kzi",     "",   "",    false, false },
  { "Kele (Democratic Republic of Congo)",                        "khy",     "",   "",    false, false },
  { "Kele (Papua New Guinea)",                                    "sbc",     "",   "",    false, false },
  { "Keley-I Kallahan",                                           "ify",     "",   "",    false, false },
  { "Keliko",                                                     "kbo",     "",   "",    false, false },
  { "Kelo",                                                       "xel",     "",   "",    false, false },
  { "Kelon",                                                      "kyo",     "",   "",    false, false },
  { "Kemak",                                                      "kem",     "",   "",    false, false },
  { "Kembayan",                                                   "xem",     "",   "",    false, false },
  { "Kemberano",                                                  "bzp",     "",   "",    false, false },
  { "Kembra",                                                     "xkw",     "",   "",    false, false },
  { "Kemedzung",                                                  "dmo",     "",   "",    false, false },
  { "Kemi Sami",                                                  "sjk",     "",   "",    false, false },
  { "Kemiehua",                                                   "kfj",     "",   "",    false, false },
  { "Kemtuik",                                                    "kmt",     "",   "",    false, false },
  { "Kenaboi",                                                    "xbn",     "",   "",    false, false },
  { "Kenati",                                                     "gat",     "",   "",    false, false },
  { "Kendayan",                                                   "knx",     "",   "",    false, false },
  { "Kendeje",                                                    "klf",     "",   "",    false, false },
  { "Kendem",                                                     "kvm",     "",   "",    false, false },
  { "Kenga",                                                      "kyq",     "",   "",    false, false },
  { "Keningau Murut",                                             "kxi",     "",   "",    false, false },
  { "Keninjal",                                                   "knl",     "",   "",    false, false },
  { "Kensiu",                                                     "kns",     "",   "",    false, false },
  { "Kenswei Nsei",                                               "ndb",     "",   "",    false, false },
  { "Kenuzi-Dongola",                                             "kzh",     "",   "",    false, true  },
  { "Kenyan Sign Language",                                       "xki",     "",   "",    false, false },
  { "Kenyang",                                                    "ken",     "",   "",    false, false },
  { "Kenyi",                                                      "lke",     "",   "",    false, false },
  { "Kenzi",                                                      "xnz",     "",   "",    false, false },
  { "Keoru-Ahia",                                                 "xeu",     "",   "",    false, false },
  { "Kepkiriwát",                                                 "kpn",     "",   "",    false, false },
  { "Kepo'",                                                      "kuk",     "",   "",    false, false },
  { "Kera",                                                       "ker",     "",   "",    false, false },
  { "Kerak",                                                      "hhr",     "",   "",    false, false },
  { "Kereho",                                                     "xke",     "",   "",    false, false },
  { "Kerek",                                                      "krk",     "",   "",    false, false },
  { "Kerewe",                                                     "ked",     "",   "",    false, false },
  { "Kerewo",                                                     "kxz",     "",   "",    false, false },
  { "Kerinci",                                                    "kvr",     "",   "",    false, false },
  { "Kesawai",                                                    "xes",     "",   "",    false, false },
  { "Ket",                                                        "ket",     "",   "",    false, false },
  { "Ketangalan",                                                 "kae",     "",   "",    false, false },
  { "Kete",                                                       "kcv",     "",   "",    false, false },
  { "Ketengban",                                                  "xte",     "",   "",    false, false },
  { "Ketum",                                                      "ktt",     "",   "",    false, false },
  { "Keyagana",                                                   "kyg",     "",   "",    false, false },
  { "Kgalagadi",                                                  "xkv",     "",   "",    false, false },
  { "Khah",                                                       "hkh",     "",   "",    false, false },
  { "Khakas",                                                     "kjh",     "",   "",    false, false },
  { "Khalaj [Indo-Iranian]",                                      "kjf",     "",   "",    false, true  },
  { "Khalaj",                                                     "klj",     "",   "",    false, false },
  { "Khaling",                                                    "klr",     "",   "",    false, false },
  { "Khamba",                                                     "kbg",     "",   "",    false, false },
  { "Khamnigan Mongol",                                           "ykh",     "",   "",    false, false },
  { "Khams Tibetan",                                              "khg",     "",   "",    false, false },
  { "Khamti",                                                     "kht",     "",   "",    false, false },
  { "Khamyang",                                                   "ksu",     "",   "",    false, false },
  { "Khana",                                                      "ogo",     "",   "",    false, false },
  { "Khandesi",                                                   "khn",     "",   "",    false, false },
  { "Khanty",                                                     "kca",     "",   "",    false, false },
  { "Khao",                                                       "xao",     "",   "",    false, false },
  { "Kharam Naga",                                                "kfw",     "",   "",    false, false },
  { "Kharia Thar",                                                "ksy",     "",   "",    false, false },
  { "Kharia",                                                     "khr",     "",   "",    false, false },
  { "Khasi",                                                      "kha",     "",   "",    true,  false },
  { "Khayo",                                                      "lko",     "",   "",    false, false },
  { "Khazar",                                                     "zkz",     "",   "",    false, false },
  { "Khe",                                                        "kqg",     "",   "",    false, false },
  { "Khehek",                                                     "tlx",     "",   "",    false, false },
  { "Khengkha",                                                   "xkf",     "",   "",    false, false },
  { "Khetrani",                                                   "xhe",     "",   "",    false, false },
  { "Khezha Naga",                                                "nkh",     "",   "",    false, false },
  { "Khiamniungan Naga",                                          "kix",     "",   "",    false, false },
  { "Khinalugh",                                                  "kjj",     "",   "",    false, false },
  { "Khirwar",                                                    "kwx",     "",   "",    false, false },
  { "Khisa",                                                      "kqm",     "",   "",    false, false },
  { "Khlor",                                                      "llo",     "",   "",    false, true  },
  { "Khlula",                                                     "ykl",     "",   "",    false, false },
  { "Khmer",                                                      "khm",     "km", "",    true,  false },
  { "Khmu",                                                       "kjg",     "",   "",    false, false },
  { "Kho'ini",                                                    "xkc",     "",   "",    false, false },
  { "Khoekhoe",                                                   "naq",     "",   "",    false, false },
  { "Khoibu Naga",                                                "nkb",     "",   "",    false, false },
  { "Khoisan languages",                                          "khi",     "",   "",    true,  false },
  { "Kholok",                                                     "ktc",     "",   "",    false, false },
  { "Khorasani Turkish",                                          "kmz",     "",   "",    false, false },
  { "Khorezmian",                                                 "zkh",     "",   "",    false, false },
  { "Khotanese",                                                  "kho",     "",   "",    true,  false },
  { "Khowar",                                                     "khw",     "",   "",    false, false },
  { "Khua",                                                       "xhv",     "",   "",    false, false },
  { "Khuen",                                                      "khf",     "",   "",    false, false },
  { "Khumi Awa Chin",                                             "cka",     "",   "",    false, true  },
  { "Khumi Chin",                                                 "cnk",     "",   "",    false, false },
  { "Khunsari",                                                   "kfm",     "",   "",    false, false },
  { "Khvarshi",                                                   "khv",     "",   "",    false, false },
  { "Kháng",                                                      "kjm",     "",   "",    false, false },
  { "Khün",                                                       "kkh",     "",   "",    false, false },
  { "Kibala",                                                     "blv",     "",   "",    false, false },
  { "Kibet",                                                      "kie",     "",   "",    false, false },
  { "Kibiri",                                                     "prm",     "",   "",    false, false },
  { "Kickapoo",                                                   "kic",     "",   "",    false, false },
  { "Kija",                                                       "gia",     "",   "",    false, false },
  { "Kikai",                                                      "kzg",     "",   "",    false, false },
  { "Kikuyu",                                                     "kik",     "ki", "",    true,  false },
  { "Kildin Sami",                                                "sjd",     "",   "",    false, false },
  { "Kilivila",                                                   "kij",     "",   "",    false, false },
  { "Kiliwa",                                                     "klb",     "",   "",    false, false },
  { "Kilmeri",                                                    "kih",     "",   "",    false, false },
  { "Kim Mun",                                                    "mji",     "",   "",    false, false },
  { "Kim",                                                        "kia",     "",   "",    false, false },
  { "Kimaama",                                                    "kig",     "",   "",    false, false },
  { "Kimaragang",                                                 "kqr",     "",   "",    false, false },
  { "Kimbu",                                                      "kiv",     "",   "",    false, false },
  { "Kimbundu",                                                   "kmb",     "",   "",    true,  false },
  { "Kimki",                                                      "sbt",     "",   "",    false, false },
  { "Kimré",                                                      "kqp",     "",   "",    false, false },
  { "Kinabalian",                                                 "cbw",     "",   "",    false, false },
  { "Kinalakna",                                                  "kco",     "",   "",    false, false },
  { "Kinamiging Manobo",                                          "mkx",     "",   "",    false, false },
  { "Kinaray-A",                                                  "krj",     "",   "",    false, false },
  { "Kinga",                                                      "zga",     "",   "",    false, false },
  { "Kinnauri",                                                   "kfk",     "",   "",    false, false },
  { "Kintaq",                                                     "knq",     "",   "",    false, false },
  { "Kinuku",                                                     "kkd",     "",   "",    false, false },
  { "Kinyarwanda",                                                "kin",     "rw", "",    true,  false },
  { "Kioko",                                                      "ues",     "",   "",    false, false },
  { "Kiong",                                                      "kkm",     "",   "",    false, false },
  { "Kiorr",                                                      "xko",     "",   "",    false, false },
  { "Kiowa Apache",                                               "apk",     "",   "",    false, false },
  { "Kiowa",                                                      "kio",     "",   "",    false, false },
  { "Kipsigis",                                                   "sgc",     "",   "",    false, false },
  { "Kiput",                                                      "kyi",     "",   "",    false, false },
  { "Kir-Balar",                                                  "kkr",     "",   "",    false, false },
  { "Kire",                                                       "geb",     "",   "",    false, false },
  { "Kirghiz",                                                    "kir",     "ky", "",    true,  false },
  { "Kirike",                                                     "okr",     "",   "",    false, false },
  { "Kirikiri",                                                   "kiy",     "",   "",    false, false },
  { "Kirmanjki (individual language)",                            "kiu",     "",   "",    false, false },
  { "Kirya-Konzəl",                                               "fkk",     "",   "",    false, false },
  { "Kis",                                                        "kis",     "",   "",    false, false },
  { "Kisa",                                                       "lks",     "",   "",    false, false },
  { "Kisan",                                                      "xis",     "",   "",    false, false },
  { "Kisankasa",                                                  "kqh",     "",   "",    false, false },
  { "Kisar",                                                      "kje",     "",   "",    false, false },
  { "Kisi",                                                       "kiz",     "",   "",    false, false },
  { "Kistane",                                                    "gru",     "",   "",    false, false },
  { "Kita Maninkakan",                                            "mwk",     "",   "",    false, false },
  { "Kitan",                                                      "zkt",     "",   "",    false, false },
  { "Kitsai",                                                     "kii",     "",   "",    false, false },
  { "Kituba (Congo)",                                             "mkw",     "",   "",    false, false },
  { "Kituba (Democratic Republic of Congo)",                      "ktu",     "",   "",    false, false },
  { "Kiunum",                                                     "wei",     "",   "",    false, false },
  { "Kizamani",                                                   "izm",     "",   "",    false, false },
  { "Kla-Dan",                                                    "lda",     "",   "",    false, false },
  { "Klamath-Modoc",                                              "kla",     "",   "",    false, false },
  { "Klao",                                                       "klu",     "",   "",    false, false },
  { "Klias River Kadazan",                                        "kqt",     "",   "",    false, false },
  { "Klingon",                                                    "tlh",     "",   "",    true,  false },
  { "Knaanic",                                                    "czk",     "",   "",    false, false },
  { "Ko",                                                         "fuj",     "",   "",    false, false },
  { "Koalib",                                                     "kib",     "",   "",    false, false },
  { "Koasati",                                                    "cku",     "",   "",    false, false },
  { "Koba",                                                       "kpd",     "",   "",    false, false },
  { "Kobiana",                                                    "kcj",     "",   "",    false, false },
  { "Kobo",                                                       "okc",     "",   "",    false, false },
  { "Kobol",                                                      "kgu",     "",   "",    false, false },
  { "Kobon",                                                      "kpw",     "",   "",    false, false },
  { "Koch",                                                       "kdq",     "",   "",    false, false },
  { "Kochila Tharu",                                              "thq",     "",   "",    false, false },
  { "Koda",                                                       "cdz",     "",   "",    false, false },
  { "Kodaku",                                                     "ksz",     "",   "",    false, false },
  { "Kodava",                                                     "kfa",     "",   "",    false, false },
  { "Kodeoha",                                                    "vko",     "",   "",    false, false },
  { "Kodi",                                                       "kod",     "",   "",    false, false },
  { "Kodia",                                                      "kwp",     "",   "",    false, false },
  { "Koenoem",                                                    "kcs",     "",   "",    false, false },
  { "Kofa",                                                       "kso",     "",   "",    false, false },
  { "Kofei",                                                      "kpi",     "",   "",    false, false },
  { "Kofyar",                                                     "kwl",     "",   "",    false, false },
  { "Koguryo",                                                    "zkg",     "",   "",    false, false },
  { "Kohin",                                                      "kkx",     "",   "",    false, false },
  { "Kohistani Shina",                                            "plk",     "",   "",    false, false },
  { "Koho",                                                       "kpm",     "",   "",    false, false },
  { "Kohumono",                                                   "bcs",     "",   "",    false, false },
  { "Koi",                                                        "kkt",     "",   "",    false, false },
  { "Koibal",                                                     "zkb",     "",   "",    false, true  },
  { "Koireng",                                                    "nkd",     "",   "",    false, false },
  { "Koitabu",                                                    "kqi",     "",   "",    false, false },
  { "Koiwat",                                                     "kxt",     "",   "",    false, false },
  { "Kok Borok",                                                  "trp",     "",   "",    false, false },
  { "Kok-Nar",                                                    "gko",     "",   "",    false, false },
  { "Kokata",                                                     "ktd",     "",   "",    false, false },
  { "Koke",                                                       "kou",     "",   "",    false, false },
  { "Koki Naga",                                                  "nxk",     "",   "",    false, false },
  { "Koko Babangk",                                               "okg",     "",   "",    false, false },
  { "Kokoda",                                                     "xod",     "",   "",    false, false },
  { "Kokola",                                                     "kzn",     "",   "",    false, false },
  { "Kokota",                                                     "kkk",     "",   "",    false, false },
  { "Kol (Bangladesh)",                                           "ekl",     "",   "",    false, false },
  { "Kol (Cameroon)",                                             "biw",     "",   "",    false, false },
  { "Kol (Papua New Guinea)",                                     "kol",     "",   "",    false, false },
  { "Kola",                                                       "kvv",     "",   "",    false, false },
  { "Kolbila",                                                    "klc",     "",   "",    false, false },
  { "Kolibugan Subanon",                                          "skn",     "",   "",    false, false },
  { "Kolum So Dogon",                                             "dkl",     "",   "",    false, true  },
  { "Koluwawa",                                                   "klx",     "",   "",    false, false },
  { "Kom (Cameroon)",                                             "bkm",     "",   "",    false, false },
  { "Kom (India)",                                                "kmm",     "",   "",    false, false },
  { "Koma",                                                       "kmy",     "",   "",    false, false },
  { "Komba",                                                      "kpf",     "",   "",    false, false },
  { "Kombai",                                                     "tyn",     "",   "",    false, false },
  { "Kombio",                                                     "xbi",     "",   "",    false, false },
  { "Komering",                                                   "kge",     "",   "",    false, false },
  { "Komi",                                                       "kom",     "kv", "",    true,  false },
  { "Komi-Permyak",                                               "koi",     "",   "",    false, false },
  { "Komi-Zyrian",                                                "kpv",     "",   "",    false, false },
  { "Kominimung",                                                 "xoi",     "",   "",    false, false },
  { "Komo (Democratic Republic of Congo)",                        "kmw",     "",   "",    false, false },
  { "Komo (Sudan)",                                               "xom",     "",   "",    false, false },
  { "Komodo",                                                     "kvh",     "",   "",    false, false },
  { "Kompane",                                                    "kvp",     "",   "",    false, false },
  { "Komyandaret",                                                "kzv",     "",   "",    false, false },
  { "Kon Keu",                                                    "kkn",     "",   "",    false, false },
  { "Konai",                                                      "kxw",     "",   "",    false, false },
  { "Konda",                                                      "knd",     "",   "",    false, false },
  { "Konda-Dora",                                                 "kfc",     "",   "",    false, false },
  { "Koneraw",                                                    "kdw",     "",   "",    false, false },
  { "Kongo",                                                      "kon",     "kg", "",    true,  false },
  { "Konkani (individual language)",                              "knn",     "",   "",    false, false },
  { "Konkani (macrolanguage)",                                    "kok",     "",   "",    true,  false },
  { "Konkomba",                                                   "xon",     "",   "",    false, false },
  { "Konni",                                                      "kma",     "",   "",    false, false },
  { "Kono (Guinea)",                                              "knu",     "",   "",    false, false },
  { "Kono (Nigeria)",                                             "klk",     "",   "",    false, false },
  { "Kono (Sierra Leone)",                                        "kno",     "",   "",    false, false },
  { "Konomala",                                                   "koa",     "",   "",    false, false },
  { "Konongo",                                                    "kcz",     "",   "",    false, false },
  { "Konso",                                                      "kxc",     "",   "",    false, false },
  { "Konyak Naga",                                                "nbe",     "",   "",    false, false },
  { "Konyanka Maninka",                                           "mku",     "",   "",    false, false },
  { "Konzo",                                                      "koo",     "",   "",    false, false },
  { "Koongo",                                                     "kng",     "",   "",    false, false },
  { "Koonzime",                                                   "ozm",     "",   "",    false, false },
  { "Koorete",                                                    "kqy",     "",   "",    false, false },
  { "Kopar",                                                      "xop",     "",   "",    false, false },
  { "Kopkaka",                                                    "opk",     "",   "",    false, false },
  { "Korafe-Yegha",                                               "kpr",     "",   "",    false, false },
  { "Korak",                                                      "koz",     "",   "",    false, false },
  { "Korana",                                                     "kqz",     "",   "",    false, false },
  { "Korandje",                                                   "kcy",     "",   "",    false, false },
  { "Kordofanian languages",                                      "kdo",     "",   "",    false, false },
  { "Korean Sign Language",                                       "kvk",     "",   "",    false, false },
  { "Korean",                                                     "kor",     "ko", "",    true,  false },
  { "Koreguaje",                                                  "coe",     "",   "",    false, false },
  { "Koresh-e Rostam",                                            "okh",     "",   "",    false, false },
  { "Korku",                                                      "kfq",     "",   "",    false, false },
  { "Korlai Creole Portuguese",                                   "vkp",     "",   "",    false, false },
  { "Koro (Côte d'Ivoire)",                                       "kfo",     "",   "",    false, false },
  { "Koro (India)",                                               "jkr",     "",   "",    false, false },
  { "Koro (Papua New Guinea)",                                    "kxr",     "",   "",    false, false },
  { "Koro (Vanuatu)",                                             "krf",     "",   "",    false, false },
  { "Koro Nulu",                                                  "vkn",     "",   "",    false, false },
  { "Koro Wachi",                                                 "bqv",     "",   "",    false, false },
  { "Koro Zuba",                                                  "vkz",     "",   "",    false, false },
  { "Koromfé",                                                    "kfz",     "",   "",    false, false },
  { "Koromira",                                                   "kqj",     "",   "",    false, false },
  { "Koronadal Blaan",                                            "bpr",     "",   "",    false, false },
  { "Koroni",                                                     "xkq",     "",   "",    false, false },
  { "Koropó",                                                     "xxr",     "",   "",    false, false },
  { "Koroshi",                                                    "ktl",     "",   "",    false, false },
  { "Korowai",                                                    "khe",     "",   "",    false, false },
  { "Korra Koraga",                                               "kfd",     "",   "",    false, false },
  { "Korubo",                                                     "xor",     "",   "",    false, false },
  { "Korupun-Sela",                                               "kpq",     "",   "",    false, false },
  { "Korwa",                                                      "kfp",     "",   "",    false, false },
  { "Koryak",                                                     "kpy",     "",   "",    false, false },
  { "Kosadle",                                                    "kiq",     "",   "",    false, false },
  { "Kosarek Yale",                                               "kkl",     "",   "",    false, false },
  { "Kosena",                                                     "kze",     "",   "",    false, false },
  { "Koshin",                                                     "kid",     "",   "",    false, false },
  { "Kosraean",                                                   "kos",     "",   "",    true,  false },
  { "Kota (Gabon)",                                               "koq",     "",   "",    false, false },
  { "Kota (India)",                                               "kfe",     "",   "",    false, false },
  { "Kota Bangun Kutai Malay",                                    "mqg",     "",   "",    false, false },
  { "Kota Marudu Talantang",                                      "grm",     "",   "",    false, false },
  { "Kota Marudu Tinagas",                                        "ktr",     "",   "",    false, true  },
  { "Kotafon Gbe",                                                "kqk",     "",   "",    false, false },
  { "Kotava",                                                     "avk",     "",   "",    false, false },
  { "Koti",                                                       "eko",     "",   "",    false, false },
  { "Kott",                                                       "zko",     "",   "",    false, false },
  { "Kou",                                                        "snz",     "",   "",    false, false },
  { "Kouya",                                                      "kyf",     "",   "",    false, false },
  { "Kovai",                                                      "kqb",     "",   "",    false, false },
  { "Kove",                                                       "kvc",     "",   "",    false, false },
  { "Kowaki",                                                     "xow",     "",   "",    false, false },
  { "Kowiai",                                                     "kwh",     "",   "",    false, false },
  { "Koy Sanjaq Surat",                                           "kqd",     "",   "",    false, false },
  { "Koya",                                                       "kff",     "",   "",    false, false },
  { "Koyaga",                                                     "kga",     "",   "",    false, false },
  { "Koyo",                                                       "koh",     "",   "",    false, false },
  { "Koyra Chiini Songhay",                                       "khq",     "",   "",    false, false },
  { "Koyraboro Senni Songhai",                                    "ses",     "",   "",    false, false },
  { "Koyukon",                                                    "koy",     "",   "",    false, false },
  { "Kpagua",                                                     "kuw",     "",   "",    false, false },
  { "Kpala",                                                      "kpl",     "",   "",    false, false },
  { "Kpan",                                                       "kpk",     "",   "",    false, false },
  { "Kpasam",                                                     "pbn",     "",   "",    false, false },
  { "Kpati",                                                      "koc",     "",   "",    false, false },
  { "Kpatili",                                                    "kym",     "",   "",    false, false },
  { "Kpeego",                                                     "cpo",     "",   "",    false, false },
  { "Kpelle",                                                     "kpe",     "",   "",    true,  false },
  { "Kpessi",                                                     "kef",     "",   "",    false, false },
  { "Kplang",                                                     "kph",     "",   "",    false, false },
  { "Krache",                                                     "kye",     "",   "",    false, false },
  { "Krahô",                                                      "xra",     "",   "",    false, false },
  { "Kraol",                                                      "rka",     "",   "",    false, false },
  { "Krenak",                                                     "kqq",     "",   "",    false, false },
  { "Krevinian",                                                  "zkv",     "",   "",    false, false },
  { "Kreye",                                                      "xre",     "",   "",    false, false },
  { "Kriang",                                                     "ngt",     "",   "",    false, false },
  { "Krikati-Timbira",                                            "xri",     "",   "",    false, false },
  { "Krim",                                                       "krm",     "",   "",    false, true  },
  { "Krio",                                                       "kri",     "",   "",    false, false },
  { "Kriol",                                                      "rop",     "",   "",    false, false },
  { "Krisa",                                                      "ksi",     "",   "",    false, false },
  { "Krobu",                                                      "kxb",     "",   "",    false, false },
  { "Krongo",                                                     "kgo",     "",   "",    false, false },
  { "Kru languages",                                              "kro",     "",   "",    true,  false },
  { "Krung",                                                      "krr",     "",   "",    false, false },
  { "Krymchak",                                                   "jct",     "",   "",    false, false },
  { "Kryts",                                                      "kry",     "",   "",    false, false },
  { "Kua",                                                        "tyu",     "",   "",    false, false },
  { "Kua-nsi",                                                    "ykn",     "",   "",    false, false },
  { "Kuamasi",                                                    "yku",     "",   "",    false, false },
  { "Kuan",                                                       "uan",     "",   "",    false, false },
  { "Kuanhua",                                                    "xnh",     "",   "",    false, false },
  { "Kuanua",                                                     "ksd",     "",   "",    false, false },
  { "Kuanyama",                                                   "kua",     "kj", "",    true,  false },
  { "Kubachi",                                                    "ugh",     "",   "",    false, false },
  { "Kube",                                                       "kgf",     "",   "",    false, false },
  { "Kubi",                                                       "kof",     "",   "",    false, false },
  { "Kubo",                                                       "jko",     "",   "",    false, false },
  { "Kubu",                                                       "kvb",     "",   "",    false, false },
  { "Kucong",                                                     "lkc",     "",   "",    false, false },
  { "Kudiya",                                                     "kfg",     "",   "",    false, false },
  { "Kudmali",                                                    "kyw",     "",   "",    false, false },
  { "Kudu-Camo",                                                  "kov",     "",   "",    false, false },
  { "Kufr Qassem Sign Language (KQSL)",                           "sqx",     "",   "",    false, false },
  { "Kugama",                                                     "kow",     "",   "",    false, false },
  { "Kugbo",                                                      "kes",     "",   "",    false, false },
  { "Kugu-Muminh",                                                "xmh",     "",   "",    false, false },
  { "Kui (India)",                                                "kxu",     "",   "",    false, true  },
  { "Kui (India)",                                                "uki",     "",   "",    false, false },
  { "Kui (Indonesia)",                                            "kvd",     "",   "",    false, false },
  { "Kuijau",                                                     "dkr",     "",   "",    false, false },
  { "Kuikúro-Kalapálo",                                           "kui",     "",   "",    false, false },
  { "Kujarge",                                                    "vkj",     "",   "",    false, false },
  { "Kuk",                                                        "kfn",     "",   "",    false, false },
  { "Kukatja",                                                    "kux",     "",   "",    false, false },
  { "Kuke",                                                       "ght",     "",   "",    false, false },
  { "Kukele",                                                     "kez",     "",   "",    false, false },
  { "Kukna",                                                      "kex",     "",   "",    false, false },
  { "Kuku",                                                       "ukv",     "",   "",    false, false },
  { "Kuku-Mangk",                                                 "xmq",     "",   "",    false, false },
  { "Kuku-Mu'inh",                                                "xmp",     "",   "",    false, false },
  { "Kuku-Ugbanh",                                                "ugb",     "",   "",    false, false },
  { "Kuku-Uwanh",                                                 "uwa",     "",   "",    false, false },
  { "Kuku-Yalanji",                                               "gvn",     "",   "",    false, false },
  { "Kula",                                                       "tpg",     "",   "",    false, false },
  { "Kulere",                                                     "kul",     "",   "",    false, false },
  { "Kulfa",                                                      "kxj",     "",   "",    false, false },
  { "Kulina Pano",                                                "xpk",     "",   "",    false, false },
  { "Kulisusu",                                                   "vkl",     "",   "",    false, false },
  { "Kullu Pahari",                                               "kfx",     "",   "",    false, false },
  { "Kulon",                                                      "uon",     "",   "",    false, false },
  { "Kulon-Pazeh",                                                "uun",     "",   "",    false, true  },
  { "Kulung (Nepal)",                                             "kle",     "",   "",    false, false },
  { "Kulung (Nigeria)",                                           "bbu",     "",   "",    false, false },
  { "Kumalu",                                                     "ksl",     "",   "",    false, false },
  { "Kumam",                                                      "kdi",     "",   "",    false, false },
  { "Kuman (Papua New Guinea)",                                   "kue",     "",   "",    false, false },
  { "Kuman (Russia)",                                             "qwm",     "",   "",    false, false },
  { "Kumaoni",                                                    "kfy",     "",   "",    false, false },
  { "Kumarbhag Paharia",                                          "kmj",     "",   "",    false, false },
  { "Kumba",                                                      "ksm",     "",   "",    false, false },
  { "Kumbainggar",                                                "kgs",     "",   "",    false, false },
  { "Kumbaran",                                                   "wkb",     "",   "",    false, false },
  { "Kumbewaha",                                                  "xks",     "",   "",    false, false },
  { "Kumhali",                                                    "kra",     "",   "",    false, false },
  { "Kumiai",                                                     "dih",     "",   "",    false, false },
  { "Kumukio",                                                    "kuo",     "",   "",    false, false },
  { "Kumyk",                                                      "kum",     "",   "",    true,  false },
  { "Kumzari",                                                    "zum",     "",   "",    false, false },
  { "Kunama",                                                     "kun",     "",   "",    false, false },
  { "Kunbarlang",                                                 "wlg",     "",   "",    false, false },
  { "Kunda",                                                      "kdn",     "",   "",    false, false },
  { "Kundal Shahi",                                               "shd",     "",   "",    false, false },
  { "Kunduvadi",                                                  "wku",     "",   "",    false, false },
  { "Kung",                                                       "kfl",     "",   "",    false, false },
  { "Kung-Ekoka",                                                 "knw",     "",   "",    false, false },
  { "Kungarakany",                                                "ggk",     "",   "",    false, false },
  { "Kungardutyi",                                                "gdt",     "",   "",    false, false },
  { "Kunggara",                                                   "kvs",     "",   "",    false, true  },
  { "Kunggari",                                                   "kgl",     "",   "",    false, false },
  { "Kungkari",                                                   "lku",     "",   "",    false, false },
  { "Kuni",                                                       "kse",     "",   "",    false, false },
  { "Kuni-Boazi",                                                 "kvg",     "",   "",    false, false },
  { "Kunigami",                                                   "xug",     "",   "",    false, false },
  { "Kunimaipa",                                                  "kup",     "",   "",    false, false },
  { "Kunja",                                                      "pep",     "",   "",    false, false },
  { "Kunjen",                                                     "kjn",     "",   "",    false, false },
  { "Kunyi",                                                      "njx",     "",   "",    false, false },
  { "Kunza",                                                      "kuz",     "",   "",    false, false },
  { "Kuo",                                                        "xuo",     "",   "",    false, false },
  { "Kuot",                                                       "kto",     "",   "",    false, false },
  { "Kupa",                                                       "kug",     "",   "",    false, false },
  { "Kupang Malay",                                               "mkn",     "",   "",    false, false },
  { "Kupia",                                                      "key",     "",   "",    false, false },
  { "Kupsabiny",                                                  "kpz",     "",   "",    false, false },
  { "Kur",                                                        "kuv",     "",   "",    false, false },
  { "Kura Ede Nago",                                              "nqk",     "",   "",    false, false },
  { "Kurama",                                                     "krh",     "",   "",    false, false },
  { "Kuranko",                                                    "knk",     "",   "",    false, false },
  { "Kurdish",                                                    "kur",     "ku", "",    true,  false },
  { "Kuri",                                                       "nbn",     "",   "",    false, false },
  { "Kuria",                                                      "kuj",     "",   "",    false, false },
  { "Kurichiya",                                                  "kfh",     "",   "",    false, false },
  { "Kurmukar",                                                   "kfv",     "",   "",    false, false },
  { "Kurnai",                                                     "unn",     "",   "",    false, false },
  { "Kurrama",                                                    "vku",     "",   "",    false, false },
  { "Kurti",                                                      "ktm",     "",   "",    false, false },
  { "Kurtokha",                                                   "xkz",     "",   "",    false, false },
  { "Kurudu",                                                     "kjr",     "",   "",    false, false },
  { "Kurukh",                                                     "kru",     "",   "",    true,  false },
  { "Kuruáya",                                                    "kyr",     "",   "",    false, false },
  { "Kusaal",                                                     "kus",     "",   "",    false, false },
  { "Kusaghe",                                                    "ksg",     "",   "",    false, false },
  { "Kushi",                                                      "kuh",     "",   "",    false, false },
  { "Kusu",                                                       "ksv",     "",   "",    false, false },
  { "Kusunda",                                                    "kgg",     "",   "",    false, false },
  { "Kutenai",                                                    "kut",     "",   "",    true,  false },
  { "Kutep",                                                      "kub",     "",   "",    false, false },
  { "Kuthant",                                                    "xut",     "",   "",    false, false },
  { "Kutong",                                                     "skm",     "",   "",    false, false },
  { "Kutto",                                                      "kpa",     "",   "",    false, false },
  { "Kutu",                                                       "kdc",     "",   "",    false, false },
  { "Kuturmi",                                                    "khj",     "",   "",    false, false },
  { "Kuuk Thaayorre",                                             "thd",     "",   "",    false, false },
  { "Kuuk-Yak",                                                   "uky",     "",   "",    false, false },
  { "Kuuku-Ya'u",                                                 "kuy",     "",   "",    false, false },
  { "Kuvale",                                                     "olu",     "",   "",    false, false },
  { "Kuvi",                                                       "kxv",     "",   "",    false, false },
  { "Kuwaa",                                                      "blh",     "",   "",    false, false },
  { "Kuwaataay",                                                  "cwt",     "",   "",    false, false },
  { "Kuwema",                                                     "woa",     "",   "",    false, false },
  { "Kuy",                                                        "kdt",     "",   "",    false, false },
  { "Kven Finnish",                                               "fkv",     "",   "",    false, false },
  { "Kw'adza",                                                    "wka",     "",   "",    false, false },
  { "Kwa",                                                        "kwb",     "",   "",    false, false },
  { "Kwa'",                                                       "bko",     "",   "",    false, false },
  { "Kwaami",                                                     "ksq",     "",   "",    false, false },
  { "Kwadi",                                                      "kwz",     "",   "",    false, false },
  { "Kwaio",                                                      "kwd",     "",   "",    false, false },
  { "Kwaja",                                                      "kdz",     "",   "",    false, false },
  { "Kwak",                                                       "kwq",     "",   "",    false, true  },
  { "Kwakiutl",                                                   "kwk",     "",   "",    false, false },
  { "Kwakum",                                                     "kwu",     "",   "",    false, false },
  { "Kwalhioqua-Tlatskanai",                                      "qwt",     "",   "",    false, false },
  { "Kwama",                                                      "kmq",     "",   "",    false, false },
  { "Kwambi",                                                     "kwm",     "",   "",    false, false },
  { "Kwamera",                                                    "tnk",     "",   "",    false, false },
  { "Kwami",                                                      "ktf",     "",   "",    false, false },
  { "Kwamtim One",                                                "okk",     "",   "",    false, false },
  { "Kwandu",                                                     "xdo",     "",   "",    false, false },
  { "Kwang",                                                      "kvi",     "",   "",    false, false },
  { "Kwanga",                                                     "kwj",     "",   "",    false, false },
  { "Kwangali",                                                   "kwn",     "",   "",    false, false },
  { "Kwanja",                                                     "knp",     "",   "",    false, false },
  { "Kwara'ae",                                                   "kwf",     "",   "",    false, false },
  { "Kwasio",                                                     "nmg",     "",   "",    false, false },
  { "Kwaya",                                                      "kya",     "",   "",    false, false },
  { "Kwaza",                                                      "xwa",     "",   "",    false, false },
  { "Kwegu",                                                      "xwg",     "",   "",    false, false },
  { "Kwer",                                                       "kwr",     "",   "",    false, false },
  { "Kwerba Mamberamo",                                           "xwr",     "",   "",    false, false },
  { "Kwerba",                                                     "kwe",     "",   "",    false, false },
  { "Kwere",                                                      "cwe",     "",   "",    false, false },
  { "Kwerisa",                                                    "kkb",     "",   "",    false, false },
  { "Kwese",                                                      "kws",     "",   "",    false, false },
  { "Kwesten",                                                    "kwt",     "",   "",    false, false },
  { "Kwini",                                                      "gww",     "",   "",    false, false },
  { "Kwinsu",                                                     "kuc",     "",   "",    false, false },
  { "Kwinti",                                                     "kww",     "",   "",    false, false },
  { "Kwoma",                                                      "kmo",     "",   "",    false, false },
  { "Kwomtari",                                                   "kwo",     "",   "",    false, false },
  { "Kxoe",                                                       "xuu",     "",   "",    false, false },
  { "Kyak",                                                       "bka",     "",   "",    false, false },
  { "Kyaka",                                                      "kyc",     "",   "",    false, false },
  { "Kyan-Karyaw Naga",                                           "nqq",     "",   "",    false, false },
  { "Kyanga",                                                     "tye",     "",   "",    false, false },
  { "Kyenele",                                                    "kql",     "",   "",    false, false },
  { "Kyerung",                                                    "kgy",     "",   "",    false, false },
  { "Kâte",                                                       "kmg",     "",   "",    false, false },
  { "Kélé",                                                       "keb",     "",   "",    false, false },
  { "Kölsch",                                                     "ksh",     "",   "",    false, false },
  { "Kɛlɛngaxo Bozo",                                             "bzx",     "",   "",    false, false },
  { "La'bi",                                                      "lbi",     "",   "",    false, false },
  { "Laal",                                                       "gdm",     "",   "",    false, false },
  { "Laari",                                                      "ldi",     "",   "",    false, false },
  { "Laarim",                                                     "loh",     "",   "",    false, false },
  { "Laba",                                                       "lau",     "",   "",    false, false },
  { "Label",                                                      "lbb",     "",   "",    false, false },
  { "Labir",                                                      "jku",     "",   "",    false, false },
  { "Labo Phowa",                                                 "ypb",     "",   "",    false, false },
  { "Labo",                                                       "mwi",     "",   "",    false, false },
  { "Labu",                                                       "lbu",     "",   "",    false, false },
  { "Labuk-Kinabatangan Kadazan",                                 "dtb",     "",   "",    false, false },
  { "Lacandon",                                                   "lac",     "",   "",    false, false },
  { "Lachi",                                                      "lbt",     "",   "",    false, false },
  { "Lachiguiri Zapotec",                                         "zpa",     "",   "",    false, false },
  { "Lachixío Zapotec",                                           "zpl",     "",   "",    false, false },
  { "Ladakhi",                                                    "lbj",     "",   "",    false, false },
  { "Ladin",                                                      "lld",     "",   "",    false, false },
  { "Ladino",                                                     "lad",     "",   "",    true,  false },
  { "Ladji Ladji",                                                "llj",     "",   "",    false, false },
  { "Laeko-Libuat",                                               "lkl",     "",   "",    false, false },
  { "Lafofa",                                                     "laf",     "",   "",    false, false },
  { "Laghu",                                                      "lgb",     "",   "",    false, false },
  { "Laghuu",                                                     "lgh",     "",   "",    false, false },
  { "Lagwan",                                                     "kot",     "",   "",    false, false },
  { "Laha (Indonesia)",                                           "lhh",     "",   "",    false, false },
  { "Laha (Viet Nam)",                                            "lha",     "",   "",    false, false },
  { "Lahanan",                                                    "lhn",     "",   "",    false, false },
  { "Lahnda",                                                     "lah",     "",   "",    true,  false },
  { "Lahta Karen",                                                "kvt",     "",   "",    false, false },
  { "Lahu Shi",                                                   "lhi",     "",   "",    false, false },
  { "Lahu",                                                       "lhu",     "",   "",    false, false },
  { "Lahul Lohar",                                                "lhl",     "",   "",    false, false },
  { "Laimbue",                                                    "lmx",     "",   "",    false, false },
  { "Laitu Chin",                                                 "clj",     "",   "",    false, false },
  { "Laiyolo",                                                    "lji",     "",   "",    false, false },
  { "Lak",                                                        "lbe",     "",   "",    false, false },
  { "Laka (Chad)",                                                "lap",     "",   "",    false, false },
  { "Laka (Nigeria)",                                             "lak",     "",   "",    false, true  },
  { "Lakalei",                                                    "lka",     "",   "",    false, false },
  { "Lake Miwok",                                                 "lmw",     "",   "",    false, false },
  { "Lakha",                                                      "lkh",     "",   "",    false, false },
  { "Laki",                                                       "lki",     "",   "",    false, false },
  { "Lakkia",                                                     "lbc",     "",   "",    false, false },
  { "Lakon",                                                      "lkn",     "",   "",    false, false },
  { "Lakondê",                                                    "lkd",     "",   "",    false, false },
  { "Lakota Dida",                                                "dic",     "",   "",    false, false },
  { "Lakota",                                                     "lkt",     "",   "",    false, false },
  { "Lakurumau",                                                  "lxm",     "",   "",    false, false },
  { "Lala",                                                       "nrz",     "",   "",    false, false },
  { "Lala-Bisa",                                                  "leb",     "",   "",    false, false },
  { "Lala-Roba",                                                  "lla",     "",   "",    false, false },
  { "Lalana Chinantec",                                           "cnl",     "",   "",    false, false },
  { "Lalia",                                                      "lal",     "",   "",    false, false },
  { "Lama (Togo)",                                                "las",     "",   "",    false, false },
  { "Lama Bai",                                                   "lay",     "",   "",    false, false },
  { "Lamaholot",                                                  "slp",     "",   "",    false, false },
  { "Lamalama",                                                   "lby",     "",   "",    false, false },
  { "Lamalera",                                                   "lmr",     "",   "",    false, false },
  { "Lamam",                                                      "lmm",     "",   "",    false, true  },
  { "Lamang",                                                     "hia",     "",   "",    false, false },
  { "Lamatuka",                                                   "lmq",     "",   "",    false, false },
  { "Lamba",                                                      "lam",     "",   "",    true,  false },
  { "Lambadi",                                                    "lmn",     "",   "",    false, false },
  { "Lambayeque Quechua",                                         "quf",     "",   "",    false, false },
  { "Lambichhong",                                                "lmh",     "",   "",    false, false },
  { "Lamboya",                                                    "lmy",     "",   "",    false, false },
  { "Lambya",                                                     "lai",     "",   "",    false, false },
  { "Lame",                                                       "bma",     "",   "",    false, false },
  { "Lamenu",                                                     "lmu",     "",   "",    false, false },
  { "Lamja-Dengsa-Tola",                                          "ldh",     "",   "",    false, false },
  { "Lamkang",                                                    "lmk",     "",   "",    false, false },
  { "Lamma",                                                      "lev",     "",   "",    false, false },
  { "Lamnso'",                                                    "lns",     "",   "",    false, false },
  { "Lamogai",                                                    "lmg",     "",   "",    false, false },
  { "Lampung Api",                                                "ljp",     "",   "",    false, false },
  { "Lampung Nyo",                                                "abl",     "",   "",    false, false },
  { "Lamu",                                                       "llh",     "",   "",    false, false },
  { "Lanas Lobu",                                                 "ruu",     "",   "",    false, false },
  { "Land Dayak languages",                                       "day",     "",   "",    true,  false },
  { "Landoma",                                                    "ldm",     "",   "",    false, false },
  { "Lang'e",                                                     "yne",     "",   "",    false, false },
  { "Langam",                                                     "lnm",     "",   "",    false, false },
  { "Langbashe",                                                  "lna",     "",   "",    false, false },
  { "Langnian Buyang",                                            "yln",     "",   "",    false, false },
  { "Lango (South Sudan)",                                        "lgo",     "",   "",    false, false },
  { "Lango (South Sudan)",                                        "lno",     "",   "",    false, true  },
  { "Lango (Uganda)",                                             "laj",     "",   "",    false, false },
  { "Langobardic",                                                "lng",     "",   "",    false, false },
  { "Langue des signes de Belgique Francophone",                  "sfb",     "",   "",    false, false },
  { "Lanima",                                                     "lnw",     "",   "",    false, false },
  { "Lanoh",                                                      "lnh",     "",   "",    false, false },
  { "Lao Naga",                                                   "nlq",     "",   "",    false, false },
  { "Lao",                                                        "lao",     "lo", "",    true,  false },
  { "Laomian",                                                    "lwm",     "",   "",    false, false },
  { "Laopang",                                                    "lbg",     "",   "",    false, false },
  { "Laos Sign Language",                                         "lso",     "",   "",    false, false },
  { "Lapaguía-Guivini Zapotec",                                   "ztl",     "",   "",    false, false },
  { "Laragia",                                                    "lrg",     "",   "",    false, false },
  { "Larantuka Malay",                                            "lrt",     "",   "",    false, false },
  { "Lardil",                                                     "lbz",     "",   "",    false, false },
  { "Larevat",                                                    "lrv",     "",   "",    false, false },
  { "Large Flowery Miao",                                         "hmd",     "",   "",    false, false },
  { "Lari",                                                       "lrl",     "",   "",    false, false },
  { "Larike-Wakasihu",                                            "alo",     "",   "",    false, false },
  { "Laro",                                                       "lro",     "",   "",    false, false },
  { "Larteh",                                                     "lar",     "",   "",    false, false },
  { "Laru",                                                       "lan",     "",   "",    false, false },
  { "Las Delicias Zapotec",                                       "zcd",     "",   "",    false, false },
  { "Lasalimu",                                                   "llm",     "",   "",    false, false },
  { "Lasgerdi",                                                   "lsa",     "",   "",    false, false },
  { "Lashi",                                                      "lsi",     "",   "",    false, false },
  { "Lasi",                                                       "lss",     "",   "",    false, false },
  { "Late Middle Chinese",                                        "ltc",     "",   "",    false, false },
  { "Latgalian",                                                  "ltg",     "",   "",    false, false },
  { "Latin",                                                      "lat",     "la", "",    true,  false },
  { "Latu",                                                       "ltu",     "",   "",    false, false },
  { "Latundê",                                                    "ltn",     "",   "",    false, false },
  { "Latvian Sign Language",                                      "lsl",     "",   "",    false, false },
  { "Latvian",                                                    "lav",     "lv", "",    true,  false },
  { "Lau",                                                        "llu",     "",   "",    false, false },
  { "Laua",                                                       "luf",     "",   "",    false, false },
  { "Lauan",                                                      "llx",     "",   "",    false, false },
  { "Lauje",                                                      "law",     "",   "",    false, false },
  { "Laura",                                                      "lur",     "",   "",    false, false },
  { "Laurentian",                                                 "lre",     "",   "",    false, false },
  { "Lautu Chin",                                                 "clt",     "",   "",    false, false },
  { "Lavatbura-Lamusong",                                         "lbv",     "",   "",    false, false },
  { "Laven",                                                      "lbo",     "",   "",    false, false },
  { "Lavi",                                                       "lvi",     "",   "",    false, false },
  { "Lavukaleve",                                                 "lvk",     "",   "",    false, false },
  { "Lawangan",                                                   "lbx",     "",   "",    false, false },
  { "Lawu",                                                       "lwu",     "",   "",    false, false },
  { "Lawunuia",                                                   "tgi",     "",   "",    false, false },
  { "Layakha",                                                    "lya",     "",   "",    false, false },
  { "Laz",                                                        "lzz",     "",   "",    false, false },
  { "Lealao Chinantec",                                           "cle",     "",   "",    false, false },
  { "Leco",                                                       "lec",     "",   "",    false, false },
  { "Ledo Kaili",                                                 "lew",     "",   "",    false, false },
  { "Leelau",                                                     "ldk",     "",   "",    false, false },
  { "Lefa",                                                       "lfa",     "",   "",    false, false },
  { "Lega-Mwenga",                                                "lgm",     "",   "",    false, false },
  { "Lega-Shabunda",                                              "lea",     "",   "",    false, false },
  { "Legbo",                                                      "agb",     "",   "",    false, false },
  { "Legenyem",                                                   "lcc",     "",   "",    false, false },
  { "Lehali",                                                     "tql",     "",   "",    false, false },
  { "Lehalurup",                                                  "urr",     "",   "",    false, false },
  { "Lehar",                                                      "cae",     "",   "",    false, false },
  { "Leinong Naga",                                               "lzn",     "",   "",    false, false },
  { "Leipon",                                                     "lek",     "",   "",    false, false },
  { "Leizhou Chinese",                                            "luh",     "",   "",    false, false },
  { "Lelak",                                                      "llk",     "",   "",    false, false },
  { "Lele (Chad)",                                                "lln",     "",   "",    false, false },
  { "Lele (Democratic Republic of Congo)",                        "lel",     "",   "",    false, false },
  { "Lele (Guinea)",                                              "llc",     "",   "",    false, false },
  { "Lele (Papua New Guinea)",                                    "lle",     "",   "",    false, false },
  { "Lelemi",                                                     "lef",     "",   "",    false, false },
  { "Lelepa",                                                     "lpa",     "",   "",    false, false },
  { "Lembena",                                                    "leq",     "",   "",    false, false },
  { "Lemerig",                                                    "lrz",     "",   "",    false, false },
  { "Lemio",                                                      "lei",     "",   "",    false, false },
  { "Lemnian",                                                    "xle",     "",   "",    false, false },
  { "Lemolang",                                                   "ley",     "",   "",    false, false },
  { "Lemoro",                                                     "ldj",     "",   "",    false, false },
  { "Lenakel",                                                    "tnl",     "",   "",    false, false },
  { "Lenca",                                                      "len",     "",   "",    false, false },
  { "Lendu",                                                      "led",     "",   "",    false, false },
  { "Lengilu",                                                    "lgi",     "",   "",    false, false },
  { "Lengo",                                                      "lgr",     "",   "",    false, false },
  { "Lengola",                                                    "lej",     "",   "",    false, false },
  { "Lengua",                                                     "leg",     "",   "",    false, true  },
  { "Leningitij",                                                 "lnj",     "",   "",    false, false },
  { "Lenje",                                                      "leh",     "",   "",    false, false },
  { "Lenkau",                                                     "ler",     "",   "",    false, false },
  { "Lenyima",                                                    "ldg",     "",   "",    false, false },
  { "Lepcha",                                                     "lep",     "",   "",    false, false },
  { "Lepki",                                                      "lpe",     "",   "",    false, false },
  { "Lepontic",                                                   "xlp",     "",   "",    false, false },
  { "Lere",                                                       "gnh",     "",   "",    false, false },
  { "Lese",                                                       "les",     "",   "",    false, false },
  { "Lesing-Gelimi",                                              "let",     "",   "",    false, false },
  { "Letemboi",                                                   "nms",     "",   "",    false, false },
  { "Leti (Cameroon)",                                            "leo",     "",   "",    false, false },
  { "Leti (Indonesia)",                                           "lti",     "",   "",    false, false },
  { "Levantine Arabic",                                           "apc",     "",   "",    false, false },
  { "Levuka",                                                     "lvu",     "",   "",    false, false },
  { "Lewo Eleng",                                                 "lwe",     "",   "",    false, false },
  { "Lewo",                                                       "lww",     "",   "",    false, false },
  { "Lewotobi",                                                   "lwt",     "",   "",    false, false },
  { "Leyigha",                                                    "ayi",     "",   "",    false, false },
  { "Lezghian",                                                   "lez",     "",   "",    true,  false },
  { "Lhokpu",                                                     "lhp",     "",   "",    false, false },
  { "Lhomi",                                                      "lhm",     "",   "",    false, false },
  { "Li'o",                                                       "ljl",     "",   "",    false, false },
  { "Liabuku",                                                    "lix",     "",   "",    false, false },
  { "Liana-Seti",                                                 "ste",     "",   "",    false, false },
  { "Liangmai Naga",                                              "njn",     "",   "",    false, false },
  { "Lianshan Zhuang",                                            "zln",     "",   "",    false, false },
  { "Liberia Kpelle",                                             "xpe",     "",   "",    false, false },
  { "Liberian English",                                           "lir",     "",   "",    false, false },
  { "Libido",                                                     "liq",     "",   "",    false, false },
  { "Libinza",                                                    "liz",     "",   "",    false, false },
  { "Libon Bikol",                                                "lbl",     "",   "",    false, false },
  { "Liburnian",                                                  "xli",     "",   "",    false, false },
  { "Libyan Arabic",                                              "ayl",     "",   "",    false, false },
  { "Libyan Sign Language",                                       "lbs",     "",   "",    false, false },
  { "Lidzonka",                                                   "add",     "",   "",    false, false },
  { "Ligbi",                                                      "lig",     "",   "",    false, false },
  { "Ligenza",                                                    "lgz",     "",   "",    false, false },
  { "Ligurian (Ancient)",                                         "xlg",     "",   "",    false, false },
  { "Ligurian",                                                   "lij",     "",   "",    false, false },
  { "Lihir",                                                      "lih",     "",   "",    false, false },
  { "Lijili",                                                     "mgi",     "",   "",    false, false },
  { "Lika",                                                       "lik",     "",   "",    false, false },
  { "Liki",                                                       "lio",     "",   "",    false, false },
  { "Likila",                                                     "lie",     "",   "",    false, false },
  { "Likuba",                                                     "kxx",     "",   "",    false, false },
  { "Likum",                                                      "lib",     "",   "",    false, false },
  { "Likwala",                                                    "kwc",     "",   "",    false, false },
  { "Lilau",                                                      "lll",     "",   "",    false, false },
  { "Lillooet",                                                   "lil",     "",   "",    false, false },
  { "Limassa",                                                    "bme",     "",   "",    false, false },
  { "Limbu",                                                      "lif",     "",   "",    false, false },
  { "Limbum",                                                     "lmp",     "",   "",    false, false },
  { "Limburgan",                                                  "lim",     "li", "",    true,  false },
  { "Limi",                                                       "ylm",     "",   "",    false, false },
  { "Limilngan",                                                  "lmc",     "",   "",    false, false },
  { "Limos Kalinga",                                              "kmk",     "",   "",    false, false },
  { "Linear A",                                                   "lab",     "",   "",    false, false },
  { "Lingala",                                                    "lin",     "ln", "",    true,  false },
  { "Lingao",                                                     "onb",     "",   "",    false, false },
  { "Lingarak",                                                   "lgk",     "",   "",    false, false },
  { "Lingkhim",                                                   "lii",     "",   "",    false, true  },
  { "Lingua Franca Nova",                                         "lfn",     "",   "",    false, false },
  { "Lingua Franca",                                              "pml",     "",   "",    false, false },
  { "Lipan Apache",                                               "apl",     "",   "",    false, false },
  { "Lipo",                                                       "lpo",     "",   "",    false, false },
  { "Lisabata-Nuniali",                                           "lcs",     "",   "",    false, false },
  { "Lisela",                                                     "lcl",     "",   "",    false, false },
  { "Lish",                                                       "lsh",     "",   "",    false, false },
  { "Lishana Deni",                                               "lsd",     "",   "",    false, false },
  { "Lishanid Noshan",                                            "aij",     "",   "",    false, false },
  { "Lishán Didán",                                               "trg",     "",   "",    false, false },
  { "Lisu",                                                       "lis",     "",   "",    false, false },
  { "Literary Chinese",                                           "lzh",     "",   "",    false, false },
  { "Lithuanian Sign Language",                                   "lls",     "",   "",    false, false },
  { "Lithuanian",                                                 "lit",     "lt", "",    true,  false },
  { "Litzlitz",                                                   "lzl",     "",   "",    false, false },
  { "Liujiang Zhuang",                                            "zlj",     "",   "",    false, false },
  { "Liuqian Zhuang",                                             "zlq",     "",   "",    false, false },
  { "Liv",                                                        "liv",     "",   "",    false, false },
  { "Livvi",                                                      "olo",     "",   "",    false, false },
  { "Lo-Toga",                                                    "lht",     "",   "",    false, false },
  { "Loarki",                                                     "lrk",     "",   "",    false, false },
  { "Lobala",                                                     "loq",     "",   "",    false, false },
  { "Lobi",                                                       "lob",     "",   "",    false, false },
  { "Lodhi",                                                      "lbm",     "",   "",    false, false },
  { "Logba",                                                      "lgq",     "",   "",    false, false },
  { "Logir",                                                      "lqr",     "",   "",    false, false },
  { "Logo",                                                       "log",     "",   "",    false, false },
  { "Logol",                                                      "lof",     "",   "",    false, false },
  { "Logooli",                                                    "rag",     "",   "",    false, false },
  { "Logorik",                                                    "liu",     "",   "",    false, false },
  { "Logudorese Sardinian",                                       "src",     "",   "",    false, false },
  { "Lohorung",                                                   "lbr",     "",   "",    false, false },
  { "Loja Highland Quichua",                                      "qvj",     "",   "",    false, false },
  { "Lojban",                                                     "jbo",     "",   "",    true,  false },
  { "Lokaa",                                                      "yaz",     "",   "",    false, false },
  { "Loke",                                                       "loy",     "",   "",    false, false },
  { "Loko",                                                       "lok",     "",   "",    false, false },
  { "Lokoya",                                                     "lky",     "",   "",    false, false },
  { "Lola",                                                       "lcd",     "",   "",    false, false },
  { "Lolak",                                                      "llq",     "",   "",    false, false },
  { "Lole",                                                       "llg",     "",   "",    false, false },
  { "Lolo",                                                       "llb",     "",   "",    false, false },
  { "Loloda",                                                     "loa",     "",   "",    false, false },
  { "Lolopo",                                                     "ycl",     "",   "",    false, false },
  { "Loma (Côte d'Ivoire)",                                       "loi",     "",   "",    false, false },
  { "Loma (Liberia)",                                             "lom",     "",   "",    false, false },
  { "Lomaiviti",                                                  "lmv",     "",   "",    false, false },
  { "Lomavren",                                                   "rmi",     "",   "",    false, false },
  { "Lombard",                                                    "lmo",     "",   "",    false, false },
  { "Lombi",                                                      "lmi",     "",   "",    false, false },
  { "Lombo",                                                      "loo",     "",   "",    false, false },
  { "Lomwe",                                                      "ngl",     "",   "",    false, false },
  { "Loncong",                                                    "lce",     "",   "",    false, false },
  { "Long Phuri Naga",                                            "lpn",     "",   "",    false, false },
  { "Long Wat",                                                   "ttw",     "",   "",    false, false },
  { "Longgu",                                                     "lgu",     "",   "",    false, false },
  { "Longto",                                                     "wok",     "",   "",    false, false },
  { "Longuda",                                                    "lnu",     "",   "",    false, false },
  { "Loniu",                                                      "los",     "",   "",    false, false },
  { "Lonwolwol",                                                  "crc",     "",   "",    false, false },
  { "Lonzo",                                                      "lnz",     "",   "",    false, false },
  { "Loo",                                                        "ldo",     "",   "",    false, false },
  { "Lopa",                                                       "lop",     "",   "",    false, false },
  { "Lopi",                                                       "lov",     "",   "",    false, false },
  { "Lopit",                                                      "lpx",     "",   "",    false, false },
  { "Lorang",                                                     "lrn",     "",   "",    false, false },
  { "Lorediakarkar",                                              "lnn",     "",   "",    false, false },
  { "Loreto-Ucayali Spanish",                                     "spq",     "",   "",    false, false },
  { "Lote",                                                       "uvl",     "",   "",    false, false },
  { "Lotha Naga",                                                 "njh",     "",   "",    false, false },
  { "Lotud",                                                      "dtr",     "",   "",    false, false },
  { "Lou",                                                        "loj",     "",   "",    false, false },
  { "Louisiana Creole",                                           "lou",     "",   "",    false, false },
  { "Loun",                                                       "lox",     "",   "",    false, false },
  { "Loup A",                                                     "xlo",     "",   "",    false, false },
  { "Loup B",                                                     "xlb",     "",   "",    false, false },
  { "Low German",                                                 "nds",     "",   "",    true,  false },
  { "Lower Burdekin",                                             "xbb",     "",   "",    false, false },
  { "Lower Chehalis",                                             "cea",     "",   "",    false, false },
  { "Lower Grand Valley Dani",                                    "dni",     "",   "",    false, false },
  { "Lower Nossob",                                               "nsb",     "",   "",    false, false },
  { "Lower Silesian",                                             "sli",     "",   "",    false, false },
  { "Lower Sorbian",                                              "dsb",     "",   "",    true,  false },
  { "Lower Southern Aranda",                                      "axl",     "",   "",    false, false },
  { "Lower Ta'oih",                                               "tto",     "",   "",    false, false },
  { "Lower Tanana",                                               "taa",     "",   "",    false, false },
  { "Lowland Oaxaca Chontal",                                     "clo",     "",   "",    false, false },
  { "Lowland Tarahumara",                                         "tac",     "",   "",    false, false },
  { "Loxicha Zapotec",                                            "ztp",     "",   "",    false, false },
  { "Lozi",                                                       "loz",     "",   "",    true,  false },
  { "Lua'",                                                       "prb",     "",   "",    false, true  },
  { "Luang",                                                      "lex",     "",   "",    false, false },
  { "Luba-Katanga",                                               "lub",     "lu", "",    true,  false },
  { "Luba-Lulua",                                                 "lua",     "",   "",    true,  false },
  { "Lubila",                                                     "kcc",     "",   "",    false, false },
  { "Lubu",                                                       "lcf",     "",   "",    false, false },
  { "Lubuagan Kalinga",                                           "knb",     "",   "",    false, false },
  { "Luchazi",                                                    "lch",     "",   "",    false, false },
  { "Lucumi",                                                     "luq",     "",   "",    false, false },
  { "Ludian",                                                     "lud",     "",   "",    false, false },
  { "Lufu",                                                       "ldq",     "",   "",    false, false },
  { "Lugbara",                                                    "lgg",     "",   "",    false, false },
  { "Luguru",                                                     "ruf",     "",   "",    false, false },
  { "Luhu",                                                       "lcq",     "",   "",    false, false },
  { "Lui",                                                        "lba",     "",   "",    false, true  },
  { "Luimbi",                                                     "lum",     "",   "",    false, false },
  { "Luiseno",                                                    "lui",     "",   "",    true,  false },
  { "Lukpa",                                                      "dop",     "",   "",    false, false },
  { "Lule Sami",                                                  "smj",     "",   "",    true,  false },
  { "Lule",                                                       "ule",     "",   "",    false, false },
  { "Lumba-Yakkha",                                               "luu",     "",   "",    false, false },
  { "Lumbee",                                                     "lmz",     "",   "",    false, true  },
  { "Lumbu",                                                      "lup",     "",   "",    false, false },
  { "Lumun",                                                      "lmd",     "",   "",    false, false },
  { "Luna",                                                       "luj",     "",   "",    false, false },
  { "Lunanakha",                                                  "luk",     "",   "",    false, false },
  { "Lunda",                                                      "lun",     "",   "",    true,  false },
  { "Lundayeh",                                                   "lnd",     "",   "",    false, false },
  { "Lungalunga",                                                 "vmg",     "",   "",    false, false },
  { "Lungga",                                                     "lga",     "",   "",    false, false },
  { "Luo (Cameroon)",                                             "luw",     "",   "",    false, false },
  { "Luo (Kenya and Tanzania)",                                   "luo",     "",   "",    true,  false },
  { "Luopohe Hmong",                                              "hml",     "",   "",    false, false },
  { "Luri",                                                       "ldd",     "",   "",    false, false },
  { "Lusengo",                                                    "lse",     "",   "",    false, false },
  { "Lushai",                                                     "lus",     "",   "",    true,  false },
  { "Lushootseed",                                                "lut",     "",   "",    false, false },
  { "Lusi",                                                       "khl",     "",   "",    false, false },
  { "Lusitanian",                                                 "xls",     "",   "",    false, false },
  { "Lutos",                                                      "ndy",     "",   "",    false, false },
  { "Luvale",                                                     "lue",     "",   "",    false, false },
  { "Luwati",                                                     "luv",     "",   "",    false, false },
  { "Luwo",                                                       "lwo",     "",   "",    false, false },
  { "Luxembourgish",                                              "ltz",     "lb", "",    true,  false },
  { "Luyana",                                                     "lyn",     "",   "",    false, false },
  { "Luyia",                                                      "luy",     "",   "",    false, false },
  { "Lwalu",                                                      "lwa",     "",   "",    false, false },
  { "Lwel",                                                       "lvl",     "",   "",    false, false },
  { "Lycian",                                                     "xlc",     "",   "",    false, false },
  { "Lydian",                                                     "xld",     "",   "",    false, false },
  { "Lyngngam",                                                   "lyg",     "",   "",    false, false },
  { "Lyons Sign Language",                                        "lsg",     "",   "",    false, true  },
  { "Lyélé",                                                      "lee",     "",   "",    false, false },
  { "Láadan",                                                     "ldn",     "",   "",    false, false },
  { "Láá Láá Bwamu",                                              "bwj",     "",   "",    false, false },
  { "Lü",                                                         "khb",     "",   "",    false, false },
  { "Ma (Democratic Republic of Congo)",                          "msj",     "",   "",    false, false },
  { "Ma (Papua New Guinea)",                                      "mjn",     "",   "",    false, false },
  { "Ma Manda",                                                   "skc",     "",   "",    false, false },
  { "Ma'anyan",                                                   "mhy",     "",   "",    false, false },
  { "Ma'di",                                                      "mhi",     "",   "",    false, false },
  { "Ma'ya",                                                      "slz",     "",   "",    false, false },
  { "Maa",                                                        "cma",     "",   "",    false, false },
  { "Maaka",                                                      "mew",     "",   "",    false, false },
  { "Maasina Fulfulde",                                           "ffm",     "",   "",    false, false },
  { "Maay",                                                       "ymm",     "",   "",    false, false },
  { "Maba (Chad)",                                                "mde",     "",   "",    false, false },
  { "Maba (Indonesia)",                                           "mqa",     "",   "",    false, false },
  { "Mabaale",                                                    "mmz",     "",   "",    false, false },
  { "Mabaan",                                                     "mfz",     "",   "",    false, false },
  { "Mabaka Valley Kalinga",                                      "kkg",     "",   "",    false, false },
  { "Mabire",                                                     "muj",     "",   "",    false, false },
  { "Maca",                                                       "mca",     "",   "",    false, false },
  { "Macaguaje",                                                  "mcl",     "",   "",    false, false },
  { "Macaguán",                                                   "mbn",     "",   "",    false, false },
  { "Macanese",                                                   "mzs",     "",   "",    false, false },
  { "Macedo-Romanian",                                            "rup",     "",   "",    true,  false },
  { "Macedonian",                                                 "mac",     "mk", "mkd", true,  false },
  { "Machame",                                                    "jmc",     "",   "",    false, false },
  { "Machiguenga",                                                "mcb",     "",   "",    false, false },
  { "Machinere",                                                  "mpd",     "",   "",    false, false },
  { "Machinga",                                                   "mvw",     "",   "",    false, false },
  { "Maco",                                                       "wpc",     "",   "",    false, false },
  { "Macuna",                                                     "myy",     "",   "",    false, false },
  { "Macushi",                                                    "mbc",     "",   "",    false, false },
  { "Mada (Cameroon)",                                            "mxu",     "",   "",    false, false },
  { "Mada (Nigeria)",                                             "mda",     "",   "",    false, false },
  { "Madagascar Sign Language",                                   "mzc",     "",   "",    false, false },
  { "Madak",                                                      "mmx",     "",   "",    false, false },
  { "Madhi Madhi",                                                "dmd",     "",   "",    false, false },
  { "Madi",                                                       "grg",     "",   "",    false, false },
  { "Madurese",                                                   "mad",     "",   "",    true,  false },
  { "Mae",                                                        "mme",     "",   "",    false, false },
  { "Maek",                                                       "hmk",     "",   "",    false, false },
  { "Maeng Itneg",                                                "itt",     "",   "",    false, false },
  { "Mafa",                                                       "maf",     "",   "",    false, false },
  { "Mafea",                                                      "mkv",     "",   "",    false, false },
  { "Mag-Indi Ayta",                                              "blx",     "",   "",    false, false },
  { "Mag-antsi Ayta",                                             "sgb",     "",   "",    false, false },
  { "Magahi",                                                     "mag",     "",   "",    true,  false },
  { "Magbukun Ayta",                                              "ayt",     "",   "",    false, false },
  { "Magdalena Peñasco Mixtec",                                   "xtm",     "",   "",    false, false },
  { "Magoma",                                                     "gmx",     "",   "",    false, false },
  { "Magori",                                                     "zgr",     "",   "",    false, false },
  { "Maguindanaon",                                               "mdh",     "",   "",    false, false },
  { "Magɨ (Madang Province)",                                     "gkd",     "",   "",    false, false },
  { "Magɨyi",                                                     "gmg",     "",   "",    false, false },
  { "Mahali",                                                     "mjx",     "",   "",    false, false },
  { "Mahasu Pahari",                                              "bfz",     "",   "",    false, false },
  { "Mahei",                                                      "mja",     "",   "",    false, true  },
  { "Mahican",                                                    "mjy",     "",   "",    false, false },
  { "Mahongwe",                                                   "mhb",     "",   "",    false, false },
  { "Mahou",                                                      "mxx",     "",   "",    false, false },
  { "Mai Brat",                                                   "ayz",     "",   "",    false, false },
  { "Maia",                                                       "sks",     "",   "",    false, false },
  { "Maiadomu",                                                   "mzz",     "",   "",    false, false },
  { "Maiani",                                                     "tnh",     "",   "",    false, false },
  { "Maii",                                                       "mmm",     "",   "",    false, false },
  { "Mailu",                                                      "mgu",     "",   "",    false, false },
  { "Maindo",                                                     "cwb",     "",   "",    false, false },
  { "Mainfränkisch",                                              "vmf",     "",   "",    false, false },
  { "Mainstream Kenyah",                                          "xkl",     "",   "",    false, false },
  { "Mairasi",                                                    "zrs",     "",   "",    false, false },
  { "Maisin",                                                     "mbq",     "",   "",    false, false },
  { "Maithili",                                                   "mai",     "",   "",    true,  false },
  { "Maiwa (Indonesia)",                                          "wmm",     "",   "",    false, false },
  { "Maiwa (Papua New Guinea)",                                   "mti",     "",   "",    false, false },
  { "Maiwala",                                                    "mum",     "",   "",    false, false },
  { "Majang",                                                     "mpe",     "",   "",    false, false },
  { "Majera",                                                     "xmj",     "",   "",    false, false },
  { "Majhi",                                                      "mjz",     "",   "",    false, false },
  { "Majhwar",                                                    "mmj",     "",   "",    false, false },
  { "Majukayang Kalinga",                                         "kmd",     "",   "",    false, false },
  { "Mak (China)",                                                "mkg",     "",   "",    false, false },
  { "Mak (Nigeria)",                                              "pbl",     "",   "",    false, false },
  { "Makaa",                                                      "mcp",     "",   "",    false, false },
  { "Makah",                                                      "myh",     "",   "",    false, false },
  { "Makalero",                                                   "mjb",     "",   "",    false, false },
  { "Makasae",                                                    "mkz",     "",   "",    false, false },
  { "Makasar",                                                    "mak",     "",   "",    true,  false },
  { "Makassar Malay",                                             "mfp",     "",   "",    false, false },
  { "Makayam",                                                    "aup",     "",   "",    false, false },
  { "Makhuwa",                                                    "vmw",     "",   "",    false, false },
  { "Makhuwa-Marrevone",                                          "xmc",     "",   "",    false, false },
  { "Makhuwa-Meetto",                                             "mgh",     "",   "",    false, false },
  { "Makhuwa-Moniga",                                             "mhm",     "",   "",    false, false },
  { "Makhuwa-Saka",                                               "xsq",     "",   "",    false, false },
  { "Makhuwa-Shirima",                                            "vmk",     "",   "",    false, false },
  { "Maklew",                                                     "mgf",     "",   "",    false, false },
  { "Makolkol",                                                   "zmh",     "",   "",    false, false },
  { "Makonde",                                                    "kde",     "",   "",    false, false },
  { "Maku'a",                                                     "lva",     "",   "",    false, false },
  { "Makuri Naga",                                                "jmn",     "",   "",    false, false },
  { "Makuráp",                                                    "mpu",     "",   "",    false, false },
  { "Makwe",                                                      "ymk",     "",   "",    false, false },
  { "Makyan Naga",                                                "umn",     "",   "",    false, false },
  { "Mal Paharia",                                                "mkb",     "",   "",    false, false },
  { "Mal",                                                        "mlf",     "",   "",    false, false },
  { "Mala (Nigeria)",                                             "ruy",     "",   "",    false, false },
  { "Mala (Papua New Guinea)",                                    "ped",     "",   "",    false, false },
  { "Mala Malasar",                                               "ima",     "",   "",    false, false },
  { "Malaccan Creole Malay",                                      "ccm",     "",   "",    false, false },
  { "Malaccan Creole Portuguese",                                 "mcm",     "",   "",    false, false },
  { "Malagasy",                                                   "mlg",     "mg", "",    true,  false },
  { "Malak Malak",                                                "mpb",     "",   "",    false, false },
  { "Malakhel",                                                   "mld",     "",   "",    false, true  },
  { "Malalamai",                                                  "mmt",     "",   "",    false, false },
  { "Malango",                                                    "mln",     "",   "",    false, false },
  { "Malankuravan",                                               "mjo",     "",   "",    false, false },
  { "Malapandaram",                                               "mjp",     "",   "",    false, false },
  { "Malaryan",                                                   "mjq",     "",   "",    false, false },
  { "Malas",                                                      "mkr",     "",   "",    false, false },
  { "Malasar",                                                    "ymr",     "",   "",    false, false },
  { "Malavedan",                                                  "mjr",     "",   "",    false, false },
  { "Malawi Lomwe",                                               "lon",     "",   "",    false, false },
  { "Malawi Sena",                                                "swk",     "",   "",    false, false },
  { "Malawian Sign Language",                                     "lws",     "",   "",    false, false },
  { "Malay (individual language)",                                "zlm",     "",   "",    false, false },
  { "Malay (macrolanguage)",                                      "may",     "ms", "msa", true,  false },
  { "Malayalam",                                                  "mal",     "ml", "",    true,  false },
  { "Malayic Dayak",                                              "xdy",     "",   "",    false, false },
  { "Malaynon",                                                   "mlz",     "",   "",    false, false },
  { "Malayo",                                                     "mbp",     "",   "",    false, false },
  { "Malayo-Polynesian languages",                                "poz",     "",   "",    false, false },
  { "Malaysian Sign Language",                                    "xml",     "",   "",    false, false },
  { "Malba Birifor",                                              "bfo",     "",   "",    false, false },
  { "Male (Ethiopia)",                                            "mdy",     "",   "",    false, false },
  { "Male (Papua New Guinea)",                                    "mdc",     "",   "",    false, false },
  { "Malecite-Passamaquoddy",                                     "pqm",     "",   "",    false, false },
  { "Maleng",                                                     "pkt",     "",   "",    false, false },
  { "Maleu-Kilenge",                                              "mgl",     "",   "",    false, false },
  { "Malfaxal",                                                   "mlx",     "",   "",    false, false },
  { "Malgana",                                                    "vml",     "",   "",    false, false },
  { "Malgbe",                                                     "mxf",     "",   "",    false, false },
  { "Mali",                                                       "gcc",     "",   "",    false, false },
  { "Maligo",                                                     "mwj",     "",   "",    false, true  },
  { "Malila",                                                     "mgq",     "",   "",    false, false },
  { "Malimba",                                                    "mzd",     "",   "",    false, false },
  { "Malimpung",                                                  "mli",     "",   "",    false, false },
  { "Malinaltepec Me'phaa",                                       "tcf",     "",   "",    false, false },
  { "Malo",                                                       "mla",     "",   "",    false, false },
  { "Malol",                                                      "mbk",     "",   "",    false, false },
  { "Maltese Sign Language",                                      "mdl",     "",   "",    false, false },
  { "Maltese",                                                    "mlt",     "mt", "",    true,  false },
  { "Malua Bay",                                                  "mll",     "",   "",    false, false },
  { "Malvi",                                                      "mup",     "",   "",    false, false },
  { "Malyangapa",                                                 "yga",     "",   "",    false, false },
  { "Maléku Jaíka",                                               "gut",     "",   "",    false, false },
  { "Mam",                                                        "mam",     "",   "",    false, false },
  { "Mama",                                                       "mma",     "",   "",    false, false },
  { "Mamaa",                                                      "mhf",     "",   "",    false, false },
  { "Mamaindé",                                                   "wmd",     "",   "",    false, false },
  { "Mamanwa",                                                    "mmn",     "",   "",    false, false },
  { "Mamara Senoufo",                                             "myk",     "",   "",    false, false },
  { "Mamasa",                                                     "mqj",     "",   "",    false, false },
  { "Mambae",                                                     "mgm",     "",   "",    false, false },
  { "Mambai",                                                     "mcs",     "",   "",    false, false },
  { "Mamboru",                                                    "mvd",     "",   "",    false, false },
  { "Mambwe-Lungu",                                               "mgr",     "",   "",    false, false },
  { "Mampruli",                                                   "maw",     "",   "",    false, false },
  { "Mamuju",                                                     "mqx",     "",   "",    false, false },
  { "Mamulique",                                                  "emm",     "",   "",    false, false },
  { "Mamusi",                                                     "kdf",     "",   "",    false, false },
  { "Mamvu",                                                      "mdi",     "",   "",    false, false },
  { "Man Met",                                                    "mml",     "",   "",    false, false },
  { "Manado Malay",                                               "xmm",     "",   "",    false, false },
  { "Manam",                                                      "mva",     "",   "",    false, false },
  { "Manambu",                                                    "mle",     "",   "",    false, false },
  { "Manangba",                                                   "nmm",     "",   "",    false, false },
  { "Manangkari",                                                 "znk",     "",   "",    false, false },
  { "Manchu",                                                     "mnc",     "",   "",    true,  false },
  { "Manda (Australia)",                                          "zma",     "",   "",    false, false },
  { "Manda (India)",                                              "mha",     "",   "",    false, false },
  { "Manda (Tanzania)",                                           "mgs",     "",   "",    false, false },
  { "Mandahuaca",                                                 "mht",     "",   "",    false, false },
  { "Mandaic",                                                    "mid",     "",   "",    false, false },
  { "Mandan",                                                     "mhq",     "",   "",    false, false },
  { "Mandandanyi",                                                "zmk",     "",   "",    false, false },
  { "Mandar",                                                     "mdr",     "",   "",    true,  false },
  { "Mandara",                                                    "tbf",     "",   "",    false, false },
  { "Mandari",                                                    "mqu",     "",   "",    false, false },
  { "Mandarin Chinese",                                           "cmn",     "",   "",    false, false },
  { "Mandaya",                                                    "mry",     "",   "",    false, false },
  { "Mande languages",                                            "dmn",     "",   "",    false, false },
  { "Mandeali",                                                   "mjl",     "",   "",    false, false },
  { "Mander",                                                     "mqr",     "",   "",    false, false },
  { "Mandingo",                                                   "man",     "",   "",    true,  false },
  { "Mandinka",                                                   "mnk",     "",   "",    false, false },
  { "Mandjak",                                                    "mfv",     "",   "",    false, false },
  { "Mandobo Atas",                                               "aax",     "",   "",    false, false },
  { "Mandobo Bawah",                                              "bwp",     "",   "",    false, false },
  { "Manem",                                                      "jet",     "",   "",    false, false },
  { "Mang",                                                       "zng",     "",   "",    false, false },
  { "Manga Kanuri",                                               "kby",     "",   "",    false, false },
  { "Mangala",                                                    "mem",     "",   "",    false, false },
  { "Mangareva",                                                  "mrv",     "",   "",    false, false },
  { "Mangarrayi",                                                 "mpc",     "",   "",    false, false },
  { "Mangas",                                                     "zns",     "",   "",    false, false },
  { "Mangayat",                                                   "myj",     "",   "",    false, false },
  { "Mangbetu",                                                   "mdj",     "",   "",    false, false },
  { "Mangbutu",                                                   "mdk",     "",   "",    false, false },
  { "Mangerr",                                                    "zme",     "",   "",    false, false },
  { "Mangetti Dune ǃXung",                                        "gfx",     "",   "",    false, true  },
  { "Mangga Buang",                                               "mmo",     "",   "",    false, false },
  { "Manggarai",                                                  "mqy",     "",   "",    false, false },
  { "Mango",                                                      "mge",     "",   "",    false, false },
  { "Mangole",                                                    "mqc",     "",   "",    false, false },
  { "Mangseng",                                                   "mbh",     "",   "",    false, false },
  { "Mangue",                                                     "mom",     "",   "",    false, false },
  { "Manichaean Middle Persian",                                  "xmn",     "",   "",    false, false },
  { "Manide",                                                     "abd",     "",   "",    false, false },
  { "Manikion",                                                   "mnx",     "",   "",    false, false },
  { "Manipa",                                                     "mqp",     "",   "",    false, false },
  { "Manipuri",                                                   "mni",     "",   "",    true,  false },
  { "Mankanya",                                                   "knf",     "",   "",    false, false },
  { "Mankiyali",                                                  "nlm",     "",   "",    false, false },
  { "Manna-Dora",                                                 "mju",     "",   "",    false, false },
  { "Mannan",                                                     "mjv",     "",   "",    false, false },
  { "Mano",                                                       "mev",     "",   "",    false, false },
  { "Manobo languages",                                           "mno",     "",   "",    true,  false },
  { "Manombai",                                                   "woo",     "",   "",    false, false },
  { "Mansaka",                                                    "msk",     "",   "",    false, false },
  { "Mansi",                                                      "mns",     "",   "",    false, false },
  { "Mansoanka",                                                  "msw",     "",   "",    false, false },
  { "Manta",                                                      "myg",     "",   "",    false, false },
  { "Mantsi",                                                     "nty",     "",   "",    false, false },
  { "Manumanaw Karen",                                            "kxf",     "",   "",    false, false },
  { "Manx",                                                       "glv",     "gv", "",    true,  false },
  { "Manya",                                                      "mzj",     "",   "",    false, false },
  { "Manyawa",                                                    "mny",     "",   "",    false, false },
  { "Manyika",                                                    "mxc",     "",   "",    false, false },
  { "Manza",                                                      "mzv",     "",   "",    false, false },
  { "Mao Naga",                                                   "nbi",     "",   "",    false, false },
  { "Maonan",                                                     "mmd",     "",   "",    false, false },
  { "Maore Comorian",                                             "swb",     "",   "",    false, false },
  { "Maori",                                                      "mao",     "mi", "mri", true,  false },
  { "Mape",                                                       "mlh",     "",   "",    false, false },
  { "Mapena",                                                     "mnm",     "",   "",    false, false },
  { "Mapia",                                                      "mpy",     "",   "",    false, false },
  { "Mapidian",                                                   "mpw",     "",   "",    false, false },
  { "Mapos Buang",                                                "bzh",     "",   "",    false, false },
  { "Mapoyo",                                                     "mcg",     "",   "",    false, false },
  { "Mapudungun",                                                 "arn",     "",   "",    true,  false },
  { "Mapun",                                                      "sjm",     "",   "",    false, false },
  { "Maquiritari",                                                "mch",     "",   "",    false, false },
  { "Mara Chin",                                                  "mrh",     "",   "",    false, false },
  { "Marachi",                                                    "lri",     "",   "",    false, false },
  { "Maraghei",                                                   "vmh",     "",   "",    false, false },
  { "Maragus",                                                    "mrs",     "",   "",    false, false },
  { "Maram Naga",                                                 "nma",     "",   "",    false, false },
  { "Marama",                                                     "lrm",     "",   "",    false, false },
  { "Maramba",                                                    "myd",     "",   "",    false, true  },
  { "Maranao",                                                    "mrw",     "",   "",    false, false },
  { "Maranunggu",                                                 "zmr",     "",   "",    false, false },
  { "Mararit",                                                    "mgb",     "",   "",    false, false },
  { "Marathi",                                                    "mar",     "mr", "",    true,  false },
  { "Marau",                                                      "mvr",     "",   "",    false, false },
  { "Marba",                                                      "mpg",     "",   "",    false, false },
  { "Mardin Sign Language",                                       "dsz",     "",   "",    false, false },
  { "Maremgi",                                                    "mrx",     "",   "",    false, false },
  { "Marenje",                                                    "vmr",     "",   "",    false, false },
  { "Marfa",                                                      "mvu",     "",   "",    false, false },
  { "Margany",                                                    "zmc",     "",   "",    false, false },
  { "Marghi Central",                                             "mrt",     "",   "",    false, false },
  { "Marghi South",                                               "mfm",     "",   "",    false, false },
  { "Margos-Yarowilca-Lauricocha Quechua",                        "qvm",     "",   "",    false, false },
  { "Margu",                                                      "mhg",     "",   "",    false, false },
  { "Mari (East Sepik Province)",                                 "mbx",     "",   "",    false, false },
  { "Mari (Madang Province)",                                     "hob",     "",   "",    false, false },
  { "Mari (Russia)",                                              "chm",     "",   "",    true,  false },
  { "Maria (India)",                                              "mrr",     "",   "",    false, false },
  { "Maria (Papua New Guinea)",                                   "mds",     "",   "",    false, false },
  { "Maricopa",                                                   "mrc",     "",   "",    false, false },
  { "Maridan",                                                    "zmd",     "",   "",    false, false },
  { "Maridjabin",                                                 "zmj",     "",   "",    false, false },
  { "Marik",                                                      "dad",     "",   "",    false, false },
  { "Marimanindji",                                               "zmm",     "",   "",    false, false },
  { "Marind",                                                     "mrz",     "",   "",    false, false },
  { "Maring Naga",                                                "nng",     "",   "",    false, false },
  { "Maring",                                                     "mbw",     "",   "",    false, false },
  { "Maringarr",                                                  "zmt",     "",   "",    false, false },
  { "Marino",                                                     "mrb",     "",   "",    false, false },
  { "Mariri",                                                     "mqi",     "",   "",    false, false },
  { "Maritime Sign Language",                                     "nsr",     "",   "",    false, false },
  { "Maritsauá",                                                  "msp",     "",   "",    false, false },
  { "Mariyedi",                                                   "zmy",     "",   "",    false, false },
  { "Marka",                                                      "rkm",     "",   "",    false, false },
  { "Markweeta",                                                  "enb",     "",   "",    false, false },
  { "Marma",                                                      "rmz",     "",   "",    false, false },
  { "Marovo",                                                     "mvo",     "",   "",    false, false },
  { "Marra",                                                      "mec",     "",   "",    false, false },
  { "Marriammu",                                                  "xru",     "",   "",    false, false },
  { "Marrithiyel",                                                "mfr",     "",   "",    false, false },
  { "Marrucinian",                                                "umc",     "",   "",    false, false },
  { "Marshallese",                                                "mah",     "mh", "",    true,  false },
  { "Marsian",                                                    "ims",     "",   "",    false, false },
  { "Martha's Vineyard Sign Language",                            "mre",     "",   "",    false, false },
  { "Marti Ke",                                                   "zmg",     "",   "",    false, false },
  { "Martu Wangka",                                               "mpj",     "",   "",    false, false },
  { "Martuyhunira",                                               "vma",     "",   "",    false, false },
  { "Maru",                                                       "mhx",     "",   "",    false, false },
  { "Marwari (India)",                                            "rwr",     "",   "",    false, false },
  { "Marwari (Pakistan)",                                         "mve",     "",   "",    false, false },
  { "Marwari",                                                    "mwr",     "",   "",    true,  false },
  { "Marúbo",                                                     "mzr",     "",   "",    false, false },
  { "Masaaba",                                                    "myx",     "",   "",    false, false },
  { "Masadiit Itneg",                                             "tis",     "",   "",    false, false },
  { "Masai",                                                      "mas",     "",   "",    true,  false },
  { "Masalit",                                                    "mls",     "",   "",    false, false },
  { "Masana",                                                     "mcn",     "",   "",    false, false },
  { "Masbatenyo",                                                 "msb",     "",   "",    false, false },
  { "Mashco Piro",                                                "cuj",     "",   "",    false, false },
  { "Mashi (Nigeria)",                                            "jms",     "",   "",    false, false },
  { "Mashi (Zambia)",                                             "mho",     "",   "",    false, false },
  { "Masikoro Malagasy",                                          "msh",     "",   "",    false, false },
  { "Masimasi",                                                   "ism",     "",   "",    false, false },
  { "Masiwang",                                                   "bnf",     "",   "",    false, false },
  { "Maskelynes",                                                 "klv",     "",   "",    false, false },
  { "Maskoy Pidgin",                                              "mhh",     "",   "",    false, true  },
  { "Maslam",                                                     "msv",     "",   "",    false, false },
  { "Masmaje",                                                    "mes",     "",   "",    false, false },
  { "Massalat",                                                   "mdg",     "",   "",    false, false },
  { "Massep",                                                     "mvs",     "",   "",    false, false },
  { "Matagalpa",                                                  "mtn",     "",   "",    false, false },
  { "Matal",                                                      "mfh",     "",   "",    false, false },
  { "Matambwe",                                                   "wtb",     "",   "",    false, false },
  { "Matbat",                                                     "xmt",     "",   "",    false, false },
  { "Matengo",                                                    "mgv",     "",   "",    false, false },
  { "Matepi",                                                     "mqe",     "",   "",    false, false },
  { "Matigsalug Manobo",                                          "mbt",     "",   "",    false, false },
  { "Matipuhy",                                                   "mzo",     "",   "",    false, false },
  { "Matngala",                                                   "zml",     "",   "",    false, false },
  { "Mato Grosso Arára",                                          "axg",     "",   "",    false, false },
  { "Mato",                                                       "met",     "",   "",    false, false },
  { "Mator",                                                      "mtm",     "",   "",    false, false },
  { "Mator-Taygi-Karagas",                                        "ymt",     "",   "",    false, true  },
  { "Matsés",                                                     "mcf",     "",   "",    false, false },
  { "Mattole",                                                    "mvb",     "",   "",    false, false },
  { "Matu Chin",                                                  "hlt",     "",   "",    false, false },
  { "Matukar",                                                    "mjk",     "",   "",    false, false },
  { "Matumbi",                                                    "mgw",     "",   "",    false, false },
  { "Matya Samo",                                                 "stj",     "",   "",    false, false },
  { "Matís",                                                      "mpq",     "",   "",    false, false },
  { "Maung",                                                      "mph",     "",   "",    false, false },
  { "Mauritian Sign Language",                                    "lsy",     "",   "",    false, false },
  { "Mauwake",                                                    "mhl",     "",   "",    false, false },
  { "Mawa (Chad)",                                                "mcw",     "",   "",    false, false },
  { "Mawa (Nigeria)",                                             "wma",     "",   "",    false, false },
  { "Mawak",                                                      "mjj",     "",   "",    false, false },
  { "Mawan",                                                      "mcz",     "",   "",    false, false },
  { "Mawayana",                                                   "mzx",     "",   "",    false, false },
  { "Mawchi",                                                     "mke",     "",   "",    false, false },
  { "Mawes",                                                      "mgk",     "",   "",    false, false },
  { "Maxakalí",                                                   "mbl",     "",   "",    false, false },
  { "Maxi Gbe",                                                   "mxl",     "",   "",    false, false },
  { "Maya Samo",                                                  "sym",     "",   "",    false, false },
  { "Mayaguduna",                                                 "xmy",     "",   "",    false, false },
  { "Mayan languages",                                            "myn",     "",   "",    true,  false },
  { "Mayangna",                                                   "yan",     "",   "",    false, false },
  { "Mayawali",                                                   "yxa",     "",   "",    false, false },
  { "Mayeka",                                                     "myc",     "",   "",    false, false },
  { "Mayi-Kulan",                                                 "xyk",     "",   "",    false, false },
  { "Mayi-Thakurti",                                              "xyt",     "",   "",    false, false },
  { "Mayi-Yapi",                                                  "xyj",     "",   "",    false, false },
  { "Maykulan",                                                   "mnt",     "",   "",    false, true  },
  { "Mayo",                                                       "mfy",     "",   "",    false, false },
  { "Mayogo",                                                     "mdm",     "",   "",    false, false },
  { "Mayoyao Ifugao",                                             "ifu",     "",   "",    false, false },
  { "Mazagway",                                                   "dkx",     "",   "",    false, false },
  { "Mazaltepec Zapotec",                                         "zpy",     "",   "",    false, false },
  { "Mazanderani",                                                "mzn",     "",   "",    false, false },
  { "Mazatlán Mazatec",                                           "vmz",     "",   "",    false, false },
  { "Mazatlán Mixe",                                              "mzl",     "",   "",    false, false },
  { "Mba",                                                        "mfc",     "",   "",    false, false },
  { "Mbala",                                                      "mdp",     "",   "",    false, false },
  { "Mbalanhu",                                                   "lnb",     "",   "",    false, false },
  { "Mbandja",                                                    "zmz",     "",   "",    false, false },
  { "Mbangala",                                                   "mxg",     "",   "",    false, false },
  { "Mbangi",                                                     "mgn",     "",   "",    false, false },
  { "Mbangwe",                                                    "zmn",     "",   "",    false, false },
  { "Mbara (Australia)",                                          "mvl",     "",   "",    false, false },
  { "Mbara (Chad)",                                               "mpk",     "",   "",    false, false },
  { "Mbariman-Gudhinma",                                          "zmv",     "",   "",    false, false },
  { "Mbati",                                                      "mdn",     "",   "",    false, false },
  { "Mbato",                                                      "gwa",     "",   "",    false, false },
  { "Mbay",                                                       "myb",     "",   "",    false, false },
  { "Mbe",                                                        "mfo",     "",   "",    false, false },
  { "Mbe'",                                                       "mtk",     "",   "",    false, false },
  { "Mbelime",                                                    "mql",     "",   "",    false, false },
  { "Mbere",                                                      "mdt",     "",   "",    false, false },
  { "Mbesa",                                                      "zms",     "",   "",    false, false },
  { "Mbessa",                                                     "emz",     "",   "",    false, false },
  { "Mbo (Cameroon)",                                             "mbo",     "",   "",    false, false },
  { "Mbo (Democratic Republic of Congo)",                         "zmw",     "",   "",    false, false },
  { "Mboi",                                                       "moi",     "",   "",    false, false },
  { "Mboko",                                                      "mdu",     "",   "",    false, false },
  { "Mbole",                                                      "mdq",     "",   "",    false, false },
  { "Mbonga",                                                     "xmb",     "",   "",    false, false },
  { "Mbongno",                                                    "bgu",     "",   "",    false, false },
  { "Mbosi",                                                      "mdw",     "",   "",    false, false },
  { "Mbowe",                                                      "mxo",     "",   "",    false, false },
  { "Mbre",                                                       "mka",     "",   "",    false, false },
  { "Mbudum",                                                     "xmd",     "",   "",    false, false },
  { "Mbugu",                                                      "mhd",     "",   "",    false, false },
  { "Mbugwe",                                                     "mgz",     "",   "",    false, false },
  { "Mbuk",                                                       "bpc",     "",   "",    false, false },
  { "Mbuko",                                                      "mqb",     "",   "",    false, false },
  { "Mbukushu",                                                   "mhw",     "",   "",    false, false },
  { "Mbula",                                                      "mna",     "",   "",    false, false },
  { "Mbula-Bwazza",                                               "mbu",     "",   "",    false, false },
  { "Mbule",                                                      "mlb",     "",   "",    false, false },
  { "Mbulungish",                                                 "mbv",     "",   "",    false, false },
  { "Mbum",                                                       "mdd",     "",   "",    false, false },
  { "Mbunda",                                                     "mck",     "",   "",    false, false },
  { "Mbunga",                                                     "mgy",     "",   "",    false, false },
  { "Mburku",                                                     "bbt",     "",   "",    false, false },
  { "Mbwela",                                                     "mfu",     "",   "",    false, false },
  { "Mbyá Guaraní",                                               "gun",     "",   "",    false, false },
  { "Me'en",                                                      "mym",     "",   "",    false, false },
  { "Mea",                                                        "meg",     "",   "",    false, true  },
  { "Medebur",                                                    "mjm",     "",   "",    false, false },
  { "Medefaidrin",                                                "dmf",     "",   "",    false, false },
  { "Media Lengua",                                               "mue",     "",   "",    false, false },
  { "Mediak",                                                     "mwx",     "",   "",    false, true  },
  { "Median",                                                     "xme",     "",   "",    false, false },
  { "Mednyj Aleut",                                               "mud",     "",   "",    false, false },
  { "Medumba",                                                    "byv",     "",   "",    false, false },
  { "Mefele",                                                     "mfj",     "",   "",    false, false },
  { "Megam",                                                      "mef",     "",   "",    false, false },
  { "Megleno Romanian",                                           "ruq",     "",   "",    false, false },
  { "Mehek",                                                      "nux",     "",   "",    false, false },
  { "Mehináku",                                                   "mmh",     "",   "",    false, false },
  { "Mehri",                                                      "gdq",     "",   "",    false, false },
  { "Mekeo",                                                      "mek",     "",   "",    false, false },
  { "Mekmek",                                                     "mvk",     "",   "",    false, false },
  { "Mekwei",                                                     "msf",     "",   "",    false, false },
  { "Mel-Khaonh",                                                 "hkn",     "",   "",    false, false },
  { "Mele-Fila",                                                  "mxe",     "",   "",    false, false },
  { "Melo",                                                       "mfx",     "",   "",    false, false },
  { "Melpa",                                                      "med",     "",   "",    false, false },
  { "Memoni",                                                     "mby",     "",   "",    false, false },
  { "Mendalam Kayan",                                             "xkd",     "",   "",    false, false },
  { "Mendankwe-Nkwen",                                            "mfd",     "",   "",    false, false },
  { "Mende (Papua New Guinea)",                                   "sim",     "",   "",    false, false },
  { "Mende (Sierra Leone)",                                       "men",     "",   "",    true,  false },
  { "Mengaka",                                                    "xmg",     "",   "",    false, false },
  { "Mengen",                                                     "mee",     "",   "",    false, false },
  { "Mengisa",                                                    "mct",     "",   "",    false, false },
  { "Menka",                                                      "mea",     "",   "",    false, false },
  { "Menominee",                                                  "mez",     "",   "",    false, false },
  { "Mentawai",                                                   "mwv",     "",   "",    false, false },
  { "Menya",                                                      "mcr",     "",   "",    false, false },
  { "Meoswar",                                                    "mvx",     "",   "",    false, false },
  { "Mer",                                                        "mnu",     "",   "",    false, false },
  { "Meramera",                                                   "mxm",     "",   "",    false, false },
  { "Merei",                                                      "lmb",     "",   "",    false, false },
  { "Merey",                                                      "meq",     "",   "",    false, false },
  { "Meriam Mir",                                                 "ulk",     "",   "",    false, false },
  { "Merlav",                                                     "mrm",     "",   "",    false, false },
  { "Meroitic",                                                   "xmr",     "",   "",    false, false },
  { "Meru",                                                       "mer",     "",   "",    false, false },
  { "Merwari",                                                    "wry",     "",   "",    false, false },
  { "Mesaka",                                                     "iyo",     "",   "",    false, false },
  { "Mescalero-Chiricahua Apache",                                "apm",     "",   "",    false, false },
  { "Mese",                                                       "mci",     "",   "",    false, false },
  { "Meskwaki",                                                   "sac",     "",   "",    false, false },
  { "Mesme",                                                      "zim",     "",   "",    false, false },
  { "Mesmes",                                                     "mys",     "",   "",    false, false },
  { "Mesopotamian Arabic",                                        "acm",     "",   "",    false, false },
  { "Mesqan",                                                     "mvz",     "",   "",    false, false },
  { "Messapic",                                                   "cms",     "",   "",    false, false },
  { "Meta'",                                                      "mgo",     "",   "",    false, false },
  { "Metlatónoc Mixtec",                                          "mxv",     "",   "",    false, false },
  { "Mewari",                                                     "mtr",     "",   "",    false, false },
  { "Mewati",                                                     "wtm",     "",   "",    false, false },
  { "Mexican Sign Language",                                      "mfs",     "",   "",    false, false },
  { "Meyah",                                                      "mej",     "",   "",    false, false },
  { "Mezontla Popoloca",                                          "pbe",     "",   "",    false, false },
  { "Mezquital Otomi",                                            "ote",     "",   "",    false, false },
  { "Mfinu",                                                      "zmf",     "",   "",    false, false },
  { "Mfumte",                                                     "nfu",     "",   "",    false, false },
  { "Mgbolizhia",                                                 "gmz",     "",   "",    false, false },
  { "Mi'kmaq",                                                    "mic",     "",   "",    true,  false },
  { "Miahuatlán Zapotec",                                         "zam",     "",   "",    false, false },
  { "Miami",                                                      "mia",     "",   "",    false, false },
  { "Mian",                                                       "mpt",     "",   "",    false, false },
  { "Miani",                                                      "pla",     "",   "",    false, false },
  { "Michif",                                                     "crg",     "",   "",    false, false },
  { "Michigamea",                                                 "cmm",     "",   "",    false, false },
  { "Michoacán Mazahua",                                          "mmc",     "",   "",    false, false },
  { "Michoacán Nahuatl",                                          "ncl",     "",   "",    false, false },
  { "Mid Grand Valley Dani",                                      "dnt",     "",   "",    false, false },
  { "Mid-Southern Banda",                                         "bjo",     "",   "",    false, false },
  { "Middle Armenian",                                            "axm",     "",   "",    false, false },
  { "Middle Breton",                                              "xbm",     "",   "",    false, false },
  { "Middle Cornish",                                             "cnx",     "",   "",    false, false },
  { "Middle Dutch (ca. 1050-1350)",                               "dum",     "",   "",    true,  false },
  { "Middle English (1100-1500)",                                 "enm",     "",   "",    true,  false },
  { "Middle French (ca. 1400-1600)",                              "frm",     "",   "",    true,  false },
  { "Middle High German (ca. 1050-1500)",                         "gmh",     "",   "",    true,  false },
  { "Middle Hittite",                                             "htx",     "",   "",    false, false },
  { "Middle Irish (900-1200)",                                    "mga",     "",   "",    true,  false },
  { "Middle Khmer (1400 to 1850 CE)",                             "xhm",     "",   "",    false, false },
  { "Middle Korean (10th-16th cent.)",                            "okm",     "",   "",    false, false },
  { "Middle Low German",                                          "gml",     "",   "",    false, false },
  { "Middle Mongolian",                                           "xng",     "",   "",    false, false },
  { "Middle Newar",                                               "nwx",     "",   "",    false, false },
  { "Middle Watut",                                               "mpl",     "",   "",    false, false },
  { "Middle Welsh",                                               "wlm",     "",   "",    false, false },
  { "Midob",                                                      "mei",     "",   "",    false, false },
  { "Migaama",                                                    "mmy",     "",   "",    false, false },
  { "Migabac",                                                    "mpp",     "",   "",    false, false },
  { "Migum",                                                      "klm",     "",   "",    false, false },
  { "Miju-Mishmi",                                                "mxj",     "",   "",    false, false },
  { "Mikasuki",                                                   "mik",     "",   "",    false, false },
  { "Mili",                                                       "ymh",     "",   "",    false, false },
  { "Miltu",                                                      "mlj",     "",   "",    false, false },
  { "Miluk",                                                      "iml",     "",   "",    false, false },
  { "Milyan",                                                     "imy",     "",   "",    false, false },
  { "Min Bei Chinese",                                            "mnp",     "",   "",    false, false },
  { "Min Dong Chinese",                                           "cdo",     "",   "",    false, false },
  { "Min Nan Chinese",                                            "nan",     "",   "",    false, false },
  { "Min Zhong Chinese",                                          "czo",     "",   "",    false, false },
  { "Mina (Cameroon)",                                            "hna",     "",   "",    false, false },
  { "Mina (India)",                                               "myi",     "",   "",    false, true  },
  { "Minaean",                                                    "inm",     "",   "",    false, false },
  { "Minang",                                                     "xrg",     "",   "",    false, false },
  { "Minangkabau",                                                "min",     "",   "",    true,  false },
  { "Minanibai",                                                  "mcv",     "",   "",    false, false },
  { "Minaveha",                                                   "mvn",     "",   "",    false, false },
  { "Minderico",                                                  "drc",     "",   "",    false, false },
  { "Mindiri",                                                    "mpn",     "",   "",    false, false },
  { "Mingang Doso",                                               "mko",     "",   "",    false, false },
  { "Mingrelian",                                                 "xmf",     "",   "",    false, false },
  { "Minica Huitoto",                                             "hto",     "",   "",    false, false },
  { "Minidien",                                                   "wii",     "",   "",    false, false },
  { "Minjungbal",                                                 "xjb",     "",   "",    false, false },
  { "Minkin",                                                     "xxm",     "",   "",    false, false },
  { "Minoan",                                                     "omn",     "",   "",    false, false },
  { "Minokok",                                                    "mqq",     "",   "",    false, false },
  { "Minriq",                                                     "mnq",     "",   "",    false, false },
  { "Mintil",                                                     "mzt",     "",   "",    false, false },
  { "Minz Zhuang",                                                "zgm",     "",   "",    false, false },
  { "Miqie",                                                      "yiq",     "",   "",    false, false },
  { "Mirandese",                                                  "mwl",     "",   "",    true,  false },
  { "Miraya Bikol",                                               "rbl",     "",   "",    false, false },
  { "Mirgan",                                                     "zrg",     "",   "",    false, false },
  { "Miriti",                                                     "mmv",     "",   "",    false, false },
  { "Miriwoong Sign Language",                                    "rsm",     "",   "",    false, false },
  { "Miriwoong",                                                  "mep",     "",   "",    false, false },
  { "Mirning",                                                    "gmr",     "",   "",    false, false },
  { "Mirpur Panjabi",                                             "pmu",     "",   "",    false, true  },
  { "Miship",                                                     "mjs",     "",   "",    false, false },
  { "Misima-Panaeati",                                            "mpx",     "",   "",    false, false },
  { "Mising",                                                     "mrg",     "",   "",    false, false },
  { "Mitla Zapotec",                                              "zaw",     "",   "",    false, false },
  { "Mitlatongo Mixtec",                                          "vmm",     "",   "",    false, false },
  { "Mittu",                                                      "mwu",     "",   "",    false, false },
  { "Mituku",                                                     "zmq",     "",   "",    false, false },
  { "Miu",                                                        "mpo",     "",   "",    false, false },
  { "Miwa",                                                       "vmi",     "",   "",    false, false },
  { "Mixed Great Andamanese",                                     "gac",     "",   "",    false, false },
  { "Mixtepec Mixtec",                                            "mix",     "",   "",    false, false },
  { "Mixtepec Zapotec",                                           "zpm",     "",   "",    false, false },
  { "Miya",                                                       "mkf",     "",   "",    false, false },
  { "Miyako",                                                     "mvi",     "",   "",    false, false },
  { "Miyakubo Sign Language",                                     "ehs",     "",   "",    false, false },
  { "Miyobe",                                                     "soy",     "",   "",    false, false },
  { "Mlabri",                                                     "mra",     "",   "",    false, false },
  { "Mlahsö",                                                     "lhs",     "",   "",    false, false },
  { "Mlap",                                                       "kja",     "",   "",    false, false },
  { "Mlomp",                                                      "mlo",     "",   "",    false, false },
  { "Mmaala",                                                     "mmu",     "",   "",    false, false },
  { "Mmen",                                                       "bfm",     "",   "",    false, false },
  { "Mo'da",                                                      "gbn",     "",   "",    false, false },
  { "Moabite",                                                    "obm",     "",   "",    false, false },
  { "Moba",                                                       "mfq",     "",   "",    false, false },
  { "Mobilian",                                                   "mod",     "",   "",    false, false },
  { "Mobumrin Aizi",                                              "ahm",     "",   "",    false, false },
  { "Mobwa Karen",                                                "jkm",     "",   "",    false, false },
  { "Mochi",                                                      "old",     "",   "",    false, false },
  { "Mochica",                                                    "omc",     "",   "",    false, false },
  { "Mocho",                                                      "mhc",     "",   "",    false, false },
  { "Mocoví",                                                     "moc",     "",   "",    false, false },
  { "Modang",                                                     "mxd",     "",   "",    false, false },
  { "Modole",                                                     "mqo",     "",   "",    false, false },
  { "Moere",                                                      "mvq",     "",   "",    false, false },
  { "Mofu-Gudur",                                                 "mif",     "",   "",    false, false },
  { "Mogholi",                                                    "mhj",     "",   "",    false, false },
  { "Mogofin",                                                    "mfg",     "",   "",    false, false },
  { "Mogum",                                                      "mou",     "",   "",    false, false },
  { "Mohave",                                                     "mov",     "",   "",    false, false },
  { "Mohawk",                                                     "moh",     "",   "",    true,  false },
  { "Mohegan-Montauk-Narragansett",                               "mof",     "",   "",    false, true  },
  { "Mohegan-Pequot",                                             "xpq",     "",   "",    false, false },
  { "Moi (Congo)",                                                "mow",     "",   "",    false, false },
  { "Moi (Indonesia)",                                            "mxn",     "",   "",    false, false },
  { "Moi-Wadea",                                                  "daz",     "",   "",    false, false },
  { "Moikodi",                                                    "mkp",     "",   "",    false, false },
  { "Moingi",                                                     "mwz",     "",   "",    false, false },
  { "Moji",                                                       "ymi",     "",   "",    false, false },
  { "Mok",                                                        "mqt",     "",   "",    false, false },
  { "Mokati",                                                     "wnb",     "",   "",    false, false },
  { "Moken",                                                      "mwt",     "",   "",    false, false },
  { "Mokerang",                                                   "mft",     "",   "",    false, false },
  { "Mokilese",                                                   "mkj",     "",   "",    false, false },
  { "Moklen",                                                     "mkm",     "",   "",    false, false },
  { "Mokole",                                                     "mkl",     "",   "",    false, false },
  { "Mokpwe",                                                     "bri",     "",   "",    false, false },
  { "Moksela",                                                    "vms",     "",   "",    false, false },
  { "Moksha",                                                     "mdf",     "",   "",    true,  false },
  { "Molale",                                                     "mbe",     "",   "",    false, false },
  { "Molbog",                                                     "pwm",     "",   "",    false, false },
  { "Moldova Sign Language",                                      "vsi",     "",   "",    false, false },
  { "Molengue",                                                   "bxc",     "",   "",    false, false },
  { "Molima",                                                     "mox",     "",   "",    false, false },
  { "Molmo One",                                                  "aun",     "",   "",    false, false },
  { "Molo",                                                       "zmo",     "",   "",    false, false },
  { "Molof",                                                      "msl",     "",   "",    false, false },
  { "Moloko",                                                     "mlw",     "",   "",    false, false },
  { "Mom Jango",                                                  "ver",     "",   "",    false, false },
  { "Moma",                                                       "myl",     "",   "",    false, false },
  { "Momare",                                                     "msz",     "",   "",    false, false },
  { "Mombo Dogon",                                                "dmb",     "",   "",    false, false },
  { "Mombum",                                                     "mso",     "",   "",    false, false },
  { "Momina",                                                     "mmb",     "",   "",    false, false },
  { "Momuna",                                                     "mqf",     "",   "",    false, false },
  { "Mon",                                                        "mnw",     "",   "",    false, false },
  { "Mon-Khmer languages",                                        "mkh",     "",   "",    true,  false },
  { "Monastic Sign Language",                                     "mzg",     "",   "",    false, false },
  { "Mondropolon",                                                "npn",     "",   "",    false, false },
  { "Mondé",                                                      "mnd",     "",   "",    false, false },
  { "Mongo",                                                      "lol",     "",   "",    true,  false },
  { "Mongol",                                                     "mgt",     "",   "",    false, false },
  { "Mongolia Buriat",                                            "bxm",     "",   "",    false, false },
  { "Mongolian Sign Language",                                    "msr",     "",   "",    false, false },
  { "Mongolian languages",                                        "xgn",     "",   "",    false, false },
  { "Mongolian",                                                  "mon",     "mn", "",    true,  false },
  { "Mongondow",                                                  "mog",     "",   "",    false, false },
  { "Moni",                                                       "mnz",     "",   "",    false, false },
  { "Mono (Cameroon)",                                            "mru",     "",   "",    false, false },
  { "Mono (Democratic Republic of Congo)",                        "mnh",     "",   "",    false, false },
  { "Mono (Solomon Islands)",                                     "mte",     "",   "",    false, false },
  { "Mono (USA)",                                                 "mnr",     "",   "",    false, false },
  { "Monom",                                                      "moo",     "",   "",    false, false },
  { "Monsang Naga",                                               "nmh",     "",   "",    false, false },
  { "Montenegrin",                                                "cnr",     "",   "",    true,  false },
  { "Montol",                                                     "mtl",     "",   "",    false, false },
  { "Monumbo",                                                    "mxk",     "",   "",    false, false },
  { "Monzombo",                                                   "moj",     "",   "",    false, false },
  { "Moo",                                                        "gwg",     "",   "",    false, false },
  { "Moose Cree",                                                 "crm",     "",   "",    false, false },
  { "Mopán Maya",                                                 "mop",     "",   "",    false, false },
  { "Mor (Bomberai Peninsula)",                                   "moq",     "",   "",    false, false },
  { "Mor (Mor Islands)",                                          "mhz",     "",   "",    false, false },
  { "Moraid",                                                     "msg",     "",   "",    false, false },
  { "Morawa",                                                     "mze",     "",   "",    false, false },
  { "Morelos Nahuatl",                                            "nhm",     "",   "",    false, false },
  { "Morerebi",                                                   "xmo",     "",   "",    false, false },
  { "Moresada",                                                   "msx",     "",   "",    false, false },
  { "Mori Atas",                                                  "mzq",     "",   "",    false, false },
  { "Mori Bawah",                                                 "xmz",     "",   "",    false, false },
  { "Morigi",                                                     "mdb",     "",   "",    false, false },
  { "Moriori",                                                    "rrm",     "",   "",    false, false },
  { "Morisyen",                                                   "mfe",     "",   "",    false, false },
  { "Moro",                                                       "mor",     "",   "",    false, false },
  { "Moroccan Arabic",                                            "ary",     "",   "",    false, false },
  { "Moroccan Sign Language",                                     "xms",     "",   "",    false, false },
  { "Morokodo",                                                   "mgc",     "",   "",    false, false },
  { "Morom",                                                      "bdo",     "",   "",    false, false },
  { "Moronene",                                                   "mqn",     "",   "",    false, false },
  { "Morori",                                                     "mok",     "",   "",    false, false },
  { "Morouas",                                                    "mrp",     "",   "",    false, false },
  { "Morrobalama",                                                "umg",     "",   "",    false, false },
  { "Mortlockese",                                                "mrl",     "",   "",    false, false },
  { "Moru",                                                       "mgd",     "",   "",    false, false },
  { "Mosimo",                                                     "mqv",     "",   "",    false, false },
  { "Mosiro",                                                     "mwy",     "",   "",    false, true  },
  { "Moskona",                                                    "mtj",     "",   "",    false, false },
  { "Mossi",                                                      "mos",     "",   "",    true,  false },
  { "Mota",                                                       "mtt",     "",   "",    false, false },
  { "Motlav",                                                     "mlv",     "",   "",    false, false },
  { "Motu",                                                       "meu",     "",   "",    false, false },
  { "Mouk-Aria",                                                  "mwh",     "",   "",    false, false },
  { "Moundadan Chetty",                                           "cty",     "",   "",    false, false },
  { "Mountain Koiali",                                            "kpx",     "",   "",    false, false },
  { "Mouwase",                                                    "jmw",     "",   "",    false, false },
  { "Movima",                                                     "mzp",     "",   "",    false, false },
  { "Moyadan Itneg",                                              "ity",     "",   "",    false, false },
  { "Moyon Naga",                                                 "nmo",     "",   "",    false, false },
  { "Mozambican Sign Language",                                   "mzy",     "",   "",    false, false },
  { "Mozarabic",                                                  "mxi",     "",   "",    false, false },
  { "Mpade",                                                      "mpi",     "",   "",    false, false },
  { "Mpalitjanh",                                                 "xpj",     "",   "",    false, false },
  { "Mpi",                                                        "mpz",     "",   "",    false, false },
  { "Mpiemo",                                                     "mcx",     "",   "",    false, false },
  { "Mpinda",                                                     "pnd",     "",   "",    false, false },
  { "Mpoto",                                                      "mpa",     "",   "",    false, false },
  { "Mpotovoro",                                                  "mvt",     "",   "",    false, false },
  { "Mpumpong",                                                   "mgg",     "",   "",    false, false },
  { "Mpuono",                                                     "zmp",     "",   "",    false, false },
  { "Mpur",                                                       "akc",     "",   "",    false, false },
  { "Mro-Khimi Chin",                                             "cmr",     "",   "",    false, false },
  { "Mru",                                                        "mro",     "",   "",    false, false },
  { "Mser",                                                       "kqx",     "",   "",    false, false },
  { "Mt. Iraya Agta",                                             "atl",     "",   "",    false, false },
  { "Mt. Iriga Agta",                                             "agz",     "",   "",    false, false },
  { "Muak Sa-aak",                                                "ukk",     "",   "",    false, false },
  { "Mualang",                                                    "mtd",     "",   "",    false, false },
  { "Mubami",                                                     "tsx",     "",   "",    false, false },
  { "Mubi",                                                       "mub",     "",   "",    false, false },
  { "Muda",                                                       "ymd",     "",   "",    false, false },
  { "Mudbura",                                                    "mwd",     "",   "",    false, true  },
  { "Mudburra",                                                   "dmw",     "",   "",    false, false },
  { "Mudhili Gadaba",                                             "gau",     "",   "",    false, false },
  { "Mudu Koraga",                                                "vmd",     "",   "",    false, false },
  { "Muduga",                                                     "udg",     "",   "",    false, false },
  { "Mufian",                                                     "aoj",     "",   "",    false, false },
  { "Mugom",                                                      "muk",     "",   "",    false, false },
  { "Muinane",                                                    "bmr",     "",   "",    false, false },
  { "Mukha-Dora",                                                 "mmk",     "",   "",    false, false },
  { "Mukulu",                                                     "moz",     "",   "",    false, false },
  { "Mulaha",                                                     "mfw",     "",   "",    false, false },
  { "Mulam",                                                      "mlm",     "",   "",    false, false },
  { "Mulao",                                                      "giu",     "",   "",    false, false },
  { "Mulgi",                                                      "mvh",     "",   "",    false, false },
  { "Mullu Kurumba",                                              "kpb",     "",   "",    false, false },
  { "Multiple languages",                                         "mul",     "",   "",    true,  false },
  { "Muluridyi",                                                  "vmu",     "",   "",    false, false },
  { "Mum",                                                        "kqa",     "",   "",    false, false },
  { "Mumuye",                                                     "mzm",     "",   "",    false, false },
  { "Muna",                                                       "mnb",     "",   "",    false, false },
  { "Munda languages",                                            "mun",     "",   "",    true,  false },
  { "Munda",                                                      "unx",     "",   "",    false, false },
  { "Mundabli",                                                   "boe",     "",   "",    false, false },
  { "Mundang",                                                    "mua",     "",   "",    false, false },
  { "Mundani",                                                    "mnf",     "",   "",    false, false },
  { "Mundari",                                                    "unr",     "",   "",    false, false },
  { "Mundat",                                                     "mmf",     "",   "",    false, false },
  { "Mundurukú",                                                  "myu",     "",   "",    false, false },
  { "Mungaka",                                                    "mhk",     "",   "",    false, false },
  { "Munggui",                                                    "mth",     "",   "",    false, false },
  { "Mungkip",                                                    "mpv",     "",   "",    false, false },
  { "Muniche",                                                    "myr",     "",   "",    false, false },
  { "Munit",                                                      "mtc",     "",   "",    false, false },
  { "Munji",                                                      "mnj",     "",   "",    false, false },
  { "Munsee",                                                     "umu",     "",   "",    false, false },
  { "Muong",                                                      "mtq",     "",   "",    false, false },
  { "Mur Pano",                                                   "tkv",     "",   "",    false, false },
  { "Muratayak",                                                  "asx",     "",   "",    false, false },
  { "Murik (Malaysia)",                                           "mxr",     "",   "",    false, false },
  { "Murik (Papua New Guinea)",                                   "mtf",     "",   "",    false, false },
  { "Murkim",                                                     "rmh",     "",   "",    false, false },
  { "Murle",                                                      "mur",     "",   "",    false, false },
  { "Murrinh-Patha",                                              "mwf",     "",   "",    false, false },
  { "Mursi",                                                      "muz",     "",   "",    false, false },
  { "Murui Huitoto",                                              "huu",     "",   "",    false, false },
  { "Murupi",                                                     "mqw",     "",   "",    false, false },
  { "Muruwari",                                                   "zmu",     "",   "",    false, false },
  { "Musak",                                                      "mmq",     "",   "",    false, false },
  { "Musasa",                                                     "smm",     "",   "",    false, false },
  { "Musey",                                                      "mse",     "",   "",    false, false },
  { "Musgu",                                                      "mug",     "",   "",    false, false },
  { "Mushungulu",                                                 "xma",     "",   "",    false, false },
  { "Musi",                                                       "mui",     "",   "",    false, false },
  { "Muskum",                                                     "mje",     "",   "",    false, false },
  { "Muslim Tat",                                                 "ttt",     "",   "",    false, false },
  { "Musom",                                                      "msu",     "",   "",    false, false },
  { "Mussau-Emira",                                               "emi",     "",   "",    false, false },
  { "Muthuvan",                                                   "muv",     "",   "",    false, false },
  { "Mutu",                                                       "tuc",     "",   "",    false, false },
  { "Muya",                                                       "mvm",     "",   "",    false, true  },
  { "Muyang",                                                     "muy",     "",   "",    false, false },
  { "Muyuw",                                                      "myw",     "",   "",    false, false },
  { "Muzi",                                                       "ymz",     "",   "",    false, false },
  { "Mvanip",                                                     "mcj",     "",   "",    false, false },
  { "Mvuba",                                                      "mxh",     "",   "",    false, false },
  { "Mwaghavul",                                                  "sur",     "",   "",    false, false },
  { "Mwali Comorian",                                             "wlc",     "",   "",    false, false },
  { "Mwan",                                                       "moa",     "",   "",    false, false },
  { "Mwani",                                                      "wmw",     "",   "",    false, false },
  { "Mwatebu",                                                    "mwa",     "",   "",    false, false },
  { "Mwera (Chimwera)",                                           "mwe",     "",   "",    false, false },
  { "Mwera (Nyasa)",                                              "mjh",     "",   "",    false, false },
  { "Mwimbi-Muthambi",                                            "mws",     "",   "",    false, false },
  { "Myanmar Sign Language",                                      "ysm",     "",   "",    false, false },
  { "Mycenaean Greek",                                            "gmy",     "",   "",    false, false },
  { "Myene",                                                      "mye",     "",   "",    false, false },
  { "Mysian",                                                     "yms",     "",   "",    false, false },
  { "Mzieme Naga",                                                "nme",     "",   "",    false, false },
  { "Mághdì",                                                     "gmd",     "",   "",    false, false },
  { "Máku",                                                       "xak",     "",   "",    false, false },
  { "Ménik",                                                      "tnr",     "",   "",    false, false },
  { "Mískito",                                                    "miq",     "",   "",    false, false },
  { "Mócheno",                                                    "mhn",     "",   "",    false, false },
  { "Mün Chin",                                                   "mwq",     "",   "",    false, false },
  { "Mündü",                                                      "muh",     "",   "",    false, false },
  { "Māhārāṣṭri Prākrit",                                         "pmh",     "",   "",    false, false },
  { "N'Ko",                                                       "nqo",     "",   "",    true,  false },
  { "Na",                                                         "nbt",     "",   "",    false, false },
  { "Na-Dene languages",                                          "xnd",     "",   "",    false, false },
  { "Na-kara",                                                    "nck",     "",   "",    false, false },
  { "Naaba",                                                      "nao",     "",   "",    false, false },
  { "Naami",                                                      "bzv",     "",   "",    false, false },
  { "Naasioi",                                                    "nas",     "",   "",    false, false },
  { "Naba",                                                       "mne",     "",   "",    false, false },
  { "Nabak",                                                      "naf",     "",   "",    false, false },
  { "Nabi",                                                       "mty",     "",   "",    false, false },
  { "Nachering",                                                  "ncd",     "",   "",    false, false },
  { "Nadruvian",                                                  "ndf",     "",   "",    false, false },
  { "Nadëb",                                                      "mbj",     "",   "",    false, false },
  { "Nafaanra",                                                   "nfr",     "",   "",    false, false },
  { "Nafi",                                                       "srf",     "",   "",    false, false },
  { "Nafri",                                                      "nxx",     "",   "",    false, false },
  { "Nafusi",                                                     "jbn",     "",   "",    false, false },
  { "Naga Pidgin",                                                "nag",     "",   "",    false, false },
  { "Nagarchal",                                                  "nbg",     "",   "",    false, false },
  { "Nage",                                                       "nxe",     "",   "",    false, false },
  { "Nagumi",                                                     "ngv",     "",   "",    false, false },
  { "Nahali",                                                     "nlx",     "",   "",    false, false },
  { "Nahari",                                                     "nhh",     "",   "",    false, false },
  { "Nahuatl languages",                                          "nah",     "",   "",    true,  false },
  { "Nai",                                                        "bio",     "",   "",    false, false },
  { "Najdi Arabic",                                               "ars",     "",   "",    false, false },
  { "Naka'ela",                                                   "nae",     "",   "",    false, false },
  { "Nakai",                                                      "nkj",     "",   "",    false, false },
  { "Nakame",                                                     "nib",     "",   "",    false, false },
  { "Nakanai",                                                    "nak",     "",   "",    false, false },
  { "Nake",                                                       "nbk",     "",   "",    false, false },
  { "Naki",                                                       "mff",     "",   "",    false, false },
  { "Nakwi",                                                      "nax",     "",   "",    false, false },
  { "Nalca",                                                      "nlc",     "",   "",    false, false },
  { "Nali",                                                       "nss",     "",   "",    false, false },
  { "Nalik",                                                      "nal",     "",   "",    false, false },
  { "Nalu",                                                       "naj",     "",   "",    false, false },
  { "Naluo Yi",                                                   "ylo",     "",   "",    false, false },
  { "Nalögo",                                                     "nlz",     "",   "",    false, false },
  { "Nama (Papua New Guinea)",                                    "nmx",     "",   "",    false, false },
  { "Namakura",                                                   "nmk",     "",   "",    false, false },
  { "Namat",                                                      "nkm",     "",   "",    false, false },
  { "Nambo",                                                      "ncm",     "",   "",    false, false },
  { "Nambya",                                                     "nmq",     "",   "",    false, false },
  { "Namia",                                                      "nnm",     "",   "",    false, false },
  { "Namiae",                                                     "nvm",     "",   "",    false, false },
  { "Namibian Sign Language",                                     "nbs",     "",   "",    false, false },
  { "Namla",                                                      "naa",     "",   "",    false, false },
  { "Namo",                                                       "mxw",     "",   "",    false, false },
  { "Namonuito",                                                  "nmt",     "",   "",    false, false },
  { "Namosi-Naitasiri-Serua",                                     "bwb",     "",   "",    false, false },
  { "Namuyi",                                                     "nmy",     "",   "",    false, false },
  { "Nanai",                                                      "gld",     "",   "",    false, false },
  { "Nancere",                                                    "nnc",     "",   "",    false, false },
  { "Nande",                                                      "nnb",     "",   "",    false, false },
  { "Nandi",                                                      "niq",     "",   "",    false, false },
  { "Nanerigé Sénoufo",                                           "sen",     "",   "",    false, false },
  { "Nanga Dama Dogon",                                           "nzz",     "",   "",    false, false },
  { "Nankina",                                                    "nnk",     "",   "",    false, false },
  { "Nanti",                                                      "cox",     "",   "",    false, false },
  { "Nanticoke",                                                  "nnt",     "",   "",    false, false },
  { "Nanubae",                                                    "afk",     "",   "",    false, false },
  { "Napo Lowland Quechua",                                       "qvo",     "",   "",    false, false },
  { "Napu",                                                       "npy",     "",   "",    false, false },
  { "Nar Phu",                                                    "npa",     "",   "",    false, false },
  { "Nara",                                                       "nrb",     "",   "",    false, false },
  { "Narak",                                                      "nac",     "",   "",    false, false },
  { "Narango",                                                    "nrg",     "",   "",    false, false },
  { "Narau",                                                      "nxu",     "",   "",    false, true  },
  { "Nari Nari",                                                  "rnr",     "",   "",    false, false },
  { "Naro",                                                       "nhr",     "",   "",    false, false },
  { "Narom",                                                      "nrm",     "",   "",    false, false },
  { "Narragansett",                                               "xnt",     "",   "",    false, false },
  { "Narua",                                                      "nru",     "",   "",    false, false },
  { "Narungga",                                                   "nnr",     "",   "",    false, false },
  { "Nasal",                                                      "nsy",     "",   "",    false, false },
  { "Nasarian",                                                   "nvh",     "",   "",    false, false },
  { "Naskapi",                                                    "nsk",     "",   "",    false, false },
  { "Natagaimas",                                                 "nts",     "",   "",    false, true  },
  { "Natanzi",                                                    "ntz",     "",   "",    false, false },
  { "Nataoran Amis",                                              "ais",     "",   "",    false, true  },
  { "Natchez",                                                    "ncz",     "",   "",    false, false },
  { "Nateni",                                                     "ntm",     "",   "",    false, false },
  { "Nathembo",                                                   "nte",     "",   "",    false, true  },
  { "Natioro",                                                    "nti",     "",   "",    false, false },
  { "Natügu",                                                     "ntu",     "",   "",    false, false },
  { "Nauete",                                                     "nxa",     "",   "",    false, false },
  { "Naukan Yupik",                                               "ynk",     "",   "",    false, false },
  { "Nauna",                                                      "ncn",     "",   "",    false, false },
  { "Nauo",                                                       "nwo",     "",   "",    false, false },
  { "Nauru",                                                      "nau",     "na", "",    true,  false },
  { "Navajo",                                                     "nav",     "nv", "",    true,  false },
  { "Navut",                                                      "nsw",     "",   "",    false, false },
  { "Nawaru",                                                     "nwr",     "",   "",    false, false },
  { "Nawathinehena",                                              "nwa",     "",   "",    false, false },
  { "Nawdm",                                                      "nmz",     "",   "",    false, false },
  { "Nawuri",                                                     "naw",     "",   "",    false, false },
  { "Naxi",                                                       "nbf",     "",   "",    false, true  },
  { "Naxi",                                                       "nxq",     "",   "",    false, false },
  { "Nayi",                                                       "noz",     "",   "",    false, false },
  { "Nayini",                                                     "nyq",     "",   "",    false, false },
  { "Ncane",                                                      "ncr",     "",   "",    false, false },
  { "Nchumbulu",                                                  "nlu",     "",   "",    false, false },
  { "Nda'nda'",                                                   "nnz",     "",   "",    false, false },
  { "Ndai",                                                       "gke",     "",   "",    false, false },
  { "Ndaka",                                                      "ndk",     "",   "",    false, false },
  { "Ndaktup",                                                    "ncp",     "",   "",    false, true  },
  { "Ndali",                                                      "ndh",     "",   "",    false, false },
  { "Ndam",                                                       "ndm",     "",   "",    false, false },
  { "Ndamba",                                                     "ndj",     "",   "",    false, false },
  { "Ndambomo",                                                   "nxo",     "",   "",    false, false },
  { "Ndasa",                                                      "nda",     "",   "",    false, false },
  { "Ndau",                                                       "ndc",     "",   "",    false, false },
  { "Nde-Gbite",                                                  "ned",     "",   "",    false, false },
  { "Nde-Nsele-Nta",                                              "ndd",     "",   "",    false, false },
  { "Ndemli",                                                     "nml",     "",   "",    false, false },
  { "Ndendeule",                                                  "dne",     "",   "",    false, false },
  { "Ndengereko",                                                 "ndg",     "",   "",    false, false },
  { "Nding",                                                      "eli",     "",   "",    false, false },
  { "Ndo",                                                        "ndp",     "",   "",    false, false },
  { "Ndobo",                                                      "ndw",     "",   "",    false, false },
  { "Ndoe",                                                       "nbb",     "",   "",    false, false },
  { "Ndogo",                                                      "ndz",     "",   "",    false, false },
  { "Ndolo",                                                      "ndl",     "",   "",    false, false },
  { "Ndom",                                                       "nqm",     "",   "",    false, false },
  { "Ndombe",                                                     "ndq",     "",   "",    false, false },
  { "Ndonde Hamba",                                               "njd",     "",   "",    false, false },
  { "Ndonga",                                                     "ndo",     "ng", "",    true,  false },
  { "Ndoola",                                                     "ndr",     "",   "",    false, false },
  { "Ndra'ngith",                                                 "dgt",     "",   "",    false, false },
  { "Ndrulo",                                                     "dno",     "",   "",    false, false },
  { "Nduga",                                                      "ndx",     "",   "",    false, false },
  { "Ndumu",                                                      "nmd",     "",   "",    false, false },
  { "Ndunda",                                                     "nuh",     "",   "",    false, false },
  { "Ndunga",                                                     "ndt",     "",   "",    false, false },
  { "Ndut",                                                       "ndv",     "",   "",    false, false },
  { "Ndwewe",                                                     "nww",     "",   "",    false, false },
  { "Ndyuka-Trio Pidgin",                                         "njt",     "",   "",    false, false },
  { "Ndzwani Comorian",                                           "wni",     "",   "",    false, false },
  { "Neapolitan",                                                 "nap",     "",   "",    true,  false },
  { "Nedebang",                                                   "nec",     "",   "",    false, false },
  { "Nefamese",                                                   "nef",     "",   "",    false, false },
  { "Negerhollands",                                              "dcr",     "",   "",    false, false },
  { "Negeri Sembilan Malay",                                      "zmi",     "",   "",    false, false },
  { "Negidal",                                                    "neg",     "",   "",    false, false },
  { "Nehan",                                                      "nsn",     "",   "",    false, false },
  { "Nek",                                                        "nif",     "",   "",    false, false },
  { "Nekgini",                                                    "nkg",     "",   "",    false, false },
  { "Neko",                                                       "nej",     "",   "",    false, false },
  { "Neku",                                                       "nek",     "",   "",    false, false },
  { "Nema",                                                       "gsn",     "",   "",    false, false },
  { "Neme",                                                       "nex",     "",   "",    false, false },
  { "Nemi",                                                       "nem",     "",   "",    false, false },
  { "Nen",                                                        "nqn",     "",   "",    false, false },
  { "Nend",                                                       "anh",     "",   "",    false, false },
  { "Nenets",                                                     "yrk",     "",   "",    false, false },
  { "Nengone",                                                    "nen",     "",   "",    false, false },
  { "Neo",                                                        "neu",     "",   "",    false, false },
  { "Neo-Hittite",                                                "nei",     "",   "",    false, false },
  { "Nepal Bhasa",                                                "new",     "",   "",    true,  false },
  { "Nepalese Sign Language",                                     "nsp",     "",   "",    false, false },
  { "Nepali (individual language)",                               "npi",     "",   "",    false, false },
  { "Nepali (macrolanguage)",                                     "nep",     "ne", "",    true,  false },
  { "Nepali Kurux",                                               "kxl",     "",   "",    false, true  },
  { "Nete",                                                       "net",     "",   "",    false, false },
  { "New Caledonian Javanese",                                    "jas",     "",   "",    false, false },
  { "New Zealand Sign Language",                                  "nzs",     "",   "",    false, false },
  { "Neyo",                                                       "ney",     "",   "",    false, false },
  { "Nez Perce",                                                  "nez",     "",   "",    false, false },
  { "Ngaanyatjarra",                                              "ntj",     "",   "",    false, false },
  { "Ngad'a",                                                     "nxg",     "",   "",    false, false },
  { "Ngadjunmaya",                                                "nju",     "",   "",    false, false },
  { "Ngadjuri",                                                   "jui",     "",   "",    false, false },
  { "Ngaing",                                                     "nnf",     "",   "",    false, false },
  { "Ngaju",                                                      "nij",     "",   "",    false, false },
  { "Ngala",                                                      "nud",     "",   "",    false, false },
  { "Ngalakgan",                                                  "nig",     "",   "",    false, false },
  { "Ngalum",                                                     "szb",     "",   "",    false, false },
  { "Ngam",                                                       "nmc",     "",   "",    false, false },
  { "Ngamambo",                                                   "nbv",     "",   "",    false, false },
  { "Ngambay",                                                    "sba",     "",   "",    false, false },
  { "Ngamini",                                                    "nmv",     "",   "",    false, false },
  { "Ngamo",                                                      "nbh",     "",   "",    false, false },
  { "Ngan'gityemerri",                                            "nam",     "",   "",    false, false },
  { "Nganakarti",                                                 "xnk",     "",   "",    false, false },
  { "Nganasan",                                                   "nio",     "",   "",    false, false },
  { "Ngandi",                                                     "nid",     "",   "",    false, false },
  { "Ngando (Central African Republic)",                          "ngd",     "",   "",    false, false },
  { "Ngando (Democratic Republic of Congo)",                      "nxd",     "",   "",    false, false },
  { "Ngandyera",                                                  "nne",     "",   "",    false, false },
  { "Ngangam",                                                    "gng",     "",   "",    false, false },
  { "Ngantangarra",                                               "ntg",     "",   "",    false, false },
  { "Nganyaywana",                                                "nyx",     "",   "",    false, false },
  { "Ngardi",                                                     "rxd",     "",   "",    false, false },
  { "Ngarigu",                                                    "xni",     "",   "",    false, false },
  { "Ngarinyin",                                                  "ung",     "",   "",    false, false },
  { "Ngarinyman",                                                 "nbj",     "",   "",    false, false },
  { "Ngarla",                                                     "nlr",     "",   "",    false, true  },
  { "Ngarla",                                                     "nrk",     "",   "",    false, false },
  { "Ngarluma",                                                   "nrl",     "",   "",    false, false },
  { "Ngarrindjeri",                                               "nay",     "",   "",    false, false },
  { "Ngas",                                                       "anc",     "",   "",    false, false },
  { "Ngasa",                                                      "nsg",     "",   "",    false, false },
  { "Ngatik Men's Creole",                                        "ngm",     "",   "",    false, false },
  { "Ngawn Chin",                                                 "cnw",     "",   "",    false, false },
  { "Ngawun",                                                     "nxn",     "",   "",    false, false },
  { "Ngayawung",                                                  "nwg",     "",   "",    false, false },
  { "Ngazidja Comorian",                                          "zdj",     "",   "",    false, false },
  { "Ngbaka Ma'bo",                                               "nbm",     "",   "",    false, false },
  { "Ngbaka Manza",                                               "ngg",     "",   "",    false, false },
  { "Ngbaka",                                                     "nga",     "",   "",    false, false },
  { "Ngbee",                                                      "jgb",     "",   "",    false, false },
  { "Ngbinda",                                                    "nbd",     "",   "",    false, false },
  { "Ngbundu",                                                    "nuu",     "",   "",    false, false },
  { "Ngelima",                                                    "agh",     "",   "",    false, false },
  { "Ngemba",                                                     "nge",     "",   "",    false, false },
  { "Ngen",                                                       "gnj",     "",   "",    false, false },
  { "Ngendelengo",                                                "nql",     "",   "",    false, false },
  { "Ngete",                                                      "nnn",     "",   "",    false, false },
  { "Nggem",                                                      "nbq",     "",   "",    false, false },
  { "Nggwahyi",                                                   "ngx",     "",   "",    false, false },
  { "Ngie",                                                       "ngj",     "",   "",    false, false },
  { "Ngiemboon",                                                  "nnh",     "",   "",    false, false },
  { "Ngile",                                                      "jle",     "",   "",    false, false },
  { "Ngindo",                                                     "nnq",     "",   "",    false, false },
  { "Ngiti",                                                      "niy",     "",   "",    false, false },
  { "Ngizim",                                                     "ngi",     "",   "",    false, false },
  { "Ngkâlmpw Kanum",                                             "kcd",     "",   "",    false, false },
  { "Ngom",                                                       "nra",     "",   "",    false, false },
  { "Ngomba",                                                     "jgo",     "",   "",    false, false },
  { "Ngombale",                                                   "nla",     "",   "",    false, false },
  { "Ngombe (Central African Republic)",                          "nmj",     "",   "",    false, false },
  { "Ngombe (Democratic Republic of Congo)",                      "ngc",     "",   "",    false, false },
  { "Ngong",                                                      "nnx",     "",   "",    false, true  },
  { "Ngongo",                                                     "noq",     "",   "",    false, false },
  { "Ngoni (Mozambique)",                                         "xnq",     "",   "",    false, false },
  { "Ngoni (Tanzania)",                                           "xnj",     "",   "",    false, false },
  { "Ngoni",                                                      "ngo",     "",   "",    false, true  },
  { "Ngoshie",                                                    "nsh",     "",   "",    false, false },
  { "Ngul",                                                       "nlo",     "",   "",    false, false },
  { "Ngulu",                                                      "ngp",     "",   "",    false, false },
  { "Nguluwan",                                                   "nuw",     "",   "",    false, false },
  { "Ngumbarl",                                                   "xnm",     "",   "",    false, false },
  { "Ngumbi",                                                     "nui",     "",   "",    false, false },
  { "Ngunawal",                                                   "xul",     "",   "",    false, false },
  { "Ngundi",                                                     "ndn",     "",   "",    false, false },
  { "Ngundu",                                                     "nue",     "",   "",    false, false },
  { "Ngungwel",                                                   "ngz",     "",   "",    false, false },
  { "Ngura",                                                      "nbx",     "",   "",    false, true  },
  { "Ngurimi",                                                    "ngq",     "",   "",    false, false },
  { "Ngurmbur",                                                   "nrx",     "",   "",    false, false },
  { "Nguôn",                                                      "nuo",     "",   "",    false, false },
  { "Ngwaba",                                                     "ngw",     "",   "",    false, false },
  { "Ngwe",                                                       "nwe",     "",   "",    false, false },
  { "Ngwo",                                                       "ngn",     "",   "",    false, false },
  { "Ngyian",                                                     "kci",     "",   "",    false, false },
  { "Ngäbere",                                                    "gym",     "",   "",    false, false },
  { "Nhanda",                                                     "nha",     "",   "",    false, false },
  { "Nhengatu",                                                   "yrl",     "",   "",    false, false },
  { "Nhirrpi",                                                    "hrp",     "",   "",    false, false },
  { "Nhuwala",                                                    "nhf",     "",   "",    false, false },
  { "Nias",                                                       "nia",     "",   "",    true,  false },
  { "Nicaragua Creole English",                                   "bzk",     "",   "",    false, false },
  { "Nicaraguan Sign Language",                                   "ncs",     "",   "",    false, false },
  { "Niellim",                                                    "nie",     "",   "",    false, false },
  { "Niger-Kordofanian languages",                                "nic",     "",   "",    true,  false },
  { "Nigeria Mambila",                                            "mzk",     "",   "",    false, false },
  { "Nigerian Fulfulde",                                          "fuv",     "",   "",    false, false },
  { "Nigerian Pidgin",                                            "pcm",     "",   "",    false, false },
  { "Nigerian Sign Language",                                     "nsi",     "",   "",    false, false },
  { "Nihali",                                                     "nll",     "",   "",    false, false },
  { "Nii",                                                        "nii",     "",   "",    false, false },
  { "Nijadali",                                                   "nad",     "",   "",    false, true  },
  { "Niksek",                                                     "gbe",     "",   "",    false, false },
  { "Nila",                                                       "nil",     "",   "",    false, false },
  { "Nilamba",                                                    "nim",     "",   "",    false, false },
  { "Nilo-Saharan languages",                                     "ssa",     "",   "",    true,  false },
  { "Nimadi",                                                     "noe",     "",   "",    false, false },
  { "Nimanbur",                                                   "nmp",     "",   "",    false, false },
  { "Nimbari",                                                    "nmr",     "",   "",    false, false },
  { "Nimboran",                                                   "nir",     "",   "",    false, false },
  { "Nimi",                                                       "nis",     "",   "",    false, false },
  { "Nimo",                                                       "niw",     "",   "",    false, false },
  { "Nimoa",                                                      "nmw",     "",   "",    false, false },
  { "Ninam",                                                      "shb",     "",   "",    false, false },
  { "Nindi",                                                      "nxi",     "",   "",    false, false },
  { "Ningera",                                                    "nby",     "",   "",    false, false },
  { "Ninggerum",                                                  "nxr",     "",   "",    false, false },
  { "Ningil",                                                     "niz",     "",   "",    false, false },
  { "Ningye",                                                     "nns",     "",   "",    false, true  },
  { "Ninia Yali",                                                 "nlk",     "",   "",    false, false },
  { "Ninzo",                                                      "nin",     "",   "",    false, false },
  { "Nipsan",                                                     "nps",     "",   "",    false, false },
  { "Nisa",                                                       "njs",     "",   "",    false, false },
  { "Nisenan",                                                    "nsz",     "",   "",    false, false },
  { "Nisga'a",                                                    "ncg",     "",   "",    false, false },
  { "Nisi (China)",                                               "yso",     "",   "",    false, false },
  { "Nisi (India)",                                               "dap",     "",   "",    false, true  },
  { "Niuafo'ou",                                                  "num",     "",   "",    false, false },
  { "Niuatoputapu",                                               "nkp",     "",   "",    false, false },
  { "Niuean",                                                     "niu",     "",   "",    true,  false },
  { "Nivaclé",                                                    "cag",     "",   "",    false, false },
  { "Niwer Mil",                                                  "hrc",     "",   "",    false, false },
  { "Njalgulgule",                                                "njl",     "",   "",    false, false },
  { "Njebi",                                                      "nzb",     "",   "",    false, false },
  { "Njen",                                                       "njj",     "",   "",    false, false },
  { "Njerep",                                                     "njr",     "",   "",    false, false },
  { "Njyem",                                                      "njy",     "",   "",    false, false },
  { "Nkami",                                                      "nkq",     "",   "",    false, false },
  { "Nkangala",                                                   "nkn",     "",   "",    false, false },
  { "Nkari",                                                      "nkz",     "",   "",    false, false },
  { "Nkem-Nkum",                                                  "isi",     "",   "",    false, false },
  { "Nkhumbi",                                                    "khu",     "",   "",    false, false },
  { "Nkongho",                                                    "nkc",     "",   "",    false, false },
  { "Nkonya",                                                     "nko",     "",   "",    false, false },
  { "Nkoroo",                                                     "nkx",     "",   "",    false, false },
  { "Nkoya",                                                      "nka",     "",   "",    false, false },
  { "Nkukoli",                                                    "nbo",     "",   "",    false, false },
  { "Nkutu",                                                      "nkw",     "",   "",    false, false },
  { "Nnam",                                                       "nbp",     "",   "",    false, false },
  { "No linguistic content",                                      "zxx",     "",   "",    true,  false },
  { "Noakhali",                                                   "oak",     "",   "",    false, false },
  { "Nobiin",                                                     "fia",     "",   "",    false, false },
  { "Nobonob",                                                    "gaw",     "",   "",    false, false },
  { "Nocamán",                                                    "nom",     "",   "",    false, true  },
  { "Nocte Naga",                                                 "njb",     "",   "",    false, false },
  { "Nogai",                                                      "nog",     "",   "",    true,  false },
  { "Noipx",                                                      "npx",     "",   "",    false, false },
  { "Noiri",                                                      "noi",     "",   "",    false, false },
  { "Nokuku",                                                     "nkk",     "",   "",    false, false },
  { "Nomaande",                                                   "lem",     "",   "",    false, false },
  { "Nomane",                                                     "nof",     "",   "",    false, false },
  { "Nomatsiguenga",                                              "not",     "",   "",    false, false },
  { "Nomlaki",                                                    "nol",     "",   "",    false, false },
  { "Nomu",                                                       "noh",     "",   "",    false, false },
  { "Nong Zhuang",                                                "zhn",     "",   "",    false, false },
  { "Nonuya",                                                     "noj",     "",   "",    false, false },
  { "Nooksack",                                                   "nok",     "",   "",    false, false },
  { "Noon",                                                       "snf",     "",   "",    false, false },
  { "Noone",                                                      "nhu",     "",   "",    false, false },
  { "Nootka",                                                     "noo",     "",   "",    false, true  },
  { "Nopala Chatino",                                             "cya",     "",   "",    false, false },
  { "Noric",                                                      "nrc",     "",   "",    false, false },
  { "Norn",                                                       "nrn",     "",   "",    false, false },
  { "Norra",                                                      "nrr",     "",   "",    false, false },
  { "North Alaskan Inupiatun",                                    "esi",     "",   "",    false, false },
  { "North Ambrym",                                               "mmg",     "",   "",    false, false },
  { "North American Indian languages",                            "nai",     "",   "",    true,  false },
  { "North Asmat",                                                "nks",     "",   "",    false, false },
  { "North Awyu",                                                 "yir",     "",   "",    false, false },
  { "North Azerbaijani",                                          "azj",     "",   "",    false, false },
  { "North Babar",                                                "bcd",     "",   "",    false, false },
  { "North Bolivian Quechua",                                     "qul",     "",   "",    false, false },
  { "North Caucasian languages",                                  "ccn",     "",   "",    false, false },
  { "North Central Mixe",                                         "neq",     "",   "",    false, false },
  { "North Efate",                                                "llp",     "",   "",    false, false },
  { "North Fali",                                                 "fll",     "",   "",    false, false },
  { "North Germanic languages",                                   "gmq",     "",   "",    false, false },
  { "North Giziga",                                               "gis",     "",   "",    false, false },
  { "North Junín Quechua",                                        "qvn",     "",   "",    false, false },
  { "North Marquesan",                                            "mrq",     "",   "",    false, false },
  { "North Mesopotamian Arabic",                                  "ayp",     "",   "",    false, false },
  { "North Midlands Tasmanian",                                   "xph",     "",   "",    false, false },
  { "North Mofu",                                                 "mfk",     "",   "",    false, false },
  { "North Moluccan Malay",                                       "max",     "",   "",    false, false },
  { "North Muyu",                                                 "kti",     "",   "",    false, false },
  { "North Ndebele",                                              "nde",     "nd", "",    true,  false },
  { "North Nuaulu",                                               "nni",     "",   "",    false, false },
  { "North Picene",                                               "nrp",     "",   "",    false, false },
  { "North Slavey",                                               "scs",     "",   "",    false, false },
  { "North Tairora",                                              "tbg",     "",   "",    false, false },
  { "North Tanna",                                                "tnn",     "",   "",    false, false },
  { "North Wahgi",                                                "whg",     "",   "",    false, false },
  { "North Watut",                                                "una",     "",   "",    false, false },
  { "Northeast Kiwai",                                            "kiw",     "",   "",    false, false },
  { "Northeast Maidu",                                            "nmu",     "",   "",    false, false },
  { "Northeast Pashai",                                           "aee",     "",   "",    false, false },
  { "Northeastern Dinka",                                         "dip",     "",   "",    false, false },
  { "Northeastern Pomo",                                          "pef",     "",   "",    false, false },
  { "Northeastern Tasmanian",                                     "xpb",     "",   "",    false, false },
  { "Northeastern Thai",                                          "tts",     "",   "",    false, false },
  { "Northern Alta",                                              "aqn",     "",   "",    false, false },
  { "Northern Altai",                                             "atv",     "",   "",    false, false },
  { "Northern Amami-Oshima",                                      "ryn",     "",   "",    false, false },
  { "Northern Betsimisaraka Malagasy",                            "bmm",     "",   "",    false, false },
  { "Northern Binukidnon",                                        "kyn",     "",   "",    false, false },
  { "Northern Bobo Madaré",                                       "bbo",     "",   "",    false, false },
  { "Northern Bontok",                                            "rbk",     "",   "",    false, false },
  { "Northern Catanduanes Bikol",                                 "cts",     "",   "",    false, false },
  { "Northern Conchucos Ancash Quechua",                          "qxn",     "",   "",    false, false },
  { "Northern Dagara",                                            "dgi",     "",   "",    false, false },
  { "Northern Dong",                                              "doc",     "",   "",    false, false },
  { "Northern East Cree",                                         "crl",     "",   "",    false, false },
  { "Northern Emberá",                                            "emp",     "",   "",    false, false },
  { "Northern Frisian",                                           "frr",     "",   "",    true,  false },
  { "Northern Ghale",                                             "ghh",     "",   "",    false, false },
  { "Northern Gondi",                                             "gno",     "",   "",    false, false },
  { "Northern Grebo",                                             "gbo",     "",   "",    false, false },
  { "Northern Guiyang Hmong",                                     "huj",     "",   "",    false, false },
  { "Northern Haida",                                             "hdn",     "",   "",    false, false },
  { "Northern Hindko",                                            "hno",     "",   "",    false, false },
  { "Northern Huishui Hmong",                                     "hmi",     "",   "",    false, false },
  { "Northern Kalapuya",                                          "nrt",     "",   "",    false, false },
  { "Northern Kankanay",                                          "xnn",     "",   "",    false, false },
  { "Northern Katang",                                            "ncq",     "",   "",    false, false },
  { "Northern Khmer",                                             "kxm",     "",   "",    false, false },
  { "Northern Kissi",                                             "kqs",     "",   "",    false, false },
  { "Northern Kurdish",                                           "kmr",     "",   "",    false, false },
  { "Northern Luri",                                              "lrc",     "",   "",    false, false },
  { "Northern Mashan Hmong",                                      "hmp",     "",   "",    false, false },
  { "Northern Muji",                                              "ymx",     "",   "",    false, false },
  { "Northern Nago",                                              "xkb",     "",   "",    false, false },
  { "Northern Ngbandi",                                           "ngb",     "",   "",    false, false },
  { "Northern Nisu",                                              "yiv",     "",   "",    false, false },
  { "Northern Nuni",                                              "nuv",     "",   "",    false, false },
  { "Northern Oaxaca Nahuatl",                                    "nhy",     "",   "",    false, false },
  { "Northern Ohlone",                                            "cst",     "",   "",    false, false },
  { "Northern One",                                               "onr",     "",   "",    false, false },
  { "Northern Paiute",                                            "pao",     "",   "",    false, false },
  { "Northern Pame",                                              "pmq",     "",   "",    false, false },
  { "Northern Pashto",                                            "pbu",     "",   "",    false, false },
  { "Northern Pastaza Quichua",                                   "qvz",     "",   "",    false, false },
  { "Northern Ping Chinese",                                      "cnp",     "",   "",    false, false },
  { "Northern Pomo",                                              "pej",     "",   "",    false, false },
  { "Northern Puebla Nahuatl",                                    "ncj",     "",   "",    false, false },
  { "Northern Pumi",                                              "pmi",     "",   "",    false, false },
  { "Northern Qiandong Miao",                                     "hea",     "",   "",    false, false },
  { "Northern Qiang",                                             "cng",     "",   "",    false, false },
  { "Northern Rengma Naga",                                       "nnl",     "",   "",    false, false },
  { "Northern Roglai",                                            "rog",     "",   "",    false, false },
  { "Northern Sami",                                              "sme",     "se", "",    true,  false },
  { "Northern Sierra Miwok",                                      "nsq",     "",   "",    false, false },
  { "Northern Sorsoganon",                                        "bks",     "",   "",    false, false },
  { "Northern Subanen",                                           "stb",     "",   "",    false, false },
  { "Northern Tarahumara",                                        "thh",     "",   "",    false, false },
  { "Northern Tasmanian",                                         "xpv",     "",   "",    false, false },
  { "Northern Tepehuan",                                          "ntp",     "",   "",    false, false },
  { "Northern Thai",                                              "nod",     "",   "",    false, false },
  { "Northern Tidung",                                            "ntd",     "",   "",    false, false },
  { "Northern Tiwa",                                              "twf",     "",   "",    false, false },
  { "Northern Tlaxiaco Mixtec",                                   "xtn",     "",   "",    false, false },
  { "Northern Toussian",                                          "tsp",     "",   "",    false, false },
  { "Northern Tujia",                                             "tji",     "",   "",    false, false },
  { "Northern Tutchone",                                          "ttm",     "",   "",    false, false },
  { "Northern Uzbek",                                             "uzn",     "",   "",    false, false },
  { "Northern Yukaghir",                                          "ykg",     "",   "",    false, false },
  { "Northwest Alaska Inupiatun",                                 "esk",     "",   "",    false, false },
  { "Northwest Gbaya",                                            "gya",     "",   "",    false, false },
  { "Northwest Maidu",                                            "mjd",     "",   "",    false, false },
  { "Northwest Oaxaca Mixtec",                                    "mxa",     "",   "",    false, false },
  { "Northwest Pashai",                                           "glh",     "",   "",    false, false },
  { "Northwestern Dinka",                                         "diw",     "",   "",    false, false },
  { "Northwestern Fars",                                          "faz",     "",   "",    false, false },
  { "Northwestern Kolami",                                        "kfb",     "",   "",    false, false },
  { "Northwestern Nisu",                                          "nsf",     "",   "",    false, false },
  { "Northwestern Ojibwa",                                        "ojb",     "",   "",    false, false },
  { "Northwestern Tamang",                                        "tmk",     "",   "",    false, true  },
  { "Northwestern Tasmanian",                                     "xpw",     "",   "",    false, false },
  { "Norwegian Bokmål",                                           "nob",     "nb", "",    true,  false },
  { "Norwegian Nynorsk",                                          "nno",     "nn", "",    true,  false },
  { "Norwegian Sign Language",                                    "nsl",     "",   "",    false, false },
  { "Norwegian",                                                  "nor",     "no", "",    true,  false },
  { "Notre",                                                      "bly",     "",   "",    false, false },
  { "Notsi",                                                      "ncf",     "",   "",    false, false },
  { "Nottoway",                                                   "ntw",     "",   "",    false, false },
  { "Nottoway-Meherrin",                                          "nwy",     "",   "",    false, false },
  { "Novial",                                                     "nov",     "",   "",    false, false },
  { "Noy",                                                        "noy",     "",   "",    false, false },
  { "Nsenga",                                                     "nse",     "",   "",    false, false },
  { "Nshi",                                                       "nsc",     "",   "",    false, false },
  { "Nsongo",                                                     "nsx",     "",   "",    false, false },
  { "Ntcham",                                                     "bud",     "",   "",    false, false },
  { "Nteng",                                                      "nqt",     "",   "",    false, false },
  { "Ntomba",                                                     "nto",     "",   "",    false, false },
  { "Nubaca",                                                     "baf",     "",   "",    false, false },
  { "Nubi",                                                       "kcn",     "",   "",    false, false },
  { "Nubian languages",                                           "nub",     "",   "",    true,  false },
  { "Nubri",                                                      "kte",     "",   "",    false, false },
  { "Nuer",                                                       "nus",     "",   "",    false, false },
  { "Nugunu (Australia)",                                         "nnv",     "",   "",    false, false },
  { "Nugunu (Cameroon)",                                          "yas",     "",   "",    false, false },
  { "Nuk",                                                        "noc",     "",   "",    false, false },
  { "Nukak Makú",                                                 "mbr",     "",   "",    false, false },
  { "Nukna",                                                      "klt",     "",   "",    false, false },
  { "Nukuini",                                                    "nuc",     "",   "",    false, false },
  { "Nukumanu",                                                   "nuq",     "",   "",    false, false },
  { "Nukunul",                                                    "xnu",     "",   "",    false, false },
  { "Nukuoro",                                                    "nkr",     "",   "",    false, false },
  { "Nukuria",                                                    "nur",     "",   "",    false, false },
  { "Numana",                                                     "nbr",     "",   "",    false, false },
  { "Numanggang",                                                 "nop",     "",   "",    false, false },
  { "Numbami",                                                    "sij",     "",   "",    false, false },
  { "Nume",                                                       "tgs",     "",   "",    false, false },
  { "Numidian",                                                   "nxm",     "",   "",    false, false },
  { "Numèè",                                                      "kdk",     "",   "",    false, false },
  { "Nung (Viet Nam)",                                            "nut",     "",   "",    false, false },
  { "Nungali",                                                    "nug",     "",   "",    false, false },
  { "Nunggubuyu",                                                 "nuy",     "",   "",    false, false },
  { "Nungu",                                                      "rin",     "",   "",    false, false },
  { "Nupbikha",                                                   "npb",     "",   "",    false, false },
  { "Nupe-Nupe-Tako",                                             "nup",     "",   "",    false, false },
  { "Nusa Laut",                                                  "nul",     "",   "",    false, false },
  { "Nusu",                                                       "nuf",     "",   "",    false, false },
  { "Nuu-chah-nulth",                                             "nuk",     "",   "",    false, false },
  { "Nyabwa",                                                     "nwb",     "",   "",    false, false },
  { "Nyaheun",                                                    "nev",     "",   "",    false, false },
  { "Nyahkur",                                                    "cbn",     "",   "",    false, false },
  { "Nyakyusa-Ngonde",                                            "nyy",     "",   "",    false, false },
  { "Nyali",                                                      "nlj",     "",   "",    false, false },
  { "Nyam",                                                       "nmi",     "",   "",    false, false },
  { "Nyamal",                                                     "nly",     "",   "",    false, false },
  { "Nyambo",                                                     "now",     "",   "",    false, false },
  { "Nyamusa-Molo",                                               "nwm",     "",   "",    false, false },
  { "Nyamwanga",                                                  "mwn",     "",   "",    false, false },
  { "Nyamwezi",                                                   "nym",     "",   "",    true,  false },
  { "Nyaneka",                                                    "nyk",     "",   "",    false, false },
  { "Nyang'i",                                                    "nyp",     "",   "",    false, false },
  { "Nyanga",                                                     "nyj",     "",   "",    false, false },
  { "Nyanga-li",                                                  "nyc",     "",   "",    false, false },
  { "Nyangatom",                                                  "nnj",     "",   "",    false, false },
  { "Nyangbo",                                                    "nyb",     "",   "",    false, false },
  { "Nyangga",                                                    "nny",     "",   "",    false, false },
  { "Nyangumarta",                                                "nna",     "",   "",    false, false },
  { "Nyanja",                                                     "nya",     "ny", "",    true,  false },
  { "Nyankole",                                                   "nyn",     "",   "",    true,  false },
  { "Nyankpa",                                                    "yes",     "",   "",    false, false },
  { "Nyarafolo Senoufo",                                          "sev",     "",   "",    false, false },
  { "Nyaturu",                                                    "rim",     "",   "",    false, false },
  { "Nyaw",                                                       "nyw",     "",   "",    false, false },
  { "Nyawaygi",                                                   "nyt",     "",   "",    false, false },
  { "Nyemba",                                                     "nba",     "",   "",    false, false },
  { "Nyengo",                                                     "nye",     "",   "",    false, false },
  { "Nyenkha",                                                    "neh",     "",   "",    false, false },
  { "Nyeu",                                                       "nyl",     "",   "",    false, false },
  { "Nyiha (Malawi)",                                             "nyr",     "",   "",    false, false },
  { "Nyiha (Tanzania)",                                           "nih",     "",   "",    false, false },
  { "Nyika (Malawi and Zambia)",                                  "nkv",     "",   "",    false, false },
  { "Nyika (Tanzania)",                                           "nkt",     "",   "",    false, false },
  { "Nyikina",                                                    "nyh",     "",   "",    false, false },
  { "Nyindrou",                                                   "lid",     "",   "",    false, false },
  { "Nyindu",                                                     "nyg",     "",   "",    false, false },
  { "Nyishi",                                                     "njz",     "",   "",    false, false },
  { "Nyiyaparli",                                                 "xny",     "",   "",    false, false },
  { "Nyokon",                                                     "nvo",     "",   "",    false, false },
  { "Nyole",                                                      "nuj",     "",   "",    false, false },
  { "Nyong",                                                      "muo",     "",   "",    false, false },
  { "Nyore",                                                      "nyd",     "",   "",    false, false },
  { "Nyoro",                                                      "nyo",     "",   "",    true,  false },
  { "Nyulnyul",                                                   "nyv",     "",   "",    false, false },
  { "Nyungar",                                                    "nys",     "",   "",    false, false },
  { "Nyungwe",                                                    "nyu",     "",   "",    false, false },
  { "Nyâlayu",                                                    "yly",     "",   "",    false, false },
  { "Nzadi",                                                      "nzd",     "",   "",    false, false },
  { "Nzakambay",                                                  "nzy",     "",   "",    false, false },
  { "Nzakara",                                                    "nzk",     "",   "",    false, false },
  { "Nzanyi",                                                     "nja",     "",   "",    false, false },
  { "Nzima",                                                      "nzi",     "",   "",    true,  false },
  { "Ná-Meo",                                                     "neo",     "",   "",    false, false },
  { "Nêlêmwa-Nixumwak",                                           "nee",     "",   "",    false, false },
  { "Nüpode Huitoto",                                             "hux",     "",   "",    false, false },
  { "Nǁng",                                                       "ngh",     "",   "",    false, false },
  { "O'chi'chi'",                                                 "xoc",     "",   "",    false, false },
  { "O'du",                                                       "tyh",     "",   "",    false, false },
  { "Obanliku",                                                   "bzy",     "",   "",    false, false },
  { "Obispeño",                                                   "obi",     "",   "",    false, false },
  { "Oblo",                                                       "obl",     "",   "",    false, false },
  { "Obo Manobo",                                                 "obo",     "",   "",    false, false },
  { "Obokuitai",                                                  "afz",     "",   "",    false, false },
  { "Obolo",                                                      "ann",     "",   "",    false, false },
  { "Obulom",                                                     "obu",     "",   "",    false, false },
  { "Ocaina",                                                     "oca",     "",   "",    false, false },
  { "Occitan (post 1500)",                                        "oci",     "oc", "",    true,  false },
  { "Ocotepec Mixtec",                                            "mie",     "",   "",    false, false },
  { "Ocotlán Zapotec",                                            "zac",     "",   "",    false, false },
  { "Od",                                                         "odk",     "",   "",    false, false },
  { "Odia",                                                       "ory",     "",   "",    false, false },
  { "Odiai",                                                      "bhf",     "",   "",    false, false },
  { "Odoodee",                                                    "kkc",     "",   "",    false, false },
  { "Odual",                                                      "odu",     "",   "",    false, false },
  { "Odut",                                                       "oda",     "",   "",    false, false },
  { "Ofayé",                                                      "opy",     "",   "",    false, false },
  { "Official Aramaic (700-300 BCE)",                             "arc",     "",   "",    true,  false },
  { "Ofo",                                                        "ofo",     "",   "",    false, false },
  { "Ogbah",                                                      "ogc",     "",   "",    false, false },
  { "Ogbia",                                                      "ogb",     "",   "",    false, false },
  { "Ogbogolo",                                                   "ogg",     "",   "",    false, false },
  { "Ogbronuagum",                                                "ogu",     "",   "",    false, false },
  { "Ogea",                                                       "eri",     "",   "",    false, false },
  { "Oirata",                                                     "oia",     "",   "",    false, false },
  { "Ojibwa",                                                     "oji",     "oj", "",    true,  false },
  { "Ojitlán Chinantec",                                          "chj",     "",   "",    false, false },
  { "Okanagan",                                                   "oka",     "",   "",    false, false },
  { "Oki-No-Erabu",                                               "okn",     "",   "",    false, false },
  { "Okiek",                                                      "oki",     "",   "",    false, false },
  { "Oko-Eni-Osayen",                                             "oks",     "",   "",    false, false },
  { "Oko-Juwoi",                                                  "okj",     "",   "",    false, false },
  { "Okobo",                                                      "okb",     "",   "",    false, false },
  { "Okodia",                                                     "okd",     "",   "",    false, false },
  { "Okolie",                                                     "oie",     "",   "",    false, false },
  { "Okolod",                                                     "kqv",     "",   "",    false, false },
  { "Okpamheri",                                                  "opa",     "",   "",    false, false },
  { "Okpe (Northwestern Edo)",                                    "okx",     "",   "",    false, false },
  { "Okpe (Southwestern Edo)",                                    "oke",     "",   "",    false, false },
  { "Oksapmin",                                                   "opm",     "",   "",    false, false },
  { "Oku",                                                        "oku",     "",   "",    false, false },
  { "Old Aramaic (up to 700 BCE)",                                "oar",     "",   "",    false, false },
  { "Old Avar",                                                   "oav",     "",   "",    false, false },
  { "Old Breton",                                                 "obt",     "",   "",    false, false },
  { "Old Burmese",                                                "obr",     "",   "",    false, false },
  { "Old Cham",                                                   "ocm",     "",   "",    false, false },
  { "Old Chinese",                                                "och",     "",   "",    false, false },
  { "Old Cornish",                                                "oco",     "",   "",    false, false },
  { "Old Dutch",                                                  "odt",     "",   "",    false, false },
  { "Old English (ca. 450-1100)",                                 "ang",     "",   "",    true,  false },
  { "Old French (842-ca. 1400)",                                  "fro",     "",   "",    true,  false },
  { "Old Frisian",                                                "ofs",     "",   "",    false, false },
  { "Old Georgian",                                               "oge",     "",   "",    false, false },
  { "Old High German (ca. 750-1050)",                             "goh",     "",   "",    true,  false },
  { "Old Hittite",                                                "oht",     "",   "",    false, false },
  { "Old Hungarian",                                              "ohu",     "",   "",    false, false },
  { "Old Irish (to 900)",                                         "sga",     "",   "",    true,  false },
  { "Old Japanese",                                               "ojp",     "",   "",    false, false },
  { "Old Kentish Sign Language",                                  "okl",     "",   "",    false, false },
  { "Old Khmer",                                                  "okz",     "",   "",    false, false },
  { "Old Korean (3rd-9th cent.)",                                 "oko",     "",   "",    false, false },
  { "Old Lithuanian",                                             "olt",     "",   "",    false, false },
  { "Old Malay",                                                  "omy",     "",   "",    false, false },
  { "Old Manipuri",                                               "omp",     "",   "",    false, false },
  { "Old Marathi",                                                "omr",     "",   "",    false, false },
  { "Old Mon",                                                    "omx",     "",   "",    false, false },
  { "Old Norse",                                                  "non",     "",   "",    true,  false },
  { "Old Nubian",                                                 "onw",     "",   "",    false, false },
  { "Old Ossetic",                                                "oos",     "",   "",    false, false },
  { "Old Persian (ca. 600-400 B.C.)",                             "peo",     "",   "",    true,  false },
  { "Old Provençal (to 1500)",                                    "pro",     "",   "",    true,  false },
  { "Old Russian",                                                "orv",     "",   "",    false, false },
  { "Old Saxon",                                                  "osx",     "",   "",    false, false },
  { "Old Spanish",                                                "osp",     "",   "",    false, false },
  { "Old Sundanese",                                              "osn",     "",   "",    false, false },
  { "Old Tamil",                                                  "oty",     "",   "",    false, false },
  { "Old Tibetan",                                                "otb",     "",   "",    false, false },
  { "Old Turkish",                                                "otk",     "",   "",    false, false },
  { "Old Uighur",                                                 "oui",     "",   "",    false, false },
  { "Old Welsh",                                                  "owl",     "",   "",    false, false },
  { "Olekha",                                                     "ole",     "",   "",    false, false },
  { "Olkol",                                                      "olk",     "",   "",    false, false },
  { "Olo",                                                        "ong",     "",   "",    false, false },
  { "Oloma",                                                      "olm",     "",   "",    false, false },
  { "Olrat",                                                      "olr",     "",   "",    false, false },
  { "Olu'bo",                                                     "lul",     "",   "",    false, false },
  { "Olulumo-Ikom",                                               "iko",     "",   "",    false, false },
  { "Oluta Popoluca",                                             "plo",     "",   "",    false, false },
  { "Omagua",                                                     "omg",     "",   "",    false, false },
  { "Omaha-Ponca",                                                "oma",     "",   "",    false, false },
  { "Omani Arabic",                                               "acx",     "",   "",    false, false },
  { "Omati",                                                      "mgx",     "",   "",    false, true  },
  { "Ombamba",                                                    "mbm",     "",   "",    false, false },
  { "Ombo",                                                       "oml",     "",   "",    false, false },
  { "Omejes",                                                     "ome",     "",   "",    false, true  },
  { "Ometepec Nahuatl",                                           "nht",     "",   "",    false, false },
  { "Omi",                                                        "omi",     "",   "",    false, false },
  { "Omok",                                                       "omk",     "",   "",    false, false },
  { "Omotic languages",                                           "omv",     "",   "",    false, false },
  { "Omotik",                                                     "omt",     "",   "",    false, false },
  { "Omurano",                                                    "omu",     "",   "",    false, false },
  { "Ona",                                                        "ona",     "",   "",    false, false },
  { "Oneida",                                                     "one",     "",   "",    false, false },
  { "Ong",                                                        "oog",     "",   "",    false, false },
  { "Onin Based Pidgin",                                          "onx",     "",   "",    false, false },
  { "Onin",                                                       "oni",     "",   "",    false, false },
  { "Onjob",                                                      "onj",     "",   "",    false, false },
  { "Ono",                                                        "ons",     "",   "",    false, false },
  { "Onobasulu",                                                  "onn",     "",   "",    false, false },
  { "Onondaga",                                                   "ono",     "",   "",    false, false },
  { "Ontenu",                                                     "ont",     "",   "",    false, false },
  { "Ontong Java",                                                "ojv",     "",   "",    false, false },
  { "Oorlams",                                                    "oor",     "",   "",    false, false },
  { "Opao",                                                       "opo",     "",   "",    false, false },
  { "Opata",                                                      "opt",     "",   "",    false, false },
  { "Orang Kanaq",                                                "orn",     "",   "",    false, false },
  { "Orang Seletar",                                              "ors",     "",   "",    false, false },
  { "Oraon Sadri",                                                "sdr",     "",   "",    false, false },
  { "Orejón",                                                     "ore",     "",   "",    false, false },
  { "Oring",                                                      "org",     "",   "",    false, false },
  { "Oriya (macrolanguage)",                                      "ori",     "or", "",    true,  false },
  { "Orizaba Nahuatl",                                            "nlv",     "",   "",    false, false },
  { "Orma",                                                       "orc",     "",   "",    false, false },
  { "Ormu",                                                       "orz",     "",   "",    false, false },
  { "Ormuri",                                                     "oru",     "",   "",    false, false },
  { "Oro Win",                                                    "orw",     "",   "",    false, false },
  { "Oro",                                                        "orx",     "",   "",    false, false },
  { "Oroch",                                                      "oac",     "",   "",    false, false },
  { "Oroha",                                                      "ora",     "",   "",    false, false },
  { "Orok",                                                       "oaa",     "",   "",    false, false },
  { "Orokaiva",                                                   "okv",     "",   "",    false, false },
  { "Oroko",                                                      "bdu",     "",   "",    false, false },
  { "Orokolo",                                                    "oro",     "",   "",    false, false },
  { "Oromo",                                                      "orm",     "om", "",    true,  false },
  { "Oroqen",                                                     "orh",     "",   "",    false, false },
  { "Orowe",                                                      "bpk",     "",   "",    false, false },
  { "Oruma",                                                      "orr",     "",   "",    false, false },
  { "Orya",                                                       "ury",     "",   "",    false, false },
  { "Osage",                                                      "osa",     "",   "",    true,  false },
  { "Osatu",                                                      "ost",     "",   "",    false, false },
  { "Oscan",                                                      "osc",     "",   "",    false, false },
  { "Osing",                                                      "osi",     "",   "",    false, false },
  { "Ososo",                                                      "oso",     "",   "",    false, false },
  { "Ossetian",                                                   "oss",     "os", "",    true,  false },
  { "Ot Danum",                                                   "otd",     "",   "",    false, false },
  { "Otank",                                                      "uta",     "",   "",    false, false },
  { "Oti",                                                        "oti",     "",   "",    false, false },
  { "Oto-Manguean languages",                                     "omq",     "",   "",    false, false },
  { "Otomian languages",                                          "oto",     "",   "",    true,  false },
  { "Otoro",                                                      "otr",     "",   "",    false, false },
  { "Ottawa",                                                     "otw",     "",   "",    false, false },
  { "Ottoman Turkish (1500-1928)",                                "ota",     "",   "",    true,  false },
  { "Otuho",                                                      "lot",     "",   "",    false, false },
  { "Otuke",                                                      "otu",     "",   "",    false, false },
  { "Ouma",                                                       "oum",     "",   "",    false, false },
  { "Oune",                                                       "oue",     "",   "",    false, false },
  { "Owa",                                                        "stn",     "",   "",    false, false },
  { "Owenia",                                                     "wsr",     "",   "",    false, false },
  { "Owiniga",                                                    "owi",     "",   "",    false, false },
  { "Oy",                                                         "oyb",     "",   "",    false, false },
  { "Oya'oya",                                                    "oyy",     "",   "",    false, false },
  { "Oyda",                                                       "oyd",     "",   "",    false, false },
  { "Oyster Bay Tasmanian",                                       "xpd",     "",   "",    false, false },
  { "Ozolotepec Zapotec",                                         "zao",     "",   "",    false, false },
  { "Ozumacín Chinantec",                                         "chz",     "",   "",    false, false },
  { "Pa Di",                                                      "pdi",     "",   "",    false, false },
  { "Pa'a",                                                       "pqa",     "",   "",    false, false },
  { "Pa'o Karen",                                                 "blk",     "",   "",    false, false },
  { "Pa-Hng",                                                     "pha",     "",   "",    false, false },
  { "Paakantyi",                                                  "drl",     "",   "",    false, false },
  { "Paama",                                                      "pma",     "",   "",    false, false },
  { "Paasaal",                                                    "sig",     "",   "",    false, false },
  { "Pacahuara",                                                  "pcp",     "",   "",    false, false },
  { "Pacaraos Quechua",                                           "qvp",     "",   "",    false, false },
  { "Pacific Gulf Yupik",                                         "ems",     "",   "",    false, false },
  { "Pacoh",                                                      "pac",     "",   "",    false, false },
  { "Padoe",                                                      "pdo",     "",   "",    false, false },
  { "Paekche",                                                    "pkc",     "",   "",    false, false },
  { "Paelignian",                                                 "pgn",     "",   "",    false, false },
  { "Pagi",                                                       "pgi",     "",   "",    false, false },
  { "Pagibete",                                                   "pae",     "",   "",    false, false },
  { "Pagu",                                                       "pgu",     "",   "",    false, false },
  { "Pahanan Agta",                                               "apf",     "",   "",    false, false },
  { "Pahari",                                                     "phj",     "",   "",    false, false },
  { "Pahari-Potwari",                                             "phr",     "",   "",    false, false },
  { "Pahi",                                                       "lgt",     "",   "",    false, false },
  { "Pahlavani",                                                  "phv",     "",   "",    false, false },
  { "Pahlavi",                                                    "pal",     "",   "",    true,  false },
  { "Pai Tavytera",                                               "pta",     "",   "",    false, false },
  { "Paicî",                                                      "pri",     "",   "",    false, false },
  { "Paipai",                                                     "ppi",     "",   "",    false, false },
  { "Paite Chin",                                                 "pck",     "",   "",    false, false },
  { "Paiwan",                                                     "pwn",     "",   "",    false, false },
  { "Pak-Tong",                                                   "pkg",     "",   "",    false, false },
  { "Pakanha",                                                    "pkn",     "",   "",    false, false },
  { "Pakaásnovos",                                                "pav",     "",   "",    false, false },
  { "Pakistan Sign Language",                                     "pks",     "",   "",    false, false },
  { "Paku Karen",                                                 "jkp",     "",   "",    false, false },
  { "Paku Karen",                                                 "kpp",     "",   "",    false, true  },
  { "Paku",                                                       "pku",     "",   "",    false, false },
  { "Pal",                                                        "abw",     "",   "",    false, false },
  { "Palaic",                                                     "plq",     "",   "",    false, false },
  { "Palaka Senoufo",                                             "plr",     "",   "",    false, false },
  { "Palantla Chinantec",                                         "cpa",     "",   "",    false, false },
  { "Palauan",                                                    "pau",     "",   "",    true,  false },
  { "Paleni",                                                     "pnl",     "",   "",    false, false },
  { "Palenquero",                                                 "pln",     "",   "",    false, false },
  { "Pali",                                                       "pli",     "pi", "",    true,  false },
  { "Palikúr",                                                    "plu",     "",   "",    false, false },
  { "Paliyan",                                                    "pcf",     "",   "",    false, false },
  { "Pallanganmiddang",                                           "pmd",     "",   "",    false, false },
  { "Paloor",                                                     "fap",     "",   "",    false, false },
  { "Palpa",                                                      "plp",     "",   "",    false, true  },
  { "Palu",                                                       "pbz",     "",   "",    false, true  },
  { "Palu'e",                                                     "ple",     "",   "",    false, false },
  { "Paluan",                                                     "plz",     "",   "",    false, false },
  { "Palumata",                                                   "pmc",     "",   "",    false, true  },
  { "Palya Bareli",                                               "bpx",     "",   "",    false, false },
  { "Pam",                                                        "pmn",     "",   "",    false, false },
  { "Pambia",                                                     "pmb",     "",   "",    false, false },
  { "Pamlico",                                                    "pmk",     "",   "",    false, true  },
  { "Pamona",                                                     "pmf",     "",   "",    false, false },
  { "Pamosu",                                                     "hih",     "",   "",    false, false },
  { "Pampanga",                                                   "pam",     "",   "",    true,  false },
  { "Pamplona Atta",                                              "att",     "",   "",    false, false },
  { "Pana (Burkina Faso)",                                        "pnq",     "",   "",    false, false },
  { "Pana (Central African Republic)",                            "pnz",     "",   "",    false, false },
  { "Panamanian Sign Language",                                   "lsp",     "",   "",    false, false },
  { "Panamint",                                                   "par",     "",   "",    false, false },
  { "Panang",                                                     "pcr",     "",   "",    false, true  },
  { "Panao Huánuco Quechua",                                      "qxh",     "",   "",    false, false },
  { "Panará",                                                     "kre",     "",   "",    false, false },
  { "Panasuan",                                                   "psn",     "",   "",    false, false },
  { "Panawa",                                                     "pwb",     "",   "",    false, false },
  { "Pancana",                                                    "pnp",     "",   "",    false, false },
  { "Panchpargania",                                              "tdb",     "",   "",    false, false },
  { "Pande",                                                      "bkj",     "",   "",    false, false },
  { "Pangasinan",                                                 "pag",     "",   "",    true,  false },
  { "Pangseng",                                                   "pgs",     "",   "",    false, false },
  { "Pangu",                                                      "png",     "",   "",    false, false },
  { "Pangutaran Sama",                                            "slm",     "",   "",    false, false },
  { "Pangwa",                                                     "pbr",     "",   "",    false, false },
  { "Pangwali",                                                   "pgg",     "",   "",    false, false },
  { "Panim",                                                      "pnr",     "",   "",    false, false },
  { "Paniya",                                                     "pcg",     "",   "",    false, false },
  { "Panjabi",                                                    "pan",     "pa", "",    true,  false },
  { "Pankararé",                                                  "pax",     "",   "",    false, false },
  { "Pankararú",                                                  "paz",     "",   "",    false, false },
  { "Pankhu",                                                     "pkh",     "",   "",    false, false },
  { "Pannei",                                                     "pnc",     "",   "",    false, false },
  { "Pano",                                                       "mqz",     "",   "",    false, false },
  { "Panoan Katukína",                                            "knt",     "",   "",    false, false },
  { "Panobo",                                                     "pno",     "",   "",    false, false },
  { "Panyi Bai",                                                  "bfc",     "",   "",    false, false },
  { "Pao",                                                        "ppa",     "",   "",    false, true  },
  { "Papantla Totonac",                                           "top",     "",   "",    false, false },
  { "Papapana",                                                   "ppn",     "",   "",    false, false },
  { "Papar",                                                      "dpp",     "",   "",    false, false },
  { "Papasena",                                                   "pas",     "",   "",    false, false },
  { "Papel",                                                      "pbo",     "",   "",    false, false },
  { "Papi",                                                       "ppe",     "",   "",    false, false },
  { "Papiamento",                                                 "pap",     "",   "",    true,  false },
  { "Papitalai",                                                  "pat",     "",   "",    false, true  },
  { "Papora",                                                     "ppu",     "",   "",    false, false },
  { "Papua New Guinean Sign Language",                            "pgz",     "",   "",    false, false },
  { "Papuan Malay",                                               "pmy",     "",   "",    false, false },
  { "Papuan languages",                                           "paa",     "",   "",    true,  false },
  { "Papuma",                                                     "ppm",     "",   "",    false, false },
  { "Parachi",                                                    "prc",     "",   "",    false, false },
  { "Paraguayan Guaraní",                                         "gug",     "",   "",    false, false },
  { "Paraguayan Sign Language",                                   "pys",     "",   "",    false, false },
  { "Parakanã",                                                   "pak",     "",   "",    false, false },
  { "Paranan",                                                    "agp",     "",   "",    false, true  },
  { "Paranan",                                                    "prf",     "",   "",    false, false },
  { "Paranawát",                                                  "paf",     "",   "",    false, false },
  { "Paraujano",                                                  "pbg",     "",   "",    false, false },
  { "Parauk",                                                     "prk",     "",   "",    false, false },
  { "Parawen",                                                    "prw",     "",   "",    false, false },
  { "Pardhan",                                                    "pch",     "",   "",    false, false },
  { "Pardhi",                                                     "pcl",     "",   "",    false, false },
  { "Pare",                                                       "ppt",     "",   "",    false, false },
  { "Parecís",                                                    "pab",     "",   "",    false, false },
  { "Parenga",                                                    "pcj",     "",   "",    false, false },
  { "Parkari Koli",                                               "kvx",     "",   "",    false, false },
  { "Parkwa",                                                     "pbi",     "",   "",    false, false },
  { "Parsi",                                                      "prp",     "",   "",    false, true  },
  { "Parsi-Dari",                                                 "prd",     "",   "",    false, false },
  { "Parthian",                                                   "xpr",     "",   "",    false, false },
  { "Parya",                                                      "paq",     "",   "",    false, false },
  { "Pará Arára",                                                 "aap",     "",   "",    false, false },
  { "Pará Gavião",                                                "gvp",     "",   "",    false, false },
  { "Pasi",                                                       "psq",     "",   "",    false, false },
  { "Pass Valley Yali",                                           "yac",     "",   "",    false, false },
  { "Patamona",                                                   "pbc",     "",   "",    false, false },
  { "Patani",                                                     "ptn",     "",   "",    false, false },
  { "Pataxó Hã-Ha-Hãe",                                           "pth",     "",   "",    false, false },
  { "Patep",                                                      "ptp",     "",   "",    false, false },
  { "Pathiya",                                                    "pty",     "",   "",    false, false },
  { "Patpatar",                                                   "gfk",     "",   "",    false, false },
  { "Pattani Malay",                                              "mfa",     "",   "",    false, false },
  { "Pattani",                                                    "lae",     "",   "",    false, false },
  { "Pattapu",                                                    "ptq",     "",   "",    false, false },
  { "Patwin",                                                     "pwi",     "",   "",    false, false },
  { "Paulohi",                                                    "plh",     "",   "",    false, false },
  { "Paumarí",                                                    "pad",     "",   "",    false, false },
  { "Paunaka",                                                    "pnk",     "",   "",    false, false },
  { "Pauri Bareli",                                               "bfb",     "",   "",    false, false },
  { "Pauserna",                                                   "psm",     "",   "",    false, false },
  { "Pawaia",                                                     "pwa",     "",   "",    false, false },
  { "Pawnee",                                                     "paw",     "",   "",    false, false },
  { "Paynamar",                                                   "pmr",     "",   "",    false, false },
  { "Pazeh",                                                      "pzh",     "",   "",    false, false },
  { "Pe",                                                         "pai",     "",   "",    false, false },
  { "Pear",                                                       "pcb",     "",   "",    false, false },
  { "Pech",                                                       "pay",     "",   "",    false, false },
  { "Pecheneg",                                                   "xpc",     "",   "",    false, false },
  { "Pedi",                                                       "nso",     "",   "",    true,  false },
  { "Pei",                                                        "ppq",     "",   "",    false, false },
  { "Pekal",                                                      "pel",     "",   "",    false, false },
  { "Pela",                                                       "bxd",     "",   "",    false, false },
  { "Pele-Ata",                                                   "ata",     "",   "",    false, false },
  { "Pelende",                                                    "ppp",     "",   "",    false, false },
  { "Pemon",                                                      "aoc",     "",   "",    false, false },
  { "Penang Sign Language",                                       "psg",     "",   "",    false, false },
  { "Penchal",                                                    "pek",     "",   "",    false, false },
  { "Pendau",                                                     "ums",     "",   "",    false, false },
  { "Pengo",                                                      "peg",     "",   "",    false, false },
  { "Pennsylvania German",                                        "pdc",     "",   "",    false, false },
  { "Penrhyn",                                                    "pnh",     "",   "",    false, false },
  { "Pentlatch",                                                  "ptw",     "",   "",    false, false },
  { "Perai",                                                      "wet",     "",   "",    false, false },
  { "Peranakan Indonesian",                                       "pea",     "",   "",    false, false },
  { "Pere",                                                       "pfe",     "",   "",    false, false },
  { "Peripheral Mongolian",                                       "mvf",     "",   "",    false, false },
  { "Pero",                                                       "pip",     "",   "",    false, false },
  { "Persian",                                                    "per",     "fa", "fas", true,  false },
  { "Peruvian Sign Language",                                     "prl",     "",   "",    false, false },
  { "Pesse",                                                      "pze",     "",   "",    false, false },
  { "Petapa Zapotec",                                             "zpe",     "",   "",    false, false },
  { "Petats",                                                     "pex",     "",   "",    false, false },
  { "Petjo",                                                      "pey",     "",   "",    false, false },
  { "Peñoles Mixtec",                                             "mil",     "",   "",    false, false },
  { "Pfaelzisch",                                                 "pfl",     "",   "",    false, false },
  { "Phai",                                                       "prt",     "",   "",    false, false },
  { "Phake",                                                      "phk",     "",   "",    false, false },
  { "Phala",                                                      "ypa",     "",   "",    false, false },
  { "Phalura",                                                    "phl",     "",   "",    false, false },
  { "Phana'",                                                     "phq",     "",   "",    false, false },
  { "Phangduwali",                                                "phw",     "",   "",    false, false },
  { "Phende",                                                     "pem",     "",   "",    false, false },
  { "Philippine Sign Language",                                   "psp",     "",   "",    false, false },
  { "Philippine languages",                                       "phi",     "",   "",    true,  false },
  { "Phimbi",                                                     "phm",     "",   "",    false, false },
  { "Phoenician",                                                 "phn",     "",   "",    true,  false },
  { "Phola",                                                      "ypg",     "",   "",    false, false },
  { "Pholo",                                                      "yip",     "",   "",    false, false },
  { "Phom Naga",                                                  "nph",     "",   "",    false, false },
  { "Phong-Kniang",                                               "pnx",     "",   "",    false, false },
  { "Phrae Pwo Karen",                                            "kjt",     "",   "",    false, false },
  { "Phrygian",                                                   "xpg",     "",   "",    false, false },
  { "Phu Thai",                                                   "pht",     "",   "",    false, false },
  { "Phuan",                                                      "phu",     "",   "",    false, false },
  { "Phudagi",                                                    "phd",     "",   "",    false, false },
  { "Phuie",                                                      "pug",     "",   "",    false, false },
  { "Phukha",                                                     "phh",     "",   "",    false, false },
  { "Phuma",                                                      "ypm",     "",   "",    false, false },
  { "Phunoi",                                                     "pho",     "",   "",    false, false },
  { "Phuong",                                                     "phg",     "",   "",    false, false },
  { "Phupa",                                                      "ypp",     "",   "",    false, false },
  { "Phupha",                                                     "yph",     "",   "",    false, false },
  { "Phuza",                                                      "ypz",     "",   "",    false, false },
  { "Piamatsina",                                                 "ptr",     "",   "",    false, false },
  { "Piame",                                                      "pin",     "",   "",    false, false },
  { "Piapoco",                                                    "pio",     "",   "",    false, false },
  { "Piaroa",                                                     "pid",     "",   "",    false, false },
  { "Picard",                                                     "pcd",     "",   "",    false, false },
  { "Pichis Ashéninka",                                           "cpu",     "",   "",    false, false },
  { "Pictish",                                                    "xpi",     "",   "",    false, false },
  { "Pidgin Delaware",                                            "dep",     "",   "",    false, false },
  { "Piemontese",                                                 "pms",     "",   "",    false, false },
  { "Pijao",                                                      "pij",     "",   "",    false, false },
  { "Pije",                                                       "piz",     "",   "",    false, false },
  { "Pijin",                                                      "pis",     "",   "",    false, false },
  { "Pilagá",                                                     "plg",     "",   "",    false, false },
  { "Pileni",                                                     "piv",     "",   "",    false, false },
  { "Pima Bajo",                                                  "pia",     "",   "",    false, false },
  { "Pimbwe",                                                     "piw",     "",   "",    false, false },
  { "Pinai-Hagahai",                                              "pnn",     "",   "",    false, false },
  { "Pindiini",                                                   "pti",     "",   "",    false, false },
  { "Pingelapese",                                                "pif",     "",   "",    false, false },
  { "Pini",                                                       "pii",     "",   "",    false, true  },
  { "Pinigura",                                                   "pnv",     "",   "",    false, false },
  { "Pinjarup",                                                   "pnj",     "",   "",    false, false },
  { "Pinji",                                                      "pic",     "",   "",    false, false },
  { "Pinotepa Nacional Mixtec",                                   "mio",     "",   "",    false, false },
  { "Pintupi-Luritja",                                            "piu",     "",   "",    false, false },
  { "Pinyin",                                                     "pny",     "",   "",    false, false },
  { "Pipil",                                                      "ppl",     "",   "",    false, false },
  { "Pirahã",                                                     "myp",     "",   "",    false, false },
  { "Piratapuyo",                                                 "pir",     "",   "",    false, false },
  { "Pirlatapa",                                                  "bxi",     "",   "",    false, false },
  { "Piro",                                                       "pie",     "",   "",    false, false },
  { "Pirriya",                                                    "xpa",     "",   "",    false, false },
  { "Piru",                                                       "ppr",     "",   "",    false, true  },
  { "Pisabo",                                                     "pig",     "",   "",    false, false },
  { "Pisaflores Tepehua",                                         "tpp",     "",   "",    false, false },
  { "Piscataway",                                                 "psy",     "",   "",    false, false },
  { "Pisidian",                                                   "xps",     "",   "",    false, false },
  { "Pitcairn-Norfolk",                                           "pih",     "",   "",    false, false },
  { "Pite Sami",                                                  "sje",     "",   "",    false, false },
  { "Piti",                                                       "pcn",     "",   "",    false, false },
  { "Pitjantjatjara",                                             "pjt",     "",   "",    false, false },
  { "Pitta Pitta",                                                "pit",     "",   "",    false, false },
  { "Piu",                                                        "pix",     "",   "",    false, false },
  { "Piya-Kwonci",                                                "piy",     "",   "",    false, false },
  { "Plains Cree",                                                "crk",     "",   "",    false, false },
  { "Plains Indian Sign Language",                                "psd",     "",   "",    false, false },
  { "Plains Miwok",                                               "pmw",     "",   "",    false, false },
  { "Plapo Krumen",                                               "ktj",     "",   "",    false, false },
  { "Plateau Malagasy",                                           "plt",     "",   "",    false, false },
  { "Plautdietsch",                                               "pdt",     "",   "",    false, false },
  { "Playero",                                                    "gob",     "",   "",    false, false },
  { "Pnar",                                                       "pbv",     "",   "",    false, false },
  { "Pochuri Naga",                                               "npo",     "",   "",    false, false },
  { "Pochutec",                                                   "xpo",     "",   "",    false, false },
  { "Podena",                                                     "pdn",     "",   "",    false, false },
  { "Pogolo",                                                     "poy",     "",   "",    false, false },
  { "Pohnpeian",                                                  "pon",     "",   "",    true,  false },
  { "Pokangá",                                                    "pok",     "",   "",    false, false },
  { "Poke",                                                       "pof",     "",   "",    false, false },
  { "Pokomo",                                                     "pkb",     "",   "",    false, false },
  { "Polabian",                                                   "pox",     "",   "",    false, false },
  { "Polari",                                                     "pld",     "",   "",    false, false },
  { "Polci",                                                      "plj",     "",   "",    false, true  },
  { "Polish Sign Language",                                       "pso",     "",   "",    false, false },
  { "Polish",                                                     "pol",     "pl", "",    true,  false },
  { "Polonombauk",                                                "plb",     "",   "",    false, false },
  { "Pom",                                                        "pmo",     "",   "",    false, false },
  { "Pomo",                                                       "pmm",     "",   "",    false, false },
  { "Ponam",                                                      "ncc",     "",   "",    false, false },
  { "Ponares",                                                    "pod",     "",   "",    false, true  },
  { "Pongyong",                                                   "pgy",     "",   "",    false, true  },
  { "Ponosakan",                                                  "pns",     "",   "",    false, false },
  { "Pontic",                                                     "pnt",     "",   "",    false, false },
  { "Ponyo-Gongwang Naga",                                        "npg",     "",   "",    false, false },
  { "Popti'",                                                     "jac",     "",   "",    false, false },
  { "Poqomam",                                                    "poc",     "",   "",    false, false },
  { "Poqomchi'",                                                  "poh",     "",   "",    false, false },
  { "Porohanon",                                                  "prh",     "",   "",    false, false },
  { "Port Sandwich",                                              "psw",     "",   "",    false, false },
  { "Port Sorell Tasmanian",                                      "xpl",     "",   "",    false, false },
  { "Port Vato",                                                  "ptv",     "",   "",    false, false },
  { "Portuguese Sign Language",                                   "psr",     "",   "",    false, false },
  { "Portuguese",                                                 "por",     "pt", "",    true,  false },
  { "Potawatomi",                                                 "pot",     "",   "",    false, false },
  { "Potiguára",                                                  "pog",     "",   "",    false, false },
  { "Pottangi Ollar Gadaba",                                      "gdb",     "",   "",    false, false },
  { "Poumei Naga",                                                "pmx",     "",   "",    false, false },
  { "Pouye",                                                      "bye",     "",   "",    false, false },
  { "Powari",                                                     "pwr",     "",   "",    false, false },
  { "Powhatan",                                                   "pim",     "",   "",    false, false },
  { "Poyanáwa",                                                   "pyn",     "",   "",    false, false },
  { "Prakrit languages",                                          "pra",     "",   "",    true,  false },
  { "Prasuni",                                                    "prn",     "",   "",    false, false },
  { "Pray 3",                                                     "pry",     "",   "",    false, true  },
  { "Primitive Irish",                                            "pgl",     "",   "",    false, false },
  { "Principense",                                                "pre",     "",   "",    false, false },
  { "Providencia Sign Language",                                  "prz",     "",   "",    false, false },
  { "Prussian",                                                   "prg",     "",   "",    false, false },
  { "Psikye",                                                     "kvj",     "",   "",    false, false },
  { "Pu Ko",                                                      "puk",     "",   "",    false, true  },
  { "Pu-Xian Chinese",                                            "cpx",     "",   "",    false, false },
  { "Puare",                                                      "pux",     "",   "",    false, false },
  { "Pudtol Atta",                                                "atp",     "",   "",    false, false },
  { "Puebla Mazatec",                                             "pbm",     "",   "",    false, false },
  { "Puelche",                                                    "pue",     "",   "",    false, false },
  { "Puerto Rican Sign Language",                                 "psl",     "",   "",    false, false },
  { "Puimei Naga",                                                "npu",     "",   "",    false, false },
  { "Puinave",                                                    "pui",     "",   "",    false, false },
  { "Pukapuka",                                                   "pkp",     "",   "",    false, false },
  { "Pulaar",                                                     "fuc",     "",   "",    false, false },
  { "Pulabu",                                                     "pup",     "",   "",    false, false },
  { "Pular",                                                      "fuf",     "",   "",    false, false },
  { "Puluwatese",                                                 "puw",     "",   "",    false, false },
  { "Puma",                                                       "pum",     "",   "",    false, false },
  { "Pumpokol",                                                   "xpm",     "",   "",    false, false },
  { "Pumé",                                                       "yae",     "",   "",    false, false },
  { "Punan Aput",                                                 "pud",     "",   "",    false, false },
  { "Punan Bah-Biau",                                             "pna",     "",   "",    false, false },
  { "Punan Batu 1",                                               "pnm",     "",   "",    false, false },
  { "Punan Merah",                                                "puf",     "",   "",    false, false },
  { "Punan Merap",                                                "puc",     "",   "",    false, false },
  { "Punan Tubu",                                                 "puj",     "",   "",    false, false },
  { "Punic",                                                      "xpu",     "",   "",    false, false },
  { "Puno Quechua",                                               "qxp",     "",   "",    false, false },
  { "Punthamara",                                                 "xpt",     "",   "",    false, false },
  { "Punu",                                                       "puu",     "",   "",    false, false },
  { "Puoc",                                                       "puo",     "",   "",    false, false },
  { "Puquina",                                                    "puq",     "",   "",    false, false },
  { "Puragi",                                                     "pru",     "",   "",    false, false },
  { "Purari",                                                     "iar",     "",   "",    false, false },
  { "Purepecha",                                                  "tsz",     "",   "",    false, false },
  { "Puri",                                                       "prr",     "",   "",    false, false },
  { "Purik",                                                      "prx",     "",   "",    false, false },
  { "Purisimeño",                                                 "puy",     "",   "",    false, false },
  { "Puroik",                                                     "suv",     "",   "",    false, false },
  { "Puruborá",                                                   "pur",     "",   "",    false, false },
  { "Purum Naga",                                                 "puz",     "",   "",    false, true  },
  { "Purum",                                                      "pub",     "",   "",    false, false },
  { "Pushto",                                                     "pus",     "ps", "",    true,  false },
  { "Putai",                                                      "mfl",     "",   "",    false, false },
  { "Putoh",                                                      "put",     "",   "",    false, false },
  { "Putukwam",                                                   "afe",     "",   "",    false, false },
  { "Puyo",                                                       "xpy",     "",   "",    false, false },
  { "Puyo-Paekche",                                               "xpp",     "",   "",    false, false },
  { "Puyuma",                                                     "pyu",     "",   "",    false, false },
  { "Pwaamei",                                                    "pme",     "",   "",    false, false },
  { "Pwapwâ",                                                     "pop",     "",   "",    false, false },
  { "Pwo Eastern Karen",                                          "kjp",     "",   "",    false, false },
  { "Pwo Northern Karen",                                         "pww",     "",   "",    false, false },
  { "Pwo Western Karen",                                          "pwo",     "",   "",    false, false },
  { "Pyapun",                                                     "pcw",     "",   "",    false, false },
  { "Pye Krumen",                                                 "pye",     "",   "",    false, false },
  { "Pyen",                                                       "pyy",     "",   "",    false, false },
  { "Pyu (Myanmar)",                                              "pyx",     "",   "",    false, false },
  { "Pyu (Papua New Guinea)",                                     "pby",     "",   "",    false, false },
  { "Páez",                                                       "pbb",     "",   "",    false, false },
  { "Pááfang",                                                    "pfa",     "",   "",    false, false },
  { "Päri",                                                       "lkr",     "",   "",    false, false },
  { "Pémono",                                                     "pev",     "",   "",    false, false },
  { "Pévé",                                                       "lme",     "",   "",    false, false },
  { "Pökoot",                                                     "pko",     "",   "",    false, false },
  { "Q'anjob'al",                                                 "kjb",     "",   "",    false, false },
  { "Qabiao",                                                     "laq",     "",   "",    false, false },
  { "Qaqet",                                                      "byx",     "",   "",    false, false },
  { "Qashqa'i",                                                   "qxq",     "",   "",    false, false },
  { "Qatabanian",                                                 "xqt",     "",   "",    false, false },
  { "Qau",                                                        "gqu",     "",   "",    false, false },
  { "Qawasqar",                                                   "alc",     "",   "",    false, false },
  { "Qila Muji",                                                  "ymq",     "",   "",    false, false },
  { "Qimant",                                                     "ahg",     "",   "",    false, false },
  { "Qiubei Zhuang",                                              "zqe",     "",   "",    false, false },
  { "Quapaw",                                                     "qua",     "",   "",    false, false },
  { "Quebec Sign Language",                                       "fcs",     "",   "",    false, false },
  { "Quechan",                                                    "yum",     "",   "",    false, false },
  { "Quechua",                                                    "que",     "qu", "",    true,  false },
  { "Quechuan (family)",                                          "qwe",     "",   "",    false, false },
  { "Quenya",                                                     "qya",     "",   "",    false, false },
  { "Querétaro Otomi",                                            "otq",     "",   "",    false, false },
  { "Quetzaltepec Mixe",                                          "pxm",     "",   "",    false, false },
  { "Queyu",                                                      "qvy",     "",   "",    false, false },
  { "Quiavicuzas Zapotec",                                        "zpj",     "",   "",    false, false },
  { "Quileute",                                                   "qui",     "",   "",    false, false },
  { "Quinault",                                                   "qun",     "",   "",    false, false },
  { "Quinqui",                                                    "quq",     "",   "",    false, false },
  { "Quioquitani-Quierí Zapotec",                                 "ztq",     "",   "",    false, false },
  { "Quiotepec Chinantec",                                        "chq",     "",   "",    false, false },
  { "Quiripi",                                                    "qyp",     "",   "",    false, false },
  { "Rabha",                                                      "rah",     "",   "",    false, false },
  { "Rade",                                                       "rad",     "",   "",    false, false },
  { "Raetic",                                                     "xrr",     "",   "",    false, false },
  { "Rahambuu",                                                   "raz",     "",   "",    false, false },
  { "Rajah Kabunsuwan Manobo",                                    "mqk",     "",   "",    false, false },
  { "Rajasthani",                                                 "raj",     "",   "",    true,  false },
  { "Rajbanshi",                                                  "rjs",     "",   "",    false, false },
  { "Raji",                                                       "rji",     "",   "",    false, false },
  { "Rajong",                                                     "rjg",     "",   "",    false, false },
  { "Rajput Garasia",                                             "gra",     "",   "",    false, false },
  { "Rakahanga-Manihiki",                                         "rkh",     "",   "",    false, false },
  { "Rakhine",                                                    "rki",     "",   "",    false, false },
  { "Ralte",                                                      "ral",     "",   "",    false, false },
  { "Rama",                                                       "rma",     "",   "",    false, false },
  { "Ramoaaina",                                                  "rai",     "",   "",    false, false },
  { "Ramopa",                                                     "kjx",     "",   "",    false, false },
  { "Rampi",                                                      "lje",     "",   "",    false, false },
  { "Rana Tharu",                                                 "thr",     "",   "",    false, false },
  { "Rang",                                                       "rax",     "",   "",    false, false },
  { "Rangi",                                                      "lag",     "",   "",    false, false },
  { "Rangkas",                                                    "rgk",     "",   "",    false, false },
  { "Ranglong",                                                   "rnl",     "",   "",    false, false },
  { "Rangpuri",                                                   "rkt",     "",   "",    false, false },
  { "Rao",                                                        "rao",     "",   "",    false, false },
  { "Rapa",                                                       "ray",     "",   "",    false, false },
  { "Rapanui",                                                    "rap",     "",   "",    true,  false },
  { "Rapoisi",                                                    "kyx",     "",   "",    false, false },
  { "Rapting",                                                    "rpt",     "",   "",    false, false },
  { "Rara Bakati'",                                               "lra",     "",   "",    false, false },
  { "Rarotongan",                                                 "rar",     "",   "",    true,  false },
  { "Rasawa",                                                     "rac",     "",   "",    false, false },
  { "Ratagnon",                                                   "btn",     "",   "",    false, false },
  { "Ratahan",                                                    "rth",     "",   "",    false, false },
  { "Rathawi",                                                    "rtw",     "",   "",    false, false },
  { "Rathwi Bareli",                                              "bgd",     "",   "",    false, false },
  { "Raute",                                                      "rau",     "",   "",    false, false },
  { "Ravula",                                                     "yea",     "",   "",    false, false },
  { "Rawa",                                                       "rwo",     "",   "",    false, false },
  { "Rawang",                                                     "raw",     "",   "",    false, false },
  { "Rawat",                                                      "jnl",     "",   "",    false, false },
  { "Rawngtu Chin",                                               "weu",     "",   "",    false, false },
  { "Rawo",                                                       "rwa",     "",   "",    false, false },
  { "Rayón Zoque",                                                "zor",     "",   "",    false, false },
  { "Razajerdi",                                                  "rat",     "",   "",    false, false },
  { "Red Gelao",                                                  "gir",     "",   "",    false, false },
  { "Reel",                                                       "atu",     "",   "",    false, false },
  { "Rejang Kayan",                                               "ree",     "",   "",    false, false },
  { "Rejang",                                                     "rej",     "",   "",    false, false },
  { "Reli",                                                       "rei",     "",   "",    false, false },
  { "Rema",                                                       "bow",     "",   "",    false, false },
  { "Rembarrnga",                                                 "rmb",     "",   "",    false, false },
  { "Rembong",                                                    "reb",     "",   "",    false, false },
  { "Remo",                                                       "rem",     "",   "",    false, false },
  { "Remontado Dumagat",                                          "agv",     "",   "",    false, false },
  { "Rempi",                                                      "rmp",     "",   "",    false, false },
  { "Remun",                                                      "lkj",     "",   "",    false, false },
  { "Rendille",                                                   "rel",     "",   "",    false, false },
  { "Rengao",                                                     "ren",     "",   "",    false, false },
  { "Rennell-Bellona",                                            "mnv",     "",   "",    false, false },
  { "Rennellese Sign Language",                                   "rsi",     "",   "",    false, true  },
  { "Repanbitip",                                                 "rpn",     "",   "",    false, false },
  { "Rer Bare",                                                   "rer",     "",   "",    false, false },
  { "Rerau",                                                      "rea",     "",   "",    false, false },
  { "Rerep",                                                      "pgk",     "",   "",    false, false },
  { "Reserved for local use",                                     "qaa-qtz", "",   "",    true,  false },
  { "Reserved for local use: qaa",                                "qaa",     "",   "",    true,  false },
  { "Reserved for local use: qab",                                "qab",     "",   "",    true,  false },
  { "Reserved for local use: qac",                                "qac",     "",   "",    true,  false },
  { "Reserved for local use: qad",                                "qad",     "",   "",    true,  false },
  { "Reserved for local use: qae",                                "qae",     "",   "",    true,  false },
  { "Reserved for local use: qaf",                                "qaf",     "",   "",    true,  false },
  { "Reserved for local use: qag",                                "qag",     "",   "",    true,  false },
  { "Reserved for local use: qah",                                "qah",     "",   "",    true,  false },
  { "Reserved for local use: qai",                                "qai",     "",   "",    true,  false },
  { "Reserved for local use: qaj",                                "qaj",     "",   "",    true,  false },
  { "Reserved for local use: qak",                                "qak",     "",   "",    true,  false },
  { "Reserved for local use: qal",                                "qal",     "",   "",    true,  false },
  { "Reserved for local use: qam",                                "qam",     "",   "",    true,  false },
  { "Reserved for local use: qan",                                "qan",     "",   "",    true,  false },
  { "Reserved for local use: qao",                                "qao",     "",   "",    true,  false },
  { "Reserved for local use: qap",                                "qap",     "",   "",    true,  false },
  { "Reserved for local use: qaq",                                "qaq",     "",   "",    true,  false },
  { "Reserved for local use: qar",                                "qar",     "",   "",    true,  false },
  { "Reserved for local use: qas",                                "qas",     "",   "",    true,  false },
  { "Reserved for local use: qat",                                "qat",     "",   "",    true,  false },
  { "Reserved for local use: qau",                                "qau",     "",   "",    true,  false },
  { "Reserved for local use: qav",                                "qav",     "",   "",    true,  false },
  { "Reserved for local use: qaw",                                "qaw",     "",   "",    true,  false },
  { "Reserved for local use: qax",                                "qax",     "",   "",    true,  false },
  { "Reserved for local use: qay",                                "qay",     "",   "",    true,  false },
  { "Reserved for local use: qaz",                                "qaz",     "",   "",    true,  false },
  { "Reserved for local use: qba",                                "qba",     "",   "",    true,  false },
  { "Reserved for local use: qbb",                                "qbb",     "",   "",    true,  false },
  { "Reserved for local use: qbc",                                "qbc",     "",   "",    true,  false },
  { "Reserved for local use: qbd",                                "qbd",     "",   "",    true,  false },
  { "Reserved for local use: qbe",                                "qbe",     "",   "",    true,  false },
  { "Reserved for local use: qbf",                                "qbf",     "",   "",    true,  false },
  { "Reserved for local use: qbg",                                "qbg",     "",   "",    true,  false },
  { "Reserved for local use: qbh",                                "qbh",     "",   "",    true,  false },
  { "Reserved for local use: qbi",                                "qbi",     "",   "",    true,  false },
  { "Reserved for local use: qbj",                                "qbj",     "",   "",    true,  false },
  { "Reserved for local use: qbk",                                "qbk",     "",   "",    true,  false },
  { "Reserved for local use: qbl",                                "qbl",     "",   "",    true,  false },
  { "Reserved for local use: qbm",                                "qbm",     "",   "",    true,  false },
  { "Reserved for local use: qbn",                                "qbn",     "",   "",    true,  false },
  { "Reserved for local use: qbo",                                "qbo",     "",   "",    true,  false },
  { "Reserved for local use: qbp",                                "qbp",     "",   "",    true,  false },
  { "Reserved for local use: qbq",                                "qbq",     "",   "",    true,  false },
  { "Reserved for local use: qbr",                                "qbr",     "",   "",    true,  false },
  { "Reserved for local use: qbs",                                "qbs",     "",   "",    true,  false },
  { "Reserved for local use: qbt",                                "qbt",     "",   "",    true,  false },
  { "Reserved for local use: qbu",                                "qbu",     "",   "",    true,  false },
  { "Reserved for local use: qbv",                                "qbv",     "",   "",    true,  false },
  { "Reserved for local use: qbw",                                "qbw",     "",   "",    true,  false },
  { "Reserved for local use: qbx",                                "qbx",     "",   "",    true,  false },
  { "Reserved for local use: qby",                                "qby",     "",   "",    true,  false },
  { "Reserved for local use: qbz",                                "qbz",     "",   "",    true,  false },
  { "Reserved for local use: qca",                                "qca",     "",   "",    true,  false },
  { "Reserved for local use: qcb",                                "qcb",     "",   "",    true,  false },
  { "Reserved for local use: qcc",                                "qcc",     "",   "",    true,  false },
  { "Reserved for local use: qcd",                                "qcd",     "",   "",    true,  false },
  { "Reserved for local use: qce",                                "qce",     "",   "",    true,  false },
  { "Reserved for local use: qcf",                                "qcf",     "",   "",    true,  false },
  { "Reserved for local use: qcg",                                "qcg",     "",   "",    true,  false },
  { "Reserved for local use: qch",                                "qch",     "",   "",    true,  false },
  { "Reserved for local use: qci",                                "qci",     "",   "",    true,  false },
  { "Reserved for local use: qcj",                                "qcj",     "",   "",    true,  false },
  { "Reserved for local use: qck",                                "qck",     "",   "",    true,  false },
  { "Reserved for local use: qcl",                                "qcl",     "",   "",    true,  false },
  { "Reserved for local use: qcm",                                "qcm",     "",   "",    true,  false },
  { "Reserved for local use: qcn",                                "qcn",     "",   "",    true,  false },
  { "Reserved for local use: qco",                                "qco",     "",   "",    true,  false },
  { "Reserved for local use: qcp",                                "qcp",     "",   "",    true,  false },
  { "Reserved for local use: qcq",                                "qcq",     "",   "",    true,  false },
  { "Reserved for local use: qcr",                                "qcr",     "",   "",    true,  false },
  { "Reserved for local use: qcs",                                "qcs",     "",   "",    true,  false },
  { "Reserved for local use: qct",                                "qct",     "",   "",    true,  false },
  { "Reserved for local use: qcu",                                "qcu",     "",   "",    true,  false },
  { "Reserved for local use: qcv",                                "qcv",     "",   "",    true,  false },
  { "Reserved for local use: qcw",                                "qcw",     "",   "",    true,  false },
  { "Reserved for local use: qcx",                                "qcx",     "",   "",    true,  false },
  { "Reserved for local use: qcy",                                "qcy",     "",   "",    true,  false },
  { "Reserved for local use: qcz",                                "qcz",     "",   "",    true,  false },
  { "Reserved for local use: qda",                                "qda",     "",   "",    true,  false },
  { "Reserved for local use: qdb",                                "qdb",     "",   "",    true,  false },
  { "Reserved for local use: qdc",                                "qdc",     "",   "",    true,  false },
  { "Reserved for local use: qdd",                                "qdd",     "",   "",    true,  false },
  { "Reserved for local use: qde",                                "qde",     "",   "",    true,  false },
  { "Reserved for local use: qdf",                                "qdf",     "",   "",    true,  false },
  { "Reserved for local use: qdg",                                "qdg",     "",   "",    true,  false },
  { "Reserved for local use: qdh",                                "qdh",     "",   "",    true,  false },
  { "Reserved for local use: qdi",                                "qdi",     "",   "",    true,  false },
  { "Reserved for local use: qdj",                                "qdj",     "",   "",    true,  false },
  { "Reserved for local use: qdk",                                "qdk",     "",   "",    true,  false },
  { "Reserved for local use: qdl",                                "qdl",     "",   "",    true,  false },
  { "Reserved for local use: qdm",                                "qdm",     "",   "",    true,  false },
  { "Reserved for local use: qdn",                                "qdn",     "",   "",    true,  false },
  { "Reserved for local use: qdo",                                "qdo",     "",   "",    true,  false },
  { "Reserved for local use: qdp",                                "qdp",     "",   "",    true,  false },
  { "Reserved for local use: qdq",                                "qdq",     "",   "",    true,  false },
  { "Reserved for local use: qdr",                                "qdr",     "",   "",    true,  false },
  { "Reserved for local use: qds",                                "qds",     "",   "",    true,  false },
  { "Reserved for local use: qdt",                                "qdt",     "",   "",    true,  false },
  { "Reserved for local use: qdu",                                "qdu",     "",   "",    true,  false },
  { "Reserved for local use: qdv",                                "qdv",     "",   "",    true,  false },
  { "Reserved for local use: qdw",                                "qdw",     "",   "",    true,  false },
  { "Reserved for local use: qdx",                                "qdx",     "",   "",    true,  false },
  { "Reserved for local use: qdy",                                "qdy",     "",   "",    true,  false },
  { "Reserved for local use: qdz",                                "qdz",     "",   "",    true,  false },
  { "Reserved for local use: qea",                                "qea",     "",   "",    true,  false },
  { "Reserved for local use: qeb",                                "qeb",     "",   "",    true,  false },
  { "Reserved for local use: qec",                                "qec",     "",   "",    true,  false },
  { "Reserved for local use: qed",                                "qed",     "",   "",    true,  false },
  { "Reserved for local use: qee",                                "qee",     "",   "",    true,  false },
  { "Reserved for local use: qef",                                "qef",     "",   "",    true,  false },
  { "Reserved for local use: qeg",                                "qeg",     "",   "",    true,  false },
  { "Reserved for local use: qeh",                                "qeh",     "",   "",    true,  false },
  { "Reserved for local use: qei",                                "qei",     "",   "",    true,  false },
  { "Reserved for local use: qej",                                "qej",     "",   "",    true,  false },
  { "Reserved for local use: qek",                                "qek",     "",   "",    true,  false },
  { "Reserved for local use: qel",                                "qel",     "",   "",    true,  false },
  { "Reserved for local use: qem",                                "qem",     "",   "",    true,  false },
  { "Reserved for local use: qen",                                "qen",     "",   "",    true,  false },
  { "Reserved for local use: qeo",                                "qeo",     "",   "",    true,  false },
  { "Reserved for local use: qep",                                "qep",     "",   "",    true,  false },
  { "Reserved for local use: qeq",                                "qeq",     "",   "",    true,  false },
  { "Reserved for local use: qer",                                "qer",     "",   "",    true,  false },
  { "Reserved for local use: qes",                                "qes",     "",   "",    true,  false },
  { "Reserved for local use: qet",                                "qet",     "",   "",    true,  false },
  { "Reserved for local use: qeu",                                "qeu",     "",   "",    true,  false },
  { "Reserved for local use: qev",                                "qev",     "",   "",    true,  false },
  { "Reserved for local use: qew",                                "qew",     "",   "",    true,  false },
  { "Reserved for local use: qex",                                "qex",     "",   "",    true,  false },
  { "Reserved for local use: qey",                                "qey",     "",   "",    true,  false },
  { "Reserved for local use: qez",                                "qez",     "",   "",    true,  false },
  { "Reserved for local use: qfa",                                "qfa",     "",   "",    true,  false },
  { "Reserved for local use: qfb",                                "qfb",     "",   "",    true,  false },
  { "Reserved for local use: qfc",                                "qfc",     "",   "",    true,  false },
  { "Reserved for local use: qfd",                                "qfd",     "",   "",    true,  false },
  { "Reserved for local use: qfe",                                "qfe",     "",   "",    true,  false },
  { "Reserved for local use: qff",                                "qff",     "",   "",    true,  false },
  { "Reserved for local use: qfg",                                "qfg",     "",   "",    true,  false },
  { "Reserved for local use: qfh",                                "qfh",     "",   "",    true,  false },
  { "Reserved for local use: qfi",                                "qfi",     "",   "",    true,  false },
  { "Reserved for local use: qfj",                                "qfj",     "",   "",    true,  false },
  { "Reserved for local use: qfk",                                "qfk",     "",   "",    true,  false },
  { "Reserved for local use: qfl",                                "qfl",     "",   "",    true,  false },
  { "Reserved for local use: qfm",                                "qfm",     "",   "",    true,  false },
  { "Reserved for local use: qfn",                                "qfn",     "",   "",    true,  false },
  { "Reserved for local use: qfo",                                "qfo",     "",   "",    true,  false },
  { "Reserved for local use: qfp",                                "qfp",     "",   "",    true,  false },
  { "Reserved for local use: qfq",                                "qfq",     "",   "",    true,  false },
  { "Reserved for local use: qfr",                                "qfr",     "",   "",    true,  false },
  { "Reserved for local use: qfs",                                "qfs",     "",   "",    true,  false },
  { "Reserved for local use: qft",                                "qft",     "",   "",    true,  false },
  { "Reserved for local use: qfu",                                "qfu",     "",   "",    true,  false },
  { "Reserved for local use: qfv",                                "qfv",     "",   "",    true,  false },
  { "Reserved for local use: qfw",                                "qfw",     "",   "",    true,  false },
  { "Reserved for local use: qfx",                                "qfx",     "",   "",    true,  false },
  { "Reserved for local use: qfy",                                "qfy",     "",   "",    true,  false },
  { "Reserved for local use: qfz",                                "qfz",     "",   "",    true,  false },
  { "Reserved for local use: qga",                                "qga",     "",   "",    true,  false },
  { "Reserved for local use: qgb",                                "qgb",     "",   "",    true,  false },
  { "Reserved for local use: qgc",                                "qgc",     "",   "",    true,  false },
  { "Reserved for local use: qgd",                                "qgd",     "",   "",    true,  false },
  { "Reserved for local use: qge",                                "qge",     "",   "",    true,  false },
  { "Reserved for local use: qgf",                                "qgf",     "",   "",    true,  false },
  { "Reserved for local use: qgg",                                "qgg",     "",   "",    true,  false },
  { "Reserved for local use: qgh",                                "qgh",     "",   "",    true,  false },
  { "Reserved for local use: qgi",                                "qgi",     "",   "",    true,  false },
  { "Reserved for local use: qgj",                                "qgj",     "",   "",    true,  false },
  { "Reserved for local use: qgk",                                "qgk",     "",   "",    true,  false },
  { "Reserved for local use: qgl",                                "qgl",     "",   "",    true,  false },
  { "Reserved for local use: qgm",                                "qgm",     "",   "",    true,  false },
  { "Reserved for local use: qgn",                                "qgn",     "",   "",    true,  false },
  { "Reserved for local use: qgo",                                "qgo",     "",   "",    true,  false },
  { "Reserved for local use: qgp",                                "qgp",     "",   "",    true,  false },
  { "Reserved for local use: qgq",                                "qgq",     "",   "",    true,  false },
  { "Reserved for local use: qgr",                                "qgr",     "",   "",    true,  false },
  { "Reserved for local use: qgs",                                "qgs",     "",   "",    true,  false },
  { "Reserved for local use: qgt",                                "qgt",     "",   "",    true,  false },
  { "Reserved for local use: qgu",                                "qgu",     "",   "",    true,  false },
  { "Reserved for local use: qgv",                                "qgv",     "",   "",    true,  false },
  { "Reserved for local use: qgw",                                "qgw",     "",   "",    true,  false },
  { "Reserved for local use: qgx",                                "qgx",     "",   "",    true,  false },
  { "Reserved for local use: qgy",                                "qgy",     "",   "",    true,  false },
  { "Reserved for local use: qgz",                                "qgz",     "",   "",    true,  false },
  { "Reserved for local use: qha",                                "qha",     "",   "",    true,  false },
  { "Reserved for local use: qhb",                                "qhb",     "",   "",    true,  false },
  { "Reserved for local use: qhc",                                "qhc",     "",   "",    true,  false },
  { "Reserved for local use: qhd",                                "qhd",     "",   "",    true,  false },
  { "Reserved for local use: qhe",                                "qhe",     "",   "",    true,  false },
  { "Reserved for local use: qhf",                                "qhf",     "",   "",    true,  false },
  { "Reserved for local use: qhg",                                "qhg",     "",   "",    true,  false },
  { "Reserved for local use: qhh",                                "qhh",     "",   "",    true,  false },
  { "Reserved for local use: qhi",                                "qhi",     "",   "",    true,  false },
  { "Reserved for local use: qhj",                                "qhj",     "",   "",    true,  false },
  { "Reserved for local use: qhk",                                "qhk",     "",   "",    true,  false },
  { "Reserved for local use: qhl",                                "qhl",     "",   "",    true,  false },
  { "Reserved for local use: qhm",                                "qhm",     "",   "",    true,  false },
  { "Reserved for local use: qhn",                                "qhn",     "",   "",    true,  false },
  { "Reserved for local use: qho",                                "qho",     "",   "",    true,  false },
  { "Reserved for local use: qhp",                                "qhp",     "",   "",    true,  false },
  { "Reserved for local use: qhq",                                "qhq",     "",   "",    true,  false },
  { "Reserved for local use: qhr",                                "qhr",     "",   "",    true,  false },
  { "Reserved for local use: qhs",                                "qhs",     "",   "",    true,  false },
  { "Reserved for local use: qht",                                "qht",     "",   "",    true,  false },
  { "Reserved for local use: qhu",                                "qhu",     "",   "",    true,  false },
  { "Reserved for local use: qhv",                                "qhv",     "",   "",    true,  false },
  { "Reserved for local use: qhw",                                "qhw",     "",   "",    true,  false },
  { "Reserved for local use: qhx",                                "qhx",     "",   "",    true,  false },
  { "Reserved for local use: qhy",                                "qhy",     "",   "",    true,  false },
  { "Reserved for local use: qhz",                                "qhz",     "",   "",    true,  false },
  { "Reserved for local use: qia",                                "qia",     "",   "",    true,  false },
  { "Reserved for local use: qib",                                "qib",     "",   "",    true,  false },
  { "Reserved for local use: qic",                                "qic",     "",   "",    true,  false },
  { "Reserved for local use: qid",                                "qid",     "",   "",    true,  false },
  { "Reserved for local use: qie",                                "qie",     "",   "",    true,  false },
  { "Reserved for local use: qif",                                "qif",     "",   "",    true,  false },
  { "Reserved for local use: qig",                                "qig",     "",   "",    true,  false },
  { "Reserved for local use: qih",                                "qih",     "",   "",    true,  false },
  { "Reserved for local use: qii",                                "qii",     "",   "",    true,  false },
  { "Reserved for local use: qij",                                "qij",     "",   "",    true,  false },
  { "Reserved for local use: qik",                                "qik",     "",   "",    true,  false },
  { "Reserved for local use: qil",                                "qil",     "",   "",    true,  false },
  { "Reserved for local use: qim",                                "qim",     "",   "",    true,  false },
  { "Reserved for local use: qin",                                "qin",     "",   "",    true,  false },
  { "Reserved for local use: qio",                                "qio",     "",   "",    true,  false },
  { "Reserved for local use: qip",                                "qip",     "",   "",    true,  false },
  { "Reserved for local use: qiq",                                "qiq",     "",   "",    true,  false },
  { "Reserved for local use: qir",                                "qir",     "",   "",    true,  false },
  { "Reserved for local use: qis",                                "qis",     "",   "",    true,  false },
  { "Reserved for local use: qit",                                "qit",     "",   "",    true,  false },
  { "Reserved for local use: qiu",                                "qiu",     "",   "",    true,  false },
  { "Reserved for local use: qiv",                                "qiv",     "",   "",    true,  false },
  { "Reserved for local use: qiw",                                "qiw",     "",   "",    true,  false },
  { "Reserved for local use: qix",                                "qix",     "",   "",    true,  false },
  { "Reserved for local use: qiy",                                "qiy",     "",   "",    true,  false },
  { "Reserved for local use: qiz",                                "qiz",     "",   "",    true,  false },
  { "Reserved for local use: qja",                                "qja",     "",   "",    true,  false },
  { "Reserved for local use: qjb",                                "qjb",     "",   "",    true,  false },
  { "Reserved for local use: qjc",                                "qjc",     "",   "",    true,  false },
  { "Reserved for local use: qjd",                                "qjd",     "",   "",    true,  false },
  { "Reserved for local use: qje",                                "qje",     "",   "",    true,  false },
  { "Reserved for local use: qjf",                                "qjf",     "",   "",    true,  false },
  { "Reserved for local use: qjg",                                "qjg",     "",   "",    true,  false },
  { "Reserved for local use: qjh",                                "qjh",     "",   "",    true,  false },
  { "Reserved for local use: qji",                                "qji",     "",   "",    true,  false },
  { "Reserved for local use: qjj",                                "qjj",     "",   "",    true,  false },
  { "Reserved for local use: qjk",                                "qjk",     "",   "",    true,  false },
  { "Reserved for local use: qjl",                                "qjl",     "",   "",    true,  false },
  { "Reserved for local use: qjm",                                "qjm",     "",   "",    true,  false },
  { "Reserved for local use: qjn",                                "qjn",     "",   "",    true,  false },
  { "Reserved for local use: qjo",                                "qjo",     "",   "",    true,  false },
  { "Reserved for local use: qjp",                                "qjp",     "",   "",    true,  false },
  { "Reserved for local use: qjq",                                "qjq",     "",   "",    true,  false },
  { "Reserved for local use: qjr",                                "qjr",     "",   "",    true,  false },
  { "Reserved for local use: qjs",                                "qjs",     "",   "",    true,  false },
  { "Reserved for local use: qjt",                                "qjt",     "",   "",    true,  false },
  { "Reserved for local use: qju",                                "qju",     "",   "",    true,  false },
  { "Reserved for local use: qjv",                                "qjv",     "",   "",    true,  false },
  { "Reserved for local use: qjw",                                "qjw",     "",   "",    true,  false },
  { "Reserved for local use: qjx",                                "qjx",     "",   "",    true,  false },
  { "Reserved for local use: qjy",                                "qjy",     "",   "",    true,  false },
  { "Reserved for local use: qjz",                                "qjz",     "",   "",    true,  false },
  { "Reserved for local use: qka",                                "qka",     "",   "",    true,  false },
  { "Reserved for local use: qkb",                                "qkb",     "",   "",    true,  false },
  { "Reserved for local use: qkc",                                "qkc",     "",   "",    true,  false },
  { "Reserved for local use: qkd",                                "qkd",     "",   "",    true,  false },
  { "Reserved for local use: qke",                                "qke",     "",   "",    true,  false },
  { "Reserved for local use: qkf",                                "qkf",     "",   "",    true,  false },
  { "Reserved for local use: qkg",                                "qkg",     "",   "",    true,  false },
  { "Reserved for local use: qkh",                                "qkh",     "",   "",    true,  false },
  { "Reserved for local use: qki",                                "qki",     "",   "",    true,  false },
  { "Reserved for local use: qkj",                                "qkj",     "",   "",    true,  false },
  { "Reserved for local use: qkk",                                "qkk",     "",   "",    true,  false },
  { "Reserved for local use: qkl",                                "qkl",     "",   "",    true,  false },
  { "Reserved for local use: qkm",                                "qkm",     "",   "",    true,  false },
  { "Reserved for local use: qkn",                                "qkn",     "",   "",    true,  false },
  { "Reserved for local use: qko",                                "qko",     "",   "",    true,  false },
  { "Reserved for local use: qkp",                                "qkp",     "",   "",    true,  false },
  { "Reserved for local use: qkq",                                "qkq",     "",   "",    true,  false },
  { "Reserved for local use: qkr",                                "qkr",     "",   "",    true,  false },
  { "Reserved for local use: qks",                                "qks",     "",   "",    true,  false },
  { "Reserved for local use: qkt",                                "qkt",     "",   "",    true,  false },
  { "Reserved for local use: qku",                                "qku",     "",   "",    true,  false },
  { "Reserved for local use: qkv",                                "qkv",     "",   "",    true,  false },
  { "Reserved for local use: qkw",                                "qkw",     "",   "",    true,  false },
  { "Reserved for local use: qkx",                                "qkx",     "",   "",    true,  false },
  { "Reserved for local use: qky",                                "qky",     "",   "",    true,  false },
  { "Reserved for local use: qkz",                                "qkz",     "",   "",    true,  false },
  { "Reserved for local use: qla",                                "qla",     "",   "",    true,  false },
  { "Reserved for local use: qlb",                                "qlb",     "",   "",    true,  false },
  { "Reserved for local use: qlc",                                "qlc",     "",   "",    true,  false },
  { "Reserved for local use: qld",                                "qld",     "",   "",    true,  false },
  { "Reserved for local use: qle",                                "qle",     "",   "",    true,  false },
  { "Reserved for local use: qlf",                                "qlf",     "",   "",    true,  false },
  { "Reserved for local use: qlg",                                "qlg",     "",   "",    true,  false },
  { "Reserved for local use: qlh",                                "qlh",     "",   "",    true,  false },
  { "Reserved for local use: qli",                                "qli",     "",   "",    true,  false },
  { "Reserved for local use: qlj",                                "qlj",     "",   "",    true,  false },
  { "Reserved for local use: qlk",                                "qlk",     "",   "",    true,  false },
  { "Reserved for local use: qll",                                "qll",     "",   "",    true,  false },
  { "Reserved for local use: qlm",                                "qlm",     "",   "",    true,  false },
  { "Reserved for local use: qln",                                "qln",     "",   "",    true,  false },
  { "Reserved for local use: qlo",                                "qlo",     "",   "",    true,  false },
  { "Reserved for local use: qlp",                                "qlp",     "",   "",    true,  false },
  { "Reserved for local use: qlq",                                "qlq",     "",   "",    true,  false },
  { "Reserved for local use: qlr",                                "qlr",     "",   "",    true,  false },
  { "Reserved for local use: qls",                                "qls",     "",   "",    true,  false },
  { "Reserved for local use: qlt",                                "qlt",     "",   "",    true,  false },
  { "Reserved for local use: qlu",                                "qlu",     "",   "",    true,  false },
  { "Reserved for local use: qlv",                                "qlv",     "",   "",    true,  false },
  { "Reserved for local use: qlw",                                "qlw",     "",   "",    true,  false },
  { "Reserved for local use: qlx",                                "qlx",     "",   "",    true,  false },
  { "Reserved for local use: qly",                                "qly",     "",   "",    true,  false },
  { "Reserved for local use: qlz",                                "qlz",     "",   "",    true,  false },
  { "Reserved for local use: qma",                                "qma",     "",   "",    true,  false },
  { "Reserved for local use: qmb",                                "qmb",     "",   "",    true,  false },
  { "Reserved for local use: qmc",                                "qmc",     "",   "",    true,  false },
  { "Reserved for local use: qmd",                                "qmd",     "",   "",    true,  false },
  { "Reserved for local use: qme",                                "qme",     "",   "",    true,  false },
  { "Reserved for local use: qmf",                                "qmf",     "",   "",    true,  false },
  { "Reserved for local use: qmg",                                "qmg",     "",   "",    true,  false },
  { "Reserved for local use: qmh",                                "qmh",     "",   "",    true,  false },
  { "Reserved for local use: qmi",                                "qmi",     "",   "",    true,  false },
  { "Reserved for local use: qmj",                                "qmj",     "",   "",    true,  false },
  { "Reserved for local use: qmk",                                "qmk",     "",   "",    true,  false },
  { "Reserved for local use: qml",                                "qml",     "",   "",    true,  false },
  { "Reserved for local use: qmm",                                "qmm",     "",   "",    true,  false },
  { "Reserved for local use: qmn",                                "qmn",     "",   "",    true,  false },
  { "Reserved for local use: qmo",                                "qmo",     "",   "",    true,  false },
  { "Reserved for local use: qmp",                                "qmp",     "",   "",    true,  false },
  { "Reserved for local use: qmq",                                "qmq",     "",   "",    true,  false },
  { "Reserved for local use: qmr",                                "qmr",     "",   "",    true,  false },
  { "Reserved for local use: qms",                                "qms",     "",   "",    true,  false },
  { "Reserved for local use: qmt",                                "qmt",     "",   "",    true,  false },
  { "Reserved for local use: qmu",                                "qmu",     "",   "",    true,  false },
  { "Reserved for local use: qmv",                                "qmv",     "",   "",    true,  false },
  { "Reserved for local use: qmw",                                "qmw",     "",   "",    true,  false },
  { "Reserved for local use: qmx",                                "qmx",     "",   "",    true,  false },
  { "Reserved for local use: qmy",                                "qmy",     "",   "",    true,  false },
  { "Reserved for local use: qmz",                                "qmz",     "",   "",    true,  false },
  { "Reserved for local use: qna",                                "qna",     "",   "",    true,  false },
  { "Reserved for local use: qnb",                                "qnb",     "",   "",    true,  false },
  { "Reserved for local use: qnc",                                "qnc",     "",   "",    true,  false },
  { "Reserved for local use: qnd",                                "qnd",     "",   "",    true,  false },
  { "Reserved for local use: qne",                                "qne",     "",   "",    true,  false },
  { "Reserved for local use: qnf",                                "qnf",     "",   "",    true,  false },
  { "Reserved for local use: qng",                                "qng",     "",   "",    true,  false },
  { "Reserved for local use: qnh",                                "qnh",     "",   "",    true,  false },
  { "Reserved for local use: qni",                                "qni",     "",   "",    true,  false },
  { "Reserved for local use: qnj",                                "qnj",     "",   "",    true,  false },
  { "Reserved for local use: qnk",                                "qnk",     "",   "",    true,  false },
  { "Reserved for local use: qnl",                                "qnl",     "",   "",    true,  false },
  { "Reserved for local use: qnm",                                "qnm",     "",   "",    true,  false },
  { "Reserved for local use: qnn",                                "qnn",     "",   "",    true,  false },
  { "Reserved for local use: qno",                                "qno",     "",   "",    true,  false },
  { "Reserved for local use: qnp",                                "qnp",     "",   "",    true,  false },
  { "Reserved for local use: qnq",                                "qnq",     "",   "",    true,  false },
  { "Reserved for local use: qnr",                                "qnr",     "",   "",    true,  false },
  { "Reserved for local use: qns",                                "qns",     "",   "",    true,  false },
  { "Reserved for local use: qnt",                                "qnt",     "",   "",    true,  false },
  { "Reserved for local use: qnu",                                "qnu",     "",   "",    true,  false },
  { "Reserved for local use: qnv",                                "qnv",     "",   "",    true,  false },
  { "Reserved for local use: qnw",                                "qnw",     "",   "",    true,  false },
  { "Reserved for local use: qnx",                                "qnx",     "",   "",    true,  false },
  { "Reserved for local use: qny",                                "qny",     "",   "",    true,  false },
  { "Reserved for local use: qnz",                                "qnz",     "",   "",    true,  false },
  { "Reserved for local use: qoa",                                "qoa",     "",   "",    true,  false },
  { "Reserved for local use: qob",                                "qob",     "",   "",    true,  false },
  { "Reserved for local use: qoc",                                "qoc",     "",   "",    true,  false },
  { "Reserved for local use: qod",                                "qod",     "",   "",    true,  false },
  { "Reserved for local use: qoe",                                "qoe",     "",   "",    true,  false },
  { "Reserved for local use: qof",                                "qof",     "",   "",    true,  false },
  { "Reserved for local use: qog",                                "qog",     "",   "",    true,  false },
  { "Reserved for local use: qoh",                                "qoh",     "",   "",    true,  false },
  { "Reserved for local use: qoi",                                "qoi",     "",   "",    true,  false },
  { "Reserved for local use: qoj",                                "qoj",     "",   "",    true,  false },
  { "Reserved for local use: qok",                                "qok",     "",   "",    true,  false },
  { "Reserved for local use: qol",                                "qol",     "",   "",    true,  false },
  { "Reserved for local use: qom",                                "qom",     "",   "",    true,  false },
  { "Reserved for local use: qon",                                "qon",     "",   "",    true,  false },
  { "Reserved for local use: qoo",                                "qoo",     "",   "",    true,  false },
  { "Reserved for local use: qop",                                "qop",     "",   "",    true,  false },
  { "Reserved for local use: qoq",                                "qoq",     "",   "",    true,  false },
  { "Reserved for local use: qor",                                "qor",     "",   "",    true,  false },
  { "Reserved for local use: qos",                                "qos",     "",   "",    true,  false },
  { "Reserved for local use: qot",                                "qot",     "",   "",    true,  false },
  { "Reserved for local use: qou",                                "qou",     "",   "",    true,  false },
  { "Reserved for local use: qov",                                "qov",     "",   "",    true,  false },
  { "Reserved for local use: qow",                                "qow",     "",   "",    true,  false },
  { "Reserved for local use: qox",                                "qox",     "",   "",    true,  false },
  { "Reserved for local use: qoy",                                "qoy",     "",   "",    true,  false },
  { "Reserved for local use: qoz",                                "qoz",     "",   "",    true,  false },
  { "Reserved for local use: qpa",                                "qpa",     "",   "",    true,  false },
  { "Reserved for local use: qpb",                                "qpb",     "",   "",    true,  false },
  { "Reserved for local use: qpc",                                "qpc",     "",   "",    true,  false },
  { "Reserved for local use: qpd",                                "qpd",     "",   "",    true,  false },
  { "Reserved for local use: qpe",                                "qpe",     "",   "",    true,  false },
  { "Reserved for local use: qpf",                                "qpf",     "",   "",    true,  false },
  { "Reserved for local use: qpg",                                "qpg",     "",   "",    true,  false },
  { "Reserved for local use: qph",                                "qph",     "",   "",    true,  false },
  { "Reserved for local use: qpi",                                "qpi",     "",   "",    true,  false },
  { "Reserved for local use: qpj",                                "qpj",     "",   "",    true,  false },
  { "Reserved for local use: qpk",                                "qpk",     "",   "",    true,  false },
  { "Reserved for local use: qpl",                                "qpl",     "",   "",    true,  false },
  { "Reserved for local use: qpm",                                "qpm",     "",   "",    true,  false },
  { "Reserved for local use: qpn",                                "qpn",     "",   "",    true,  false },
  { "Reserved for local use: qpo",                                "qpo",     "",   "",    true,  false },
  { "Reserved for local use: qpp",                                "qpp",     "",   "",    true,  false },
  { "Reserved for local use: qpq",                                "qpq",     "",   "",    true,  false },
  { "Reserved for local use: qpr",                                "qpr",     "",   "",    true,  false },
  { "Reserved for local use: qps",                                "qps",     "",   "",    true,  false },
  { "Reserved for local use: qpt",                                "qpt",     "",   "",    true,  false },
  { "Reserved for local use: qpu",                                "qpu",     "",   "",    true,  false },
  { "Reserved for local use: qpv",                                "qpv",     "",   "",    true,  false },
  { "Reserved for local use: qpw",                                "qpw",     "",   "",    true,  false },
  { "Reserved for local use: qpx",                                "qpx",     "",   "",    true,  false },
  { "Reserved for local use: qpy",                                "qpy",     "",   "",    true,  false },
  { "Reserved for local use: qpz",                                "qpz",     "",   "",    true,  false },
  { "Reserved for local use: qqa",                                "qqa",     "",   "",    true,  false },
  { "Reserved for local use: qqb",                                "qqb",     "",   "",    true,  false },
  { "Reserved for local use: qqc",                                "qqc",     "",   "",    true,  false },
  { "Reserved for local use: qqd",                                "qqd",     "",   "",    true,  false },
  { "Reserved for local use: qqe",                                "qqe",     "",   "",    true,  false },
  { "Reserved for local use: qqf",                                "qqf",     "",   "",    true,  false },
  { "Reserved for local use: qqg",                                "qqg",     "",   "",    true,  false },
  { "Reserved for local use: qqh",                                "qqh",     "",   "",    true,  false },
  { "Reserved for local use: qqi",                                "qqi",     "",   "",    true,  false },
  { "Reserved for local use: qqj",                                "qqj",     "",   "",    true,  false },
  { "Reserved for local use: qqk",                                "qqk",     "",   "",    true,  false },
  { "Reserved for local use: qql",                                "qql",     "",   "",    true,  false },
  { "Reserved for local use: qqm",                                "qqm",     "",   "",    true,  false },
  { "Reserved for local use: qqn",                                "qqn",     "",   "",    true,  false },
  { "Reserved for local use: qqo",                                "qqo",     "",   "",    true,  false },
  { "Reserved for local use: qqp",                                "qqp",     "",   "",    true,  false },
  { "Reserved for local use: qqq",                                "qqq",     "",   "",    true,  false },
  { "Reserved for local use: qqr",                                "qqr",     "",   "",    true,  false },
  { "Reserved for local use: qqs",                                "qqs",     "",   "",    true,  false },
  { "Reserved for local use: qqt",                                "qqt",     "",   "",    true,  false },
  { "Reserved for local use: qqu",                                "qqu",     "",   "",    true,  false },
  { "Reserved for local use: qqv",                                "qqv",     "",   "",    true,  false },
  { "Reserved for local use: qqw",                                "qqw",     "",   "",    true,  false },
  { "Reserved for local use: qqx",                                "qqx",     "",   "",    true,  false },
  { "Reserved for local use: qqy",                                "qqy",     "",   "",    true,  false },
  { "Reserved for local use: qqz",                                "qqz",     "",   "",    true,  false },
  { "Reserved for local use: qra",                                "qra",     "",   "",    true,  false },
  { "Reserved for local use: qrb",                                "qrb",     "",   "",    true,  false },
  { "Reserved for local use: qrc",                                "qrc",     "",   "",    true,  false },
  { "Reserved for local use: qrd",                                "qrd",     "",   "",    true,  false },
  { "Reserved for local use: qre",                                "qre",     "",   "",    true,  false },
  { "Reserved for local use: qrf",                                "qrf",     "",   "",    true,  false },
  { "Reserved for local use: qrg",                                "qrg",     "",   "",    true,  false },
  { "Reserved for local use: qrh",                                "qrh",     "",   "",    true,  false },
  { "Reserved for local use: qri",                                "qri",     "",   "",    true,  false },
  { "Reserved for local use: qrj",                                "qrj",     "",   "",    true,  false },
  { "Reserved for local use: qrk",                                "qrk",     "",   "",    true,  false },
  { "Reserved for local use: qrl",                                "qrl",     "",   "",    true,  false },
  { "Reserved for local use: qrm",                                "qrm",     "",   "",    true,  false },
  { "Reserved for local use: qrn",                                "qrn",     "",   "",    true,  false },
  { "Reserved for local use: qro",                                "qro",     "",   "",    true,  false },
  { "Reserved for local use: qrp",                                "qrp",     "",   "",    true,  false },
  { "Reserved for local use: qrq",                                "qrq",     "",   "",    true,  false },
  { "Reserved for local use: qrr",                                "qrr",     "",   "",    true,  false },
  { "Reserved for local use: qrs",                                "qrs",     "",   "",    true,  false },
  { "Reserved for local use: qrt",                                "qrt",     "",   "",    true,  false },
  { "Reserved for local use: qru",                                "qru",     "",   "",    true,  false },
  { "Reserved for local use: qrv",                                "qrv",     "",   "",    true,  false },
  { "Reserved for local use: qrw",                                "qrw",     "",   "",    true,  false },
  { "Reserved for local use: qrx",                                "qrx",     "",   "",    true,  false },
  { "Reserved for local use: qry",                                "qry",     "",   "",    true,  false },
  { "Reserved for local use: qrz",                                "qrz",     "",   "",    true,  false },
  { "Reserved for local use: qsa",                                "qsa",     "",   "",    true,  false },
  { "Reserved for local use: qsb",                                "qsb",     "",   "",    true,  false },
  { "Reserved for local use: qsc",                                "qsc",     "",   "",    true,  false },
  { "Reserved for local use: qsd",                                "qsd",     "",   "",    true,  false },
  { "Reserved for local use: qse",                                "qse",     "",   "",    true,  false },
  { "Reserved for local use: qsf",                                "qsf",     "",   "",    true,  false },
  { "Reserved for local use: qsg",                                "qsg",     "",   "",    true,  false },
  { "Reserved for local use: qsh",                                "qsh",     "",   "",    true,  false },
  { "Reserved for local use: qsi",                                "qsi",     "",   "",    true,  false },
  { "Reserved for local use: qsj",                                "qsj",     "",   "",    true,  false },
  { "Reserved for local use: qsk",                                "qsk",     "",   "",    true,  false },
  { "Reserved for local use: qsl",                                "qsl",     "",   "",    true,  false },
  { "Reserved for local use: qsm",                                "qsm",     "",   "",    true,  false },
  { "Reserved for local use: qsn",                                "qsn",     "",   "",    true,  false },
  { "Reserved for local use: qso",                                "qso",     "",   "",    true,  false },
  { "Reserved for local use: qsp",                                "qsp",     "",   "",    true,  false },
  { "Reserved for local use: qsq",                                "qsq",     "",   "",    true,  false },
  { "Reserved for local use: qsr",                                "qsr",     "",   "",    true,  false },
  { "Reserved for local use: qss",                                "qss",     "",   "",    true,  false },
  { "Reserved for local use: qst",                                "qst",     "",   "",    true,  false },
  { "Reserved for local use: qsu",                                "qsu",     "",   "",    true,  false },
  { "Reserved for local use: qsv",                                "qsv",     "",   "",    true,  false },
  { "Reserved for local use: qsw",                                "qsw",     "",   "",    true,  false },
  { "Reserved for local use: qsx",                                "qsx",     "",   "",    true,  false },
  { "Reserved for local use: qsy",                                "qsy",     "",   "",    true,  false },
  { "Reserved for local use: qsz",                                "qsz",     "",   "",    true,  false },
  { "Reserved for local use: qta",                                "qta",     "",   "",    true,  false },
  { "Reserved for local use: qtb",                                "qtb",     "",   "",    true,  false },
  { "Reserved for local use: qtc",                                "qtc",     "",   "",    true,  false },
  { "Reserved for local use: qtd",                                "qtd",     "",   "",    true,  false },
  { "Reserved for local use: qte",                                "qte",     "",   "",    true,  false },
  { "Reserved for local use: qtf",                                "qtf",     "",   "",    true,  false },
  { "Reserved for local use: qtg",                                "qtg",     "",   "",    true,  false },
  { "Reserved for local use: qth",                                "qth",     "",   "",    true,  false },
  { "Reserved for local use: qti",                                "qti",     "",   "",    true,  false },
  { "Reserved for local use: qtj",                                "qtj",     "",   "",    true,  false },
  { "Reserved for local use: qtk",                                "qtk",     "",   "",    true,  false },
  { "Reserved for local use: qtl",                                "qtl",     "",   "",    true,  false },
  { "Reserved for local use: qtm",                                "qtm",     "",   "",    true,  false },
  { "Reserved for local use: qtn",                                "qtn",     "",   "",    true,  false },
  { "Reserved for local use: qto",                                "qto",     "",   "",    true,  false },
  { "Reserved for local use: qtp",                                "qtp",     "",   "",    true,  false },
  { "Reserved for local use: qtq",                                "qtq",     "",   "",    true,  false },
  { "Reserved for local use: qtr",                                "qtr",     "",   "",    true,  false },
  { "Reserved for local use: qts",                                "qts",     "",   "",    true,  false },
  { "Reserved for local use: qtt",                                "qtt",     "",   "",    true,  false },
  { "Reserved for local use: qtu",                                "qtu",     "",   "",    true,  false },
  { "Reserved for local use: qtv",                                "qtv",     "",   "",    true,  false },
  { "Reserved for local use: qtw",                                "qtw",     "",   "",    true,  false },
  { "Reserved for local use: qtx",                                "qtx",     "",   "",    true,  false },
  { "Reserved for local use: qty",                                "qty",     "",   "",    true,  false },
  { "Reserved for local use: qtz",                                "qtz",     "",   "",    true,  false },
  { "Reshe",                                                      "res",     "",   "",    false, false },
  { "Resígaro",                                                   "rgr",     "",   "",    false, false },
  { "Retta",                                                      "ret",     "",   "",    false, false },
  { "Reyesano",                                                   "rey",     "",   "",    false, false },
  { "Riang (India)",                                              "ria",     "",   "",    false, false },
  { "Riang Lai",                                                  "yin",     "",   "",    false, false },
  { "Riang Lang",                                                 "ril",     "",   "",    false, false },
  { "Riantana",                                                   "ran",     "",   "",    false, false },
  { "Ribun",                                                      "rir",     "",   "",    false, false },
  { "Rien",                                                       "rie",     "",   "",    false, true  },
  { "Rigwe",                                                      "iri",     "",   "",    false, false },
  { "Rikbaktsa",                                                  "rkb",     "",   "",    false, false },
  { "Rinconada Bikol",                                            "bto",     "",   "",    false, false },
  { "Rincón Zapotec",                                             "zar",     "",   "",    false, false },
  { "Ringgou",                                                    "rgu",     "",   "",    false, false },
  { "Ririo",                                                      "rri",     "",   "",    false, false },
  { "Rishiwa",                                                    "rsw",     "",   "",    false, false },
  { "Ritharrngu",                                                 "rit",     "",   "",    false, false },
  { "Riung",                                                      "riu",     "",   "",    false, false },
  { "Riverain Sango",                                             "snj",     "",   "",    false, false },
  { "Rmeet",                                                      "lbn",     "",   "",    false, false },
  { "Rogo",                                                       "rod",     "",   "",    false, false },
  { "Rohingya",                                                   "rhg",     "",   "",    false, false },
  { "Roma",                                                       "rmm",     "",   "",    false, false },
  { "Romagnol",                                                   "rgn",     "",   "",    false, false },
  { "Romam",                                                      "rmx",     "",   "",    false, false },
  { "Romance languages",                                          "roa",     "",   "",    true,  false },
  { "Romanian Sign Language",                                     "rms",     "",   "",    false, false },
  { "Romanian",                                                   "rum",     "ro", "ron", true,  false },
  { "Romano-Greek",                                               "rge",     "",   "",    false, false },
  { "Romano-Serbian",                                             "rsb",     "",   "",    false, false },
  { "Romanova",                                                   "rmv",     "",   "",    false, false },
  { "Romansh",                                                    "roh",     "rm", "",    true,  false },
  { "Romany",                                                     "rom",     "",   "",    true,  false },
  { "Romblomanon",                                                "rol",     "",   "",    false, false },
  { "Rombo",                                                      "rof",     "",   "",    false, false },
  { "Romkun",                                                     "rmk",     "",   "",    false, false },
  { "Ron",                                                        "cla",     "",   "",    false, false },
  { "Ronga",                                                      "rng",     "",   "",    false, false },
  { "Rongga",                                                     "ror",     "",   "",    false, false },
  { "Rongmei Naga",                                               "nbu",     "",   "",    false, false },
  { "Rongpo",                                                     "rnp",     "",   "",    false, false },
  { "Ronji",                                                      "roe",     "",   "",    false, false },
  { "Roon",                                                       "rnn",     "",   "",    false, false },
  { "Roria",                                                      "rga",     "",   "",    false, false },
  { "Rotokas",                                                    "roo",     "",   "",    false, false },
  { "Rotuman",                                                    "rtm",     "",   "",    false, false },
  { "Roviana",                                                    "rug",     "",   "",    false, false },
  { "Ruching Palaung",                                            "pce",     "",   "",    false, false },
  { "Rudbari",                                                    "rdb",     "",   "",    false, false },
  { "Rufiji",                                                     "rui",     "",   "",    false, false },
  { "Ruga",                                                       "ruh",     "",   "",    false, false },
  { "Rukai",                                                      "dru",     "",   "",    false, false },
  { "Ruma",                                                       "ruz",     "",   "",    false, false },
  { "Rumai Palaung",                                              "rbb",     "",   "",    false, false },
  { "Rumu",                                                       "klq",     "",   "",    false, false },
  { "Runa",                                                       "rna",     "",   "",    false, true  },
  { "Rundi",                                                      "run",     "rn", "",    true,  false },
  { "Runga",                                                      "rou",     "",   "",    false, false },
  { "Rungtu Chin",                                                "rtc",     "",   "",    false, false },
  { "Rungus",                                                     "drg",     "",   "",    false, false },
  { "Rungwa",                                                     "rnw",     "",   "",    false, false },
  { "Russia Buriat",                                              "bxr",     "",   "",    false, false },
  { "Russian Sign Language",                                      "rsl",     "",   "",    false, false },
  { "Russian",                                                    "rus",     "ru", "",    true,  false },
  { "Rusyn",                                                      "rue",     "",   "",    false, false },
  { "Ruthenian",                                                  "rsk",     "",   "",    false, false },
  { "Rutul",                                                      "rut",     "",   "",    false, false },
  { "Ruuli",                                                      "ruc",     "",   "",    false, false },
  { "Ruund",                                                      "rnd",     "",   "",    false, false },
  { "Ruwila",                                                     "rwl",     "",   "",    false, false },
  { "Rwa",                                                        "rwk",     "",   "",    false, false },
  { "Rwandan Sign Language",                                      "rsn",     "",   "",    false, false },
  { "Réunion Creole French",                                      "rcf",     "",   "",    false, false },
  { "Rāziḥī",                                                     "rzh",     "",   "",    false, false },
  { "S'gaw Karen",                                                "ksw",     "",   "",    false, false },
  { "Sa",                                                         "sax",     "",   "",    false, false },
  { "Sa'a",                                                       "apb",     "",   "",    false, false },
  { "Sa'ban",                                                     "snv",     "",   "",    false, false },
  { "Sa'och",                                                     "scq",     "",   "",    false, false },
  { "Saafi-Saafi",                                                "sav",     "",   "",    false, false },
  { "Saam",                                                       "raq",     "",   "",    false, false },
  { "Saamia",                                                     "lsm",     "",   "",    false, false },
  { "Saaroa",                                                     "sxr",     "",   "",    false, false },
  { "Saba",                                                       "saa",     "",   "",    false, false },
  { "Sabaean",                                                    "xsa",     "",   "",    false, false },
  { "Sabah Bisaya",                                               "bsy",     "",   "",    false, false },
  { "Sabah Malay",                                                "msi",     "",   "",    false, false },
  { "Sabanê",                                                     "sae",     "",   "",    false, false },
  { "Sabaot",                                                     "spy",     "",   "",    false, false },
  { "Sabine",                                                     "sbv",     "",   "",    false, false },
  { "Sabu",                                                       "hvn",     "",   "",    false, false },
  { "Sabüm",                                                      "sbo",     "",   "",    false, false },
  { "Sacapulteco",                                                "quv",     "",   "",    false, false },
  { "Sadri",                                                      "sck",     "",   "",    false, false },
  { "Saek",                                                       "skb",     "",   "",    false, false },
  { "Saep",                                                       "spd",     "",   "",    false, false },
  { "Safaliba",                                                   "saf",     "",   "",    false, false },
  { "Safeyoka",                                                   "apz",     "",   "",    false, false },
  { "Safwa",                                                      "sbk",     "",   "",    false, false },
  { "Sagala",                                                     "sbm",     "",   "",    false, false },
  { "Sagalla",                                                    "tga",     "",   "",    false, false },
  { "Saho",                                                       "ssy",     "",   "",    false, false },
  { "Sahu",                                                       "saj",     "",   "",    false, false },
  { "Saidi Arabic",                                               "aec",     "",   "",    false, false },
  { "Saint Lucian Creole French",                                 "acf",     "",   "",    false, false },
  { "Saisiyat",                                                   "xsy",     "",   "",    false, false },
  { "Sajalong",                                                   "sjl",     "",   "",    false, false },
  { "Sajau Basap",                                                "sjb",     "",   "",    false, false },
  { "Sakachep",                                                   "sch",     "",   "",    false, false },
  { "Sakalava Malagasy",                                          "skg",     "",   "",    false, false },
  { "Sakao",                                                      "sku",     "",   "",    false, false },
  { "Sakata",                                                     "skt",     "",   "",    false, false },
  { "Sake",                                                       "sak",     "",   "",    false, false },
  { "Sakirabiá",                                                  "skf",     "",   "",    false, false },
  { "Sakizaya",                                                   "szy",     "",   "",    false, false },
  { "Sala",                                                       "shq",     "",   "",    false, false },
  { "Salampasu",                                                  "slx",     "",   "",    false, false },
  { "Salar",                                                      "slr",     "",   "",    false, false },
  { "Salas",                                                      "sgu",     "",   "",    false, false },
  { "Salasaca Highland Quichua",                                  "qxl",     "",   "",    false, false },
  { "Salawati",                                                   "xmx",     "",   "",    false, false },
  { "Salchuq",                                                    "slq",     "",   "",    false, true  },
  { "Saleman",                                                    "sau",     "",   "",    false, false },
  { "Saliba",                                                     "sbe",     "",   "",    false, false },
  { "Salinan",                                                    "sln",     "",   "",    false, false },
  { "Salishan languages",                                         "sal",     "",   "",    true,  false },
  { "Sallands",                                                   "sdz",     "",   "",    false, false },
  { "Salt-Yui",                                                   "sll",     "",   "",    false, false },
  { "Saluan",                                                     "loe",     "",   "",    false, false },
  { "Salumá",                                                     "slj",     "",   "",    false, false },
  { "Salvadoran Sign Language",                                   "esn",     "",   "",    false, false },
  { "Sam",                                                        "snx",     "",   "",    false, false },
  { "Sama",                                                       "smd",     "",   "",    false, true  },
  { "Samaritan Aramaic",                                          "sam",     "",   "",    true,  false },
  { "Samaritan",                                                  "smp",     "",   "",    false, false },
  { "Samarokena",                                                 "tmj",     "",   "",    false, false },
  { "Samatao",                                                    "ysd",     "",   "",    false, false },
  { "Samay",                                                      "syx",     "",   "",    false, false },
  { "Samba Daka",                                                 "ccg",     "",   "",    false, false },
  { "Samba Leko",                                                 "ndi",     "",   "",    false, false },
  { "Samba",                                                      "smx",     "",   "",    false, false },
  { "Sambal",                                                     "xsb",     "",   "",    false, false },
  { "Sambalpuri",                                                 "spv",     "",   "",    false, false },
  { "Sambe",                                                      "xab",     "",   "",    false, false },
  { "Samberigi",                                                  "ssx",     "",   "",    false, false },
  { "Samburu",                                                    "saq",     "",   "",    false, false },
  { "Samei",                                                      "smh",     "",   "",    false, false },
  { "Sami languages",                                             "smi",     "",   "",    true,  false },
  { "Samo",                                                       "smq",     "",   "",    false, false },
  { "Samoan",                                                     "smo",     "sm", "",    true,  false },
  { "Samogitian",                                                 "sgs",     "",   "",    false, false },
  { "Samosa",                                                     "swm",     "",   "",    false, false },
  { "Samoyedic languages",                                        "syd",     "",   "",    false, false },
  { "Sampang",                                                    "rav",     "",   "",    false, false },
  { "Samre",                                                      "sxm",     "",   "",    false, false },
  { "Samtao",                                                     "stu",     "",   "",    false, false },
  { "Samvedi",                                                    "smv",     "",   "",    false, false },
  { "San Agustín Mixtepec Zapotec",                               "ztm",     "",   "",    false, false },
  { "San Baltazar Loxicha Zapotec",                               "zpx",     "",   "",    false, false },
  { "San Blas Kuna",                                              "cuk",     "",   "",    false, false },
  { "San Dionisio Del Mar Huave",                                 "hve",     "",   "",    false, false },
  { "San Felipe Otlaltepec Popoloca",                             "pow",     "",   "",    false, false },
  { "San Francisco Del Mar Huave",                                "hue",     "",   "",    false, false },
  { "San Francisco Matlatzinca",                                  "mat",     "",   "",    false, false },
  { "San Jerónimo Tecóatl Mazatec",                               "maa",     "",   "",    false, false },
  { "San Juan Atzingo Popoloca",                                  "poe",     "",   "",    false, false },
  { "San Juan Colorado Mixtec",                                   "mjc",     "",   "",    false, false },
  { "San Juan Teita Mixtec",                                      "xtj",     "",   "",    false, false },
  { "San Luís Temalacayuca Popoloca",                             "pps",     "",   "",    false, false },
  { "San Marcos Tlacoyalco Popoloca",                             "pls",     "",   "",    false, false },
  { "San Martín Itunyoso Triqui",                                 "trq",     "",   "",    false, false },
  { "San Martín Quechua",                                         "qvs",     "",   "",    false, false },
  { "San Mateo Del Mar Huave",                                    "huv",     "",   "",    false, false },
  { "San Miguel Creole French",                                   "scf",     "",   "",    false, false },
  { "San Miguel El Grande Mixtec",                                "mig",     "",   "",    false, false },
  { "San Miguel Piedras Mixtec",                                  "xtp",     "",   "",    false, false },
  { "San Pedro Amuzgos Amuzgo",                                   "azg",     "",   "",    false, false },
  { "San Pedro Quiatoni Zapotec",                                 "zpf",     "",   "",    false, false },
  { "San Salvador Kongo",                                         "kwy",     "",   "",    false, false },
  { "San Vicente Coatlán Zapotec",                                "zpt",     "",   "",    false, false },
  { "Sanaani Arabic",                                             "ayn",     "",   "",    false, false },
  { "Sanapaná",                                                   "sap",     "",   "",    false, true  },
  { "Sanapaná",                                                   "spn",     "",   "",    false, false },
  { "Sandawe",                                                    "sad",     "",   "",    true,  false },
  { "Sanga (Democratic Republic of Congo)",                       "sng",     "",   "",    false, false },
  { "Sanga (Nigeria)",                                            "xsn",     "",   "",    false, false },
  { "Sangab Mandaya",                                             "myt",     "",   "",    false, true  },
  { "Sanggau",                                                    "scg",     "",   "",    false, false },
  { "Sangil",                                                     "snl",     "",   "",    false, false },
  { "Sangir",                                                     "sxn",     "",   "",    false, false },
  { "Sangisari",                                                  "sgr",     "",   "",    false, false },
  { "Sangkong",                                                   "sgk",     "",   "",    false, false },
  { "Sanglechi",                                                  "sgy",     "",   "",    false, false },
  { "Sanglechi-Ishkashimi",                                       "sgl",     "",   "",    false, true  },
  { "Sango",                                                      "sag",     "sg", "",    true,  false },
  { "Sangtam Naga",                                               "nsa",     "",   "",    false, false },
  { "Sangu (Gabon)",                                              "snq",     "",   "",    false, false },
  { "Sangu (Tanzania)",                                           "sbp",     "",   "",    false, false },
  { "Sani",                                                       "ysn",     "",   "",    false, false },
  { "Sanie",                                                      "ysy",     "",   "",    false, false },
  { "Saniyo-Hiyewe",                                              "sny",     "",   "",    false, false },
  { "Sankaran Maninka",                                           "msc",     "",   "",    false, false },
  { "Sansi",                                                      "ssi",     "",   "",    false, false },
  { "Sanskrit",                                                   "san",     "sa", "",    true,  false },
  { "Sansu",                                                      "sca",     "",   "",    false, true  },
  { "Santa Ana de Tusi Pasco Quechua",                            "qxt",     "",   "",    false, false },
  { "Santa Catarina Albarradas Zapotec",                          "ztn",     "",   "",    false, false },
  { "Santa Inés Ahuatempan Popoloca",                             "pca",     "",   "",    false, false },
  { "Santa Inés Yatzechi Zapotec",                                "zpn",     "",   "",    false, false },
  { "Santa Lucía Monteverde Mixtec",                              "mdv",     "",   "",    false, false },
  { "Santa María Del Mar Huave",                                  "hvv",     "",   "",    false, false },
  { "Santa María La Alta Nahuatl",                                "nhz",     "",   "",    false, false },
  { "Santa María Quiegolani Zapotec",                             "zpi",     "",   "",    false, false },
  { "Santa María Zacatepec Mixtec",                               "mza",     "",   "",    false, false },
  { "Santa Teresa Cora",                                          "cok",     "",   "",    false, false },
  { "Santali",                                                    "sat",     "",   "",    true,  false },
  { "Santiago Xanica Zapotec",                                    "zpr",     "",   "",    false, false },
  { "Santiago del Estero Quichua",                                "qus",     "",   "",    false, false },
  { "Santo Domingo Albarradas Zapotec",                           "zas",     "",   "",    false, false },
  { "Sanumá",                                                     "xsu",     "",   "",    false, false },
  { "Saparua",                                                    "spr",     "",   "",    false, false },
  { "Sapo",                                                       "krn",     "",   "",    false, false },
  { "Saponi",                                                     "spi",     "",   "",    false, false },
  { "Saposa",                                                     "sps",     "",   "",    false, false },
  { "Sapuan",                                                     "spu",     "",   "",    false, false },
  { "Sapé",                                                       "spc",     "",   "",    false, false },
  { "Sar",                                                        "mwm",     "",   "",    false, false },
  { "Sara Dunjo",                                                 "koj",     "",   "",    false, true  },
  { "Sara Kaba Deme",                                             "kwg",     "",   "",    false, false },
  { "Sara Kaba Náà",                                              "kwv",     "",   "",    false, false },
  { "Sara Kaba",                                                  "sbz",     "",   "",    false, false },
  { "Sara",                                                       "sre",     "",   "",    false, false },
  { "Saraiki",                                                    "skr",     "",   "",    false, false },
  { "Saramaccan",                                                 "srm",     "",   "",    false, false },
  { "Sarangani Blaan",                                            "bps",     "",   "",    false, false },
  { "Sarangani Manobo",                                           "mbs",     "",   "",    false, false },
  { "Sarasira",                                                   "zsa",     "",   "",    false, false },
  { "Saraveca",                                                   "sar",     "",   "",    false, false },
  { "Sardinian",                                                  "srd",     "sc", "",    true,  false },
  { "Sari",                                                       "asj",     "",   "",    false, false },
  { "Sarikoli",                                                   "srh",     "",   "",    false, false },
  { "Sarli",                                                      "sdf",     "",   "",    false, false },
  { "Sarsi",                                                      "srs",     "",   "",    false, false },
  { "Sartang",                                                    "onp",     "",   "",    false, false },
  { "Sarua",                                                      "swy",     "",   "",    false, false },
  { "Sarudu",                                                     "sdu",     "",   "",    false, false },
  { "Saruga",                                                     "sra",     "",   "",    false, false },
  { "Sasak",                                                      "sas",     "",   "",    true,  false },
  { "Sasaru",                                                     "sxs",     "",   "",    false, false },
  { "Sassarese Sardinian",                                        "sdc",     "",   "",    false, false },
  { "Satawalese",                                                 "stw",     "",   "",    false, false },
  { "Saterfriesisch",                                             "stq",     "",   "",    false, false },
  { "Sateré-Mawé",                                                "mav",     "",   "",    false, false },
  { "Saudi Arabian Sign Language",                                "sdl",     "",   "",    false, false },
  { "Sauraseni Prākrit",                                          "psu",     "",   "",    false, false },
  { "Saurashtra",                                                 "saz",     "",   "",    false, false },
  { "Sauri",                                                      "srt",     "",   "",    false, false },
  { "Sauria Paharia",                                             "mjt",     "",   "",    false, false },
  { "Sause",                                                      "sao",     "",   "",    false, false },
  { "Sausi",                                                      "ssj",     "",   "",    false, false },
  { "Savara",                                                     "svr",     "",   "",    false, true  },
  { "Savi",                                                       "sdg",     "",   "",    false, false },
  { "Savosavo",                                                   "svs",     "",   "",    false, false },
  { "Sawai",                                                      "szw",     "",   "",    false, false },
  { "Saweru",                                                     "swr",     "",   "",    false, false },
  { "Sawi",                                                       "saw",     "",   "",    false, false },
  { "Sawila",                                                     "swt",     "",   "",    false, false },
  { "Sawknah",                                                    "swn",     "",   "",    false, false },
  { "Saxwe Gbe",                                                  "sxw",     "",   "",    false, false },
  { "Saya",                                                       "say",     "",   "",    false, false },
  { "Sayula Popoluca",                                            "pos",     "",   "",    false, false },
  { "Scots",                                                      "sco",     "",   "",    true,  false },
  { "Scottish Gaelic",                                            "gla",     "gd", "",    true,  false },
  { "Scythian",                                                   "xsc",     "",   "",    false, false },
  { "Sea Island Creole English",                                  "gul",     "",   "",    false, false },
  { "Seba",                                                       "kdg",     "",   "",    false, false },
  { "Sebat Bet Gurage",                                           "sgw",     "",   "",    false, false },
  { "Seberuang",                                                  "sbx",     "",   "",    false, false },
  { "Sebop",                                                      "sib",     "",   "",    false, false },
  { "Sebuyau",                                                    "snb",     "",   "",    false, true  },
  { "Sechelt",                                                    "sec",     "",   "",    false, false },
  { "Secoya",                                                     "sey",     "",   "",    false, false },
  { "Sedang",                                                     "sed",     "",   "",    false, false },
  { "Sediq",                                                      "trv",     "",   "",    false, false },
  { "Sedoa",                                                      "tvw",     "",   "",    false, false },
  { "Seeku",                                                      "sos",     "",   "",    false, false },
  { "Segai",                                                      "sge",     "",   "",    false, false },
  { "Segeju",                                                     "seg",     "",   "",    false, false },
  { "Seget",                                                      "sbg",     "",   "",    false, false },
  { "Sehwi",                                                      "sfw",     "",   "",    false, false },
  { "Seimat",                                                     "ssg",     "",   "",    false, false },
  { "Seit-Kaitetu",                                               "hik",     "",   "",    false, false },
  { "Sekani",                                                     "sek",     "",   "",    false, false },
  { "Sekapan",                                                    "skp",     "",   "",    false, false },
  { "Sekar",                                                      "skz",     "",   "",    false, false },
  { "Seke (Nepal)",                                               "skj",     "",   "",    false, false },
  { "Seke (Vanuatu)",                                             "ske",     "",   "",    false, false },
  { "Sekele",                                                     "vaj",     "",   "",    false, false },
  { "Seki",                                                       "syi",     "",   "",    false, false },
  { "Seko Padang",                                                "skx",     "",   "",    false, false },
  { "Seko Tengah",                                                "sko",     "",   "",    false, false },
  { "Sekpele",                                                    "lip",     "",   "",    false, false },
  { "Selangor Sign Language",                                     "kgi",     "",   "",    false, false },
  { "Selaru",                                                     "slu",     "",   "",    false, false },
  { "Selayar",                                                    "sly",     "",   "",    false, false },
  { "Selee",                                                      "snw",     "",   "",    false, false },
  { "Selepet",                                                    "spl",     "",   "",    false, false },
  { "Selian",                                                     "sxl",     "",   "",    false, false },
  { "Selkup",                                                     "sel",     "",   "",    true,  false },
  { "Selungai Murut",                                             "slg",     "",   "",    false, false },
  { "Seluwasan",                                                  "sws",     "",   "",    false, false },
  { "Semai",                                                      "sea",     "",   "",    false, false },
  { "Semandang",                                                  "sdm",     "",   "",    false, true  },
  { "Semandang",                                                  "sdq",     "",   "",    false, false },
  { "Semaq Beri",                                                 "szc",     "",   "",    false, false },
  { "Sembakung Murut",                                            "sbr",     "",   "",    false, false },
  { "Semelai",                                                    "sza",     "",   "",    false, false },
  { "Semimi",                                                     "etz",     "",   "",    false, false },
  { "Semitic languages",                                          "sem",     "",   "",    true,  false },
  { "Semnam",                                                     "ssm",     "",   "",    false, false },
  { "Semnani",                                                    "smy",     "",   "",    false, false },
  { "Sempan",                                                     "xse",     "",   "",    false, false },
  { "Sena",                                                       "seh",     "",   "",    false, false },
  { "Senara Sénoufo",                                             "seq",     "",   "",    false, false },
  { "Senaya",                                                     "syn",     "",   "",    false, false },
  { "Sene",                                                       "sej",     "",   "",    false, false },
  { "Seneca",                                                     "see",     "",   "",    false, false },
  { "Sened",                                                      "sds",     "",   "",    false, false },
  { "Sengele",                                                    "szg",     "",   "",    false, false },
  { "Senggi",                                                     "snu",     "",   "",    false, false },
  { "Sengo",                                                      "spk",     "",   "",    false, false },
  { "Sengseng",                                                   "ssz",     "",   "",    false, false },
  { "Senhaja De Srair",                                           "sjs",     "",   "",    false, false },
  { "Sensi",                                                      "sni",     "",   "",    false, false },
  { "Sentani",                                                    "set",     "",   "",    false, false },
  { "Senthang Chin",                                              "sez",     "",   "",    false, false },
  { "Sentinel",                                                   "std",     "",   "",    false, false },
  { "Sepa (Indonesia)",                                           "spb",     "",   "",    false, false },
  { "Sepa (Papua New Guinea)",                                    "spe",     "",   "",    false, false },
  { "Sepik Iwam",                                                 "iws",     "",   "",    false, false },
  { "Sera",                                                       "sry",     "",   "",    false, false },
  { "Serbian",                                                    "srp",     "sr", "",    true,  false },
  { "Serbo-Croatian",                                             "hbs",     "sh", "",    false, false },
  { "Sere",                                                       "swf",     "",   "",    false, false },
  { "Serer",                                                      "srr",     "",   "",    true,  false },
  { "Seri",                                                       "sei",     "",   "",    false, false },
  { "Serili",                                                     "sve",     "",   "",    false, false },
  { "Seroa",                                                      "kqu",     "",   "",    false, false },
  { "Serrano",                                                    "ser",     "",   "",    false, false },
  { "Seru",                                                       "szd",     "",   "",    false, true  },
  { "Serua",                                                      "srw",     "",   "",    false, false },
  { "Serudung Murut",                                             "srk",     "",   "",    false, false },
  { "Serui-Laut",                                                 "seu",     "",   "",    false, false },
  { "Seselwa Creole French",                                      "crs",     "",   "",    false, false },
  { "Seta",                                                       "stf",     "",   "",    false, false },
  { "Setaman",                                                    "stm",     "",   "",    false, false },
  { "Seti",                                                       "sbi",     "",   "",    false, false },
  { "Settla",                                                     "sta",     "",   "",    false, false },
  { "Severn Ojibwa",                                              "ojs",     "",   "",    false, false },
  { "Sewa Bay",                                                   "sew",     "",   "",    false, false },
  { "Seychelles Sign Language",                                   "lsw",     "",   "",    false, false },
  { "Seze",                                                       "sze",     "",   "",    false, false },
  { "Sha",                                                        "scw",     "",   "",    false, false },
  { "Shabak",                                                     "sdb",     "",   "",    false, false },
  { "Shahmirzadi",                                                "srz",     "",   "",    false, false },
  { "Shahrudi",                                                   "shm",     "",   "",    false, false },
  { "Shall-Zwall",                                                "sha",     "",   "",    false, false },
  { "Shama-Sambuga",                                              "sqa",     "",   "",    false, false },
  { "Shamang",                                                    "xsh",     "",   "",    false, false },
  { "Shambala",                                                   "ksb",     "",   "",    false, false },
  { "Shan",                                                       "shn",     "",   "",    true,  false },
  { "Shanenawa",                                                  "swo",     "",   "",    false, false },
  { "Shanga",                                                     "sho",     "",   "",    false, false },
  { "Shaojiang Chinese",                                          "sjc",     "",   "",    false, false },
  { "Sharanahua",                                                 "mcd",     "",   "",    false, false },
  { "Shark Bay",                                                  "ssv",     "",   "",    false, false },
  { "Sharwa",                                                     "swq",     "",   "",    false, false },
  { "Shasta",                                                     "sht",     "",   "",    false, false },
  { "Shatt",                                                      "shj",     "",   "",    false, false },
  { "Shau",                                                       "sqh",     "",   "",    false, false },
  { "Shawnee",                                                    "sjw",     "",   "",    false, false },
  { "She",                                                        "shx",     "",   "",    false, false },
  { "Shehri",                                                     "shv",     "",   "",    false, false },
  { "Shekhawati",                                                 "swv",     "",   "",    false, false },
  { "Shekkacho",                                                  "moy",     "",   "",    false, false },
  { "Sheko",                                                      "she",     "",   "",    false, false },
  { "Shelta",                                                     "sth",     "",   "",    false, false },
  { "Shempire Senoufo",                                           "seb",     "",   "",    false, false },
  { "Shendu",                                                     "shl",     "",   "",    false, false },
  { "Sheni",                                                      "scv",     "",   "",    false, false },
  { "Sherbro",                                                    "bun",     "",   "",    false, false },
  { "Sherdukpen",                                                 "sdp",     "",   "",    false, false },
  { "Sherpa",                                                     "xsr",     "",   "",    false, false },
  { "Sheshi Kham",                                                "kip",     "",   "",    false, false },
  { "Shi",                                                        "shr",     "",   "",    false, false },
  { "Shihhi Arabic",                                              "ssh",     "",   "",    false, false },
  { "Shiki",                                                      "gua",     "",   "",    false, false },
  { "Shilluk",                                                    "shk",     "",   "",    false, false },
  { "Shina",                                                      "scl",     "",   "",    false, false },
  { "Shinabo",                                                    "snh",     "",   "",    false, true  },
  { "Shipibo-Conibo",                                             "shp",     "",   "",    false, false },
  { "Sholaga",                                                    "sle",     "",   "",    false, false },
  { "Shom Peng",                                                  "sii",     "",   "",    false, false },
  { "Shona",                                                      "sna",     "sn", "",    true,  false },
  { "Shoo-Minda-Nye",                                             "bcv",     "",   "",    false, false },
  { "Shor",                                                       "cjs",     "",   "",    false, false },
  { "Shoshoni",                                                   "shh",     "",   "",    false, false },
  { "Shua",                                                       "shg",     "",   "",    false, false },
  { "Shuadit",                                                    "sdt",     "",   "",    false, false },
  { "Shuar",                                                      "jiv",     "",   "",    false, false },
  { "Shubi",                                                      "suj",     "",   "",    false, false },
  { "Shughni",                                                    "sgh",     "",   "",    false, false },
  { "Shuhi",                                                      "sxg",     "",   "",    false, false },
  { "Shumashti",                                                  "sts",     "",   "",    false, false },
  { "Shumcho",                                                    "scu",     "",   "",    false, false },
  { "Shuswap",                                                    "shs",     "",   "",    false, false },
  { "Shuwa-Zamani",                                               "ksa",     "",   "",    false, true  },
  { "Shwai",                                                      "shw",     "",   "",    false, false },
  { "Shwe Palaung",                                               "pll",     "",   "",    false, false },
  { "Sialum",                                                     "slw",     "",   "",    false, false },
  { "Siamou",                                                     "sif",     "",   "",    false, false },
  { "Sian",                                                       "spg",     "",   "",    false, false },
  { "Siane",                                                      "snp",     "",   "",    false, false },
  { "Siang",                                                      "sya",     "",   "",    false, false },
  { "Siar-Lak",                                                   "sjr",     "",   "",    false, false },
  { "Siawi",                                                      "mmp",     "",   "",    false, false },
  { "Sibe",                                                       "nco",     "",   "",    false, false },
  { "Siberian Tatar",                                             "sty",     "",   "",    false, false },
  { "Sibu Melanau",                                               "sdx",     "",   "",    false, false },
  { "Sicanian",                                                   "sxc",     "",   "",    false, false },
  { "Sicel",                                                      "scx",     "",   "",    false, false },
  { "Sichuan Yi",                                                 "iii",     "ii", "",    true,  false },
  { "Sicilian",                                                   "scn",     "",   "",    true,  false },
  { "Siculo Arabic",                                              "sqr",     "",   "",    false, false },
  { "Sidamo",                                                     "sid",     "",   "",    true,  false },
  { "Sidetic",                                                    "xsd",     "",   "",    false, false },
  { "Sie",                                                        "erg",     "",   "",    false, false },
  { "Sierra Leone Sign Language",                                 "sgx",     "",   "",    false, false },
  { "Sierra Negra Nahuatl",                                       "nsu",     "",   "",    false, false },
  { "Sierra de Juárez Zapotec",                                   "zaa",     "",   "",    false, false },
  { "Sighu",                                                      "sxe",     "",   "",    false, false },
  { "Sign Languages",                                             "sgn",     "",   "",    true,  false },
  { "Sihan",                                                      "snr",     "",   "",    false, false },
  { "Sihuas Ancash Quechua",                                      "qws",     "",   "",    false, false },
  { "Sika",                                                       "ski",     "",   "",    false, false },
  { "Sikaiana",                                                   "sky",     "",   "",    false, false },
  { "Sikaritai",                                                  "tty",     "",   "",    false, false },
  { "Sikiana",                                                    "sik",     "",   "",    false, false },
  { "Sikkimese",                                                  "sip",     "",   "",    false, false },
  { "Siksika",                                                    "bla",     "",   "",    true,  false },
  { "Sikule",                                                     "skh",     "",   "",    false, false },
  { "Sila",                                                       "slt",     "",   "",    false, false },
  { "Silacayoapan Mixtec",                                        "mks",     "",   "",    false, false },
  { "Sileibi",                                                    "sbq",     "",   "",    false, false },
  { "Silesian",                                                   "szl",     "",   "",    false, false },
  { "Silimo",                                                     "wul",     "",   "",    false, false },
  { "Siliput",                                                    "mkc",     "",   "",    false, false },
  { "Silopi",                                                     "xsp",     "",   "",    false, false },
  { "Silt'e",                                                     "stv",     "",   "",    false, false },
  { "Simaa",                                                      "sie",     "",   "",    false, false },
  { "Simba",                                                      "sbw",     "",   "",    false, false },
  { "Simbali",                                                    "smg",     "",   "",    false, false },
  { "Simbari",                                                    "smb",     "",   "",    false, false },
  { "Simbo",                                                      "sbb",     "",   "",    false, false },
  { "Simeku",                                                     "smz",     "",   "",    false, false },
  { "Simeulue",                                                   "smr",     "",   "",    false, false },
  { "Simte",                                                      "smt",     "",   "",    false, false },
  { "Sinagen",                                                    "siu",     "",   "",    false, false },
  { "Sinasina",                                                   "sst",     "",   "",    false, false },
  { "Sinaugoro",                                                  "snc",     "",   "",    false, false },
  { "Sindarin",                                                   "sjn",     "",   "",    false, false },
  { "Sindhi Bhil",                                                "sbn",     "",   "",    false, false },
  { "Sindhi",                                                     "snd",     "sd", "",    true,  false },
  { "Sindihui Mixtec",                                            "xts",     "",   "",    false, false },
  { "Singa",                                                      "sgm",     "",   "",    false, false },
  { "Singapore Sign Language",                                    "sls",     "",   "",    false, false },
  { "Singpho",                                                    "sgp",     "",   "",    false, false },
  { "Sinhala",                                                    "sin",     "si", "",    true,  false },
  { "Sinicahua Mixtec",                                           "xti",     "",   "",    false, false },
  { "Sininkere",                                                  "skq",     "",   "",    false, false },
  { "Sino-Tibetan languages",                                     "sit",     "",   "",    true,  false },
  { "Sinte Romani",                                               "rmo",     "",   "",    false, false },
  { "Sinyar",                                                     "sys",     "",   "",    false, false },
  { "Sio",                                                        "xsi",     "",   "",    false, false },
  { "Siona",                                                      "snn",     "",   "",    false, false },
  { "Siouan languages",                                           "sio",     "",   "",    true,  false },
  { "Sipacapense",                                                "qum",     "",   "",    false, false },
  { "Sira",                                                       "swj",     "",   "",    false, false },
  { "Siraya",                                                     "fos",     "",   "",    false, false },
  { "Sirenik Yupik",                                              "ysr",     "",   "",    false, false },
  { "Siri",                                                       "sir",     "",   "",    false, false },
  { "Siriano",                                                    "sri",     "",   "",    false, false },
  { "Sirionó",                                                    "srq",     "",   "",    false, false },
  { "Sirmauri",                                                   "srx",     "",   "",    false, false },
  { "Siroi",                                                      "ssd",     "",   "",    false, false },
  { "Sissala",                                                    "sld",     "",   "",    false, false },
  { "Sissano",                                                    "sso",     "",   "",    false, false },
  { "Siuslaw",                                                    "sis",     "",   "",    false, false },
  { "Sivandi",                                                    "siy",     "",   "",    false, false },
  { "Sivia Sign Language",                                        "lsv",     "",   "",    false, false },
  { "Siwai",                                                      "siw",     "",   "",    false, false },
  { "Siwi",                                                       "siz",     "",   "",    false, false },
  { "Siwu",                                                       "akp",     "",   "",    false, false },
  { "Siyin Chin",                                                 "csy",     "",   "",    false, false },
  { "Skagit",                                                     "ska",     "",   "",    false, false },
  { "Skalvian",                                                   "svx",     "",   "",    false, false },
  { "Skepi Creole Dutch",                                         "skw",     "",   "",    false, false },
  { "Skolt Sami",                                                 "sms",     "",   "",    true,  false },
  { "Skou",                                                       "skv",     "",   "",    false, false },
  { "Slave (Athapascan)",                                         "den",     "",   "",    true,  false },
  { "Slavic languages",                                           "sla",     "",   "",    true,  false },
  { "Slavomolisano",                                              "svm",     "",   "",    false, false },
  { "Slovak",                                                     "slo",     "sk", "slk", true,  false },
  { "Slovakian Sign Language",                                    "svk",     "",   "",    false, false },
  { "Slovenian",                                                  "slv",     "sl", "",    true,  false },
  { "Small Flowery Miao",                                         "sfm",     "",   "",    false, false },
  { "Smärky Kanum",                                               "kxq",     "",   "",    false, false },
  { "Snohomish",                                                  "sno",     "",   "",    false, false },
  { "So (Democratic Republic of Congo)",                          "soc",     "",   "",    false, false },
  { "So'a",                                                       "ssq",     "",   "",    false, false },
  { "Sobei",                                                      "sob",     "",   "",    false, false },
  { "Sochiapam Chinantec",                                        "cso",     "",   "",    false, false },
  { "Soga",                                                       "xog",     "",   "",    false, false },
  { "Sogdian",                                                    "sog",     "",   "",    true,  false },
  { "Soi",                                                        "soj",     "",   "",    false, false },
  { "Sok",                                                        "skk",     "",   "",    false, true  },
  { "Sokoro",                                                     "sok",     "",   "",    false, false },
  { "Solano",                                                     "xso",     "",   "",    false, false },
  { "Soli",                                                       "sby",     "",   "",    false, false },
  { "Solomon Islands Sign Language",                              "szs",     "",   "",    false, false },
  { "Solong",                                                     "aaw",     "",   "",    false, false },
  { "Solos",                                                      "sol",     "",   "",    false, false },
  { "Som",                                                        "smc",     "",   "",    false, false },
  { "Somali",                                                     "som",     "so", "",    true,  false },
  { "Somba-Siawari",                                              "bmu",     "",   "",    false, false },
  { "Somrai",                                                     "sor",     "",   "",    false, false },
  { "Somray",                                                     "smu",     "",   "",    false, false },
  { "Somyev",                                                     "kgt",     "",   "",    false, false },
  { "Sonaga",                                                     "ysg",     "",   "",    false, false },
  { "Sonde",                                                      "shc",     "",   "",    false, false },
  { "Songa",                                                      "sgo",     "",   "",    false, true  },
  { "Songe",                                                      "sop",     "",   "",    false, false },
  { "Songhai languages",                                          "son",     "",   "",    true,  false },
  { "Songlai Chin",                                               "csj",     "",   "",    false, false },
  { "Songo",                                                      "soo",     "",   "",    false, false },
  { "Songomeno",                                                  "soe",     "",   "",    false, false },
  { "Songoora",                                                   "sod",     "",   "",    false, false },
  { "Sonha",                                                      "soi",     "",   "",    false, false },
  { "Sonia",                                                      "siq",     "",   "",    false, false },
  { "Soninke",                                                    "snk",     "",   "",    true,  false },
  { "Sonsorol",                                                   "sov",     "",   "",    false, false },
  { "Soo",                                                        "teu",     "",   "",    false, false },
  { "Sop",                                                        "urw",     "",   "",    false, false },
  { "Soqotri",                                                    "sqt",     "",   "",    false, false },
  { "Sora",                                                       "srb",     "",   "",    false, false },
  { "Sorbian languages",                                          "wen",     "",   "",    true,  false },
  { "Sori-Harengan",                                              "sbh",     "",   "",    false, false },
  { "Sorkhei",                                                    "sqo",     "",   "",    false, false },
  { "Sorothaptic",                                                "sxo",     "",   "",    false, false },
  { "Sorsogon Ayta",                                              "ays",     "",   "",    false, false },
  { "Sos Kundi",                                                  "sdk",     "",   "",    false, false },
  { "Sota Kanum",                                                 "krz",     "",   "",    false, false },
  { "Sou Nama",                                                   "tlt",     "",   "",    false, false },
  { "Sou Upaa",                                                   "wha",     "",   "",    false, false },
  { "Sou",                                                        "sqq",     "",   "",    false, false },
  { "South African Sign Language",                                "sfs",     "",   "",    false, false },
  { "South American Indian languages",                            "sai",     "",   "",    true,  false },
  { "South Awyu",                                                 "aws",     "",   "",    false, false },
  { "South Azerbaijani",                                          "azb",     "",   "",    false, false },
  { "South Bolivian Quechua",                                     "quh",     "",   "",    false, false },
  { "South Caucasian languages",                                  "ccs",     "",   "",    false, false },
  { "South Central Banda",                                        "lnl",     "",   "",    false, false },
  { "South Central Dinka",                                        "dib",     "",   "",    false, false },
  { "South Efate",                                                "erk",     "",   "",    false, false },
  { "South Fali",                                                 "fal",     "",   "",    false, false },
  { "South Giziga",                                               "giz",     "",   "",    false, false },
  { "South Lembata",                                              "lmf",     "",   "",    false, false },
  { "South Levantine Arabic",                                     "ajp",     "",   "",    false, true  },
  { "South Marquesan",                                            "mqm",     "",   "",    false, false },
  { "South Muyu",                                                 "kts",     "",   "",    false, false },
  { "South Ndebele",                                              "nbl",     "nr", "",    true,  false },
  { "South Nuaulu",                                               "nxl",     "",   "",    false, false },
  { "South Picene",                                               "spx",     "",   "",    false, false },
  { "South Slavey",                                               "xsl",     "",   "",    false, false },
  { "South Slavic languages",                                     "zls",     "",   "",    false, false },
  { "South Tairora",                                              "omw",     "",   "",    false, false },
  { "South Ucayali Ashéninka",                                    "cpy",     "",   "",    false, false },
  { "South Watut",                                                "mcy",     "",   "",    false, false },
  { "South Wemale",                                               "tlw",     "",   "",    false, true  },
  { "South West Bay",                                             "sns",     "",   "",    false, false },
  { "Southeast Ambrym",                                           "tvk",     "",   "",    false, false },
  { "Southeast Babar",                                            "vbb",     "",   "",    false, false },
  { "Southeast Ijo",                                              "ijs",     "",   "",    false, false },
  { "Southeast Pashai",                                           "psi",     "",   "",    false, false },
  { "Southeast Tasmanian",                                        "xpf",     "",   "",    false, false },
  { "Southeastern Dinka",                                         "dks",     "",   "",    false, false },
  { "Southeastern Ixtlán Zapotec",                                "zpd",     "",   "",    false, false },
  { "Southeastern Kolami",                                        "nit",     "",   "",    false, false },
  { "Southeastern Nochixtlán Mixtec",                             "mxy",     "",   "",    false, false },
  { "Southeastern Pomo",                                          "pom",     "",   "",    false, false },
  { "Southeastern Puebla Nahuatl",                                "npl",     "",   "",    false, false },
  { "Southeastern Tarahumara",                                    "tcu",     "",   "",    false, false },
  { "Southeastern Tepehuan",                                      "stp",     "",   "",    false, false },
  { "Southern Alta",                                              "agy",     "",   "",    false, false },
  { "Southern Altai",                                             "alt",     "",   "",    true,  false },
  { "Southern Amami-Oshima",                                      "ams",     "",   "",    false, false },
  { "Southern Aymara",                                            "ayc",     "",   "",    false, false },
  { "Southern Bai",                                               "bfs",     "",   "",    false, false },
  { "Southern Balochi",                                           "bcc",     "",   "",    false, false },
  { "Southern Betsimisaraka Malagasy",                            "bjq",     "",   "",    false, true  },
  { "Southern Betsimisaraka Malagasy",                            "bzc",     "",   "",    false, false },
  { "Southern Binukidnon",                                        "mtw",     "",   "",    false, false },
  { "Southern Birifor",                                           "biv",     "",   "",    false, false },
  { "Southern Bobo Madaré",                                       "bwq",     "",   "",    false, false },
  { "Southern Bontok",                                            "obk",     "",   "",    false, false },
  { "Southern Carrier",                                           "caf",     "",   "",    false, false },
  { "Southern Catanduanes Bikol",                                 "bln",     "",   "",    false, false },
  { "Southern Conchucos Ancash Quechua",                          "qxo",     "",   "",    false, false },
  { "Southern Dagaare",                                           "dga",     "",   "",    false, false },
  { "Southern Dong",                                              "kmc",     "",   "",    false, false },
  { "Southern East Cree",                                         "crj",     "",   "",    false, false },
  { "Southern Ghale",                                             "ghe",     "",   "",    false, false },
  { "Southern Gondi",                                             "ggo",     "",   "",    false, true  },
  { "Southern Grebo",                                             "grj",     "",   "",    false, false },
  { "Southern Guiyang Hmong",                                     "hmy",     "",   "",    false, false },
  { "Southern Haida",                                             "hax",     "",   "",    false, false },
  { "Southern Hindko",                                            "hnd",     "",   "",    false, false },
  { "Southern Kalapuya",                                          "sxk",     "",   "",    false, false },
  { "Southern Kalinga",                                           "ksc",     "",   "",    false, false },
  { "Southern Katang",                                            "sct",     "",   "",    false, false },
  { "Southern Kisi",                                              "kss",     "",   "",    false, false },
  { "Southern Kiwai",                                             "kjd",     "",   "",    false, false },
  { "Southern Kurdish",                                           "sdh",     "",   "",    false, false },
  { "Southern Lolopo",                                            "ysp",     "",   "",    false, false },
  { "Southern Luri",                                              "luz",     "",   "",    false, false },
  { "Southern Ma'di",                                             "snm",     "",   "",    false, false },
  { "Southern Mashan Hmong",                                      "hma",     "",   "",    false, false },
  { "Southern Mnong",                                             "mnn",     "",   "",    false, false },
  { "Southern Muji",                                              "ymc",     "",   "",    false, false },
  { "Southern Nago",                                              "nqg",     "",   "",    false, false },
  { "Southern Nambikuára",                                        "nab",     "",   "",    false, false },
  { "Southern Ngbandi",                                           "nbw",     "",   "",    false, false },
  { "Southern Nicobarese",                                        "nik",     "",   "",    false, false },
  { "Southern Nisu",                                              "nsd",     "",   "",    false, false },
  { "Southern Nuni",                                              "nnw",     "",   "",    false, false },
  { "Southern Ohlone",                                            "css",     "",   "",    false, false },
  { "Southern One",                                               "osu",     "",   "",    false, false },
  { "Southern Pame",                                              "pmz",     "",   "",    false, false },
  { "Southern Pashto",                                            "pbt",     "",   "",    false, false },
  { "Southern Pastaza Quechua",                                   "qup",     "",   "",    false, false },
  { "Southern Ping Chinese",                                      "csp",     "",   "",    false, false },
  { "Southern Pomo",                                              "peq",     "",   "",    false, false },
  { "Southern Puebla Mixtec",                                     "mit",     "",   "",    false, false },
  { "Southern Puget Sound Salish",                                "slh",     "",   "",    false, false },
  { "Southern Pumi",                                              "pmj",     "",   "",    false, false },
  { "Southern Qiandong Miao",                                     "hms",     "",   "",    false, false },
  { "Southern Qiang",                                             "qxs",     "",   "",    false, false },
  { "Southern Rengma Naga",                                       "nre",     "",   "",    false, false },
  { "Southern Rincon Zapotec",                                    "zsr",     "",   "",    false, false },
  { "Southern Roglai",                                            "rgs",     "",   "",    false, false },
  { "Southern Sama",                                              "ssb",     "",   "",    false, false },
  { "Southern Sami",                                              "sma",     "",   "",    true,  false },
  { "Southern Samo",                                              "sbd",     "",   "",    false, false },
  { "Southern Sierra Miwok",                                      "skd",     "",   "",    false, false },
  { "Southern Sorsoganon",                                        "srv",     "",   "",    false, false },
  { "Southern Sotho",                                             "sot",     "st", "",    true,  false },
  { "Southern Subanen",                                           "laa",     "",   "",    false, false },
  { "Southern Thai",                                              "sou",     "",   "",    false, false },
  { "Southern Tidung",                                            "itd",     "",   "",    false, false },
  { "Southern Tiwa",                                              "tix",     "",   "",    false, false },
  { "Southern Toussian",                                          "wib",     "",   "",    false, false },
  { "Southern Tujia",                                             "tjs",     "",   "",    false, false },
  { "Southern Tutchone",                                          "tce",     "",   "",    false, false },
  { "Southern Uzbek",                                             "uzs",     "",   "",    false, false },
  { "Southern Yamphu",                                            "lrr",     "",   "",    false, false },
  { "Southern Yukaghir",                                          "yux",     "",   "",    false, false },
  { "Southwest Gbaya",                                            "gso",     "",   "",    false, false },
  { "Southwest Palawano",                                         "plv",     "",   "",    false, false },
  { "Southwest Pashai",                                           "psh",     "",   "",    false, false },
  { "Southwest Tanna",                                            "nwi",     "",   "",    false, false },
  { "Southwestern Bontok",                                        "vbk",     "",   "",    false, false },
  { "Southwestern Dinka",                                         "dik",     "",   "",    false, false },
  { "Southwestern Fars",                                          "fay",     "",   "",    false, false },
  { "Southwestern Guiyang Hmong",                                 "hmg",     "",   "",    false, false },
  { "Southwestern Huishui Hmong",                                 "hmh",     "",   "",    false, false },
  { "Southwestern Nisu",                                          "nsv",     "",   "",    false, false },
  { "Southwestern Tamang",                                        "tsf",     "",   "",    false, true  },
  { "Southwestern Tarahumara",                                    "twr",     "",   "",    false, false },
  { "Southwestern Tasmanian",                                     "xpx",     "",   "",    false, false },
  { "Southwestern Tepehuan",                                      "tla",     "",   "",    false, false },
  { "Southwestern Tlaxiaco Mixtec",                               "meh",     "",   "",    false, false },
  { "Sowa",                                                       "sww",     "",   "",    false, false },
  { "Sowanda",                                                    "sow",     "",   "",    false, false },
  { "Soyaltepec Mazatec",                                         "vmp",     "",   "",    false, false },
  { "Soyaltepec Mixtec",                                          "vmq",     "",   "",    false, false },
  { "Spanish Sign Language",                                      "ssp",     "",   "",    false, false },
  { "Spanish",                                                    "spa",     "es", "",    true,  false },
  { "Spiti Bhoti",                                                "spt",     "",   "",    false, false },
  { "Spokane",                                                    "spo",     "",   "",    false, false },
  { "Squamish",                                                   "squ",     "",   "",    false, false },
  { "Sranan Tongo",                                               "srn",     "",   "",    true,  false },
  { "Sri Lankan Creole Malay",                                    "sci",     "",   "",    false, false },
  { "Sri Lankan Sign Language",                                   "sqs",     "",   "",    false, false },
  { "Standard Arabic",                                            "arb",     "",   "",    false, false },
  { "Standard Estonian",                                          "ekk",     "",   "",    false, false },
  { "Standard Latvian",                                           "lvs",     "",   "",    false, false },
  { "Standard Malay",                                             "zsm",     "",   "",    false, false },
  { "Standard Moroccan Tamazight",                                "zgh",     "",   "",    true,  false },
  { "Stellingwerfs",                                              "stl",     "",   "",    false, false },
  { "Stod Bhoti",                                                 "sbu",     "",   "",    false, false },
  { "Stoney",                                                     "sto",     "",   "",    false, false },
  { "Straits Salish",                                             "str",     "",   "",    false, false },
  { "Suabo",                                                      "szp",     "",   "",    false, false },
  { "Suarmin",                                                    "seo",     "",   "",    false, false },
  { "Suau",                                                       "swp",     "",   "",    false, false },
  { "Suba",                                                       "sxb",     "",   "",    false, false },
  { "Suba-Simbiti",                                               "ssc",     "",   "",    false, false },
  { "Subi",                                                       "xsj",     "",   "",    false, false },
  { "Subiya",                                                     "sbs",     "",   "",    false, false },
  { "Subtiaba",                                                   "sut",     "",   "",    false, false },
  { "Sudanese Arabic",                                            "apd",     "",   "",    false, false },
  { "Sudanese Creole Arabic",                                     "pga",     "",   "",    false, false },
  { "Sudest",                                                     "tgo",     "",   "",    false, false },
  { "Sudovian",                                                   "xsv",     "",   "",    false, false },
  { "Suena",                                                      "sue",     "",   "",    false, false },
  { "Suga",                                                       "sgi",     "",   "",    false, false },
  { "Suganga",                                                    "sug",     "",   "",    false, false },
  { "Sugut Dusun",                                                "kzs",     "",   "",    false, false },
  { "Sui",                                                        "swi",     "",   "",    false, false },
  { "Suki",                                                       "sui",     "",   "",    false, false },
  { "Suku",                                                       "sub",     "",   "",    false, false },
  { "Sukuma",                                                     "suk",     "",   "",    true,  false },
  { "Sukur",                                                      "syk",     "",   "",    false, false },
  { "Sukurum",                                                    "zsu",     "",   "",    false, false },
  { "Sula",                                                       "szn",     "",   "",    false, false },
  { "Sulka",                                                      "sua",     "",   "",    false, false },
  { "Sulod",                                                      "srg",     "",   "",    false, false },
  { "Suma",                                                       "sqm",     "",   "",    false, false },
  { "Sumariup",                                                   "siv",     "",   "",    false, false },
  { "Sumau",                                                      "six",     "",   "",    false, false },
  { "Sumbawa",                                                    "smw",     "",   "",    false, false },
  { "Sumbwa",                                                     "suw",     "",   "",    false, false },
  { "Sumerian",                                                   "sux",     "",   "",    true,  false },
  { "Sumi Naga",                                                  "nsm",     "",   "",    false, false },
  { "Sumo-Mayangna",                                              "sum",     "",   "",    false, true  },
  { "Sumtu Chin",                                                 "csv",     "",   "",    false, false },
  { "Sunam",                                                      "ssk",     "",   "",    false, false },
  { "Sundanese",                                                  "sun",     "su", "",    true,  false },
  { "Sunwar",                                                     "suz",     "",   "",    false, false },
  { "Suoy",                                                       "syo",     "",   "",    false, false },
  { "Supyire Senoufo",                                            "spp",     "",   "",    false, false },
  { "Sur",                                                        "tdl",     "",   "",    false, false },
  { "Surbakhal",                                                  "sbj",     "",   "",    false, false },
  { "Surgujia",                                                   "sgj",     "",   "",    false, false },
  { "Surigaonon",                                                 "sgd",     "",   "",    false, false },
  { "Surigaonon",                                                 "sul",     "",   "",    false, true  },
  { "Surjapuri",                                                  "sjp",     "",   "",    false, false },
  { "Sursurunga",                                                 "sgz",     "",   "",    false, false },
  { "Suruahá",                                                    "swx",     "",   "",    false, false },
  { "Surubu",                                                     "sde",     "",   "",    false, false },
  { "Suruí Do Pará",                                              "mdz",     "",   "",    false, false },
  { "Suruí",                                                      "sru",     "",   "",    false, false },
  { "Susquehannock",                                              "sqn",     "",   "",    false, false },
  { "Susu",                                                       "sus",     "",   "",    true,  false },
  { "Susuami",                                                    "ssu",     "",   "",    false, false },
  { "Suundi",                                                     "sdj",     "",   "",    false, false },
  { "Suwawa",                                                     "swu",     "",   "",    false, false },
  { "Suyá",                                                       "suy",     "",   "",    false, false },
  { "Svan",                                                       "sva",     "",   "",    false, false },
  { "Swabian",                                                    "swg",     "",   "",    false, false },
  { "Swahili (individual language)",                              "swh",     "",   "",    false, false },
  { "Swahili (macrolanguage)",                                    "swa",     "sw", "",    true,  false },
  { "Swampy Cree",                                                "csw",     "",   "",    false, false },
  { "Swati",                                                      "ssw",     "ss", "",    true,  false },
  { "Swedish Sign Language",                                      "swl",     "",   "",    false, false },
  { "Swedish",                                                    "swe",     "sv", "",    true,  false },
  { "Swiss German",                                               "gsw",     "",   "",    true,  false },
  { "Swiss-French Sign Language",                                 "ssr",     "",   "",    false, false },
  { "Swiss-German Sign Language",                                 "sgg",     "",   "",    false, false },
  { "Swiss-Italian Sign Language",                                "slf",     "",   "",    false, false },
  { "Swo",                                                        "sox",     "",   "",    false, false },
  { "Syenara Senoufo",                                            "shz",     "",   "",    false, false },
  { "Sylheti",                                                    "syl",     "",   "",    false, false },
  { "Syriac",                                                     "syr",     "",   "",    true,  false },
  { "Sáliba",                                                     "slc",     "",   "",    false, false },
  { "São Paulo Kaingáng",                                         "zkp",     "",   "",    false, false },
  { "Sãotomense",                                                 "cri",     "",   "",    false, false },
  { "Sìcìté Sénoufo",                                             "sep",     "",   "",    false, false },
  { "Sô",                                                         "sss",     "",   "",    false, false },
  { "T'apo",                                                      "lgn",     "",   "",    false, false },
  { "T'en",                                                       "tct",     "",   "",    false, false },
  { "Ta'izzi-Adeni Arabic",                                       "acq",     "",   "",    false, false },
  { "Taabwa",                                                     "tap",     "",   "",    false, false },
  { "Tabaa Zapotec",                                              "zat",     "",   "",    false, false },
  { "Tabaru",                                                     "tby",     "",   "",    false, false },
  { "Tabasco Chontal",                                            "chf",     "",   "",    false, false },
  { "Tabasco Nahuatl",                                            "nhc",     "",   "",    false, false },
  { "Tabasco Zoque",                                              "zoq",     "",   "",    false, false },
  { "Tabassaran",                                                 "tab",     "",   "",    false, false },
  { "Tabla",                                                      "tnm",     "",   "",    false, false },
  { "Tabo",                                                       "knv",     "",   "",    false, false },
  { "Tabriak",                                                    "tzx",     "",   "",    false, false },
  { "Tacahua Mixtec",                                             "xtt",     "",   "",    false, false },
  { "Tacana",                                                     "tna",     "",   "",    false, false },
  { "Tachawit",                                                   "shy",     "",   "",    false, false },
  { "Tachelhit",                                                  "shi",     "",   "",    false, false },
  { "Tachoni",                                                    "lts",     "",   "",    false, false },
  { "Tadaksahak",                                                 "dsq",     "",   "",    false, false },
  { "Tado",                                                       "klw",     "",   "",    false, false },
  { "Tadyawan",                                                   "tdy",     "",   "",    false, false },
  { "Tae'",                                                       "rob",     "",   "",    false, false },
  { "Tafi",                                                       "tcd",     "",   "",    false, false },
  { "Tagabawa",                                                   "bgs",     "",   "",    false, false },
  { "Tagakaulo",                                                  "klg",     "",   "",    false, false },
  { "Tagal Murut",                                                "mvv",     "",   "",    false, false },
  { "Tagalaka",                                                   "tgz",     "",   "",    false, false },
  { "Tagalog",                                                    "tgl",     "tl", "",    true,  false },
  { "Tagargrent",                                                 "oua",     "",   "",    false, false },
  { "Tagbanwa",                                                   "tbw",     "",   "",    false, false },
  { "Tagbu",                                                      "tbm",     "",   "",    false, false },
  { "Tagdal",                                                     "tda",     "",   "",    false, false },
  { "Tagin",                                                      "tgj",     "",   "",    false, false },
  { "Tagish",                                                     "tgx",     "",   "",    false, false },
  { "Tagoi",                                                      "tag",     "",   "",    false, false },
  { "Tagwana Senoufo",                                            "tgw",     "",   "",    false, false },
  { "Tahaggart Tamahaq",                                          "thv",     "",   "",    false, false },
  { "Tahitian",                                                   "tah",     "ty", "",    true,  false },
  { "Tahltan",                                                    "tht",     "",   "",    false, false },
  { "Tai Daeng",                                                  "tyr",     "",   "",    false, false },
  { "Tai Dam",                                                    "blt",     "",   "",    false, false },
  { "Tai Do",                                                     "tyj",     "",   "",    false, false },
  { "Tai Dón",                                                    "twh",     "",   "",    false, false },
  { "Tai Hang Tong",                                              "thc",     "",   "",    false, true  },
  { "Tai Hongjin",                                                "tiz",     "",   "",    false, false },
  { "Tai Laing",                                                  "tjl",     "",   "",    false, false },
  { "Tai Loi",                                                    "tlq",     "",   "",    false, false },
  { "Tai Long",                                                   "thi",     "",   "",    false, false },
  { "Tai Mène",                                                   "tmp",     "",   "",    false, true  },
  { "Tai Nüa",                                                    "tdd",     "",   "",    false, false },
  { "Tai Pao",                                                    "tpo",     "",   "",    false, false },
  { "Tai Thanh",                                                  "tmm",     "",   "",    false, false },
  { "Tai Ya",                                                     "cuu",     "",   "",    false, false },
  { "Tai languages",                                              "tai",     "",   "",    true,  false },
  { "Tai",                                                        "taw",     "",   "",    false, false },
  { "Taiap",                                                      "gpn",     "",   "",    false, false },
  { "Taikat",                                                     "aos",     "",   "",    false, false },
  { "Tainae",                                                     "ago",     "",   "",    false, false },
  { "Taino",                                                      "tnq",     "",   "",    false, false },
  { "Tairaha",                                                    "bxa",     "",   "",    false, false },
  { "Tairuma",                                                    "uar",     "",   "",    false, false },
  { "Taita",                                                      "dav",     "",   "",    false, false },
  { "Taivoan",                                                    "tvx",     "",   "",    false, false },
  { "Taiwan Sign Language",                                       "tss",     "",   "",    false, false },
  { "Taje",                                                       "pee",     "",   "",    false, false },
  { "Tajik",                                                      "tgk",     "tg", "",    true,  false },
  { "Tajiki Arabic",                                              "abh",     "",   "",    false, false },
  { "Tajio",                                                      "tdj",     "",   "",    false, false },
  { "Tajuasohn",                                                  "tja",     "",   "",    false, false },
  { "Takelma",                                                    "tkm",     "",   "",    false, false },
  { "Takestani",                                                  "tks",     "",   "",    false, false },
  { "Takia",                                                      "tbc",     "",   "",    false, false },
  { "Takpa",                                                      "tkk",     "",   "",    false, true  },
  { "Takua",                                                      "tkz",     "",   "",    false, false },
  { "Takuu",                                                      "nho",     "",   "",    false, false },
  { "Takwane",                                                    "tke",     "",   "",    false, false },
  { "Tal",                                                        "tal",     "",   "",    false, false },
  { "Tala",                                                       "tak",     "",   "",    false, false },
  { "Talaud",                                                     "tld",     "",   "",    false, false },
  { "Taliabu",                                                    "tlv",     "",   "",    false, false },
  { "Talieng",                                                    "tdf",     "",   "",    false, false },
  { "Talinga-Bwisi",                                              "tlj",     "",   "",    false, false },
  { "Talise",                                                     "tlr",     "",   "",    false, false },
  { "Talodi",                                                     "tlo",     "",   "",    false, false },
  { "Taloki",                                                     "tlk",     "",   "",    false, false },
  { "Talondo'",                                                   "tln",     "",   "",    false, false },
  { "Talossan",                                                   "tzl",     "",   "",    false, false },
  { "Talu",                                                       "yta",     "",   "",    false, false },
  { "Talur",                                                      "ilw",     "",   "",    false, true  },
  { "Talysh",                                                     "tly",     "",   "",    false, false },
  { "Tama (Chad)",                                                "tma",     "",   "",    false, false },
  { "Tama (Colombia)",                                            "ten",     "",   "",    false, false },
  { "Tamagario",                                                  "tcg",     "",   "",    false, false },
  { "Taman (Indonesia)",                                          "tmn",     "",   "",    false, false },
  { "Taman (Myanmar)",                                            "tcl",     "",   "",    false, false },
  { "Tamanaku",                                                   "tmz",     "",   "",    false, false },
  { "Tamashek",                                                   "tmh",     "",   "",    true,  false },
  { "Tamasheq",                                                   "taq",     "",   "",    false, false },
  { "Tamazola Mixtec",                                            "vmx",     "",   "",    false, false },
  { "Tambas",                                                     "tdk",     "",   "",    false, false },
  { "Tambora",                                                    "xxt",     "",   "",    false, false },
  { "Tambotalo",                                                  "tls",     "",   "",    false, false },
  { "Tambunan Dusun",                                             "kzt",     "",   "",    false, true  },
  { "Tami",                                                       "tmy",     "",   "",    false, false },
  { "Tamil",                                                      "tam",     "ta", "",    true,  false },
  { "Tamki",                                                      "tax",     "",   "",    false, false },
  { "Tamnim Citak",                                               "tml",     "",   "",    false, false },
  { "Tampias Lobu",                                               "low",     "",   "",    false, false },
  { "Tampuan",                                                    "tpu",     "",   "",    false, false },
  { "Tampulma",                                                   "tpm",     "",   "",    false, false },
  { "Tanacross",                                                  "tcb",     "",   "",    false, false },
  { "Tanahmerah",                                                 "tcm",     "",   "",    false, false },
  { "Tanaina",                                                    "tfn",     "",   "",    false, false },
  { "Tanapag",                                                    "tpv",     "",   "",    false, false },
  { "Tandaganon",                                                 "tgn",     "",   "",    false, false },
  { "Tandia",                                                     "tni",     "",   "",    false, false },
  { "Tandroy-Mahafaly Malagasy",                                  "tdx",     "",   "",    false, false },
  { "Tanema",                                                     "tnx",     "",   "",    false, false },
  { "Tangale",                                                    "tan",     "",   "",    false, false },
  { "Tangchangya",                                                "tnv",     "",   "",    false, false },
  { "Tangga",                                                     "tgg",     "",   "",    false, true  },
  { "Tanggu",                                                     "tgu",     "",   "",    false, false },
  { "Tangkhul Naga (India)",                                      "nmf",     "",   "",    false, false },
  { "Tangkhul Naga (Myanmar)",                                    "ntx",     "",   "",    false, false },
  { "Tangko",                                                     "tkx",     "",   "",    false, false },
  { "Tanglang",                                                   "ytl",     "",   "",    false, false },
  { "Tangoa",                                                     "tgp",     "",   "",    false, false },
  { "Tangshewi",                                                  "tnf",     "",   "",    false, true  },
  { "Tanguat",                                                    "tbs",     "",   "",    false, false },
  { "Tangut",                                                     "txg",     "",   "",    false, false },
  { "Tanimbili",                                                  "tbe",     "",   "",    false, false },
  { "Tanimuca-Retuarã",                                           "tnc",     "",   "",    false, false },
  { "Tanjijili",                                                  "uji",     "",   "",    false, false },
  { "Tanosy Malagasy",                                            "txy",     "",   "",    false, false },
  { "Tanudan Kalinga",                                            "kml",     "",   "",    false, false },
  { "Tanzanian Sign Language",                                    "tza",     "",   "",    false, false },
  { "Tapeba",                                                     "tbb",     "",   "",    false, true  },
  { "Tapei",                                                      "afp",     "",   "",    false, false },
  { "Tapieté",                                                    "tpj",     "",   "",    false, false },
  { "Tapirapé",                                                   "taf",     "",   "",    false, false },
  { "Tarao Naga",                                                 "tro",     "",   "",    false, false },
  { "Tareng",                                                     "tgr",     "",   "",    false, false },
  { "Tariana",                                                    "tae",     "",   "",    false, false },
  { "Tarifit",                                                    "rif",     "",   "",    false, false },
  { "Tarjumo",                                                    "txj",     "",   "",    false, false },
  { "Tarok",                                                      "yer",     "",   "",    false, false },
  { "Tarpia",                                                     "tpf",     "",   "",    false, false },
  { "Tartessian",                                                 "txr",     "",   "",    false, false },
  { "Taruma",                                                     "tdm",     "",   "",    false, false },
  { "Tasawaq",                                                    "twq",     "",   "",    false, false },
  { "Tase Naga",                                                  "nst",     "",   "",    false, false },
  { "Tasmanian",                                                  "xtz",     "",   "",    false, true  },
  { "Tasmate",                                                    "tmt",     "",   "",    false, false },
  { "Tataltepec Chatino",                                         "cta",     "",   "",    false, false },
  { "Tatana",                                                     "txx",     "",   "",    false, false },
  { "Tatar",                                                      "tat",     "tt", "",    true,  false },
  { "Tatuyo",                                                     "tav",     "",   "",    false, false },
  { "Tauade",                                                     "ttd",     "",   "",    false, false },
  { "Taulil",                                                     "tuh",     "",   "",    false, false },
  { "Taungyo",                                                    "tco",     "",   "",    false, false },
  { "Taupota",                                                    "tpa",     "",   "",    false, false },
  { "Tause",                                                      "tad",     "",   "",    false, false },
  { "Taushiro",                                                   "trr",     "",   "",    false, false },
  { "Tausug",                                                     "tsg",     "",   "",    false, false },
  { "Tauya",                                                      "tya",     "",   "",    false, false },
  { "Taveta",                                                     "tvs",     "",   "",    false, false },
  { "Tavoyan",                                                    "tvn",     "",   "",    false, false },
  { "Tavringer Romani",                                           "rmu",     "",   "",    false, false },
  { "Tawala",                                                     "tbo",     "",   "",    false, false },
  { "Tawallammat Tamajaq",                                        "ttq",     "",   "",    false, false },
  { "Tawandê",                                                    "xtw",     "",   "",    false, false },
  { "Tawang Monpa",                                               "twm",     "",   "",    false, false },
  { "Tawara",                                                     "twl",     "",   "",    false, false },
  { "Taworta",                                                    "tbp",     "",   "",    false, false },
  { "Tawoyan",                                                    "twy",     "",   "",    false, false },
  { "Tawr Chin",                                                  "tcp",     "",   "",    false, false },
  { "Tay Boi",                                                    "tas",     "",   "",    false, false },
  { "Tay Khang",                                                  "tnu",     "",   "",    false, false },
  { "Tayabas Ayta",                                               "ayy",     "",   "",    false, true  },
  { "Tayart Tamajeq",                                             "thz",     "",   "",    false, false },
  { "Tayo",                                                       "cks",     "",   "",    false, false },
  { "Taznatit",                                                   "grr",     "",   "",    false, false },
  { "Tboli",                                                      "tbl",     "",   "",    false, false },
  { "Tchitchege",                                                 "tck",     "",   "",    false, false },
  { "Tchumbuli",                                                  "bqa",     "",   "",    false, false },
  { "Te'un",                                                      "tve",     "",   "",    false, false },
  { "Teanu",                                                      "tkw",     "",   "",    false, false },
  { "Tebul Sign Language",                                        "tsy",     "",   "",    false, false },
  { "Tebul Ure Dogon",                                            "dtu",     "",   "",    false, false },
  { "Tecpatlán Totonac",                                          "tcw",     "",   "",    false, false },
  { "Tedaga",                                                     "tuq",     "",   "",    false, false },
  { "Tedim Chin",                                                 "ctd",     "",   "",    false, false },
  { "Tee",                                                        "tkq",     "",   "",    false, false },
  { "Tefaro",                                                     "tfo",     "",   "",    false, false },
  { "Tegali",                                                     "ras",     "",   "",    false, false },
  { "Tehit",                                                      "kps",     "",   "",    false, false },
  { "Tehuelche",                                                  "teh",     "",   "",    false, false },
  { "Tejalapan Zapotec",                                          "ztt",     "",   "",    false, false },
  { "Teke-Ebo",                                                   "ebo",     "",   "",    false, false },
  { "Teke-Fuumu",                                                 "ifm",     "",   "",    false, false },
  { "Teke-Kukuya",                                                "kkw",     "",   "",    false, false },
  { "Teke-Laali",                                                 "lli",     "",   "",    false, false },
  { "Teke-Nzikou",                                                "nzu",     "",   "",    false, false },
  { "Teke-Tege",                                                  "teg",     "",   "",    false, false },
  { "Teke-Tsaayi",                                                "tyi",     "",   "",    false, false },
  { "Teke-Tyee",                                                  "tyx",     "",   "",    false, false },
  { "Tektiteko",                                                  "ttc",     "",   "",    false, false },
  { "Tela-Masbuar",                                               "tvm",     "",   "",    false, false },
  { "Telefol",                                                    "tlf",     "",   "",    false, false },
  { "Telugu",                                                     "tel",     "te", "",    true,  false },
  { "Tem",                                                        "kdh",     "",   "",    false, false },
  { "Temacine Tamazight",                                         "tjo",     "",   "",    false, false },
  { "Temascaltepec Nahuatl",                                      "nhv",     "",   "",    false, false },
  { "Tembo (Kitembo)",                                            "tbt",     "",   "",    false, false },
  { "Tembo (Motembo)",                                            "tmv",     "",   "",    false, false },
  { "Tembé",                                                      "tqb",     "",   "",    false, false },
  { "Teme",                                                       "tdo",     "",   "",    false, false },
  { "Temein",                                                     "teq",     "",   "",    false, false },
  { "Temi",                                                       "soz",     "",   "",    false, false },
  { "Temiar",                                                     "tea",     "",   "",    false, false },
  { "Temoaya Otomi",                                              "ott",     "",   "",    false, false },
  { "Temoq",                                                      "tmo",     "",   "",    false, false },
  { "Tempasuk Dusun",                                             "tdu",     "",   "",    false, true  },
  { "Temuan",                                                     "tmw",     "",   "",    false, false },
  { "Ten'edn",                                                    "tnz",     "",   "",    false, false },
  { "Tena Lowland Quichua",                                       "quw",     "",   "",    false, false },
  { "Tenango Otomi",                                              "otn",     "",   "",    false, false },
  { "Tene Kan Dogon",                                             "dtk",     "",   "",    false, false },
  { "Tenggarong Kutai Malay",                                     "vkt",     "",   "",    false, false },
  { "Tengger",                                                    "tes",     "",   "",    false, false },
  { "Tenharim",                                                   "pah",     "",   "",    false, false },
  { "Tenino",                                                     "tqn",     "",   "",    false, false },
  { "Tenis",                                                      "tns",     "",   "",    false, false },
  { "Tennet",                                                     "tex",     "",   "",    false, false },
  { "Teop",                                                       "tio",     "",   "",    false, false },
  { "Teor",                                                       "tev",     "",   "",    false, false },
  { "Tepecano",                                                   "tep",     "",   "",    false, false },
  { "Tepetotutla Chinantec",                                      "cnt",     "",   "",    false, false },
  { "Tepeuxila Cuicatec",                                         "cux",     "",   "",    false, false },
  { "Tepinapa Chinantec",                                         "cte",     "",   "",    false, false },
  { "Tepo Krumen",                                                "ted",     "",   "",    false, false },
  { "Ter Sami",                                                   "sjt",     "",   "",    false, false },
  { "Tera",                                                       "ttr",     "",   "",    false, false },
  { "Terebu",                                                     "trb",     "",   "",    false, false },
  { "Terei",                                                      "buo",     "",   "",    false, false },
  { "Tereno",                                                     "ter",     "",   "",    true,  false },
  { "Teressa",                                                    "tef",     "",   "",    false, false },
  { "Tereweng",                                                   "twg",     "",   "",    false, false },
  { "Teribe",                                                     "tfr",     "",   "",    false, false },
  { "Terik",                                                      "tec",     "",   "",    false, false },
  { "Termanu",                                                    "twu",     "",   "",    false, false },
  { "Ternate",                                                    "tft",     "",   "",    false, false },
  { "Ternateño",                                                  "tmg",     "",   "",    false, false },
  { "Tesaka Malagasy",                                            "tkg",     "",   "",    false, false },
  { "Tese",                                                       "keg",     "",   "",    false, false },
  { "Teshenawa",                                                  "twc",     "",   "",    false, false },
  { "Teso",                                                       "teo",     "",   "",    false, false },
  { "Tetela",                                                     "tll",     "",   "",    false, false },
  { "Tetelcingo Nahuatl",                                         "nhg",     "",   "",    false, false },
  { "Tetete",                                                     "teb",     "",   "",    false, false },
  { "Tetserret",                                                  "tez",     "",   "",    false, false },
  { "Tetum",                                                      "tet",     "",   "",    true,  false },
  { "Tetun Dili",                                                 "tdt",     "",   "",    false, false },
  { "Teutila Cuicatec",                                           "cut",     "",   "",    false, false },
  { "Tewa (Indonesia)",                                           "twe",     "",   "",    false, false },
  { "Tewa (USA)",                                                 "tew",     "",   "",    false, false },
  { "Tewe",                                                       "twx",     "",   "",    false, false },
  { "Texcatepec Otomi",                                           "otx",     "",   "",    false, false },
  { "Texistepec Popoluca",                                        "poq",     "",   "",    false, false },
  { "Texmelucan Zapotec",                                         "zpz",     "",   "",    false, false },
  { "Tezoatlán Mixtec",                                           "mxb",     "",   "",    false, false },
  { "Tha",                                                        "thy",     "",   "",    false, false },
  { "Thachanadan",                                                "thn",     "",   "",    false, false },
  { "Thado Chin",                                                 "tcz",     "",   "",    false, false },
  { "Thai Sign Language",                                         "tsq",     "",   "",    false, false },
  { "Thai Song",                                                  "soa",     "",   "",    false, false },
  { "Thai",                                                       "tha",     "th", "",    true,  false },
  { "Thaiphum Chin",                                              "cth",     "",   "",    false, false },
  { "Thakali",                                                    "ths",     "",   "",    false, false },
  { "Thangal Naga",                                               "nki",     "",   "",    false, false },
  { "Thangmi",                                                    "thf",     "",   "",    false, false },
  { "Thao",                                                       "ssf",     "",   "",    false, false },
  { "Tharaka",                                                    "thk",     "",   "",    false, false },
  { "Thawa",                                                      "xtv",     "",   "",    false, false },
  { "Thaypan",                                                    "typ",     "",   "",    false, false },
  { "The",                                                        "thx",     "",   "",    false, true  },
  { "Thiin",                                                      "iin",     "",   "",    false, false },
  { "Tho",                                                        "tou",     "",   "",    false, false },
  { "Thompson",                                                   "thp",     "",   "",    false, false },
  { "Thopho",                                                     "ytp",     "",   "",    false, false },
  { "Thracian",                                                   "txh",     "",   "",    false, false },
  { "Thu Lao",                                                    "tyl",     "",   "",    false, false },
  { "Thudam",                                                     "thw",     "",   "",    false, true  },
  { "Thulung",                                                    "tdh",     "",   "",    false, false },
  { "Thur",                                                       "lth",     "",   "",    false, false },
  { "Thuri",                                                      "thu",     "",   "",    false, false },
  { "Tiagbamrin Aizi",                                            "ahi",     "",   "",    false, false },
  { "Tiale",                                                      "mnl",     "",   "",    false, false },
  { "Tiang",                                                      "tbj",     "",   "",    false, false },
  { "Tibea",                                                      "ngy",     "",   "",    false, false },
  { "Tibetan Sign Language",                                      "lsn",     "",   "",    false, false },
  { "Tibetan",                                                    "tib",     "bo", "bod", true,  false },
  { "Tibeto-Burman languages",                                    "tbq",     "",   "",    false, false },
  { "Tichurong",                                                  "tcn",     "",   "",    false, false },
  { "Ticuna",                                                     "tca",     "",   "",    false, false },
  { "Tidaá Mixtec",                                               "mtx",     "",   "",    false, false },
  { "Tidikelt Tamazight",                                         "tia",     "",   "",    false, false },
  { "Tidong",                                                     "tid",     "",   "",    false, true  },
  { "Tidore",                                                     "tvo",     "",   "",    false, false },
  { "Tiemacèwè Bozo",                                             "boo",     "",   "",    false, false },
  { "Tiene",                                                      "tii",     "",   "",    false, false },
  { "Tifal",                                                      "tif",     "",   "",    false, false },
  { "Tigak",                                                      "tgc",     "",   "",    false, false },
  { "Tigon Mbembe",                                               "nza",     "",   "",    false, false },
  { "Tigre",                                                      "tig",     "",   "",    true,  false },
  { "Tigrinya",                                                   "tir",     "ti", "",    true,  false },
  { "Tii",                                                        "txq",     "",   "",    false, false },
  { "Tijaltepec Mixtec",                                          "xtl",     "",   "",    false, false },
  { "Tikar",                                                      "tik",     "",   "",    false, false },
  { "Tikopia",                                                    "tkp",     "",   "",    false, false },
  { "Tilapa Otomi",                                               "otl",     "",   "",    false, false },
  { "Tillamook",                                                  "til",     "",   "",    false, false },
  { "Tilquiapan Zapotec",                                         "zts",     "",   "",    false, false },
  { "Tilung",                                                     "tij",     "",   "",    false, false },
  { "Tima",                                                       "tms",     "",   "",    false, false },
  { "Timbe",                                                      "tim",     "",   "",    false, false },
  { "Timne",                                                      "tem",     "",   "",    true,  false },
  { "Timor Pidgin",                                               "tvy",     "",   "",    false, false },
  { "Timucua",                                                    "tjm",     "",   "",    false, false },
  { "Timugon Murut",                                              "tih",     "",   "",    false, false },
  { "Tinani",                                                     "lbf",     "",   "",    false, false },
  { "Tindi",                                                      "tin",     "",   "",    false, false },
  { "Tingal",                                                     "tie",     "",   "",    false, true  },
  { "Tingui-Boto",                                                "tgv",     "",   "",    false, false },
  { "Tinigua",                                                    "tit",     "",   "",    false, false },
  { "Tinoc Kallahan",                                             "tne",     "",   "",    false, true  },
  { "Tinputz",                                                    "tpz",     "",   "",    false, false },
  { "Tippera",                                                    "tpe",     "",   "",    false, false },
  { "Tira",                                                       "tic",     "",   "",    false, false },
  { "Tirahi",                                                     "tra",     "",   "",    false, false },
  { "Tiranige Diga Dogon",                                        "tde",     "",   "",    false, false },
  { "Tiri",                                                       "cir",     "",   "",    false, false },
  { "Tirmaga-Chai Suri",                                          "suq",     "",   "",    false, false },
  { "Tiruray",                                                    "tiy",     "",   "",    false, false },
  { "Tita",                                                       "tdq",     "",   "",    false, false },
  { "Titan",                                                      "ttv",     "",   "",    false, false },
  { "Tiv",                                                        "tiv",     "",   "",    true,  false },
  { "Tiwa",                                                       "lax",     "",   "",    false, false },
  { "Tiwi",                                                       "tiw",     "",   "",    false, false },
  { "Tiyaa",                                                      "tyy",     "",   "",    false, false },
  { "Tiéfo",                                                      "tiq",     "",   "",    false, false },
  { "Tiéyaxo Bozo",                                               "boz",     "",   "",    false, false },
  { "Tjungundji",                                                 "tjj",     "",   "",    false, false },
  { "Tjupany",                                                    "tjp",     "",   "",    false, false },
  { "Tjurruru",                                                   "tju",     "",   "",    false, false },
  { "Tlachichilco Tepehua",                                       "tpt",     "",   "",    false, false },
  { "Tlacoapa Me'phaa",                                           "tpl",     "",   "",    false, false },
  { "Tlacoatzintepec Chinantec",                                  "ctl",     "",   "",    false, false },
  { "Tlacolulita Zapotec",                                        "zpk",     "",   "",    false, false },
  { "Tlahuitoltepec Mixe",                                        "mxp",     "",   "",    false, false },
  { "Tlamacazapa Nahuatl",                                        "nuz",     "",   "",    false, false },
  { "Tlazoyaltepec Mixtec",                                       "mqh",     "",   "",    false, false },
  { "Tlicho",                                                     "dgr",     "",   "",    true,  false },
  { "Tlingit",                                                    "tli",     "",   "",    true,  false },
  { "To",                                                         "toz",     "",   "",    false, false },
  { "To'abaita",                                                  "mlu",     "",   "",    false, false },
  { "Toaripi",                                                    "tqo",     "",   "",    false, false },
  { "Toba",                                                       "tob",     "",   "",    false, false },
  { "Toba-Maskoy",                                                "tmf",     "",   "",    false, false },
  { "Tobagonian Creole English",                                  "tgh",     "",   "",    false, false },
  { "Tobanga",                                                    "tng",     "",   "",    false, false },
  { "Tobati",                                                     "tti",     "",   "",    false, false },
  { "Tobelo",                                                     "tlb",     "",   "",    false, false },
  { "Tobian",                                                     "tox",     "",   "",    false, false },
  { "Tobilung",                                                   "tgb",     "",   "",    false, false },
  { "Tobo",                                                       "tbv",     "",   "",    false, false },
  { "Tocantins Asurini",                                          "asu",     "",   "",    false, false },
  { "Tocho",                                                      "taz",     "",   "",    false, false },
  { "Toda",                                                       "tcx",     "",   "",    false, false },
  { "Todrah",                                                     "tdr",     "",   "",    false, false },
  { "Tofanma",                                                    "tlg",     "",   "",    false, false },
  { "Tofin Gbe",                                                  "tfi",     "",   "",    false, false },
  { "Togbo-Vara Banda",                                           "tor",     "",   "",    false, false },
  { "Togoyo",                                                     "tgy",     "",   "",    false, false },
  { "Tohono O'odham",                                             "ood",     "",   "",    false, false },
  { "Tojolabal",                                                  "toj",     "",   "",    false, false },
  { "Tok Pisin",                                                  "tpi",     "",   "",    true,  false },
  { "Tokano",                                                     "zuh",     "",   "",    false, false },
  { "Tokelau",                                                    "tkl",     "",   "",    true,  false },
  { "Tokharian A",                                                "xto",     "",   "",    false, false },
  { "Tokharian B",                                                "txb",     "",   "",    false, false },
  { "Toki Pona",                                                  "tok",     "",   "",    false, false },
  { "Toku-No-Shima",                                              "tkn",     "",   "",    false, false },
  { "Tol",                                                        "jic",     "",   "",    false, false },
  { "Tolaki",                                                     "lbw",     "",   "",    false, false },
  { "Tolomako",                                                   "tlm",     "",   "",    false, false },
  { "Tolowa",                                                     "tol",     "",   "",    false, false },
  { "Toma",                                                       "tod",     "",   "",    false, false },
  { "Tomadino",                                                   "tdi",     "",   "",    false, false },
  { "Tombelala",                                                  "ttp",     "",   "",    false, false },
  { "Tombonuo",                                                   "txa",     "",   "",    false, false },
  { "Tombulu",                                                    "tom",     "",   "",    false, false },
  { "Tomedes",                                                    "toe",     "",   "",    false, true  },
  { "Tomini",                                                     "txm",     "",   "",    false, false },
  { "Tommo So Dogon",                                             "dto",     "",   "",    false, false },
  { "Tomo Kan Dogon",                                             "dtm",     "",   "",    false, false },
  { "Tomoip",                                                     "tqp",     "",   "",    false, false },
  { "Tondano",                                                    "tdn",     "",   "",    false, false },
  { "Tondi Songway Kiini",                                        "tst",     "",   "",    false, false },
  { "Tonga (Nyasa)",                                              "tog",     "",   "",    true,  false },
  { "Tonga (Tonga Islands)",                                      "ton",     "to", "",    true,  false },
  { "Tonga (Zambia)",                                             "toi",     "",   "",    false, false },
  { "Tongwe",                                                     "tny",     "",   "",    false, false },
  { "Tonjon",                                                     "tjn",     "",   "",    false, false },
  { "Tonkawa",                                                    "tqw",     "",   "",    false, false },
  { "Tonsawang",                                                  "tnw",     "",   "",    false, false },
  { "Tonsea",                                                     "txs",     "",   "",    false, false },
  { "Tontemboan",                                                 "tnt",     "",   "",    false, false },
  { "Tooro",                                                      "ttj",     "",   "",    false, false },
  { "Topoiyo",                                                    "toy",     "",   "",    false, false },
  { "Toposa",                                                     "toq",     "",   "",    false, false },
  { "Toraja-Sa'dan",                                              "sda",     "",   "",    false, false },
  { "Toram",                                                      "trj",     "",   "",    false, false },
  { "Torau",                                                      "ttu",     "",   "",    false, false },
  { "Tornedalen Finnish",                                         "fit",     "",   "",    false, false },
  { "Toro So Dogon",                                              "dts",     "",   "",    false, false },
  { "Toro Tegu Dogon",                                            "dtt",     "",   "",    false, false },
  { "Toro",                                                       "tdv",     "",   "",    false, false },
  { "Toromono",                                                   "tno",     "",   "",    false, false },
  { "Torona",                                                     "tqr",     "",   "",    false, false },
  { "Torres Strait Creole",                                       "tcs",     "",   "",    false, false },
  { "Torricelli",                                                 "tei",     "",   "",    false, false },
  { "Torwali",                                                    "trw",     "",   "",    false, false },
  { "Torá",                                                       "trz",     "",   "",    false, false },
  { "Tosk Albanian",                                              "als",     "",   "",    false, false },
  { "Totela",                                                     "ttl",     "",   "",    false, false },
  { "Toto",                                                       "txo",     "",   "",    false, false },
  { "Totoli",                                                     "txe",     "",   "",    false, false },
  { "Totomachapan Zapotec",                                       "zph",     "",   "",    false, false },
  { "Totontepec Mixe",                                            "mto",     "",   "",    false, false },
  { "Totoro",                                                     "ttk",     "",   "",    false, false },
  { "Touo",                                                       "tqu",     "",   "",    false, false },
  { "Toura (Côte d'Ivoire)",                                      "neb",     "",   "",    false, false },
  { "Toura (Papua New Guinea)",                                   "don",     "",   "",    false, false },
  { "Towei",                                                      "ttn",     "",   "",    false, false },
  { "Trans-New Guinea languages",                                 "ngf",     "",   "",    false, false },
  { "Transalpine Gaulish",                                        "xtg",     "",   "",    false, false },
  { "Traveller Danish",                                           "rmd",     "",   "",    false, false },
  { "Traveller Norwegian",                                        "rmg",     "",   "",    false, false },
  { "Traveller Scottish",                                         "trl",     "",   "",    false, false },
  { "Tregami",                                                    "trm",     "",   "",    false, false },
  { "Tremembé",                                                   "tme",     "",   "",    false, false },
  { "Trieng",                                                     "stg",     "",   "",    false, false },
  { "Trimuris",                                                   "tip",     "",   "",    false, false },
  { "Tring",                                                      "tgq",     "",   "",    false, false },
  { "Tringgus-Sembaan Bidayuh",                                   "trx",     "",   "",    false, false },
  { "Trinidad and Tobago Sign Language",                          "lst",     "",   "",    false, false },
  { "Trinidadian Creole English",                                 "trf",     "",   "",    false, false },
  { "Trinitario",                                                 "trn",     "",   "",    false, false },
  { "Trió",                                                       "tri",     "",   "",    false, false },
  { "Truká",                                                      "tka",     "",   "",    false, false },
  { "Trumai",                                                     "tpy",     "",   "",    false, false },
  { "Ts'ün-Lao",                                                  "tsl",     "",   "",    false, false },
  { "Tsaangi",                                                    "tsa",     "",   "",    false, false },
  { "Tsakhur",                                                    "tkr",     "",   "",    false, false },
  { "Tsakonian",                                                  "tsd",     "",   "",    false, false },
  { "Tsakwambo",                                                  "kvz",     "",   "",    false, false },
  { "Tsamai",                                                     "tsb",     "",   "",    false, false },
  { "Tsat",                                                       "huq",     "",   "",    false, false },
  { "Tseku",                                                      "tsk",     "",   "",    false, false },
  { "Tsetsaut",                                                   "txc",     "",   "",    false, false },
  { "Tshangla",                                                   "tsj",     "",   "",    false, false },
  { "Tsikimba",                                                   "kdl",     "",   "",    false, false },
  { "Tsimané",                                                    "cas",     "",   "",    false, false },
  { "Tsimihety Malagasy",                                         "xmw",     "",   "",    false, false },
  { "Tsimshian",                                                  "tsi",     "",   "",    true,  false },
  { "Tsishingini",                                                "tsw",     "",   "",    false, false },
  { "Tso",                                                        "ldp",     "",   "",    false, false },
  { "Tsoa",                                                       "hio",     "",   "",    false, false },
  { "Tsogo",                                                      "tsv",     "",   "",    false, false },
  { "Tsonga",                                                     "tso",     "ts", "",    true,  false },
  { "Tsotso",                                                     "lto",     "",   "",    false, false },
  { "Tsou",                                                       "tsu",     "",   "",    false, false },
  { "Tsucuba",                                                    "cbq",     "",   "",    false, false },
  { "Tsum",                                                       "ttz",     "",   "",    false, false },
  { "Tsuvadi",                                                    "tvd",     "",   "",    false, false },
  { "Tsuvan",                                                     "tsh",     "",   "",    false, false },
  { "Tswa",                                                       "tsc",     "",   "",    false, false },
  { "Tswana",                                                     "tsn",     "tn", "",    true,  false },
  { "Tswapong",                                                   "two",     "",   "",    false, false },
  { "Tu",                                                         "mjg",     "",   "",    false, false },
  { "Tuamotuan",                                                  "pmt",     "",   "",    false, false },
  { "Tubar",                                                      "tbu",     "",   "",    false, false },
  { "Tucano",                                                     "tuo",     "",   "",    false, false },
  { "Tugen",                                                      "tuy",     "",   "",    false, false },
  { "Tugun",                                                      "tzn",     "",   "",    false, false },
  { "Tugutil",                                                    "tuj",     "",   "",    false, false },
  { "Tukang Besi North",                                          "khc",     "",   "",    false, false },
  { "Tukang Besi South",                                          "bhq",     "",   "",    false, false },
  { "Tuki",                                                       "bag",     "",   "",    false, false },
  { "Tukpa",                                                      "tpq",     "",   "",    false, false },
  { "Tukudede",                                                   "tkd",     "",   "",    false, false },
  { "Tukumanféd",                                                 "tkf",     "",   "",    false, false },
  { "Tula",                                                       "tul",     "",   "",    false, false },
  { "Tulai",                                                      "tvi",     "",   "",    false, false },
  { "Tulehu",                                                     "tlu",     "",   "",    false, false },
  { "Tulishi",                                                    "tey",     "",   "",    false, false },
  { "Tulu",                                                       "tcy",     "",   "",    false, false },
  { "Tulu-Bohuai",                                                "rak",     "",   "",    false, false },
  { "Tuma-Irumu",                                                 "iou",     "",   "",    false, false },
  { "Tumak",                                                      "tmc",     "",   "",    false, false },
  { "Tumari Kanuri",                                              "krt",     "",   "",    false, false },
  { "Tumbuka",                                                    "tum",     "",   "",    true,  false },
  { "Tumi",                                                       "kku",     "",   "",    false, false },
  { "Tumleo",                                                     "tmq",     "",   "",    false, false },
  { "Tumshuqese",                                                 "xtq",     "",   "",    false, false },
  { "Tumtum",                                                     "tbr",     "",   "",    false, false },
  { "Tumulung Sisaala",                                           "sil",     "",   "",    false, false },
  { "Tumzabt",                                                    "mzb",     "",   "",    false, false },
  { "Tundra Enets",                                               "enh",     "",   "",    false, false },
  { "Tunen",                                                      "baz",     "",   "",    false, true  },
  { "Tunen",                                                      "tvu",     "",   "",    false, false },
  { "Tungag",                                                     "lcm",     "",   "",    false, false },
  { "Tunggare",                                                   "trt",     "",   "",    false, false },
  { "Tungus languages",                                           "tuw",     "",   "",    false, false },
  { "Tunia",                                                      "tug",     "",   "",    false, false },
  { "Tunica",                                                     "tun",     "",   "",    false, false },
  { "Tunisian Arabic",                                            "aeb",     "",   "",    false, false },
  { "Tunisian Sign Language",                                     "tse",     "",   "",    false, false },
  { "Tunjung",                                                    "tjg",     "",   "",    false, false },
  { "Tunni",                                                      "tqq",     "",   "",    false, false },
  { "Tunzu",                                                      "dza",     "",   "",    false, false },
  { "Tuotomb",                                                    "ttf",     "",   "",    false, false },
  { "Tuparí",                                                     "tpr",     "",   "",    false, false },
  { "Tupi languages",                                             "tup",     "",   "",    true,  false },
  { "Tupinambá",                                                  "tpn",     "",   "",    false, false },
  { "Tupinikin",                                                  "tpk",     "",   "",    false, false },
  { "Tupuri",                                                     "tui",     "",   "",    false, false },
  { "Tupí",                                                       "tpw",     "",   "",    false, true  },
  { "Turaka",                                                     "trh",     "",   "",    false, false },
  { "Turi",                                                       "trd",     "",   "",    false, false },
  { "Turiwára",                                                   "twt",     "",   "",    false, false },
  { "Turka",                                                      "tuz",     "",   "",    false, false },
  { "Turkana",                                                    "tuv",     "",   "",    false, false },
  { "Turkic languages",                                           "trk",     "",   "",    false, false },
  { "Turkish Sign Language",                                      "tsm",     "",   "",    false, false },
  { "Turkish",                                                    "tur",     "tr", "",    true,  false },
  { "Turkmen",                                                    "tuk",     "tk", "",    true,  false },
  { "Turks And Caicos Creole English",                            "tch",     "",   "",    false, false },
  { "Turoyo",                                                     "tru",     "",   "",    false, false },
  { "Turumsa",                                                    "tqm",     "",   "",    false, false },
  { "Turung",                                                     "try",     "",   "",    false, false },
  { "Tuscarora",                                                  "tus",     "",   "",    false, false },
  { "Tutelo",                                                     "tta",     "",   "",    false, false },
  { "Tutong",                                                     "ttg",     "",   "",    false, false },
  { "Tutsa Naga",                                                 "tvt",     "",   "",    false, false },
  { "Tutuba",                                                     "tmi",     "",   "",    false, false },
  { "Tututepec Mixtec",                                           "mtu",     "",   "",    false, false },
  { "Tututni",                                                    "tuu",     "",   "",    false, false },
  { "Tuvalu",                                                     "tvl",     "",   "",    true,  false },
  { "Tuvinian",                                                   "tyv",     "",   "",    true,  false },
  { "Tuwali Ifugao",                                              "ifk",     "",   "",    false, false },
  { "Tuwari",                                                     "tww",     "",   "",    false, false },
  { "Tuwuli",                                                     "bov",     "",   "",    false, false },
  { "Tuxináwa",                                                   "tux",     "",   "",    false, false },
  { "Tuxá",                                                       "tud",     "",   "",    false, false },
  { "Tuyuca",                                                     "tue",     "",   "",    false, false },
  { "Twana",                                                      "twa",     "",   "",    false, false },
  { "Twendi",                                                     "twn",     "",   "",    false, false },
  { "Twents",                                                     "twd",     "",   "",    false, false },
  { "Twi",                                                        "twi",     "tw", "",    true,  false },
  { "Tyap",                                                       "kcg",     "",   "",    false, false },
  { "Tz'utujil",                                                  "tzj",     "",   "",    false, false },
  { "Tzeltal",                                                    "tzh",     "",   "",    false, false },
  { "Tzotzil",                                                    "tzo",     "",   "",    false, false },
  { "Tày Sa Pa",                                                  "tys",     "",   "",    false, false },
  { "Tày Tac",                                                    "tyt",     "",   "",    false, false },
  { "Tày",                                                        "tyz",     "",   "",    false, false },
  { "Téén",                                                       "lor",     "",   "",    false, false },
  { "Tübatulabal",                                                "tub",     "",   "",    false, false },
  { "U",                                                          "uuu",     "",   "",    false, false },
  { "Uab Meto",                                                   "aoz",     "",   "",    false, false },
  { "Uamué",                                                      "uam",     "",   "",    false, false },
  { "Uare",                                                       "ksj",     "",   "",    false, false },
  { "Ubaghara",                                                   "byc",     "",   "",    false, false },
  { "Ubang",                                                      "uba",     "",   "",    false, false },
  { "Ubi",                                                        "ubi",     "",   "",    false, false },
  { "Ubir",                                                       "ubr",     "",   "",    false, false },
  { "Ubykh",                                                      "uby",     "",   "",    false, false },
  { "Ucayali-Yurúa Ashéninka",                                    "cpb",     "",   "",    false, false },
  { "Uda",                                                        "uda",     "",   "",    false, false },
  { "Udi",                                                        "udi",     "",   "",    false, false },
  { "Udihe",                                                      "ude",     "",   "",    false, false },
  { "Udmurt",                                                     "udm",     "",   "",    true,  false },
  { "Uduk",                                                       "udu",     "",   "",    false, false },
  { "Ufim",                                                       "ufi",     "",   "",    false, false },
  { "Ugandan Sign Language",                                      "ugn",     "",   "",    false, false },
  { "Ugaritic",                                                   "uga",     "",   "",    true,  false },
  { "Ughele",                                                     "uge",     "",   "",    false, false },
  { "Ugong",                                                      "ugo",     "",   "",    false, false },
  { "Uhami",                                                      "uha",     "",   "",    false, false },
  { "Uighur",                                                     "uig",     "ug", "",    true,  false },
  { "Uisai",                                                      "uis",     "",   "",    false, false },
  { "Ujir",                                                       "udj",     "",   "",    false, false },
  { "Ukaan",                                                      "kcf",     "",   "",    false, false },
  { "Ukhwejo",                                                    "ukh",     "",   "",    false, false },
  { "Ukit",                                                       "umi",     "",   "",    false, false },
  { "Ukpe-Bayobiri",                                              "ukp",     "",   "",    false, false },
  { "Ukpet-Ehom",                                                 "akd",     "",   "",    false, false },
  { "Ukrainian Sign Language",                                    "ukl",     "",   "",    false, false },
  { "Ukrainian",                                                  "ukr",     "uk", "",    true,  false },
  { "Ukue",                                                       "uku",     "",   "",    false, false },
  { "Ukuriguma",                                                  "ukg",     "",   "",    false, false },
  { "Ukwa",                                                       "ukq",     "",   "",    false, false },
  { "Ukwuani-Aboh-Ndoni",                                         "ukw",     "",   "",    false, false },
  { "Ulau-Suain",                                                 "svb",     "",   "",    false, false },
  { "Ulch",                                                       "ulc",     "",   "",    false, false },
  { "Ulithian",                                                   "uli",     "",   "",    false, false },
  { "Ullatan",                                                    "ull",     "",   "",    false, false },
  { "Ulukwumi",                                                   "ulb",     "",   "",    false, false },
  { "Ulumanda'",                                                  "ulm",     "",   "",    false, false },
  { "Ulwa",                                                       "ulw",     "",   "",    false, false },
  { "Uma",                                                        "ppk",     "",   "",    false, false },
  { "Uma' Lasan",                                                 "xky",     "",   "",    false, false },
  { "Uma' Lung",                                                  "ulu",     "",   "",    false, false },
  { "Umanakaina",                                                 "gdn",     "",   "",    false, false },
  { "Umatilla",                                                   "uma",     "",   "",    false, false },
  { "Umbindhamu",                                                 "umd",     "",   "",    false, false },
  { "Umbrian",                                                    "xum",     "",   "",    false, false },
  { "Umbu-Ungu",                                                  "ubu",     "",   "",    false, false },
  { "Umbugarla",                                                  "umr",     "",   "",    false, false },
  { "Umbundu",                                                    "umb",     "",   "",    true,  false },
  { "Ume Sami",                                                   "sju",     "",   "",    false, false },
  { "Umeda",                                                      "upi",     "",   "",    false, false },
  { "Umiida",                                                     "xud",     "",   "",    false, false },
  { "Umiray Dumaget Agta",                                        "due",     "",   "",    false, false },
  { "Umon",                                                       "umm",     "",   "",    false, false },
  { "Umotína",                                                    "umo",     "",   "",    false, false },
  { "Umpila",                                                     "ump",     "",   "",    false, false },
  { "Una",                                                        "mtg",     "",   "",    false, false },
  { "Unami",                                                      "unm",     "",   "",    false, false },
  { "Uncoded languages",                                          "mis",     "",   "",    true,  false },
  { "Unde Kaili",                                                 "unz",     "",   "",    false, false },
  { "Undetermined",                                               "und",     "",   "",    true,  false },
  { "Uneapa",                                                     "bbn",     "",   "",    false, false },
  { "Uneme",                                                      "une",     "",   "",    false, false },
  { "Unggaranggu",                                                "xun",     "",   "",    false, false },
  { "Unggumi",                                                    "xgu",     "",   "",    false, false },
  { "Uni",                                                        "uni",     "",   "",    false, false },
  { "Unserdeutsch",                                               "uln",     "",   "",    false, false },
  { "Unua",                                                       "onu",     "",   "",    false, false },
  { "Unubahe",                                                    "unu",     "",   "",    false, false },
  { "Uokha",                                                      "uok",     "",   "",    false, true  },
  { "Upper Chehalis",                                             "cjh",     "",   "",    false, false },
  { "Upper Grand Valley Dani",                                    "dna",     "",   "",    false, false },
  { "Upper Guinea Crioulo",                                       "pov",     "",   "",    false, false },
  { "Upper Kinabatangan",                                         "dmg",     "",   "",    false, false },
  { "Upper Kuskokwim",                                            "kuu",     "",   "",    false, false },
  { "Upper Necaxa Totonac",                                       "tku",     "",   "",    false, false },
  { "Upper Saxon",                                                "sxu",     "",   "",    false, false },
  { "Upper Sorbian",                                              "hsb",     "",   "",    true,  false },
  { "Upper Ta'oih",                                               "tth",     "",   "",    false, false },
  { "Upper Tanana",                                               "tau",     "",   "",    false, false },
  { "Upper Tanudan Kalinga",                                      "kgh",     "",   "",    false, true  },
  { "Upper Taromi",                                               "tov",     "",   "",    false, false },
  { "Upper Umpqua",                                               "xup",     "",   "",    false, false },
  { "Ura (Papua New Guinea)",                                     "uro",     "",   "",    false, false },
  { "Ura (Vanuatu)",                                              "uur",     "",   "",    false, false },
  { "Uradhi",                                                     "urf",     "",   "",    false, false },
  { "Urak Lawoi'",                                                "urk",     "",   "",    false, false },
  { "Urali",                                                      "url",     "",   "",    false, false },
  { "Uralic languages",                                           "urj",     "",   "",    false, false },
  { "Urapmin",                                                    "urm",     "",   "",    false, false },
  { "Urarina",                                                    "ura",     "",   "",    false, false },
  { "Urartian",                                                   "xur",     "",   "",    false, false },
  { "Urat",                                                       "urt",     "",   "",    false, false },
  { "Urdu",                                                       "urd",     "ur", "",    true,  false },
  { "Urhobo",                                                     "urh",     "",   "",    false, false },
  { "Uri",                                                        "uvh",     "",   "",    false, false },
  { "Urigina",                                                    "urg",     "",   "",    false, false },
  { "Urim",                                                       "uri",     "",   "",    false, false },
  { "Urimo",                                                      "urx",     "",   "",    false, false },
  { "Uripiv-Wala-Rano-Atchin",                                    "upv",     "",   "",    false, false },
  { "Urningangg",                                                 "urc",     "",   "",    false, false },
  { "Uru",                                                        "ure",     "",   "",    false, false },
  { "Uru-Eu-Wau-Wau",                                             "urz",     "",   "",    false, false },
  { "Uru-Pa-In",                                                  "urp",     "",   "",    false, false },
  { "Uruangnirin",                                                "urn",     "",   "",    false, false },
  { "Uruava",                                                     "urv",     "",   "",    false, false },
  { "Urubú-Kaapor Sign Language",                                 "uks",     "",   "",    false, false },
  { "Urubú-Kaapor",                                               "urb",     "",   "",    false, false },
  { "Uruguayan Sign Language",                                    "ugy",     "",   "",    false, false },
  { "Urum",                                                       "uum",     "",   "",    false, false },
  { "Urumi",                                                      "uru",     "",   "",    false, false },
  { "Usaghade",                                                   "usk",     "",   "",    false, false },
  { "Usan",                                                       "wnu",     "",   "",    false, false },
  { "Usarufa",                                                    "usa",     "",   "",    false, false },
  { "Ushojo",                                                     "ush",     "",   "",    false, false },
  { "Usila Chinantec",                                            "cuc",     "",   "",    false, false },
  { "Usku",                                                       "ulf",     "",   "",    false, false },
  { "Uspanteco",                                                  "usp",     "",   "",    false, false },
  { "Usui",                                                       "usi",     "",   "",    false, false },
  { "Utarmbung",                                                  "omo",     "",   "",    false, false },
  { "Ute-Southern Paiute",                                        "ute",     "",   "",    false, false },
  { "Uto-Aztecan languages",                                      "azc",     "",   "",    false, false },
  { "Utu",                                                        "utu",     "",   "",    false, false },
  { "Uvbie",                                                      "evh",     "",   "",    false, false },
  { "Uya",                                                        "usu",     "",   "",    false, false },
  { "Uyajitaya",                                                  "duk",     "",   "",    false, false },
  { "Uzbek",                                                      "uzb",     "uz", "",    true,  false },
  { "Uzbeki Arabic",                                              "auz",     "",   "",    false, false },
  { "Uzekwe",                                                     "eze",     "",   "",    false, false },
  { "Vaagri Booli",                                               "vaa",     "",   "",    false, false },
  { "Vafsi",                                                      "vaf",     "",   "",    false, false },
  { "Vaghat-Ya-Bijim-Legeri",                                     "bij",     "",   "",    false, true  },
  { "Vaghri",                                                     "vgr",     "",   "",    false, false },
  { "Vaghua",                                                     "tva",     "",   "",    false, false },
  { "Vagla",                                                      "vag",     "",   "",    false, false },
  { "Vai",                                                        "vai",     "",   "",    true,  false },
  { "Vaiphei",                                                    "vap",     "",   "",    false, false },
  { "Vale",                                                       "vae",     "",   "",    false, false },
  { "Valencian Sign Language",                                    "vsv",     "",   "",    false, false },
  { "Valle Nacional Chinantec",                                   "cvn",     "",   "",    false, false },
  { "Valley Maidu",                                               "vmv",     "",   "",    false, false },
  { "Valman",                                                     "van",     "",   "",    false, false },
  { "Valpei",                                                     "vlp",     "",   "",    false, false },
  { "Vamale",                                                     "mkt",     "",   "",    false, false },
  { "Vame",                                                       "mlr",     "",   "",    false, false },
  { "Vandalic",                                                   "xvn",     "",   "",    false, false },
  { "Vangunu",                                                    "mpr",     "",   "",    false, false },
  { "Vanimo",                                                     "vam",     "",   "",    false, false },
  { "Vano",                                                       "vnk",     "",   "",    false, false },
  { "Vanuma",                                                     "vau",     "",   "",    false, false },
  { "Vao",                                                        "vao",     "",   "",    false, false },
  { "Varhadi-Nagpuri",                                            "vah",     "",   "",    false, false },
  { "Varisi",                                                     "vrs",     "",   "",    false, false },
  { "Varli",                                                      "vav",     "",   "",    false, false },
  { "Vasavi",                                                     "vas",     "",   "",    false, false },
  { "Veddah",                                                     "ved",     "",   "",    false, false },
  { "Vedic Sanskrit",                                             "vsn",     "",   "",    false, false },
  { "Vehes",                                                      "val",     "",   "",    false, false },
  { "Veluws",                                                     "vel",     "",   "",    false, false },
  { "Vemgo-Mabas",                                                "vem",     "",   "",    false, false },
  { "Venda",                                                      "ven",     "ve", "",    true,  false },
  { "Venetian",                                                   "vec",     "",   "",    false, false },
  { "Venetic",                                                    "xve",     "",   "",    false, false },
  { "Venezuelan Sign Language",                                   "vsl",     "",   "",    false, false },
  { "Vengo",                                                      "bav",     "",   "",    false, false },
  { "Ventureño",                                                  "veo",     "",   "",    false, false },
  { "Veps",                                                       "vep",     "",   "",    false, false },
  { "Vera'a",                                                     "vra",     "",   "",    false, false },
  { "Vestinian",                                                  "xvs",     "",   "",    false, false },
  { "Vidunda",                                                    "vid",     "",   "",    false, false },
  { "Viemo",                                                      "vig",     "",   "",    false, false },
  { "Vietnamese",                                                 "vie",     "vi", "",    true,  false },
  { "Vilela",                                                     "vil",     "",   "",    false, false },
  { "Vili",                                                       "vif",     "",   "",    false, false },
  { "Villa Viciosa Agta",                                         "dyg",     "",   "",    false, false },
  { "Vincentian Creole English",                                  "svc",     "",   "",    false, false },
  { "Vinmavis",                                                   "vnm",     "",   "",    false, false },
  { "Vinza",                                                      "vin",     "",   "",    false, false },
  { "Virgin Islands Creole English",                              "vic",     "",   "",    false, false },
  { "Vishavan",                                                   "vis",     "",   "",    false, false },
  { "Viti",                                                       "vit",     "",   "",    false, false },
  { "Vitou",                                                      "vto",     "",   "",    false, false },
  { "Vitu",                                                       "wiv",     "",   "",    false, false },
  { "Vlaams",                                                     "vls",     "",   "",    false, false },
  { "Vlaamse Gebarentaal",                                        "vgt",     "",   "",    false, false },
  { "Vlax Romani",                                                "rmy",     "",   "",    false, false },
  { "Volapük",                                                    "vol",     "vo", "",    true,  false },
  { "Volscian",                                                   "xvo",     "",   "",    false, false },
  { "Vono",                                                       "kch",     "",   "",    false, false },
  { "Voro",                                                       "vor",     "",   "",    false, false },
  { "Votic",                                                      "vot",     "",   "",    true,  false },
  { "Vumbu",                                                      "vum",     "",   "",    false, false },
  { "Vunapu",                                                     "vnp",     "",   "",    false, false },
  { "Vunjo",                                                      "vun",     "",   "",    false, false },
  { "Vurës",                                                      "msn",     "",   "",    false, false },
  { "Vute",                                                       "vut",     "",   "",    false, false },
  { "Vwanji",                                                     "wbi",     "",   "",    false, false },
  { "Võro",                                                       "vro",     "",   "",    false, false },
  { "Wa",                                                         "wbm",     "",   "",    false, false },
  { "Wa'ema",                                                     "wag",     "",   "",    false, false },
  { "Waama",                                                      "wwa",     "",   "",    false, false },
  { "Waamwang",                                                   "wmn",     "",   "",    false, false },
  { "Waata",                                                      "ssn",     "",   "",    false, false },
  { "Wab",                                                        "wab",     "",   "",    false, false },
  { "Wabo",                                                       "wbb",     "",   "",    false, false },
  { "Waboda",                                                     "kmx",     "",   "",    false, false },
  { "Waci Gbe",                                                   "wci",     "",   "",    false, false },
  { "Wadaginam",                                                  "wdg",     "",   "",    false, false },
  { "Waddar",                                                     "wbq",     "",   "",    false, false },
  { "Wadi Wadi",                                                  "xwd",     "",   "",    false, false },
  { "Wadikali",                                                   "wdk",     "",   "",    false, false },
  { "Wadiyara Koli",                                              "kxp",     "",   "",    false, false },
  { "Wadjabangayi",                                               "wdy",     "",   "",    false, false },
  { "Wadjiginy",                                                  "wdj",     "",   "",    false, false },
  { "Wadjigu",                                                    "wdu",     "",   "",    false, false },
  { "Wae Rana",                                                   "wrx",     "",   "",    false, false },
  { "Waffa",                                                      "waj",     "",   "",    false, false },
  { "Wagawaga",                                                   "wgb",     "",   "",    false, false },
  { "Wagawaga",                                                   "wgw",     "",   "",    false, true  },
  { "Wagaya",                                                     "wga",     "",   "",    false, false },
  { "Wagdi",                                                      "wbr",     "",   "",    false, false },
  { "Wagi",                                                       "fad",     "",   "",    false, false },
  { "Wagiman",                                                    "waq",     "",   "",    false, false },
  { "Wahau Kayan",                                                "whu",     "",   "",    false, false },
  { "Wahau Kenyah",                                               "whk",     "",   "",    false, false },
  { "Wahgi",                                                      "wgi",     "",   "",    false, false },
  { "Waigali",                                                    "wbk",     "",   "",    false, false },
  { "Waigeo",                                                     "wgo",     "",   "",    false, false },
  { "Wailaki",                                                    "wlk",     "",   "",    false, false },
  { "Wailapa",                                                    "wlr",     "",   "",    false, false },
  { "Waima",                                                      "rro",     "",   "",    false, false },
  { "Waima'a",                                                    "wmh",     "",   "",    false, false },
  { "Waimaha",                                                    "bao",     "",   "",    false, false },
  { "Waimiri-Atroari",                                            "atr",     "",   "",    false, false },
  { "Waioli",                                                     "wli",     "",   "",    false, false },
  { "Waiwai",                                                     "waw",     "",   "",    false, false },
  { "Waja",                                                       "wja",     "",   "",    false, false },
  { "Wajarri",                                                    "wbv",     "",   "",    false, false },
  { "Wajuk",                                                      "xwj",     "",   "",    false, false },
  { "Waka",                                                       "wav",     "",   "",    false, false },
  { "Wakabunga",                                                  "wwb",     "",   "",    false, false },
  { "Wakashan languages",                                         "wak",     "",   "",    true,  false },
  { "Wakawaka",                                                   "wkw",     "",   "",    false, false },
  { "Wakde",                                                      "wkd",     "",   "",    false, false },
  { "Wakhi",                                                      "wbl",     "",   "",    false, false },
  { "Wakoná",                                                     "waf",     "",   "",    false, false },
  { "Wala",                                                       "lgl",     "",   "",    false, false },
  { "Walak",                                                      "wlw",     "",   "",    false, false },
  { "Walangama",                                                  "nlw",     "",   "",    false, false },
  { "Wali (Ghana)",                                               "wlx",     "",   "",    false, false },
  { "Wali (Sudan)",                                               "wll",     "",   "",    false, false },
  { "Waling",                                                     "wly",     "",   "",    false, false },
  { "Walio",                                                      "wla",     "",   "",    false, false },
  { "Walla Walla",                                                "waa",     "",   "",    false, false },
  { "Wallisian",                                                  "wls",     "",   "",    false, false },
  { "Walloon",                                                    "wln",     "wa", "",    true,  false },
  { "Walmajarri",                                                 "wmt",     "",   "",    false, false },
  { "Walo Kumbe Dogon",                                           "dwl",     "",   "",    false, true  },
  { "Walser",                                                     "wae",     "",   "",    false, false },
  { "Walungge",                                                   "ola",     "",   "",    false, false },
  { "Waluwarra",                                                  "wrb",     "",   "",    false, false },
  { "Wamas",                                                      "wmc",     "",   "",    false, false },
  { "Wambaya",                                                    "wmb",     "",   "",    false, false },
  { "Wambon",                                                     "wms",     "",   "",    false, false },
  { "Wambule",                                                    "wme",     "",   "",    false, false },
  { "Wamesa",                                                     "wad",     "",   "",    false, false },
  { "Wamey",                                                      "cou",     "",   "",    false, false },
  { "Wamin",                                                      "wmi",     "",   "",    false, false },
  { "Wampanoag",                                                  "wam",     "",   "",    false, false },
  { "Wampar",                                                     "lbq",     "",   "",    false, false },
  { "Wampur",                                                     "waz",     "",   "",    false, false },
  { "Wan",                                                        "wan",     "",   "",    false, false },
  { "Wanap",                                                      "wnp",     "",   "",    false, false },
  { "Wancho Naga",                                                "nnp",     "",   "",    false, false },
  { "Wanda",                                                      "wbh",     "",   "",    false, false },
  { "Wandala",                                                    "mfi",     "",   "",    false, false },
  { "Wandarang",                                                  "wnd",     "",   "",    false, false },
  { "Wandji",                                                     "wdd",     "",   "",    false, false },
  { "Waneci",                                                     "wne",     "",   "",    false, false },
  { "Wanga",                                                      "lwg",     "",   "",    false, false },
  { "Wangaaybuwan-Ngiyambaa",                                     "wyb",     "",   "",    false, false },
  { "Wanggamala",                                                 "wnm",     "",   "",    false, false },
  { "Wanggom",                                                    "wng",     "",   "",    false, false },
  { "Wangkangurru",                                               "wgg",     "",   "",    false, false },
  { "Wangkayutyuru",                                              "wky",     "",   "",    false, false },
  { "Wangkumara",                                                 "xwk",     "",   "",    false, false },
  { "Wannu",                                                      "jub",     "",   "",    false, false },
  { "Wano",                                                       "wno",     "",   "",    false, false },
  { "Wantoat",                                                    "wnc",     "",   "",    false, false },
  { "Wanukaka",                                                   "wnk",     "",   "",    false, false },
  { "Wanyi",                                                      "wny",     "",   "",    false, false },
  { "Wané",                                                       "hwa",     "",   "",    false, false },
  { "Waorani",                                                    "auc",     "",   "",    false, false },
  { "Wapan",                                                      "juk",     "",   "",    false, false },
  { "Wapishana",                                                  "wap",     "",   "",    false, false },
  { "Wappo",                                                      "wao",     "",   "",    false, false },
  { "War-Jaintia",                                                "aml",     "",   "",    false, false },
  { "Wara",                                                       "wbf",     "",   "",    false, false },
  { "Warao",                                                      "wba",     "",   "",    false, false },
  { "Warapu",                                                     "wra",     "",   "",    false, true  },
  { "Waray (Australia)",                                          "wrz",     "",   "",    false, false },
  { "Waray (Philippines)",                                        "war",     "",   "",    true,  false },
  { "Wardaman",                                                   "wrr",     "",   "",    false, false },
  { "Wardandi",                                                   "wxw",     "",   "",    false, false },
  { "Warduji",                                                    "wrd",     "",   "",    false, true  },
  { "Warembori",                                                  "wsa",     "",   "",    false, false },
  { "Wares",                                                      "wai",     "",   "",    false, false },
  { "Waris",                                                      "wrs",     "",   "",    false, false },
  { "Waritai",                                                    "wbe",     "",   "",    false, false },
  { "Wariyangga",                                                 "wri",     "",   "",    false, false },
  { "Warji",                                                      "wji",     "",   "",    false, false },
  { "Warkay-Bipim",                                               "bgv",     "",   "",    false, false },
  { "Warlmanpa",                                                  "wrl",     "",   "",    false, false },
  { "Warlpiri",                                                   "wbp",     "",   "",    false, false },
  { "Warnang",                                                    "wrn",     "",   "",    false, false },
  { "Warnman",                                                    "wbt",     "",   "",    false, false },
  { "Waropen",                                                    "wrp",     "",   "",    false, false },
  { "Warrgamay",                                                  "wgy",     "",   "",    false, false },
  { "Warrwa",                                                     "wwr",     "",   "",    false, false },
  { "Waru",                                                       "wru",     "",   "",    false, false },
  { "Warumungu",                                                  "wrm",     "",   "",    false, false },
  { "Waruna",                                                     "wrv",     "",   "",    false, false },
  { "Warungu",                                                    "wrg",     "",   "",    false, false },
  { "Warwar Feni",                                                "hrw",     "",   "",    false, false },
  { "Wasa",                                                       "wss",     "",   "",    false, false },
  { "Wasco-Wishram",                                              "wac",     "",   "",    false, false },
  { "Wasembo",                                                    "gsp",     "",   "",    false, false },
  { "Washo",                                                      "was",     "",   "",    true,  false },
  { "Waskia",                                                     "wsk",     "",   "",    false, false },
  { "Wasu",                                                       "wsu",     "",   "",    false, false },
  { "Watakataui",                                                 "wtk",     "",   "",    false, false },
  { "Watam",                                                      "wax",     "",   "",    false, false },
  { "Wathawurrung",                                               "wth",     "",   "",    false, false },
  { "Watiwa",                                                     "wtf",     "",   "",    false, false },
  { "Watubela",                                                   "wah",     "",   "",    false, false },
  { "Waube",                                                      "kop",     "",   "",    false, false },
  { "Waurá",                                                      "wau",     "",   "",    false, false },
  { "Wauyai",                                                     "wuy",     "",   "",    false, false },
  { "Wawa",                                                       "www",     "",   "",    false, false },
  { "Wawonii",                                                    "wow",     "",   "",    false, false },
  { "Waxianghua",                                                 "wxa",     "",   "",    false, false },
  { "Wayampi",                                                    "oym",     "",   "",    false, false },
  { "Wayana",                                                     "way",     "",   "",    false, false },
  { "Wayanad Chetti",                                             "ctt",     "",   "",    false, false },
  { "Wayoró",                                                     "wyr",     "",   "",    false, false },
  { "Wayu",                                                       "vay",     "",   "",    false, false },
  { "Wayuu",                                                      "guc",     "",   "",    false, false },
  { "Wedau",                                                      "wed",     "",   "",    false, false },
  { "Weh",                                                        "weh",     "",   "",    false, false },
  { "Wejewa",                                                     "wew",     "",   "",    false, false },
  { "Welaun",                                                     "wlh",     "",   "",    false, false },
  { "Weliki",                                                     "klh",     "",   "",    false, false },
  { "Welsh Romani",                                               "rmw",     "",   "",    false, false },
  { "Welsh",                                                      "wel",     "cy", "cym", true,  false },
  { "Wemale",                                                     "weo",     "",   "",    false, false },
  { "Wemba Wemba",                                                "xww",     "",   "",    false, false },
  { "Weme Gbe",                                                   "wem",     "",   "",    false, false },
  { "Wendat",                                                     "wdt",     "",   "",    false, false },
  { "Wergaia",                                                    "weg",     "",   "",    false, false },
  { "Weri",                                                       "wer",     "",   "",    false, false },
  { "Wersing",                                                    "kvw",     "",   "",    false, false },
  { "West Albay Bikol",                                           "fbl",     "",   "",    false, false },
  { "West Ambae",                                                 "nnd",     "",   "",    false, false },
  { "West Bengal Sign Language",                                  "wbs",     "",   "",    false, false },
  { "West Berawan",                                               "zbw",     "",   "",    false, false },
  { "West Central Banda",                                         "bbp",     "",   "",    false, false },
  { "West Central Oromo",                                         "gaz",     "",   "",    false, false },
  { "West Coast Bajau",                                           "bdr",     "",   "",    false, false },
  { "West Damar",                                                 "drn",     "",   "",    false, false },
  { "West Germanic languages",                                    "gmw",     "",   "",    false, false },
  { "West Goodenough",                                            "ddi",     "",   "",    false, false },
  { "West Kewa",                                                  "kew",     "",   "",    false, false },
  { "West Lembata",                                               "lmj",     "",   "",    false, false },
  { "West Makian",                                                "mqs",     "",   "",    false, false },
  { "West Masela",                                                "mss",     "",   "",    false, false },
  { "West Slavic languages",                                      "zlw",     "",   "",    false, false },
  { "West Tarangan",                                              "txn",     "",   "",    false, false },
  { "West Uvean",                                                 "uve",     "",   "",    false, false },
  { "West Yugur",                                                 "ybe",     "",   "",    false, false },
  { "West-Central Limba",                                         "lia",     "",   "",    false, false },
  { "Western Abnaki",                                             "abe",     "",   "",    false, false },
  { "Western Apache",                                             "apw",     "",   "",    false, false },
  { "Western Armenian",                                           "hyw",     "",   "",    false, false },
  { "Western Arrarnta",                                           "are",     "",   "",    false, false },
  { "Western Balochi",                                            "bgn",     "",   "",    false, false },
  { "Western Bolivian Guaraní",                                   "gnw",     "",   "",    false, false },
  { "Western Bru",                                                "brv",     "",   "",    false, false },
  { "Western Bukidnon Manobo",                                    "mbb",     "",   "",    false, false },
  { "Western Cham",                                               "cja",     "",   "",    false, false },
  { "Western Dani",                                               "dnw",     "",   "",    false, false },
  { "Western Durango Nahuatl",                                    "azn",     "",   "",    false, false },
  { "Western Fijian",                                             "wyy",     "",   "",    false, false },
  { "Western Frisian",                                            "fry",     "fy", "",    true,  false },
  { "Western Highland Chatino",                                   "ctp",     "",   "",    false, false },
  { "Western Highland Purepecha",                                 "pua",     "",   "",    false, false },
  { "Western Huasteca Nahuatl",                                   "nhw",     "",   "",    false, false },
  { "Western Juxtlahuaca Mixtec",                                 "jmx",     "",   "",    false, false },
  { "Western Kanjobal",                                           "knj",     "",   "",    false, false },
  { "Western Karaboro",                                           "kza",     "",   "",    false, false },
  { "Western Katu",                                               "kuf",     "",   "",    false, false },
  { "Western Kayah",                                              "kyu",     "",   "",    false, false },
  { "Western Keres",                                              "kjq",     "",   "",    false, false },
  { "Western Krahn",                                              "krw",     "",   "",    false, false },
  { "Western Lalu",                                               "ywl",     "",   "",    false, false },
  { "Western Lawa",                                               "lcp",     "",   "",    false, false },
  { "Western Magar",                                              "mrd",     "",   "",    false, false },
  { "Western Malayo-Polynesian languages",                        "pqw",     "",   "",    false, false },
  { "Western Maninkakan",                                         "mlq",     "",   "",    false, false },
  { "Western Mari",                                               "mrj",     "",   "",    false, false },
  { "Western Mashan Hmong",                                       "hmw",     "",   "",    false, false },
  { "Western Meohang",                                            "raf",     "",   "",    false, false },
  { "Western Minyag",                                             "wmg",     "",   "",    false, false },
  { "Western Muria",                                              "mut",     "",   "",    false, false },
  { "Western Neo-Aramaic",                                        "amw",     "",   "",    false, false },
  { "Western Niger Fulfulde",                                     "fuh",     "",   "",    false, false },
  { "Western Ojibwa",                                             "ojw",     "",   "",    false, false },
  { "Western Panjabi",                                            "pnb",     "",   "",    false, false },
  { "Western Parbate Kham",                                       "kjl",     "",   "",    false, false },
  { "Western Penan",                                              "pne",     "",   "",    false, false },
  { "Western Sisaala",                                            "ssl",     "",   "",    false, false },
  { "Western Subanon",                                            "suc",     "",   "",    false, false },
  { "Western Tamang",                                             "tdg",     "",   "",    false, false },
  { "Western Tawbuid",                                            "twb",     "",   "",    false, false },
  { "Western Tlacolula Valley Zapotec",                           "zab",     "",   "",    false, false },
  { "Western Totonac",                                            "tqt",     "",   "",    false, false },
  { "Western Tunebo",                                             "tnb",     "",   "",    false, false },
  { "Western Xiangxi Miao",                                       "mmr",     "",   "",    false, false },
  { "Western Xwla Gbe",                                           "xwl",     "",   "",    false, false },
  { "Western Yiddish",                                            "yih",     "",   "",    false, false },
  { "Westphalien",                                                "wep",     "",   "",    false, false },
  { "Wetamut",                                                    "wwo",     "",   "",    false, false },
  { "Wewaw",                                                      "wea",     "",   "",    false, false },
  { "Weyto",                                                      "woy",     "",   "",    false, false },
  { "White Gelao",                                                "giw",     "",   "",    false, false },
  { "White Lachi",                                                "lwh",     "",   "",    false, false },
  { "Whitesands",                                                 "tnp",     "",   "",    false, false },
  { "Wiarumus",                                                   "tua",     "",   "",    false, false },
  { "Wichita",                                                    "wic",     "",   "",    false, false },
  { "Wichí Lhamtés Güisnay",                                      "mzh",     "",   "",    false, false },
  { "Wichí Lhamtés Nocten",                                       "mtp",     "",   "",    false, false },
  { "Wichí Lhamtés Vejoz",                                        "wlv",     "",   "",    false, false },
  { "Wik Ngathan",                                                "wig",     "",   "",    false, false },
  { "Wik-Epa",                                                    "wie",     "",   "",    false, false },
  { "Wik-Iiyanh",                                                 "wij",     "",   "",    false, false },
  { "Wik-Keyangan",                                               "wif",     "",   "",    false, false },
  { "Wik-Me'anha",                                                "wih",     "",   "",    false, false },
  { "Wik-Mungkan",                                                "wim",     "",   "",    false, false },
  { "Wikalkan",                                                   "wik",     "",   "",    false, false },
  { "Wikngenchera",                                               "wua",     "",   "",    false, false },
  { "Wilawila",                                                   "wil",     "",   "",    false, false },
  { "Wintu",                                                      "wit",     "",   "",    false, true  },
  { "Wintu",                                                      "wnw",     "",   "",    false, false },
  { "Winyé",                                                      "kst",     "",   "",    false, false },
  { "Wipi",                                                       "gdr",     "",   "",    false, false },
  { "Wiradjuri",                                                  "wrh",     "",   "",    false, false },
  { "Wiraféd",                                                    "wir",     "",   "",    false, false },
  { "Wirangu",                                                    "wgu",     "",   "",    false, false },
  { "Wirangu",                                                    "wiw",     "",   "",    false, true  },
  { "Wiru",                                                       "wiu",     "",   "",    false, false },
  { "Wiyot",                                                      "wiy",     "",   "",    false, false },
  { "Woccon",                                                     "xwc",     "",   "",    false, false },
  { "Wogamusin",                                                  "wog",     "",   "",    false, false },
  { "Wogeo",                                                      "woc",     "",   "",    false, false },
  { "Woi",                                                        "wbw",     "",   "",    false, false },
  { "Woiwurrung",                                                 "wyi",     "",   "",    false, false },
  { "Wojenaka",                                                   "jod",     "",   "",    false, false },
  { "Wolane",                                                     "wle",     "",   "",    false, false },
  { "Wolani",                                                     "wod",     "",   "",    false, false },
  { "Wolaytta",                                                   "wal",     "",   "",    true,  false },
  { "Woleaian",                                                   "woe",     "",   "",    false, false },
  { "Wolio",                                                      "wlo",     "",   "",    false, false },
  { "Wolof",                                                      "wol",     "wo", "",    true,  false },
  { "Wom (Nigeria)",                                              "wom",     "",   "",    false, false },
  { "Wom (Papua New Guinea)",                                     "wmo",     "",   "",    false, false },
  { "Womo",                                                       "wmx",     "",   "",    false, false },
  { "Wongo",                                                      "won",     "",   "",    false, false },
  { "Woods Cree",                                                 "cwd",     "",   "",    false, false },
  { "Woria",                                                      "wor",     "",   "",    false, false },
  { "Worimi",                                                     "kda",     "",   "",    false, false },
  { "Worodougou",                                                 "jud",     "",   "",    false, false },
  { "Worora",                                                     "unp",     "",   "",    false, true  },
  { "Worrorra",                                                   "wro",     "",   "",    false, false },
  { "Wotapuri-Katarqalai",                                        "wsv",     "",   "",    false, false },
  { "Wotjobaluk",                                                 "xwt",     "",   "",    false, false },
  { "Wotu",                                                       "wtw",     "",   "",    false, false },
  { "Woun Meu",                                                   "noa",     "",   "",    false, false },
  { "Written Oirat",                                              "xwo",     "",   "",    false, false },
  { "Wu Chinese",                                                 "wuu",     "",   "",    false, false },
  { "Wuding-Luquan Yi",                                           "ywq",     "",   "",    false, false },
  { "Wudu",                                                       "wud",     "",   "",    false, false },
  { "Wuliwuli",                                                   "wlu",     "",   "",    false, false },
  { "Wulna",                                                      "wux",     "",   "",    false, false },
  { "Wumboko",                                                    "bqm",     "",   "",    false, false },
  { "Wumbvu",                                                     "wum",     "",   "",    false, false },
  { "Wumeng Nasu",                                                "ywu",     "",   "",    false, false },
  { "Wunai Bunu",                                                 "bwn",     "",   "",    false, false },
  { "Wunambal",                                                   "wub",     "",   "",    false, false },
  { "Wunumara",                                                   "wnn",     "",   "",    false, false },
  { "Wurrugu",                                                    "wur",     "",   "",    false, false },
  { "Wusa Nasu",                                                  "yig",     "",   "",    false, false },
  { "Wushi",                                                      "bse",     "",   "",    false, false },
  { "Wusi",                                                       "wsi",     "",   "",    false, false },
  { "Wutung",                                                     "wut",     "",   "",    false, false },
  { "Wutunhua",                                                   "wuh",     "",   "",    false, false },
  { "Wuvulu-Aua",                                                 "wuv",     "",   "",    false, false },
  { "Wuzlam",                                                     "udl",     "",   "",    false, false },
  { "Wyandot",                                                    "wya",     "",   "",    false, true  },
  { "Wyandot",                                                    "wyn",     "",   "",    false, false },
  { "Wymysorys",                                                  "wym",     "",   "",    false, false },
  { "Wára",                                                       "tci",     "",   "",    false, false },
  { "Wãpha",                                                      "juw",     "",   "",    false, false },
  { "Wè Northern",                                                "wob",     "",   "",    false, false },
  { "Wè Southern",                                                "gxx",     "",   "",    false, false },
  { "Wè Western",                                                 "wec",     "",   "",    false, false },
  { "Xaasongaxango",                                              "kao",     "",   "",    false, false },
  { "Xadani Zapotec",                                             "zax",     "",   "",    false, false },
  { "Xakriabá",                                                   "xkr",     "",   "",    false, false },
  { "Xamtanga",                                                   "xan",     "",   "",    false, false },
  { "Xanaguía Zapotec",                                           "ztg",     "",   "",    false, false },
  { "Xavánte",                                                    "xav",     "",   "",    false, false },
  { "Xerénte",                                                    "xer",     "",   "",    false, false },
  { "Xetá",                                                       "xet",     "",   "",    false, false },
  { "Xhosa",                                                      "xho",     "xh", "",    true,  false },
  { "Xiandao",                                                    "xia",     "",   "",    false, true  },
  { "Xiang Chinese",                                              "hsn",     "",   "",    false, false },
  { "Xibe",                                                       "sjo",     "",   "",    false, false },
  { "Xicotepec De Juárez Totonac",                                "too",     "",   "",    false, false },
  { "Xinca",                                                      "xin",     "",   "",    false, false },
  { "Xingú Asuriní",                                              "asn",     "",   "",    false, false },
  { "Xipaya",                                                     "xiy",     "",   "",    false, false },
  { "Xipináwa",                                                   "xip",     "",   "",    false, true  },
  { "Xiri",                                                       "xii",     "",   "",    false, false },
  { "Xiriâna",                                                    "xir",     "",   "",    false, false },
  { "Xishanba Lalo",                                              "ywt",     "",   "",    false, false },
  { "Xokleng",                                                    "xok",     "",   "",    false, false },
  { "Xukurú",                                                     "xoo",     "",   "",    false, false },
  { "Xwela Gbe",                                                  "xwe",     "",   "",    false, false },
  { "Xârâcùù",                                                    "ane",     "",   "",    false, false },
  { "Xârâgurè",                                                   "axx",     "",   "",    false, false },
  { "Yaaku",                                                      "muu",     "",   "",    false, false },
  { "Yabarana",                                                   "yar",     "",   "",    false, false },
  { "Yabaâna",                                                    "ybn",     "",   "",    false, false },
  { "Yabem",                                                      "jae",     "",   "",    false, false },
  { "Yaben",                                                      "ybm",     "",   "",    false, false },
  { "Yabong",                                                     "ybo",     "",   "",    false, false },
  { "Yabula Yabula",                                              "yxy",     "",   "",    false, false },
  { "Yace",                                                       "ekr",     "",   "",    false, false },
  { "Yaeyama",                                                    "rys",     "",   "",    false, false },
  { "Yafi",                                                       "wfg",     "",   "",    false, false },
  { "Yagara",                                                     "yxg",     "",   "",    false, false },
  { "Yagaria",                                                    "ygr",     "",   "",    false, false },
  { "Yagnobi",                                                    "yai",     "",   "",    false, false },
  { "Yagomi",                                                     "ygm",     "",   "",    false, false },
  { "Yagua",                                                      "yad",     "",   "",    false, false },
  { "Yagwoia",                                                    "ygw",     "",   "",    false, false },
  { "Yahadian",                                                   "ner",     "",   "",    false, false },
  { "Yahang",                                                     "rhp",     "",   "",    false, false },
  { "Yahuna",                                                     "ynu",     "",   "",    false, false },
  { "Yaka (Central African Republic)",                            "axk",     "",   "",    false, false },
  { "Yaka (Congo)",                                               "iyx",     "",   "",    false, false },
  { "Yaka (Democratic Republic of Congo)",                        "yaf",     "",   "",    false, false },
  { "Yakaikeke",                                                  "ykk",     "",   "",    false, false },
  { "Yakama",                                                     "yak",     "",   "",    false, false },
  { "Yakan",                                                      "yka",     "",   "",    false, false },
  { "Yakha",                                                      "ybh",     "",   "",    false, false },
  { "Yakoma",                                                     "yky",     "",   "",    false, false },
  { "Yakut",                                                      "sah",     "",   "",    true,  false },
  { "Yala",                                                       "yba",     "",   "",    false, false },
  { "Yalahatan",                                                  "jal",     "",   "",    false, false },
  { "Yalakalore",                                                 "xyl",     "",   "",    false, false },
  { "Yalarnnga",                                                  "ylr",     "",   "",    false, false },
  { "Yale",                                                       "nce",     "",   "",    false, false },
  { "Yaleba",                                                     "ylb",     "",   "",    false, false },
  { "Yalunka",                                                    "yal",     "",   "",    false, false },
  { "Yalálag Zapotec",                                            "zpu",     "",   "",    false, false },
  { "Yamap",                                                      "ymp",     "",   "",    false, false },
  { "Yamba",                                                      "yam",     "",   "",    false, false },
  { "Yamben",                                                     "ynb",     "",   "",    false, false },
  { "Yambes",                                                     "ymb",     "",   "",    false, false },
  { "Yambeta",                                                    "yat",     "",   "",    false, false },
  { "Yamdena",                                                    "jmd",     "",   "",    false, false },
  { "Yameo",                                                      "yme",     "",   "",    false, false },
  { "Yami",                                                       "tao",     "",   "",    false, false },
  { "Yaminahua",                                                  "yaa",     "",   "",    false, false },
  { "Yamna",                                                      "ymn",     "",   "",    false, false },
  { "Yamongeri",                                                  "ymg",     "",   "",    false, false },
  { "Yamphe",                                                     "yma",     "",   "",    false, true  },
  { "Yamphu",                                                     "ybi",     "",   "",    false, false },
  { "Yan-nhangu",                                                 "jay",     "",   "",    false, false },
  { "Yan-nhaŋu Sign Language",                                    "yhs",     "",   "",    false, false },
  { "Yana",                                                       "ynn",     "",   "",    false, false },
  { "Yanahuanca Pasco Quechua",                                   "qur",     "",   "",    false, false },
  { "Yanda Dom Dogon",                                            "dym",     "",   "",    false, false },
  { "Yanda",                                                      "yda",     "",   "",    false, false },
  { "Yandjibara",                                                 "xyb",     "",   "",    false, false },
  { "Yandruwandha",                                               "ynd",     "",   "",    false, false },
  { "Yanesha'",                                                   "ame",     "",   "",    false, false },
  { "Yang Zhuang",                                                "zyg",     "",   "",    false, false },
  { "Yangben",                                                    "yav",     "",   "",    false, false },
  { "Yangbye",                                                    "ybd",     "",   "",    false, true  },
  { "Yangho",                                                     "ynh",     "",   "",    false, true  },
  { "Yangkam",                                                    "bsx",     "",   "",    false, false },
  { "Yangman",                                                    "jng",     "",   "",    false, false },
  { "Yango",                                                      "yng",     "",   "",    false, false },
  { "Yangulam",                                                   "ynl",     "",   "",    false, false },
  { "Yangum Dey",                                                 "yde",     "",   "",    false, false },
  { "Yangum Gel",                                                 "ygl",     "",   "",    false, false },
  { "Yangum Mon",                                                 "ymo",     "",   "",    false, false },
  { "Yankunytjatjara",                                            "kdd",     "",   "",    false, false },
  { "Yanomamö",                                                   "guu",     "",   "",    false, false },
  { "Yanomámi",                                                   "wca",     "",   "",    false, false },
  { "Yansi",                                                      "yns",     "",   "",    false, false },
  { "Yanyuwa",                                                    "jao",     "",   "",    false, false },
  { "Yao",                                                        "yao",     "",   "",    true,  false },
  { "Yaosakor Asmat",                                             "asy",     "",   "",    false, false },
  { "Yaouré",                                                     "yre",     "",   "",    false, false },
  { "Yapese",                                                     "yap",     "",   "",    true,  false },
  { "Yapunda",                                                    "yev",     "",   "",    false, false },
  { "Yaqay",                                                      "jaq",     "",   "",    false, false },
  { "Yaqui",                                                      "yaq",     "",   "",    false, false },
  { "Yarawata",                                                   "yrw",     "",   "",    false, false },
  { "Yardliyawarra",                                              "yxl",     "",   "",    false, false },
  { "Yareba",                                                     "yrb",     "",   "",    false, false },
  { "Yareni Zapotec",                                             "zae",     "",   "",    false, false },
  { "Yarluyandi",                                                 "yry",     "",   "",    false, false },
  { "Yaroamë",                                                    "yro",     "",   "",    false, false },
  { "Yarsun",                                                     "yrs",     "",   "",    false, false },
  { "Yarí",                                                       "yri",     "",   "",    false, true  },
  { "Yasa",                                                       "yko",     "",   "",    false, false },
  { "Yassic",                                                     "ysc",     "",   "",    false, false },
  { "Yatay",                                                      "yty",     "",   "",    false, false },
  { "Yatee Zapotec",                                              "zty",     "",   "",    false, false },
  { "Yatzachi Zapotec",                                           "zav",     "",   "",    false, false },
  { "Yau (Morobe Province)",                                      "yuw",     "",   "",    false, false },
  { "Yau (Sandaun Province)",                                     "yyu",     "",   "",    false, false },
  { "Yaul",                                                       "yla",     "",   "",    false, false },
  { "Yauma",                                                      "yax",     "",   "",    false, false },
  { "Yaur",                                                       "jau",     "",   "",    false, false },
  { "Yautepec Zapotec",                                           "zpb",     "",   "",    false, false },
  { "Yauyos Quechua",                                             "qux",     "",   "",    false, false },
  { "Yavitero",                                                   "yvt",     "",   "",    false, false },
  { "Yawa",                                                       "yva",     "",   "",    false, false },
  { "Yawalapití",                                                 "yaw",     "",   "",    false, false },
  { "Yawanawa",                                                   "ywn",     "",   "",    false, false },
  { "Yawarawarga",                                                "yww",     "",   "",    false, false },
  { "Yaweyuha",                                                   "yby",     "",   "",    false, false },
  { "Yawijibaya",                                                 "jbw",     "",   "",    false, false },
  { "Yawiyo",                                                     "ybx",     "",   "",    false, false },
  { "Yawuru",                                                     "ywr",     "",   "",    false, false },
  { "Yaygir",                                                     "xya",     "",   "",    false, false },
  { "Yazgulyam",                                                  "yah",     "",   "",    false, false },
  { "Yecuatla Totonac",                                           "tlc",     "",   "",    false, false },
  { "Yei",                                                        "jei",     "",   "",    false, false },
  { "Yekhee",                                                     "ets",     "",   "",    false, false },
  { "Yekora",                                                     "ykr",     "",   "",    false, false },
  { "Yela",                                                       "yel",     "",   "",    false, false },
  { "Yele",                                                       "yle",     "",   "",    false, false },
  { "Yelmek",                                                     "jel",     "",   "",    false, false },
  { "Yelogu",                                                     "ylg",     "",   "",    false, false },
  { "Yemba",                                                      "ybb",     "",   "",    false, false },
  { "Yemsa",                                                      "jnj",     "",   "",    false, false },
  { "Yendang",                                                    "yen",     "",   "",    false, true  },
  { "Yendang",                                                    "ynq",     "",   "",    false, false },
  { "Yeni",                                                       "yei",     "",   "",    false, false },
  { "Yeniche",                                                    "yec",     "",   "",    false, false },
  { "Yerakai",                                                    "yra",     "",   "",    false, false },
  { "Yeretuar",                                                   "gop",     "",   "",    false, false },
  { "Yerong",                                                     "yrn",     "",   "",    false, false },
  { "Yerukula",                                                   "yeu",     "",   "",    false, false },
  { "Yessan-Mayo",                                                "yss",     "",   "",    false, false },
  { "Yetfa",                                                      "yet",     "",   "",    false, false },
  { "Yevanic",                                                    "yej",     "",   "",    false, false },
  { "Yeyi",                                                       "yey",     "",   "",    false, false },
  { "Yiddish Sign Language",                                      "yds",     "",   "",    false, true  },
  { "Yiddish",                                                    "yid",     "yi", "",    true,  false },
  { "Yidgha",                                                     "ydg",     "",   "",    false, false },
  { "Yidiny",                                                     "yii",     "",   "",    false, false },
  { "Yil",                                                        "yll",     "",   "",    false, false },
  { "Yilan Creole",                                               "ycr",     "",   "",    false, false },
  { "Yimas",                                                      "yee",     "",   "",    false, false },
  { "Yimchungru Naga",                                            "yim",     "",   "",    false, false },
  { "Yinbaw Karen",                                               "kvu",     "",   "",    false, false },
  { "Yindjibarndi",                                               "yij",     "",   "",    false, false },
  { "Yindjilandji",                                               "yil",     "",   "",    false, false },
  { "Yine",                                                       "pib",     "",   "",    false, false },
  { "Yinggarda",                                                  "yia",     "",   "",    false, false },
  { "Yinhawangka",                                                "ywg",     "",   "",    false, false },
  { "Yiningayi",                                                  "ygi",     "",   "",    false, false },
  { "Yintale Karen",                                              "kvy",     "",   "",    false, false },
  { "Yinwum",                                                     "yxm",     "",   "",    false, false },
  { "Yir Yoront",                                                 "yiy",     "",   "",    false, true  },
  { "Yir Yoront",                                                 "yyr",     "",   "",    false, false },
  { "Yirandali",                                                  "ljw",     "",   "",    false, false },
  { "Yirrk-Mel",                                                  "yrm",     "",   "",    false, false },
  { "Yis",                                                        "yis",     "",   "",    false, false },
  { "Yitha Yitha",                                                "xth",     "",   "",    false, false },
  { "Yoba",                                                       "yob",     "",   "",    false, false },
  { "Yocoboué Dida",                                              "gud",     "",   "",    false, false },
  { "Yogad",                                                      "yog",     "",   "",    false, false },
  { "Yoidik",                                                     "ydk",     "",   "",    false, false },
  { "Yoke",                                                       "yki",     "",   "",    false, false },
  { "Yokuts",                                                     "yok",     "",   "",    false, false },
  { "Yola",                                                       "yol",     "",   "",    false, false },
  { "Yoloxochitl Mixtec",                                         "xty",     "",   "",    false, false },
  { "Yolŋu Sign Language",                                        "ygs",     "",   "",    false, false },
  { "Yom",                                                        "pil",     "",   "",    false, false },
  { "Yombe",                                                      "yom",     "",   "",    false, false },
  { "Yonaguni",                                                   "yoi",     "",   "",    false, false },
  { "Yong",                                                       "yno",     "",   "",    false, false },
  { "Yongbei Zhuang",                                             "zyb",     "",   "",    false, false },
  { "Yongkom",                                                    "yon",     "",   "",    false, false },
  { "Yongnan Zhuang",                                             "zyn",     "",   "",    false, false },
  { "Yopno",                                                      "yut",     "",   "",    false, false },
  { "Yora",                                                       "mts",     "",   "",    false, false },
  { "Yoron",                                                      "yox",     "",   "",    false, false },
  { "Yorta Yorta",                                                "xyy",     "",   "",    false, false },
  { "Yoruba",                                                     "yor",     "yo", "",    true,  false },
  { "Yos",                                                        "yos",     "",   "",    false, true  },
  { "Yosondúa Mixtec",                                            "mpm",     "",   "",    false, false },
  { "Yotti",                                                      "yot",     "",   "",    false, false },
  { "Youjiang Zhuang",                                            "zyj",     "",   "",    false, false },
  { "Youle Jinuo",                                                "jiu",     "",   "",    false, false },
  { "Younuo Bunu",                                                "buh",     "",   "",    false, false },
  { "Yout Wam",                                                   "ytw",     "",   "",    false, false },
  { "Yoy",                                                        "yoy",     "",   "",    false, false },
  { "Yuanga",                                                     "nua",     "",   "",    false, false },
  { "Yucatec Maya Sign Language",                                 "msd",     "",   "",    false, false },
  { "Yucateco",                                                   "yua",     "",   "",    false, false },
  { "Yuchi",                                                      "yuc",     "",   "",    false, false },
  { "Yucuañe Mixtec",                                             "mvg",     "",   "",    false, false },
  { "Yucuna",                                                     "ycn",     "",   "",    false, false },
  { "Yue Chinese",                                                "yue",     "",   "",    false, false },
  { "Yug",                                                        "yug",     "",   "",    false, false },
  { "Yugambal",                                                   "yub",     "",   "",    false, false },
  { "Yugh",                                                       "yuu",     "",   "",    false, true  },
  { "Yugoslavian Sign Language",                                  "ysl",     "",   "",    false, false },
  { "Yugul",                                                      "ygu",     "",   "",    false, false },
  { "Yuhup",                                                      "yab",     "",   "",    false, false },
  { "Yuki",                                                       "yuk",     "",   "",    false, false },
  { "Yukpa",                                                      "yup",     "",   "",    false, false },
  { "Yukuben",                                                    "ybl",     "",   "",    false, false },
  { "Yulu",                                                       "yul",     "",   "",    false, false },
  { "Yupik languages",                                            "ypk",     "",   "",    true,  false },
  { "Yuqui",                                                      "yuq",     "",   "",    false, false },
  { "Yuracare",                                                   "yuz",     "",   "",    false, false },
  { "Yurats",                                                     "rts",     "",   "",    false, false },
  { "Yurok",                                                      "yur",     "",   "",    false, false },
  { "Yuru",                                                       "ljx",     "",   "",    false, false },
  { "Yurutí",                                                     "yui",     "",   "",    false, false },
  { "Yutanduchi Mixtec",                                          "mab",     "",   "",    false, false },
  { "Yuwana",                                                     "yau",     "",   "",    false, false },
  { "Yuyu",                                                       "yxu",     "",   "",    false, false },
  { "Ywom",                                                       "gek",     "",   "",    false, false },
  { "Yámana",                                                     "yag",     "",   "",    false, false },
  { "Zaachila Zapotec",                                           "ztx",     "",   "",    false, false },
  { "Zabana",                                                     "kji",     "",   "",    false, false },
  { "Zacatepec Chatino",                                          "ctz",     "",   "",    false, false },
  { "Zacatlán-Ahuacatlán-Tepetzintla Nahuatl",                    "nhi",     "",   "",    false, false },
  { "Zaghawa",                                                    "zag",     "",   "",    false, false },
  { "Zaiwa",                                                      "atb",     "",   "",    false, false },
  { "Zakhring",                                                   "zkr",     "",   "",    false, false },
  { "Zambian Sign Language",                                      "zsl",     "",   "",    false, false },
  { "Zan Gula",                                                   "zna",     "",   "",    false, false },
  { "Zanaki",                                                     "zak",     "",   "",    false, false },
  { "Zande (individual language)",                                "zne",     "",   "",    false, false },
  { "Zande languages",                                            "znd",     "",   "",    true,  false },
  { "Zangskari",                                                  "zau",     "",   "",    false, false },
  { "Zangwal",                                                    "zah",     "",   "",    false, false },
  { "Zaniza Zapotec",                                             "zpw",     "",   "",    false, false },
  { "Zapotec",                                                    "zap",     "",   "",    true,  false },
  { "Zaramo",                                                     "zaj",     "",   "",    false, false },
  { "Zari",                                                       "zaz",     "",   "",    false, false },
  { "Zarma",                                                      "dje",     "",   "",    false, false },
  { "Zarphatic",                                                  "zrp",     "",   "",    false, false },
  { "Zauzou",                                                     "zal",     "",   "",    false, false },
  { "Zay",                                                        "zwa",     "",   "",    false, false },
  { "Zayein Karen",                                               "kxk",     "",   "",    false, false },
  { "Zayse-Zergulla",                                             "zay",     "",   "",    false, false },
  { "Zaza",                                                       "zza",     "",   "",    true,  false },
  { "Zazao",                                                      "jaj",     "",   "",    false, false },
  { "Zeem",                                                       "zem",     "",   "",    false, false },
  { "Zeem",                                                       "zua",     "",   "",    false, true  },
  { "Zeeuws",                                                     "zea",     "",   "",    false, false },
  { "Zemba",                                                      "dhm",     "",   "",    false, false },
  { "Zeme Naga",                                                  "nzm",     "",   "",    false, false },
  { "Zemgalian",                                                  "xzm",     "",   "",    false, false },
  { "Zenag",                                                      "zeg",     "",   "",    false, false },
  { "Zenaga",                                                     "zen",     "",   "",    true,  false },
  { "Zenzontepec Chatino",                                        "czn",     "",   "",    false, false },
  { "Zerenkel",                                                   "zrn",     "",   "",    false, false },
  { "Zhaba",                                                      "zhb",     "",   "",    false, false },
  { "Zhang-Zhung",                                                "xzh",     "",   "",    false, false },
  { "Zhire",                                                      "zhi",     "",   "",    false, false },
  { "Zhoa",                                                       "zhw",     "",   "",    false, false },
  { "Zhuang",                                                     "zha",     "za", "",    true,  false },
  { "Zia",                                                        "zia",     "",   "",    false, false },
  { "Zialo",                                                      "zil",     "",   "",    false, false },
  { "Zigula",                                                     "ziw",     "",   "",    false, false },
  { "Zimakani",                                                   "zik",     "",   "",    false, false },
  { "Zimba",                                                      "zmb",     "",   "",    false, false },
  { "Zimbabwe Sign Language",                                     "zib",     "",   "",    false, false },
  { "Zinza",                                                      "zin",     "",   "",    false, false },
  { "Zire",                                                       "sih",     "",   "",    false, false },
  { "Ziriya",                                                     "zir",     "",   "",    false, true  },
  { "Zizilivakan",                                                "ziz",     "",   "",    false, false },
  { "Zo'é",                                                       "pto",     "",   "",    false, false },
  { "Zokhuo",                                                     "yzk",     "",   "",    false, false },
  { "Zoogocho Zapotec",                                           "zpq",     "",   "",    false, false },
  { "Zoroastrian Dari",                                           "gbz",     "",   "",    false, false },
  { "Zotung Chin",                                                "czt",     "",   "",    false, false },
  { "Zou",                                                        "zom",     "",   "",    false, false },
  { "Zul",                                                        "zlu",     "",   "",    false, false },
  { "Zula",                                                       "zla",     "",   "",    false, false },
  { "Zulgo-Gemzek",                                               "gnd",     "",   "",    false, false },
  { "Zulu",                                                       "zul",     "zu", "",    true,  false },
  { "Zumaya",                                                     "zuy",     "",   "",    false, false },
  { "Zumbun",                                                     "jmb",     "",   "",    false, false },
  { "Zuni",                                                       "zun",     "",   "",    true,  false },
  { "Zuojiang Zhuang",                                            "zzj",     "",   "",    false, false },
  { "Zyphe Chin",                                                 "zyp",     "",   "",    false, false },
  { "Záparo",                                                     "zro",     "",   "",    false, false },
  { "sTodsde",                                                    "jih",     "",   "",    false, false },
  { "us-Saare",                                                   "uss",     "",   "",    false, false },
  { "ut-Hun",                                                     "uth",     "",   "",    false, false },
  { "ut-Ma'in",                                                   "gel",     "",   "",    false, false },
  { "Àhàn",                                                       "ahn",     "",   "",    false, false },
  { "Áncá",                                                       "acb",     "",   "",    false, false },
  { "Ömie",                                                       "aom",     "",   "",    false, false },
  { "Önge",                                                       "oon",     "",   "",    false, false },
  { "ǀGwi",                                                       "gwj",     "",   "",    false, false },
  { "ǀXam",                                                       "xam",     "",   "",    false, false },
  { "ǁAni",                                                       "hnh",     "",   "",    false, false },
  { "ǁGana",                                                      "gnk",     "",   "",    false, false },
  { "ǁXegwi",                                                     "xeg",     "",   "",    false, false },
  { "ǂHua",                                                       "huc",     "",   "",    false, false },
  { "ǂKxʼauǁʼein",                                                "aue",     "",   "",    false, true  },
  { "ǂUngkue",                                                    "gku",     "",   "",    false, false },
  { "ǃOǃung",                                                     "oun",     "",   "",    false, true  },
  { "ǃXóõ",                                                       "nmn",     "",   "",    false, false },
};

void
init() {
  g_languages.reserve(8783);

  for (language_init_t const *lang = s_languages_init, *end = lang + 8783; lang < end; ++lang)
    g_languages.emplace_back(lang->english_name, lang->alpha_3_code, lang->alpha_2_code, lang->terminology_abbrev, lang->is_part_of_iso639_2, lang->is_deprecated);
}

} // namespace mtx::iso639
