/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.NativeQuery;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int[] NO_BINDS = new int[0];

    public static List<NativeQuery> parseJdbcSql(String query, boolean standardConformingStrings, boolean withParameters, boolean splitStatements) {
        if (!withParameters && !splitStatements) {
            return Collections.singletonList(new NativeQuery(query));
        }
        int fragmentStart = 0;
        int inParen = 0;
        char[] aChars = query.toCharArray();
        StringBuilder nativeSql = new StringBuilder(query.length() + 10);
        ArrayList<Integer> bindPositions = null;
        List<NativeQuery> nativeQueries = null;
        boolean whitespaceOnly = true;
        block11: for (int i2 = 0; i2 < aChars.length; ++i2) {
            char aChar = aChars[i2];
            whitespaceOnly &= aChar == ';' || Character.isWhitespace(aChar);
            switch (aChar) {
                case '\'': {
                    i2 = Parser.parseSingleQuotes(aChars, i2, standardConformingStrings);
                    continue block11;
                }
                case '\"': {
                    i2 = Parser.parseDoubleQuotes(aChars, i2);
                    continue block11;
                }
                case '-': {
                    i2 = Parser.parseLineComment(aChars, i2);
                    continue block11;
                }
                case '/': {
                    i2 = Parser.parseBlockComment(aChars, i2);
                    continue block11;
                }
                case '$': {
                    i2 = Parser.parseDollarQuotes(aChars, i2);
                    continue block11;
                }
                case '(': {
                    ++inParen;
                    continue block11;
                }
                case ')': {
                    --inParen;
                    continue block11;
                }
                case '?': {
                    nativeSql.append(aChars, fragmentStart, i2 - fragmentStart);
                    if (i2 + 1 < aChars.length && aChars[i2 + 1] == '?') {
                        nativeSql.append('?');
                        ++i2;
                    } else if (!withParameters) {
                        nativeSql.append('?');
                    } else {
                        if (bindPositions == null) {
                            bindPositions = new ArrayList<Integer>();
                        }
                        bindPositions.add(nativeSql.length());
                        int bindIndex = bindPositions.size();
                        nativeSql.append(NativeQuery.bindName(bindIndex));
                    }
                    fragmentStart = i2 + 1;
                    continue block11;
                }
                case ';': {
                    if (inParen != 0 || !splitStatements) continue block11;
                    if (!whitespaceOnly) {
                        nativeSql.append(aChars, fragmentStart, i2 - fragmentStart);
                        whitespaceOnly = true;
                    }
                    fragmentStart = i2 + 1;
                    if (nativeSql.length() > 0) {
                        if (nativeQueries == null) {
                            nativeQueries = new ArrayList<NativeQuery>();
                        }
                        nativeQueries.add(new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions)));
                    }
                    if (bindPositions != null) {
                        bindPositions.clear();
                    }
                    nativeSql.setLength(0);
                    continue block11;
                }
            }
        }
        if (fragmentStart < aChars.length && !whitespaceOnly) {
            nativeSql.append(aChars, fragmentStart, aChars.length - fragmentStart);
        }
        if (nativeSql.length() == 0) {
            return nativeQueries != null ? nativeQueries : Collections.emptyList();
        }
        NativeQuery lastQuery = new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions));
        if (nativeQueries == null) {
            return Collections.singletonList(lastQuery);
        }
        if (!whitespaceOnly) {
            nativeQueries.add(lastQuery);
        }
        return nativeQueries;
    }

    private static int[] toIntArray(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return NO_BINDS;
        }
        int[] res = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            res[i2] = list.get(i2);
        }
        return res;
    }

    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
        } else {
            block8: while (++offset < query.length) {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        continue block8;
                    }
                    case '\'': {
                        return offset;
                    }
                }
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                for (int d2 = offset + 2; d2 < query.length; ++d2) {
                    if (query[d2] == '$') {
                        endIdx = d2;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d2])) break;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean isSpace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '\f';
    }

    public static boolean isOperatorChar(char c2) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c2) != -1;
    }

    public static boolean isIdentifierStartChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f';
    }

    public static boolean isIdentifierContChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f' || c2 >= '0' && c2 <= '9' || c2 == '$';
    }

    public static boolean charTerminatesIdentifier(char c2) {
        return c2 == '\"' || Parser.isSpace(c2) || Parser.isOperatorChar(c2);
    }

    public static boolean isDollarQuoteStartChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f';
    }

    public static boolean isDollarQuoteContChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f' || c2 >= '0' && c2 <= '9';
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (arr[offA + i2] == arr[offB + i2]) continue;
            return false;
        }
        return true;
    }

    public static JdbcCallParseInfo modifyJdbcCall(String jdbcSql, boolean stdStrings, int serverVersion, int protocolVersion) throws SQLException {
        String sql = jdbcSql;
        boolean isFunction = false;
        boolean outParmBeforeFunc = false;
        int len = jdbcSql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i2 = 0;
        block10: while (i2 < len && !syntaxError) {
            char ch = jdbcSql.charAt(i2);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i2;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    i2 = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        isFunction = true;
                        outParmBeforeFunc = true;
                        ++i2;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c' || ch == 'C') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i2;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i2 + 4 <= len && jdbcSql.substring(i2, i2 + 4).equalsIgnoreCase("call")) {
                        isFunction = true;
                        i2 += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i2;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\' && !stdStrings) {
                        i2 += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i2++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i2;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i2;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i2 == len && !syntaxError) {
            if (state == 1) {
                return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", i2), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (serverVersion < 80100 || protocolVersion != 3) {
            sql = "select " + jdbcSql.substring(startIndex, endIndex) + " as result";
            return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
        }
        String s2 = jdbcSql.substring(startIndex, endIndex);
        StringBuilder sb = new StringBuilder(s2);
        if (outParmBeforeFunc) {
            boolean needComma = false;
            int opening = s2.indexOf(40) + 1;
            int closing = s2.indexOf(41);
            for (int j2 = opening; j2 < closing; ++j2) {
                if (Character.isWhitespace(sb.charAt(j2))) continue;
                needComma = true;
                break;
            }
            if (needComma) {
                sb.insert(opening, "?,");
            } else {
                sb.insert(opening, "?");
            }
        }
        sql = "select * from " + sb.toString() + " as result";
        return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
    }
}

