/* SPDX-License-Identifier: GPL-2.0-only
 * Copyright (c) 2023-2024 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _PM4125_REGISTERS_H
#define _PM4125_REGISTERS_H

#include <linux/soundwire/sdw.h>
#include <linux/soundwire/sdw_type.h>
#include "wcd-common.h"

#define PM4125_ANA_BASE_ADDR			0x3000
#define PM4125_DIG_BASE_ADDR			0x3400

#define PM4125_ANA_MICBIAS_MICB_1_2_EN		(PM4125_ANA_BASE_ADDR+0x040)
#define  PM4125_ANA_MICBIAS_MICB1_PULL_UP_MASK	BIT(5)
#define  PM4125_ANA_MICBIAS_MICB2_PULL_UP_MASK	BIT(1)
#define  PM4125_ANA_MICBIAS_MICB2_PULL_DN_MASK	BIT(0)
#define  PM4125_ANA_MICBIAS_MICB_PULL_ENABLE	1
#define  PM4125_ANA_MICBIAS_MICB_PULL_DISABLE	0
#define PM4125_ANA_MICBIAS_MICB_3_EN		(PM4125_ANA_BASE_ADDR+0x041)
#define PM4125_ANA_MICBIAS_LDO_1_SETTING	(PM4125_ANA_BASE_ADDR+0x042)
#define  PM4125_ANA_MICBIAS_MICB_OUT_VAL_MASK	GENMASK(7, 3)
#define PM4125_ANA_MICBIAS_LDO_1_CTRL		(PM4125_ANA_BASE_ADDR+0x043)
#define PM4125_ANA_TX_AMIC1			(PM4125_ANA_BASE_ADDR+0x047)
#define PM4125_ANA_TX_AMIC2			(PM4125_ANA_BASE_ADDR+0x048)
#define PM4125_ANA_MBHC_MECH			(PM4125_ANA_BASE_ADDR+0x05A)
#define PM4125_ANA_MBHC_ELECT			(PM4125_ANA_BASE_ADDR+0x05B)
#define  PM4125_ANA_MBHC_ELECT_BIAS_EN_MASK	BIT(0)
#define  PM4125_ANA_MBHC_ELECT_BIAS_ENABLE	1
#define  PM4125_ANA_MBHC_ELECT_BIAS_DISABLE	0
#define PM4125_ANA_MBHC_ZDET			(PM4125_ANA_BASE_ADDR+0x05C)
#define PM4125_ANA_MBHC_RESULT_1		(PM4125_ANA_BASE_ADDR+0x05D)
#define PM4125_ANA_MBHC_RESULT_2		(PM4125_ANA_BASE_ADDR+0x05E)
#define PM4125_ANA_MBHC_RESULT_3		(PM4125_ANA_BASE_ADDR+0x05F)
#define PM4125_ANA_MBHC_BTN0_ZDET_VREF1		(PM4125_ANA_BASE_ADDR+0x060)
#define  PM4125_ANA_MBHC_BTN0_THRESHOLD_MASK	GENMASK(7, 2)
#define PM4125_ANA_MBHC_BTN1_ZDET_VREF2		(PM4125_ANA_BASE_ADDR+0x061)
#define PM4125_ANA_MBHC_BTN2_ZDET_VREF3		(PM4125_ANA_BASE_ADDR+0x062)
#define PM4125_ANA_MBHC_BTN3_ZDET_DBG_400	(PM4125_ANA_BASE_ADDR+0x063)
#define PM4125_ANA_MBHC_BTN4_ZDET_DBG_1400	(PM4125_ANA_BASE_ADDR+0x064)
#define PM4125_ANA_MBHC_MICB2_RAMP		(PM4125_ANA_BASE_ADDR+0x065)
#define PM4125_ANA_MBHC_CTL_1			(PM4125_ANA_BASE_ADDR+0x066)
#define PM4125_ANA_MBHC_CTL_2			(PM4125_ANA_BASE_ADDR+0x067)
#define PM4125_ANA_MBHC_PLUG_DETECT_CTL		(PM4125_ANA_BASE_ADDR+0x068)
#define PM4125_ANA_MBHC_ZDET_ANA_CTL		(PM4125_ANA_BASE_ADDR+0x069)
#define PM4125_ANA_MBHC_ZDET_RAMP_CTL		(PM4125_ANA_BASE_ADDR+0x06A)
#define PM4125_ANA_MBHC_FSM_STATUS		(PM4125_ANA_BASE_ADDR+0x06B)
#define PM4125_ANA_MBHC_ADC_RESULT		(PM4125_ANA_BASE_ADDR+0x06C)
#define PM4125_ANA_MBHC_CTL_CLK			(PM4125_ANA_BASE_ADDR+0x06D)
#define PM4125_ANA_MBHC_ZDET_CALIB_RESULT	(PM4125_ANA_BASE_ADDR+0x072)
#define PM4125_ANA_NCP_EN			(PM4125_ANA_BASE_ADDR+0x077)
#define  PM4125_ANA_NCP_ENABLE_MASK		BIT(0)
#define  PM4125_ANA_NCP_ENABLE			1
#define  PM4125_ANA_NCP_DISABLE			0
#define PM4125_ANA_NCP_VCTRL			(PM4125_ANA_BASE_ADDR+0x07C)
#define PM4125_ANA_HPHPA_CNP_CTL_1		(PM4125_ANA_BASE_ADDR+0x083)
#define  PM4125_ANA_HPHPA_CNP_CTL_1_EN_MASK	BIT(1)
#define  PM4125_ANA_HPHPA_CNP_CTL_1_EN		1
#define PM4125_ANA_HPHPA_CNP_CTL_2		(PM4125_ANA_BASE_ADDR+0x084)
#define  PM4125_ANA_HPHPA_CNP_OCP_EN_L_MASK	BIT(1)
#define  PM4125_ANA_HPHPA_CNP_OCP_EN_R_MASK	BIT(0)
#define  PM4125_ANA_HPHPA_CNP_OCP_ENABLE	1
#define  PM4125_ANA_HPHPA_CNP_OCP_DISABLE	0
#define PM4125_ANA_HPHPA_PA_STATUS		(PM4125_ANA_BASE_ADDR+0x087)
#define PM4125_ANA_HPHPA_FSM_CLK		(PM4125_ANA_BASE_ADDR+0x088)
#define  PM4125_ANA_HPHPA_FSM_CLK_DIV_EN_MASK	BIT(7)
#define  PM4125_ANA_HPHPA_FSM_CLK_DIV_ENABLE	1
#define  PM4125_ANA_HPHPA_FSM_CLK_DIV_DISABLE	0
#define  PM4125_ANA_HPHPA_FSM_DIV_RATIO_MASK	GENMASK(6, 0)
#define  PM4125_ANA_HPHPA_FSM_DIV_RATIO_68	(0x11)
#define PM4125_ANA_HPHPA_L_GAIN			(PM4125_ANA_BASE_ADDR+0x08B)
#define PM4125_ANA_HPHPA_R_GAIN			(PM4125_ANA_BASE_ADDR+0x08C)
#define PM4125_ANA_HPHPA_SPARE_CTL		(PM4125_ANA_BASE_ADDR+0x08E)
#define PM4125_SWR_HPHPA_HD2			(PM4125_ANA_BASE_ADDR+0x090)
#define  PM4125_SWR_HPHPA_HD2_LEFT_MASK		GENMASK(5, 3)
#define  PM4125_SWR_HPHPA_HD2_RIGHT_MASK	GENMASK(2, 0)
#define  PM4125_SWR_HPHPA_HD2_ENABLE		(BIT(2) | BIT(1) | BIT(0))
#define PM4125_ANA_SURGE_EN			(PM4125_ANA_BASE_ADDR+0x097)
#define  PM4125_ANA_SURGE_PROTECTION_HPHL_MASK	BIT(7)
#define  PM4125_ANA_SURGE_PROTECTION_HPHR_MASK	BIT(6)
#define  PM4125_ANA_SURGE_PROTECTION_ENABLE	1
#define  PM4125_ANA_SURGE_PROTECTION_DISABLE	0
#define PM4125_ANA_COMBOPA_CTL			(PM4125_ANA_BASE_ADDR+0x09B)
#define  PM4125_ANA_COMBO_PA_SELECT_MASK	BIT(6)
#define  PM4125_ANA_COMBO_PA_SELECT_EAR		0
#define  PM4125_ANA_COMBO_PA_SELECT_LO		1
#define PM4125_ANA_COMBOPA_CTL_4		(PM4125_ANA_BASE_ADDR+0x09F)
#define PM4125_ANA_COMBOPA_CTL_5		(PM4125_ANA_BASE_ADDR+0x0A0)
#define PM4125_ANA_RXLDO_CTL			(PM4125_ANA_BASE_ADDR+0x0B2)
#define PM4125_ANA_MBIAS_EN			(PM4125_ANA_BASE_ADDR+0x0B4)
#define  PM4125_ANA_MBIAS_EN_GLOBAL_MASK	BIT(5)
#define  PM4125_ANA_MBIAS_EN_V2I_MASK		BIT(4)
#define  PM4125_ANA_MBIAS_EN_ENABLE		1
#define  PM4125_ANA_MBIAS_EN_DISABLE		0

#define PM4125_DIG_SWR_CHIP_ID0			(PM4125_DIG_BASE_ADDR+0x001)
#define PM4125_DIG_SWR_CHIP_ID1			(PM4125_DIG_BASE_ADDR+0x002)
#define PM4125_DIG_SWR_CHIP_ID2			(PM4125_DIG_BASE_ADDR+0x003)
#define PM4125_DIG_SWR_CHIP_ID3			(PM4125_DIG_BASE_ADDR+0x004)
#define PM4125_DIG_SWR_SWR_TX_CLK_RATE		(PM4125_DIG_BASE_ADDR+0x040)
#define PM4125_DIG_SWR_CDC_RST_CTL		(PM4125_DIG_BASE_ADDR+0x041)
#define PM4125_DIG_SWR_TOP_CLK_CFG		(PM4125_DIG_BASE_ADDR+0x042)
#define PM4125_DIG_SWR_CDC_RX_CLK_CTL		(PM4125_DIG_BASE_ADDR+0x043)
#define  PM4125_DIG_SWR_ANA_RX_DIV2_CLK_EN_MASK	BIT(5)
#define  PM4125_DIG_SWR_ANA_RX_CLK_EN_MASK	BIT(4)
#define  PM4125_DIG_SWR_RX1_CLK_EN_MASK		BIT(1)
#define  PM4125_DIG_SWR_RX0_CLK_EN_MASK		BIT(0)
#define  PM4125_DIG_SWR_RX_CLK_ENABLE		1
#define  PM4125_DIG_SWR_RX_CLK_DISABLE		0
#define PM4125_DIG_SWR_CDC_TX_CLK_CTL		(PM4125_DIG_BASE_ADDR+0x044)
#define PM4125_DIG_SWR_SWR_RST_EN		(PM4125_DIG_BASE_ADDR+0x045)
#define PM4125_DIG_SWR_CDC_RX_RST		(PM4125_DIG_BASE_ADDR+0x047)
#define PM4125_DIG_SWR_CDC_RX0_CTL		(PM4125_DIG_BASE_ADDR+0x048)
#define  PM4125_DIG_SWR_DSM_DITHER_EN_MASK	BIT(7)
#define  PM4125_DIG_SWR_DSM_DITHER_DISABLE	0
#define  PM4125_DIG_SWR_DSM_DITHER_ENABLE	1
#define PM4125_DIG_SWR_CDC_RX1_CTL		(PM4125_DIG_BASE_ADDR+0x049)
#define PM4125_DIG_SWR_CDC_TX_ANA_MODE_0_1	(PM4125_DIG_BASE_ADDR+0x04B)
#define  PM4125_DIG_SWR_TX_ANA_TXD1_MODE_MASK	GENMASK(7, 4)
#define  PM4125_DIG_SWR_TX_ANA_TXD0_MODE_MASK	GENMASK(3, 0)
#define  PM4125_DIG_SWR_TXD_MODE_ULPI		(0x9)
#define  PM4125_DIG_SWR_TXD_MODE_NORMAL		(0x3)
#define PM4125_DIG_SWR_CDC_COMP_CTL_0		(PM4125_DIG_BASE_ADDR+0x04F)
#define  PM4125_DIG_SWR_COMP_HPHL_EN_MASK	BIT(1)
#define  PM4125_DIG_SWR_COMP_HPHR_EN_MASK	BIT(0)
#define  PM4125_DIG_SWR_COMP_ENABLE		1
#define  PM4125_DIG_SWR_COMP_DISABLE		0
#define PM4125_DIG_SWR_CDC_RX_DELAY_CTL		(PM4125_DIG_BASE_ADDR+0x052)
#define PM4125_DIG_SWR_CDC_RX_GAIN_0		(PM4125_DIG_BASE_ADDR+0x053)
#define PM4125_DIG_SWR_CDC_RX_GAIN_1		(PM4125_DIG_BASE_ADDR+0x054)
#define PM4125_DIG_SWR_CDC_RX_GAIN_CTL		(PM4125_DIG_BASE_ADDR+0x057)
#define  PM4125_DIG_SWR_RX1_EN_MASK		BIT(3)
#define  PM4125_DIG_SWR_RX0_EN_MASK		BIT(2)
#define  PM4125_DIG_SWR_RX_INPUT_DISABLE	0
#define  PM4125_DIG_SWR_RX_INPUT_ENABLE		1
#define PM4125_DIG_SWR_CDC_TX0_CTL		(PM4125_DIG_BASE_ADDR+0x060)
#define PM4125_DIG_SWR_CDC_TX1_CTL		(PM4125_DIG_BASE_ADDR+0x061)
#define PM4125_DIG_SWR_CDC_TX_RST		(PM4125_DIG_BASE_ADDR+0x063)
#define PM4125_DIG_SWR_CDC_REQ0_CTL		(PM4125_DIG_BASE_ADDR+0x064)
#define PM4125_DIG_SWR_CDC_REQ1_CTL		(PM4125_DIG_BASE_ADDR+0x065)
#define PM4125_DIG_SWR_CDC_RST			(PM4125_DIG_BASE_ADDR+0x067)
#define PM4125_DIG_SWR_CDC_AMIC_CTL		(PM4125_DIG_BASE_ADDR+0x06A)
#define  PM4125_DIG_SWR_AMIC_SELECT_MASK	BIT(1)
#define  PM4125_DIG_SWR_AMIC_SELECT_DMIC1	0
#define  PM4125_DIG_SWR_AMIC_SELECT_AMIC3	1
#define PM4125_DIG_SWR_CDC_DMIC_CTL		(PM4125_DIG_BASE_ADDR+0x06B)
#define PM4125_DIG_SWR_CDC_DMIC1_CTL		(PM4125_DIG_BASE_ADDR+0x06C)
#define  PM4125_DIG_SWR_DMIC1_CLK_EN_MASK	BIT(3)
#define  PM4125_DIG_SWR_DMIC1_CLK_ENABLE	1
#define  PM4125_DIG_SWR_DMIC1_CLK_DISABLE	0
#define PM4125_DIG_SWR_CDC_DMIC1_RATE		(PM4125_DIG_BASE_ADDR+0x06D)
#define PM4125_DIG_SWR_PDM_WD_CTL0		(PM4125_DIG_BASE_ADDR+0x070)
#define  PM4125_WDT_ENABLE_MASK			GENMASK(1, 0)
#define  PM4125_WDT_ENABLE_RX0_L		BIT(0)
#define  PM4125_WDT_ENABLE_RX0_M		BIT(1)
#define PM4125_DIG_SWR_PDM_WD_CTL1		(PM4125_DIG_BASE_ADDR+0x071)
#define  PM4125_WDT_ENABLE_RX1_L		BIT(0)
#define  PM4125_WDT_ENABLE_RX1_M		BIT(1)
#define PM4125_DIG_SWR_INTR_MODE		(PM4125_DIG_BASE_ADDR+0x080)
#define PM4125_DIG_SWR_INTR_MASK_0		(PM4125_DIG_BASE_ADDR+0x081)
#define PM4125_DIG_SWR_INTR_MASK_1		(PM4125_DIG_BASE_ADDR+0x082)
#define PM4125_DIG_SWR_INTR_MASK_2		(PM4125_DIG_BASE_ADDR+0x083)
#define PM4125_DIG_SWR_INTR_STATUS_0		(PM4125_DIG_BASE_ADDR+0x084)
#define PM4125_DIG_SWR_INTR_STATUS_1		(PM4125_DIG_BASE_ADDR+0x085)
#define PM4125_DIG_SWR_INTR_STATUS_2		(PM4125_DIG_BASE_ADDR+0x086)
#define PM4125_DIG_SWR_INTR_CLEAR_0		(PM4125_DIG_BASE_ADDR+0x087)
#define PM4125_DIG_SWR_INTR_CLEAR_1		(PM4125_DIG_BASE_ADDR+0x088)
#define PM4125_DIG_SWR_INTR_CLEAR_2		(PM4125_DIG_BASE_ADDR+0x089)
#define PM4125_DIG_SWR_INTR_LEVEL_0		(PM4125_DIG_BASE_ADDR+0x08A)
#define PM4125_DIG_SWR_INTR_LEVEL_1		(PM4125_DIG_BASE_ADDR+0x08B)
#define PM4125_DIG_SWR_INTR_LEVEL_2		(PM4125_DIG_BASE_ADDR+0x08C)
#define PM4125_DIG_SWR_CDC_CONN_RX0_CTL		(PM4125_DIG_BASE_ADDR+0x093)
#define PM4125_DIG_SWR_CDC_CONN_RX1_CTL		(PM4125_DIG_BASE_ADDR+0x094)
#define PM4125_DIG_SWR_LOOP_BACK_MODE		(PM4125_DIG_BASE_ADDR+0x097)
#define PM4125_DIG_SWR_DRIVE_STRENGTH_0		(PM4125_DIG_BASE_ADDR+0x0A0)
#define PM4125_DIG_SWR_DIG_DEBUG_CTL		(PM4125_DIG_BASE_ADDR+0x0AB)
#define PM4125_DIG_SWR_DIG_DEBUG_EN		(PM4125_DIG_BASE_ADDR+0x0AC)
#define PM4125_DIG_SWR_DEM_BYPASS_DATA0		(PM4125_DIG_BASE_ADDR+0x0B0)
#define PM4125_DIG_SWR_DEM_BYPASS_DATA1		(PM4125_DIG_BASE_ADDR+0x0B1)
#define PM4125_DIG_SWR_DEM_BYPASS_DATA2		(PM4125_DIG_BASE_ADDR+0x0B2)
#define PM4125_DIG_SWR_DEM_BYPASS_DATA3		(PM4125_DIG_BASE_ADDR+0x0B3)

#define PM4125_ANALOG_REGISTERS_MAX_SIZE	(PM4125_ANA_BASE_ADDR+0x0B5)
#define PM4125_DIGITAL_REGISTERS_MAX_SIZE	(PM4125_DIG_BASE_ADDR+0x0B4)
#define PM4125_ANALOG_MAX_REGISTER		(PM4125_ANALOG_REGISTERS_MAX_SIZE - 1)
#define PM4125_DIGITAL_MAX_REGISTER		(PM4125_DIGITAL_REGISTERS_MAX_SIZE - 1)
#define PM4125_MAX_REGISTER			PM4125_DIGITAL_MAX_REGISTER

#define PM4125_MAX_MICBIAS			3
#define PM4125_MAX_SWR_CH_IDS			15
#define PM4125_SWRM_CH_MASK(ch_idx)		BIT(ch_idx - 1)

enum pm4125_tx_sdw_ports {
	PM4125_ADC_1_2_DMIC1L_BCS_PORT = 1,
	PM4125_DMIC_1L_1R_ADC1_BCS_PORT,
	PM4125_MAX_TX_SWR_PORTS = PM4125_DMIC_1L_1R_ADC1_BCS_PORT,
};

enum pm4125_rx_sdw_ports {
	PM4125_HPH_PORT = 1,
	PM4125_COMP_PORT,
	PM4125_MAX_SWR_PORTS = PM4125_COMP_PORT,
};

struct pm4125_priv;
struct pm4125_sdw_priv {
	struct sdw_slave *sdev;
	struct sdw_stream_config sconfig;
	struct sdw_stream_runtime *sruntime;
	struct sdw_port_config port_config[PM4125_MAX_SWR_PORTS];
	struct wcd_sdw_ch_info *ch_info;
	bool port_enable[PM4125_MAX_SWR_CH_IDS];
	unsigned int master_channel_map[SDW_MAX_PORTS];
	int active_ports;
	int num_ports;
	bool is_tx;
	struct pm4125_priv *pm4125;
	struct irq_domain *slave_irq;
	struct regmap *regmap;
};

#if IS_ENABLED(CONFIG_SND_SOC_PM4125_SDW)
int pm4125_sdw_free(struct pm4125_sdw_priv *pm4125, struct snd_pcm_substream *substream,
		    struct snd_soc_dai *dai);
int pm4125_sdw_set_sdw_stream(struct pm4125_sdw_priv *pm4125, struct snd_soc_dai *dai, void *stream,
			      int direction);
int pm4125_sdw_hw_params(struct pm4125_sdw_priv *pm4125, struct snd_pcm_substream *substream,
			 struct snd_pcm_hw_params *params, struct snd_soc_dai *dai);

#else
static inline int pm4125_sdw_free(struct pm4125_sdw_priv *pm4125,
				  struct snd_pcm_substream *substream, struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}

static inline int pm4125_sdw_set_sdw_stream(struct pm4125_sdw_priv *pm4125,
					    struct snd_soc_dai *dai, void *stream, int direction)
{
	return -EOPNOTSUPP;
}

static inline int pm4125_sdw_hw_params(struct pm4125_sdw_priv *pm4125,
				       struct snd_pcm_substream *substream,
				       struct snd_pcm_hw_params *params, struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}
#endif

enum {
	/* INTR_CTRL_INT_MASK_0 */
	PM4125_IRQ_MBHC_BUTTON_PRESS_DET = 0,
	PM4125_IRQ_MBHC_BUTTON_RELEASE_DET,
	PM4125_IRQ_MBHC_ELECT_INS_REM_DET,
	PM4125_IRQ_MBHC_ELECT_INS_REM_LEG_DET,
	PM4125_IRQ_MBHC_SW_DET,
	PM4125_IRQ_HPHR_OCP_INT,
	PM4125_IRQ_HPHR_CNP_INT,
	PM4125_IRQ_HPHL_OCP_INT,

	/* INTR_CTRL_INT_MASK_1 */
	PM4125_IRQ_HPHL_CNP_INT,
	PM4125_IRQ_EAR_CNP_INT,
	PM4125_IRQ_EAR_SCD_INT,
	PM4125_IRQ_AUX_CNP_INT,
	PM4125_IRQ_AUX_SCD_INT,
	PM4125_IRQ_HPHL_PDM_WD_INT,
	PM4125_IRQ_HPHR_PDM_WD_INT,
	PM4125_IRQ_AUX_PDM_WD_INT,

	/* INTR_CTRL_INT_MASK_2 */
	PM4125_IRQ_LDORT_SCD_INT,
	PM4125_IRQ_MBHC_MOISTURE_INT,
	PM4125_IRQ_HPHL_SURGE_DET_INT,
	PM4125_IRQ_HPHR_SURGE_DET_INT,
	PM4125_NUM_IRQS,
};

enum pm4125_tx_sdw_channels {
	PM4125_ADC1,
	PM4125_ADC2,
};

enum pm4125_rx_sdw_channels {
	PM4125_HPH_L,
	PM4125_HPH_R,
	PM4125_COMP_L,
	PM4125_COMP_R,
};

#endif /* _PM4125_REGISTERS_H */
